/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.win32.CHOOSEFONT;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;
    boolean effectsVisible = true;

    public FontDialog(Shell shell) {
        this(shell, 65536);
    }

    public FontDialog(Shell shell, int n) {
        super(shell, FontDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    public boolean getEffectsVisible() {
        return this.effectsVisible;
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] fontDataArray = new FontData[]{this.fontData};
        return fontDataArray;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public FontData open() {
        int n;
        int n2;
        Object object;
        int n3;
        int n4;
        int n5;
        if (OS.IsWinCE) {
            this.error(20);
        }
        int n6 = this.parent.handle;
        int n7 = this.parent.handle;
        boolean bl = false;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10) && (n5 = this.style & 0x6000000) != (n4 = this.parent.style & 0x6000000)) {
            n3 = 0x100000;
            if (n5 == 0x4000000) {
                n3 |= 0x400000;
            }
            n6 = OS.CreateWindowEx(n3, Shell.DialogClass, null, 0, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, n7, 0, OS.GetModuleHandle(null), null);
            bl = OS.IsWindowEnabled(n7);
            if (bl) {
                OS.EnableWindow(n7, false);
            }
        }
        n5 = OS.GetProcessHeap();
        CHOOSEFONT cHOOSEFONT = new CHOOSEFONT();
        cHOOSEFONT.lStructSize = CHOOSEFONT.sizeof;
        cHOOSEFONT.hwndOwner = n6;
        cHOOSEFONT.Flags = 1;
        if (this.effectsVisible) {
            cHOOSEFONT.Flags |= 0x100;
        }
        n3 = OS.HeapAlloc(n5, 8, LOGFONT.sizeof);
        if (this.fontData != null && this.fontData.data != null) {
            object = this.fontData.data;
            n2 = ((LOGFONT)object).lfHeight;
            n = OS.GetDC(0);
            int n8 = -((int)(0.5f + this.fontData.height * (float)OS.GetDeviceCaps(n, 90) / 72.0f));
            OS.ReleaseDC(0, n);
            ((LOGFONT)object).lfHeight = n8;
            cHOOSEFONT.Flags |= 0x40;
            OS.MoveMemory(n3, (LOGFONT)object, LOGFONT.sizeof);
            ((LOGFONT)object).lfHeight = n2;
        }
        cHOOSEFONT.lpLogFont = n3;
        if (this.rgb != null) {
            int n9 = this.rgb.red & 0xFF;
            n2 = this.rgb.green << 8 & 0xFF00;
            n = this.rgb.blue << 16 & 0xFF0000;
            cHOOSEFONT.rgbColors = n9 | n2 | n;
        }
        object = null;
        Display display = this.parent.getDisplay();
        if ((this.style & 0x30000) != 0) {
            object = display.getModalDialog();
            display.setModalDialog(this);
        }
        display.sendPreExternalEventDispatchEvent();
        n = OS.ChooseFont(cHOOSEFONT) ? 1 : 0;
        display.sendPostExternalEventDispatchEvent();
        if ((this.style & 0x30000) != 0) {
            display.setModalDialog((Dialog)object);
        }
        if (n != 0) {
            int n10;
            LOGFONT lOGFONT = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            OS.MoveMemory(lOGFONT, n3, LOGFONT.sizeof);
            int n11 = OS.GetDC(0);
            int n12 = OS.GetDeviceCaps(n11, 90);
            int n13 = 0;
            if (lOGFONT.lfHeight > 0) {
                int n14 = OS.CreateFontIndirect(lOGFONT);
                n10 = OS.SelectObject(n11, n14);
                TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                OS.GetTextMetrics(n11, tEXTMETRIC);
                OS.SelectObject(n11, n10);
                OS.DeleteObject(n14);
                n13 = lOGFONT.lfHeight - tEXTMETRIC.tmInternalLeading;
            } else {
                n13 = -lOGFONT.lfHeight;
            }
            OS.ReleaseDC(0, n11);
            float f = (float)n13 * 72.0f / (float)n12;
            this.fontData = FontData.win32_new(lOGFONT, f);
            if (this.effectsVisible) {
                n10 = cHOOSEFONT.rgbColors & 0xFF;
                int n15 = cHOOSEFONT.rgbColors >> 8 & 0xFF;
                int n16 = cHOOSEFONT.rgbColors >> 16 & 0xFF;
                this.rgb = new RGB(n10, n15, n16);
            }
        }
        if (n3 != 0) {
            OS.HeapFree(n5, 0, n3);
        }
        if (n7 != n6) {
            if (bl) {
                OS.EnableWindow(n7, true);
            }
            OS.SetActiveWindow(n7);
            OS.DestroyWindow(n6);
        }
        if (n == 0) {
            return null;
        }
        return this.fontData;
    }

    public void setEffectsVisible(boolean bl) {
        this.effectsVisible = bl;
    }

    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontDataArray) {
        this.fontData = fontDataArray != null && fontDataArray.length > 0 ? fontDataArray[0] : null;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }
}

