/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.TreeSet;
import org.glassfish.hk2.api.Descriptor;
import org.jvnet.hk2.internal.DescriptorComparator;
import org.jvnet.hk2.internal.ServiceLocatorImpl;
import org.jvnet.hk2.internal.SystemDescriptor;

public class IndexedListData {
    private static final DescriptorComparator UNSORTED_COMPARATOR = new DescriptorComparator();
    private LinkedList<SystemDescriptor<?>> unsortedList = new LinkedList();
    private TreeSet<SystemDescriptor<?>> sortedList = null;

    public Collection<SystemDescriptor<?>> getSortedList() {
        if (this.sortedList != null) {
            return this.sortedList;
        }
        if (this.unsortedList.size() <= 1) {
            return this.unsortedList;
        }
        this.sortedList = new TreeSet<Descriptor>(ServiceLocatorImpl.DESCRIPTOR_COMPARATOR);
        this.sortedList.addAll(this.unsortedList);
        this.unsortedList.clear();
        this.unsortedList = null;
        return this.sortedList;
    }

    public void addDescriptor(SystemDescriptor<?> descriptor) {
        if (this.sortedList != null) {
            this.sortedList.add(descriptor);
        } else {
            this.unsortedList.add(descriptor);
        }
        descriptor.addList(this);
    }

    public void removeDescriptor(SystemDescriptor<?> descriptor) {
        if (this.sortedList != null) {
            this.sortedList.remove(descriptor);
        } else {
            ListIterator iterator = this.unsortedList.listIterator();
            while (iterator.hasNext()) {
                SystemDescriptor candidate = (SystemDescriptor)iterator.next();
                if (UNSORTED_COMPARATOR.compare(descriptor, candidate) != 0) continue;
                iterator.remove();
                break;
            }
        }
        descriptor.removeList(this);
    }

    public boolean isEmpty() {
        if (this.sortedList != null) {
            return this.sortedList.isEmpty();
        }
        return this.unsortedList.isEmpty();
    }

    public void unSort() {
        if (this.sortedList != null) {
            this.unsortedList = new LinkedList(this.sortedList);
            this.sortedList.clear();
            this.sortedList = null;
        }
    }

    public void clear() {
        AbstractCollection removeMe = this.sortedList != null ? this.sortedList : this.unsortedList;
        for (SystemDescriptor descriptor : removeMe) {
            descriptor.removeList(this);
        }
        if (this.sortedList != null) {
            this.sortedList.clear();
            this.sortedList = null;
            this.unsortedList = new LinkedList();
        } else {
            this.unsortedList.clear();
        }
    }
}

