/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.dbgl.gui.BrowseArchiveDialog;
import org.dbgl.gui.GeneralPurposeGUI;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.StringRelatedUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class BrowseButton {
    private final Button button;
    private Settings settings = Settings.getInstance();

    public BrowseButton(Composite composite, int n) {
        this.button = GeneralPurposeGUI.createIconButton(composite, n, this.settings, this.settings.msg("button.browse"), "folder.png");
    }

    public void connect(Shell shell, Text text, Text text2, BrowseType browseType, CanonicalType canonicalType, boolean bl, Combo combo) {
        this.button.addSelectionListener((SelectionListener)new Sa(shell, text, text2, browseType, canonicalType, bl, combo));
    }

    public void setLayoutData(Object object) {
        this.button.setLayoutData(object);
    }

    public void setEnabled(boolean bl) {
        this.button.setEnabled(bl);
    }

    private class Sa
    extends SelectionAdapter {
        private final Text field;
        private final Text alt;
        private final BrowseType browse;
        private final CanonicalType canon;
        private final boolean save;
        private final Combo combo;
        private final Shell shell;

        public Sa(Shell shell, Text text, Text text2, BrowseType browseType, CanonicalType canonicalType, boolean bl, Combo combo) {
            this.shell = shell;
            this.field = text;
            this.alt = text2;
            this.browse = browseType;
            this.canon = canonicalType;
            this.save = bl;
            this.combo = combo;
        }

        private String filterPath() {
            String string = this.field.getText();
            CanonicalType canonicalType = this.canon;
            if (string.equals("") && this.alt != null) {
                string = this.alt.getText();
                if (canonicalType == CanonicalType.DOC) {
                    canonicalType = CanonicalType.DOSROOT;
                }
            } else if (this.browse == BrowseType.DIR && canonicalType == CanonicalType.NONE) {
                canonicalType = CanonicalType.DOSROOT;
            }
            switch (canonicalType) {
                case DOC: 
                case DBGLZIP: 
                case NATIVE_EXE: {
                    return FileUtils.canonicalToData(string).getPath();
                }
                case EXE: 
                case INSTALLER: 
                case ZIP: 
                case BOOTER: 
                case DOSROOT: {
                    return FileUtils.canonicalToDosroot(string).getPath();
                }
                case DOSBOX: 
                case DOSBOXCONF: {
                    return FileUtils.canonicalToDosbox(string).getPath();
                }
                case DFEND: {
                    return PlatformUtils.DFEND_PATH;
                }
                case CDIMAGE: {
                    String[] stringArray = StringRelatedUtils.textAreaToStringArray(this.field.getText(), this.field.getLineDelimiter());
                    if (stringArray.length > 0) {
                        return FileUtils.canonicalToDosroot(stringArray[0]).getPath();
                    }
                    return FileUtils.getDosRoot();
                }
            }
            return "";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String getResult(String string, File file, String[] stringArray) {
            switch (this.canon) {
                case DOC: 
                case DBGLZIP: 
                case NATIVE_EXE: {
                    return FileUtils.makeRelativeToData(new File(string)).getPath();
                }
                case EXE: 
                case INSTALLER: {
                    if (!FileUtils.isArchive(string) && !FileUtils.isIsoFile(string)) {
                        if (!FileUtils.isFatImage(string)) return FileUtils.makeRelativeToDosroot(new File(string)).getPath();
                    }
                    BrowseArchiveDialog browseArchiveDialog = new BrowseArchiveDialog(this.shell, 4096);
                    browseArchiveDialog.setFileToBrowse(string);
                    String string2 = (String)browseArchiveDialog.open();
                    if (string2 == null) {
                        return null;
                    }
                    String string3 = FileUtils.makeRelativeToDosroot(new File(string2)).getPath();
                    return string3;
                }
                case ZIP: 
                case BOOTER: 
                case DOSROOT: {
                    return FileUtils.makeRelativeToDosroot(new File(string)).getPath();
                }
                case DOSBOX: {
                    if (!PlatformUtils.IS_OSX) return FileUtils.makeRelativeToDosbox(new File(string)).getPath();
                    File file2 = FileUtils.makeRelativeToDosbox(new File(string));
                    if (file2.getName().endsWith(".app")) {
                        File file3 = new File(file2, PlatformUtils.DB_APP_EXE);
                        if (!FileUtils.isExistingFile(file3)) return FileUtils.makeRelativeToDosbox(new File(string)).getPath();
                        return file3.getParent();
                    }
                    if (!file2.getName().equals(PlatformUtils.DB_EXECUTABLE)) return FileUtils.makeRelativeToDosbox(new File(string)).getPath();
                    return file2.getParent();
                }
                case DOSBOXCONF: {
                    return FileUtils.makeRelativeToDosbox(new File(string)).getPath();
                }
                case CDIMAGE: {
                    File file4 = FileUtils.makeRelativeToDosroot(file);
                    StringBuffer stringBuffer = new StringBuffer();
                    String[] stringArray2 = stringArray;
                    int n = stringArray2.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string4 = stringArray2[n2];
                        stringBuffer.append(new File(file4, string4)).append(this.field.getLineDelimiter());
                        ++n2;
                    }
                    return stringBuffer.toString();
                }
            }
            return string;
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            Object object;
            String string = null;
            File file = null;
            String[] stringArray = null;
            this.shell.setEnabled(false);
            String string2 = this.filterPath();
            File file2 = new File(string2);
            if (file2 != null && !file2.isDirectory()) {
                file2 = file2.getParentFile();
            }
            if (this.browse == BrowseType.DIR) {
                object = new DirectoryDialog(this.shell);
                if (file2 != null) {
                    object.setFilterPath(file2.getPath());
                }
                string = object.open();
            } else if (this.browse == BrowseType.FILE && (this.canon == CanonicalType.EXE || this.canon == CanonicalType.INSTALLER) && (FileUtils.isArchive(string2) || FileUtils.isIsoFile(string2) || FileUtils.isFatImage(string2))) {
                string = string2;
            } else if (this.browse == BrowseType.FILE) {
                int n;
                int n2 = n = this.canon == CanonicalType.CDIMAGE ? 4098 : 4096;
                if (this.save) {
                    n = 8192;
                }
                FileDialog fileDialog = new FileDialog(this.shell, n);
                if (file2 != null) {
                    fileDialog.setFilterPath(file2.getPath());
                }
                String[] stringArray2 = null;
                String[] stringArray3 = null;
                switch (this.canon) {
                    case DOC: {
                        stringArray2 = new String[]{"*"};
                        stringArray3 = new String[]{"*"};
                        break;
                    }
                    case EXE: 
                    case INSTALLER: {
                        boolean bl = this.combo != null && this.combo.isEnabled();
                        ArrayList<String> arrayList = new ArrayList<String>();
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        arrayList.add(BrowseButton.this.settings.msg("filetype.applicable"));
                        arrayList2.add("*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT;*.iso;*.ISO;*.cue;*.CUE;*.ima;*.IMA;" + (bl ? ";*.zip;*.ZIP;*.7z;*.7Z" : ""));
                        Collections.addAll(arrayList, BrowseButton.this.settings.msg("filetype.exe"), BrowseButton.this.settings.msg("filetype.cdimage"), BrowseButton.this.settings.msg("filetype.floppyimage"), BrowseButton.this.settings.msg("filetype.archive"), "*");
                        Collections.addAll(arrayList2, "*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT", "*.iso;*.ISO;*.cue;*.CUE", "*.ima;*.IMA;", "*.zip;*.ZIP;*.7z;*.7Z", "*");
                        stringArray2 = arrayList.toArray(new String[0]);
                        stringArray3 = arrayList2.toArray(new String[0]);
                        break;
                    }
                    case NATIVE_EXE: 
                    case DOSBOX: {
                        String string3 = BrowseButton.this.settings.msg("filetype.native_exe");
                        String string4 = PlatformUtils.NATIVE_EXE_FILTER;
                        stringArray2 = new String[]{string3, "*"};
                        stringArray3 = new String[]{string4, "*"};
                        break;
                    }
                    case ZIP: {
                        stringArray2 = new String[]{BrowseButton.this.settings.msg("filetype.archive"), "*"};
                        stringArray3 = new String[]{"*.zip;*.ZIP;*.7z;*.7Z", "*"};
                        break;
                    }
                    case DBGLZIP: {
                        stringArray2 = new String[]{BrowseButton.this.settings.msg("filetype.gamepack"), "*"};
                        stringArray3 = new String[]{"*.dbgl.zip;*.DBGL.ZIP", "*"};
                        break;
                    }
                    case BOOTER: {
                        stringArray2 = new String[]{BrowseButton.this.settings.msg("filetype.booterimage"), "*"};
                        stringArray3 = new String[]{"*.cp2;*.CP2;*.dcf;*.DCF;*.img;*.IMG;*.jrc;*.JRC;*.td0;*.TD0", "*"};
                        break;
                    }
                    case DFEND: {
                        stringArray2 = new String[]{BrowseButton.this.settings.msg("filetype.dfendprofile")};
                        stringArray3 = new String[]{"Profiles.dat"};
                        break;
                    }
                    case CDIMAGE: {
                        stringArray2 = new String[]{BrowseButton.this.settings.msg("filetype.applicable"), BrowseButton.this.settings.msg("filetype.cdimage"), BrowseButton.this.settings.msg("filetype.floppyimage"), "*"};
                        stringArray3 = new String[]{"*.iso;*.ISO;*.cue;*.CUE;*.ima;*.IMA;", "*.iso;*.ISO;*.cue;*.CUE", "*.ima;*.IMA;", "*"};
                        break;
                    }
                    case DOSBOXCONF: {
                        stringArray2 = new String[]{BrowseButton.this.settings.msg("filetype.conf"), "*"};
                        stringArray3 = new String[]{"*.conf;*.CONF", "*"};
                        break;
                    }
                }
                if (stringArray2 != null) {
                    fileDialog.setFilterNames(stringArray2);
                }
                if (stringArray3 != null) {
                    fileDialog.setFilterExtensions(stringArray3);
                }
                if (this.canon == CanonicalType.DFEND) {
                    fileDialog.setFileName("Profiles.dat");
                }
                string = fileDialog.open();
                if (this.canon == CanonicalType.CDIMAGE) {
                    file = new File(fileDialog.getFilterPath());
                    stringArray = fileDialog.getFileNames();
                }
            }
            if (string != null && (string = this.getResult(string, file, stringArray)) != null) {
                this.field.setText(string);
                if (this.canon == CanonicalType.DOSBOX && this.alt != null) {
                    this.alt.setText(FileUtils.constructRelativeDBConfLocation(string).getPath());
                } else if (this.canon == CanonicalType.CDIMAGE && this.combo != null) {
                    if (FileUtils.isIsoFile((String)stringArray[0])) {
                        this.combo.setText("iso");
                    } else if (FileUtils.isFatImage((String)stringArray[0])) {
                        this.combo.setText("floppy");
                    }
                } else if (this.canon == CanonicalType.NATIVE_EXE && this.alt != null && (object = FileUtils.makeRelativeToData(FileUtils.canonicalToData(string).getParentFile()).getPath()) != null) {
                    this.alt.setText((String)object);
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (this.shell.getDisplay().readAndDispatch()) {
            }
            this.shell.setEnabled(true);
        }
    }

    public static enum CanonicalType {
        DOSROOT,
        DFEND,
        CDIMAGE,
        ZIP,
        DBGLZIP,
        DOSBOX,
        DOSBOXCONF,
        DOC,
        BOOTER,
        EXE,
        INSTALLER,
        NATIVE_EXE,
        NONE;

    }

    public static enum BrowseType {
        DIR,
        FILE;

    }
}

