/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import SevenZip.Archive.SevenZip.Handler;
import SevenZip.Archive.SevenZipEntry;
import SevenZip.MyRandomAccessFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.ProgressDialog;
import org.dbgl.gui.Wizard;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.dbgl.util.ImportThread;
import org.dbgl.util.ProgressNotifyable;
import org.dbgl.util.SevenzipExtractSingleFileCallback;
import org.dbgl.util.XmlUtils;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ImportDialog
extends Wizard {
    private Text confLogText;
    private Text logText;
    private Text title;
    private Text author;
    private Text notes;
    private Button settingsOnly;
    private Button fullGames;
    private Button fullSettingsButton;
    private Button incrementalSettingsButton;
    private Button importCapturesButton;
    private Button importMapperfilesButton;
    private Button importNativeCommandsButton;
    private Button useOrgConf;
    private Button createNewConf;
    private Button customValues;
    private Button customFields;
    private Table profilesTable;
    private Table impDbVersionsList;
    private org.eclipse.swt.widgets.List myDbVersionsList;
    private ProgressBar progressBar;
    private Label profileLabel;
    private File archive;
    private List<DosboxVersion> dbversionsList;
    private StringBuffer messageLog;
    private String packageVersion;
    private String packageTitle;
    private String packageAuthor;
    private String packageNotes;
    private String creationApp;
    private String creationAppVersion;
    private String[] customFieldTitles;
    private Date creationDate;
    private boolean capturesAvailable = false;
    private boolean mapperfilesAvailable = false;
    private boolean nativecommandsAvailable = false;
    private boolean gamedataAvailable = false;
    private List<ExpProfile> profs;
    private SortedSet<DosboxVersion> dbSet;
    private List<Integer> dbmapping;

    public ImportDialog(Shell shell, List<DosboxVersion> list, File file) {
        super(shell, 0, Settings.getInstance().msg("dialog.import.title"), "import", true);
        this.dbversionsList = list;
        this.archive = file;
    }

    @Override
    protected boolean actionAfterNext() {
        if (this.stepNr == 2) {
            this.refillImportedDBVersionsList();
        } else if (this.stepNr == 4) {
            try {
                ExpProfile expProfile;
                int n;
                for (n = 0; n < this.profs.size(); ++n) {
                    for (int i = 0; i < n; ++i) {
                        expProfile = this.profs.get(n);
                        ExpProfile expProfile2 = this.profs.get(i);
                        if (!expProfile.getGameDir().equals(expProfile2.getGameDir())) continue;
                        expProfile.setImportedId(expProfile2.getImportedId());
                    }
                }
                for (n = this.profs.size() - 1; n >= 0; --n) {
                    TableItem tableItem = this.profilesTable.getItem(n);
                    if (tableItem.getChecked()) {
                        expProfile = this.profs.get(n);
                        expProfile.setDbversionId(ImportDialog.getMappedDosboxVersionId(this.dbSet, this.dbmapping, expProfile.getDbversionId()));
                        continue;
                    }
                    this.profs.remove(n);
                }
                this.extensiveJobThread = new ImportThread(this.logText, this.progressBar, this.profileLabel, this.profs, this.archive, this.importCapturesButton.getSelection(), this.importMapperfilesButton.getSelection(), this.importNativeCommandsButton.getSelection(), this.useOrgConf.getSelection(), this.fullGames.getSelection(), this.fullSettingsButton.getSelection(), this.customValues.getSelection(), this.customFields.getSelection() ? this.customFieldTitles : null);
            }
            catch (IOException | SQLException exception) {
                GeneralPurposeDialogs.warningMessage(this.shell, exception);
                this.extensiveJobThread = null;
            }
        } else if (this.stepNr == 5) {
            if (this.extensiveJobThread.isEverythingOk()) {
                GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.import.notice.importok"));
            } else {
                GeneralPurposeDialogs.warningMessage(this.shell, this.settings.msg("dialog.import.error.problem"));
            }
            this.profileLabel.setText(this.settings.msg("dialog.export.reviewlog"));
            this.profileLabel.pack();
        }
        return true;
    }

    @Override
    protected boolean init() {
        Settings settings = Settings.getInstance();
        this.messageLog = new StringBuffer();
        try {
            this.profs = new ArrayList<ExpProfile>();
            this.dbSet = new TreeSet<DosboxVersion>();
            Document document = this.getProfilesXmlDocFromZip();
            if (document == null) {
                throw new ZipException(settings.msg("dialog.import.error.gamepackarchivemissingprofilesxml"));
            }
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            this.packageVersion = xPath.evaluate("/document/export/format-version", document);
            this.packageTitle = xPath.evaluate("/document/export/title", document);
            this.packageAuthor = xPath.evaluate("/document/export/author", document);
            this.packageNotes = xPath.evaluate("/document/export/notes", document);
            this.customFieldTitles = new String[10];
            for (int i = 0; i < 10; ++i) {
                this.customFieldTitles[i] = xPath.evaluate("/document/export/custom" + (i + 1), document);
            }
            this.creationApp = xPath.evaluate("/document/export/generator-title", document);
            this.creationAppVersion = xPath.evaluate("/document/export/generator-version", document);
            this.creationDate = XmlUtils.datetimeFormatter.parse(xPath.evaluate("/document/export/creationdatetime", document));
            this.capturesAvailable = Boolean.valueOf(xPath.evaluate("/document/export/captures-available", document));
            this.mapperfilesAvailable = this.packageVersion.equals("1.0") ? false : Boolean.valueOf(xPath.evaluate("/document/export/keymapperfiles-available", document));
            this.nativecommandsAvailable = this.packageVersion.equals("1.0") || this.packageVersion.equals("1.1") ? false : Boolean.valueOf(xPath.evaluate("/document/export/nativecommands-available", document));
            this.gamedataAvailable = Boolean.valueOf(xPath.evaluate("/document/export/gamedata-available", document));
            NodeList nodeList = (NodeList)xPath.evaluate("/document/profile", document, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                Element element2 = XmlUtils.getNode(element, "dosbox");
                DosboxVersion dosboxVersion = new DosboxVersion(i, XmlUtils.getTextValue(element2, "title"), "", "", true, false, false, "", XmlUtils.getTextValue(element2, "version"), null, null, null, 0);
                this.dbSet.add(dosboxVersion);
                this.profs.add(new ExpProfile(element, ImportDialog.getDosboxVersionId(dosboxVersion, this.dbSet), this.nativecommandsAvailable, this.packageVersion));
            }
        }
        catch (ParseException | ZipException | ParserConfigurationException exception) {
            this.messageLog.append(exception.toString()).append('\n');
            exception.printStackTrace();
        }
        catch (XPathExpressionException | SAXException exception) {
            this.messageLog.append(settings.msg("dialog.import.error.profilesxmlinvalidformat", new Object[]{exception.toString()})).append('\n');
            exception.printStackTrace();
        }
        catch (IOException iOException) {
            this.messageLog.append(settings.msg("general.error.openfile", new Object[]{this.archive})).append('\n').append(iOException.toString()).append('\n');
            iOException.printStackTrace();
        }
        if (this.messageLog.length() == 0) {
            this.messageLog.append(settings.msg("dialog.import.notice.importinformation", new Object[]{this.packageVersion, this.creationDate, this.creationApp, this.creationAppVersion})).append('\n');
        }
        return true;
    }

    public Document getProfilesXmlDocFromZip() throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        String string = this.archive.getPath();
        Document document = null;
        if (string.toLowerCase().endsWith(FileUtils.ARCHIVES[0])) {
            ZipFile zipFile = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory() || !zipEntry.getName().equalsIgnoreCase("profiles.xml")) continue;
                document = documentBuilder.parse(zipFile.getInputStream(zipEntry));
                break;
            }
            zipFile.close();
            return document;
        }
        if (string.toLowerCase().endsWith(FileUtils.ARCHIVES[1])) {
            final Handler handler = new Handler();
            MyRandomAccessFile myRandomAccessFile = new MyRandomAccessFile(string, "r");
            if (handler.Open(myRandomAccessFile) != 0) {
                throw new IOException(Settings.getInstance().msg("general.error.opensevenzip", new Object[]{string}));
            }
            final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (int i = 0; i < handler.size(); ++i) {
                SevenZipEntry sevenZipEntry = handler.getEntry(i);
                if (sevenZipEntry.isDirectory() || !sevenZipEntry.getName().equalsIgnoreCase("profiles.xml")) continue;
                ProgressDialog progressDialog = new ProgressDialog(this.getParent(), this.settings.msg("dialog.import.notice.processing7zip"));
                class Extract
                extends Thread {
                    private int entryId;
                    private SevenzipExtractSingleFileCallback extractCallback;
                    private IOException exception;

                    Extract(int n, ProgressNotifyable progressNotifyable) {
                        this.entryId = n;
                        this.extractCallback = new SevenzipExtractSingleFileCallback(progressNotifyable, byteArrayOutputStream);
                        this.exception = null;
                    }

                    @Override
                    public void run() {
                        try {
                            handler.Extract(new int[]{this.entryId}, 1, 0, this.extractCallback);
                        }
                        catch (IOException iOException) {
                            this.exception = iOException;
                        }
                    }

                    public IOException getIOException() {
                        return this.exception;
                    }
                }
                Extract extract = new Extract(i, progressDialog);
                progressDialog.setThread(extract);
                progressDialog.open();
                if (extract.getIOException() != null) {
                    handler.close();
                    byteArrayOutputStream.close();
                    throw extract.getIOException();
                }
                document = documentBuilder.parse(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                break;
            }
            handler.close();
            byteArrayOutputStream.close();
            return document;
        }
        return null;
    }

    @Override
    protected void onExit() {
        this.result = this.extensiveJobThread != null && ((ImportThread)this.extensiveJobThread).getCustomFields() != null;
    }

    @Override
    protected boolean isValidInput() {
        if (this.stepNr == 2) {
            return this.conditionsForStep3Ok();
        }
        return true;
    }

    private boolean conditionsForStep3Ok() {
        GeneralPurposeDialogs.initErrorDialog();
        this.atLeastOneProfileSelected();
        if (this.fullGames.getSelection()) {
            this.gameDirExists();
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }

    private void atLeastOneProfileSelected() {
        for (TableItem tableItem : this.profilesTable.getItems()) {
            if (!tableItem.getChecked()) continue;
            return;
        }
        GeneralPurposeDialogs.addError(this.settings.msg("dialog.import.required.oneprofiletoimport"), (Control)this.profilesTable);
    }

    private void gameDirExists() {
        for (TableItem tableItem : this.profilesTable.getItems()) {
            File file;
            if (!tableItem.getChecked() || !(file = FileUtils.canonicalToDosroot(new File(tableItem.getText(1), tableItem.getText(2)).getPath())).exists()) continue;
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.import.error.gamedatadirexists", new Object[]{file}), (Control)this.profilesTable);
        }
    }

    private void refillImportedDBVersionsList() {
        int n = 0;
        for (DosboxVersion dosboxVersion : this.dbSet) {
            int n2 = dosboxVersion.getId();
            TableItem tableItem = this.impDbVersionsList.getItem(n);
            Display display = this.shell.getDisplay();
            Color color = this.isUsed(n2) ? null : display.getSystemColor(15);
            tableItem.setForeground(color);
            ++n;
        }
    }

    private boolean isUsed(int n) {
        for (int i = 0; i < this.profs.size(); ++i) {
            TableItem tableItem = this.profilesTable.getItem(i);
            int n2 = this.profs.get(i).getDbversionId();
            if (!tableItem.getChecked() || n != n2) continue;
            return true;
        }
        return false;
    }

    public static int getMappedDosboxVersionId(Set<DosboxVersion> set, List<Integer> list, int n) {
        int n2 = 0;
        for (DosboxVersion dosboxVersion : set) {
            if (dosboxVersion.getId() == n) {
                return list.get(n2);
            }
            ++n2;
        }
        return -1;
    }

    public static int getDosboxVersionId(DosboxVersion dosboxVersion, Set<DosboxVersion> set) {
        for (DosboxVersion dosboxVersion2 : set) {
            if (dosboxVersion2.compareTo(dosboxVersion) != 0) continue;
            return dosboxVersion2.getId();
        }
        return -1;
    }

    @Override
    protected void fillPages() {
        this.addStep(this.page1());
        this.addStep(this.page2());
        this.addStep(this.page3());
        this.addStep(this.page4());
        this.addStep(this.page5());
    }

    private Control page1() {
        Group group = new Group((Composite)this.shell, 0);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setText(this.settings.msg("dialog.import.step1"));
        group.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)group, 0);
        label.setText(this.settings.msg("dialog.export.exporttitle"));
        this.title = new Text((Composite)group, 2048);
        this.title.setLayoutData((Object)new GridData(4, 4, true, false));
        this.title.setEditable(false);
        Label label2 = new Label((Composite)group, 0);
        label2.setText(this.settings.msg("dialog.export.author"));
        this.author = new Text((Composite)group, 2048);
        this.author.setLayoutData((Object)new GridData(4, 4, true, false));
        this.author.setEditable(false);
        Label label3 = new Label((Composite)group, 0);
        label3.setText(this.settings.msg("dialog.export.notes"));
        this.notes = new Text((Composite)group, 2890);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumHeight = 40;
        this.notes.setLayoutData((Object)gridData);
        Label label4 = new Label((Composite)group, 0);
        label4.setText(this.settings.msg("dialog.import.log"));
        this.confLogText = new Text((Composite)group, 2890);
        GridData gridData2 = new GridData(4, 4, true, true);
        gridData2.minimumHeight = 40;
        this.confLogText.setLayoutData((Object)gridData2);
        if (this.packageTitle != null) {
            this.title.setText(this.packageTitle);
        }
        if (this.packageAuthor != null) {
            this.author.setText(this.packageAuthor);
        }
        if (this.packageNotes != null) {
            this.notes.setText(this.packageNotes);
        }
        this.confLogText.setText(this.messageLog.toString());
        return group;
    }

    private Control page2() {
        Group group = new Group((Composite)this.shell, 0);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setText(this.settings.msg("dialog.import.step2"));
        group.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)group, 0);
        label.setText(this.settings.msg("dialog.import.import"));
        Group group2 = new Group((Composite)group, 0);
        group2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group2.setLayout((Layout)new GridLayout());
        this.settingsOnly = new Button((Composite)group2, 16);
        this.settingsOnly.setText(this.settings.msg("dialog.export.export.profiles"));
        this.fullGames = new Button((Composite)group2, 16);
        this.fullGames.setText(this.settings.msg("dialog.export.export.games"));
        new Label((Composite)group, 0);
        Group group3 = new Group((Composite)group, 0);
        group3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group3.setLayout((Layout)new GridLayout());
        this.incrementalSettingsButton = new Button((Composite)group3, 16);
        this.incrementalSettingsButton.setText(this.settings.msg("dialog.import.import.incrconf"));
        this.fullSettingsButton = new Button((Composite)group3, 16);
        this.fullSettingsButton.setText(this.settings.msg("dialog.import.import.fullconf"));
        this.incrementalSettingsButton.setSelection(true);
        new Label((Composite)group, 0);
        Group group4 = new Group((Composite)group, 0);
        group4.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group4.setLayout((Layout)new GridLayout());
        this.importCapturesButton = new Button((Composite)group4, 32);
        this.importCapturesButton.setText(this.settings.msg("dialog.template.captures"));
        this.importMapperfilesButton = new Button((Composite)group4, 32);
        this.importMapperfilesButton.setText(this.settings.msg("dialog.template.mapperfile"));
        this.importNativeCommandsButton = new Button((Composite)group4, 32);
        this.importNativeCommandsButton.setText(this.settings.msg("dialog.export.nativecommands"));
        new Label((Composite)group, 0);
        Group group5 = new Group((Composite)group, 0);
        group5.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group5.setLayout((Layout)new GridLayout());
        this.customValues = new Button((Composite)group5, 32);
        this.customValues.setText(this.settings.msg("dialog.import.import.customvalues"));
        this.customValues.setSelection(true);
        this.customFields = new Button((Composite)group5, 32);
        this.customFields.setText(this.settings.msg("dialog.import.import.customfields"));
        Label label2 = new Label((Composite)group, 0);
        label2.setText(this.settings.msg("dialog.main.profile.view.conf"));
        Group group6 = new Group((Composite)group, 0);
        group6.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group6.setLayout((Layout)new GridLayout());
        this.useOrgConf = new Button((Composite)group6, 16);
        this.useOrgConf.setText(this.settings.msg("dialog.import.useorgconf"));
        this.createNewConf = new Button((Composite)group6, 16);
        this.createNewConf.setText(this.settings.msg("dialog.import.createnewconf"));
        if (this.gamedataAvailable) {
            this.fullGames.setSelection(true);
        } else {
            this.fullGames.setEnabled(false);
            this.settingsOnly.setSelection(true);
        }
        if (this.settings.getSettings().getIntValue("profiledefaults", "confpath") == 1) {
            this.useOrgConf.setSelection(true);
        } else {
            this.useOrgConf.setEnabled(false);
            this.createNewConf.setEnabled(false);
        }
        if (this.capturesAvailable) {
            this.importCapturesButton.setSelection(true);
        } else {
            this.importCapturesButton.setEnabled(false);
        }
        if (this.mapperfilesAvailable) {
            this.importMapperfilesButton.setSelection(true);
        } else {
            this.importMapperfilesButton.setEnabled(false);
        }
        this.importNativeCommandsButton.setEnabled(this.nativecommandsAvailable);
        return group;
    }

    private Control page3() {
        Group group = new Group((Composite)this.shell, 0);
        group.setText(this.settings.msg("dialog.import.step3"));
        group.setLayout((Layout)new GridLayout(2, false));
        this.profilesTable = new Table((Composite)group, 67616);
        this.profilesTable.setHeaderVisible(true);
        GridData gridData = new GridData(4, 4, true, true, 1, 2);
        gridData.heightHint = 80;
        this.profilesTable.setLayoutData((Object)gridData);
        this.profilesTable.setLinesVisible(true);
        TableColumn tableColumn = new TableColumn(this.profilesTable, 0);
        tableColumn.setWidth(260);
        tableColumn.setText(this.settings.msg("dialog.main.profiles.column.title"));
        TableColumn tableColumn2 = new TableColumn(this.profilesTable, 0);
        tableColumn2.setWidth(100);
        tableColumn2.setText(this.settings.msg("dialog.import.column.basedir"));
        TableColumn tableColumn3 = new TableColumn(this.profilesTable, 0);
        tableColumn3.setWidth(120);
        tableColumn3.setText(this.settings.msg("dialog.export.column.gamedir"));
        Button button = new Button((Composite)group, 0);
        GridData gridData2 = new GridData(4, 128, true, false);
        button.setLayoutData((Object)gridData2);
        button.setText(this.settings.msg("button.all"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                for (TableItem tableItem : ImportDialog.this.profilesTable.getItems()) {
                    tableItem.setChecked(true);
                }
            }
        });
        Button button2 = new Button((Composite)group, 0);
        GridData gridData3 = new GridData(4, 1024, true, false);
        button2.setLayoutData((Object)gridData3);
        button2.setText(this.settings.msg("button.none"));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                for (TableItem tableItem : ImportDialog.this.profilesTable.getItems()) {
                    tableItem.setChecked(false);
                }
            }
        });
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayout((Layout)new RowLayout());
        Button button3 = new Button(composite, 0);
        button3.setText(this.settings.msg("button.setbasedir"));
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DirectoryDialog directoryDialog = new DirectoryDialog(ImportDialog.this.shell);
                directoryDialog.setFilterPath(FileUtils.canonicalToDosroot(".").getPath());
                String string = directoryDialog.open();
                if (string != null) {
                    File file = FileUtils.makeRelativeToDosroot(new File(string));
                    for (int i = 0; i < ImportDialog.this.profilesTable.getItems().length; ++i) {
                        TableItem tableItem = ImportDialog.this.profilesTable.getItem(i);
                        if (!tableItem.getChecked()) continue;
                        ((ExpProfile)ImportDialog.this.profs.get(i)).setBaseDir(file);
                        tableItem.setText(1, file.getPath());
                    }
                }
            }
        });
        Button button4 = new Button(composite, 0);
        button4.setText(this.settings.msg("button.addgametitletobasedir"));
        button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                for (int i = 0; i < ImportDialog.this.profilesTable.getItems().length; ++i) {
                    TableItem tableItem = ImportDialog.this.profilesTable.getItem(i);
                    if (!tableItem.getChecked()) continue;
                    String string = tableItem.getText(0).replaceAll("[^a-zA-Z_0-9()]", "");
                    if (tableItem.getText(1).endsWith(string)) continue;
                    File file = new File(tableItem.getText(1), string);
                    ((ExpProfile)ImportDialog.this.profs.get(i)).setBaseDir(file);
                    tableItem.setText(1, file.getPath());
                }
            }
        });
        Button button5 = new Button(composite, 0);
        button5.setText(this.settings.msg("button.removegametitlefrombasedir"));
        button5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                for (int i = 0; i < ImportDialog.this.profilesTable.getItems().length; ++i) {
                    TableItem tableItem = ImportDialog.this.profilesTable.getItem(i);
                    if (!tableItem.getChecked()) continue;
                    String string = tableItem.getText(0).replaceAll("[^a-zA-Z_0-9()]", "");
                    if (!tableItem.getText(1).endsWith(string)) continue;
                    File file = new File(tableItem.getText(1)).getParentFile();
                    ((ExpProfile)ImportDialog.this.profs.get(i)).setBaseDir(file);
                    tableItem.setText(1, file.getPath());
                }
            }
        });
        this.profilesTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                int n = ImportDialog.this.profilesTable.getSelectionIndex();
                ExpProfile expProfile = (ExpProfile)ImportDialog.this.profs.get(n);
                DirectoryDialog directoryDialog = new DirectoryDialog(ImportDialog.this.shell);
                directoryDialog.setFilterPath(FileUtils.canonicalToDosroot(expProfile.getBaseDir().getPath()).getPath());
                String string = directoryDialog.open();
                if (string != null) {
                    File file = FileUtils.makeRelativeToDosroot(new File(string));
                    expProfile.setBaseDir(file);
                    ImportDialog.this.profilesTable.getSelection()[0].setText(1, file.getPath());
                }
            }
        });
        for (ExpProfile expProfile : this.profs) {
            TableItem tableItem = new TableItem(this.profilesTable, 0);
            tableItem.setText(expProfile.getTitle());
            tableItem.setText(1, expProfile.getBaseDir().getPath());
            tableItem.setText(2, expProfile.getGameDir().getPath());
            tableItem.setChecked(true);
        }
        return group;
    }

    private Control page4() {
        Group group = new Group((Composite)this.shell, 0);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setText(this.settings.msg("dialog.import.step4"));
        group.setLayoutData((Object)"North");
        Label label = new Label((Composite)group, 0);
        label.setText(this.settings.msg("dialog.import.dosboxversioninimport"));
        Label label2 = new Label((Composite)group, 2);
        label2.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 2));
        Label label3 = new Label((Composite)group, 0);
        label3.setText(this.settings.msg("dialog.import.dosboxversioninstalled"));
        this.impDbVersionsList = new Table((Composite)group, 67584);
        this.impDbVersionsList.setLayoutData((Object)new GridData(4, 4, true, true));
        this.impDbVersionsList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = ImportDialog.this.impDbVersionsList.getSelectionIndex();
                int n2 = (Integer)ImportDialog.this.dbmapping.get(n);
                int n3 = DosboxVersion.findIndexById(ImportDialog.this.dbversionsList, n2);
                ImportDialog.this.myDbVersionsList.select(n3);
            }
        });
        this.myDbVersionsList = new org.eclipse.swt.widgets.List((Composite)group, 2816);
        this.myDbVersionsList.setLayoutData((Object)new GridData(4, 4, true, true));
        this.myDbVersionsList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = ImportDialog.this.impDbVersionsList.getSelectionIndex();
                if (n != -1) {
                    int n2 = ImportDialog.this.myDbVersionsList.getSelectionIndex();
                    ImportDialog.this.dbmapping.set(n, ((DosboxVersion)ImportDialog.this.dbversionsList.get(n2)).getId());
                }
            }
        });
        for (DosboxVersion dosboxVersion : this.dbversionsList) {
            this.myDbVersionsList.add(dosboxVersion.getTitle() + " (" + dosboxVersion.getVersion() + ")");
        }
        this.dbmapping = new ArrayList<Integer>();
        for (DosboxVersion dosboxVersion : this.dbSet) {
            TableItem tableItem = new TableItem(this.impDbVersionsList, 0);
            tableItem.setText(dosboxVersion.getTitle() + " (" + dosboxVersion.getVersion() + ")");
            this.dbmapping.add(dosboxVersion.findBestMatchId(this.dbversionsList));
        }
        return group;
    }

    private Control page5() {
        Group group = new Group((Composite)this.shell, 0);
        group.setText(this.settings.msg("dialog.import.step5"));
        group.setLayout((Layout)new GridLayout());
        this.progressBar = new ProgressBar((Composite)group, 0);
        this.progressBar.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.profileLabel = new Label((Composite)group, 0);
        this.profileLabel.setText(this.settings.msg("dialog.import.start"));
        this.logText = new Text((Composite)group, 2826);
        this.logText.setLayoutData((Object)new GridData(4, 4, true, true));
        return group;
    }
}

