/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.searchengine;

import java.io.IOException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.model.WebProfile;
import org.dbgl.util.searchengine.WebSearchEngine;

public class HotudSearchEngine
extends WebSearchEngine {
    private static final String HTML_MULTIPLE_RESULT_MARKER_START = "<table class=\"jrResults\" width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">";
    private static final String HTML_GAME_TITLE_START = "<div class=\"jrContentTitle\">";
    private static final String HTML_GAME_END_MARKER = "<td class=\"jrTableColumnLast\">";
    private static final String HOTUD_ORG_HOST_NAME = "www.hotud.org";
    private static final int RESULTS_PER_PAGE = 50;

    private HotudSearchEngine() {
    }

    public static WebSearchEngine getInstance() {
        return SearchEngineHolder.instance;
    }

    @Override
    public String getIcon() {
        return "hotud.png";
    }

    @Override
    public String getName() {
        return "Home o/t Underdogs";
    }

    @Override
    public String getSimpleName() {
        return "hotud";
    }

    @Override
    public List<WebProfile> getEntries(String string, String[] stringArray) throws IOException {
        String string2;
        int n = 1;
        ArrayList<WebProfile> arrayList = new ArrayList<WebProfile>();
        String string3 = string2 = stringArray.length == 1 ? "/tag/reqs/" + stringArray[0] : "";
        for (int i = 0; i < n; ++i) {
            String string4 = HotudSearchEngine.getResponseContent("http://www.hotud.org/component/jreviews/search-results" + string2 + "?criteria=1&query=all&scope=title&keywords=" + URLEncoder.encode(string.replaceAll("/", " "), "UTF-8") + "&order=alpha&page=" + (i + 1) + "&limit=" + 50, "UTF-8");
            if (i == 0) {
                n = HotudSearchEngine.getPages(string4);
            }
            if (n > 0) {
                arrayList.addAll(HotudSearchEngine.extractEntries(string4));
                continue;
            }
            if (string4.indexOf("<h1 class=\"contentheading\">") == -1) continue;
            arrayList.add(this.extractSingleEntry(string4));
        }
        if (stringArray.length == 1) {
            for (WebProfile webProfile : arrayList) {
                webProfile.setPlatform(stringArray[0].toUpperCase());
            }
        }
        return arrayList;
    }

    private static int getPages(String string) {
        int n = string.indexOf("<div class=\"jrCol4 jrPagenavResults\">");
        int n2 = string.indexOf(" results", n);
        if (n == -1 || n2 == -1) {
            return 0;
        }
        return (int)Math.ceil((double)Integer.parseInt(string.substring(n + 37, n2).trim()) / 50.0);
    }

    private static List<WebProfile> extractEntries(String string) {
        ArrayList<WebProfile> arrayList = new ArrayList<WebProfile>();
        int n = (string = string.replaceAll("\\\\\"", "\"")).indexOf(HTML_MULTIPLE_RESULT_MARKER_START);
        if (n != -1) {
            n += HTML_MULTIPLE_RESULT_MARKER_START.length();
        }
        while (n != -1) {
            n = string.indexOf("<tr class=\"row" + (arrayList.size() % 2 + 1) + "\">", n);
            int n2 = string.indexOf(HTML_GAME_TITLE_START, n);
            String string2 = HotudSearchEngine.extractNextContent(string, n2, "<a ", "</a>");
            String string3 = HotudSearchEngine.absoluteUrl(HOTUD_ORG_HOST_NAME, HotudSearchEngine.extractNextHrefContent(string, n2));
            int n3 = string.indexOf("<div class=\"jrCustomFields\">", n2 + HTML_GAME_TITLE_START.length());
            int n4 = string.indexOf("<div class=\"jrFieldLabel\">Year released</div><div class=\"jrFieldValue \">", n3);
            String string4 = HotudSearchEngine.extractNextContent(string, n4, "<a ", "</a>");
            WebProfile webProfile = new WebProfile();
            webProfile.setTitle(string2);
            webProfile.setYear(string4);
            webProfile.setPlatform("");
            webProfile.setUrl(string3);
            arrayList.add(webProfile);
            int n5 = string.indexOf(HTML_GAME_END_MARKER, n2);
            n = string.indexOf("<tr class=\"row" + (arrayList.size() % 2 + 1) + "\">", n5 + HTML_GAME_END_MARKER.length());
        }
        return arrayList;
    }

    private WebProfile extractSingleEntry(String string) {
        int n = string.indexOf("<base href=");
        String string2 = HotudSearchEngine.extractNextHrefContent(string, n);
        int n2 = string.indexOf("<span itemprop=\"name\">");
        String string3 = HotudSearchEngine.extractNextContent(string, n2, "<span ", "</span>");
        int n3 = string.indexOf("<div class=\"jrListingInfoContainer\">", n2);
        int n4 = string.indexOf("<div class=\"jrFieldLabel\">Year released</div><div class=\"jrFieldValue \">", n3);
        String string4 = HotudSearchEngine.extractNextContent(string, n4, "<a ", "</a>");
        WebProfile webProfile = new WebProfile();
        webProfile.setTitle(string3);
        webProfile.setYear(string4);
        webProfile.setPlatform("");
        webProfile.setUrl(string2);
        return this.setAdditionalFields(webProfile, string);
    }

    @Override
    public WebProfile getEntryDetailedInformation(WebProfile webProfile) throws UnknownHostException, IOException {
        if (webProfile.getNotes() != null) {
            return webProfile;
        }
        return this.setAdditionalFields(webProfile, HotudSearchEngine.getResponseContent(webProfile.getUrl(), "UTF-8"));
    }

    private WebProfile setAdditionalFields(WebProfile webProfile, String string) {
        int n = string.indexOf("<span class=\"jrRatingValue\"");
        n = string.indexOf(">", n);
        int n2 = string.indexOf(" ", n + 1);
        String string2 = string.substring(n + 1, n2).replace(".", "");
        int n3 = 0;
        try {
            n3 = new Integer(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int n4 = string.indexOf("<div class=\"jrFieldGroup game-information\">", n);
        int n5 = string.indexOf("<div class=\"jrFieldLabel\">Developer</div><div class=\"jrFieldValue \">", n4);
        String string3 = HotudSearchEngine.unescapeHtml(HotudSearchEngine.removeAllTags(HotudSearchEngine.extractNextContent(string, n5, "<a ", "</a>")));
        int n6 = string.indexOf("<div class=\"jrFieldLabel\">Publisher</div><div class=\"jrFieldValue \">", n4);
        String string4 = HotudSearchEngine.unescapeHtml(HotudSearchEngine.removeAllTags(HotudSearchEngine.extractNextContent(string, n6, "<a ", "</a>")));
        int n7 = string.indexOf("<div class=\"jrFieldLabel\">Genre</div><div class=\"jrFieldValue \">", n4);
        String string5 = this.stripStars(HotudSearchEngine.extractNextContent(string, n7, "<a ", "</a>"));
        int n8 = string.indexOf("<div class=\"jrFieldLabel\">Platform</div><div class=\"jrFieldValue \">", n4);
        String string6 = HotudSearchEngine.extractNextContent(string, n8, "<a ", "</a>");
        int n9 = string.indexOf("<div class=\"jrListingFulltext\" itemprop=\"description\">", n4);
        String string7 = HotudSearchEngine.unescapeHtml(HotudSearchEngine.removeAllTags(HotudSearchEngine.extractNextContent(string, n9, "<div", "</div>")));
        webProfile.setDeveloperName(string3);
        webProfile.setPublisherName(string4);
        webProfile.setGenre(string5);
        webProfile.setPlatform(string6);
        webProfile.setNotes(string7);
        webProfile.setRank(n3);
        return webProfile;
    }

    private String stripStars(String string) {
        if (string.startsWith("*") && string.endsWith("*")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    @Override
    public SearchEngineImageInformation[] getEntryImages(WebProfile webProfile, int n, int n2, boolean bl) throws IOException {
        webProfile.setWebImages(new SearchEngineImageInformation[0]);
        return webProfile.getWebImages();
    }

    private static class SearchEngineHolder {
        private static WebSearchEngine instance = new HotudSearchEngine();

        private SearchEngineHolder() {
        }
    }
}

