/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.waldheinz.fs.fat;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.dbgl.waldheinz.fs.fat.BlockDevice;
import org.dbgl.waldheinz.fs.fat.Fat16BootSector;
import org.dbgl.waldheinz.fs.fat.Fat32BootSector;
import org.dbgl.waldheinz.fs.fat.FatType;
import org.dbgl.waldheinz.fs.fat.Sector;

public abstract class BootSector
extends Sector {
    public static final int FAT_COUNT_OFFSET = 16;
    public static final int RESERVED_SECTORS_OFFSET = 14;
    public static final int TOTAL_SECTORS_16_OFFSET = 19;
    public static final int TOTAL_SECTORS_32_OFFSET = 32;
    public static final int FILE_SYSTEM_TYPE_LENGTH = 8;
    public static final int SECTORS_PER_CLUSTER_OFFSET = 13;
    public static final int SIZE = 512;

    protected BootSector(BlockDevice blockDevice, long l) {
        super(blockDevice, l, 512);
    }

    public static BootSector read(BlockDevice blockDevice) throws IOException {
        int n;
        int n2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(512);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        long l = 0L;
        if (blockDevice.getSize() > 0x2D0000L) {
            l = 32256L;
            blockDevice.read(0L, byteBuffer);
            if ((byteBuffer.get(510) & 0xFF) != 85 || (byteBuffer.get(511) & 0xFF) != 170) {
                System.err.println("missing boot sector signature");
            }
            for (n2 = 0; n2 < 4; ++n2) {
                n = byteBuffer.getInt(446 + (n2 * 16 + 12));
                if (n <= 0) continue;
                l = byteBuffer.getInt(446 + (n2 * 16 + 8)) * 512;
                break;
            }
        }
        byteBuffer.clear();
        blockDevice.read(l, byteBuffer);
        if ((byteBuffer.get(510) & 0xFF) != 85 || (byteBuffer.get(511) & 0xFF) != 170) {
            System.err.println("missing boot sector signature");
        }
        if ((n2 = (int)byteBuffer.get(13)) <= 0) {
            throw new IOException("suspicious sectors per cluster count " + n2);
        }
        n = byteBuffer.getShort(17);
        int n3 = (n * 32 + (blockDevice.getSectorSize() - 1)) / blockDevice.getSectorSize();
        int n4 = byteBuffer.getShort(19) & 0xFFFF;
        long l2 = (long)byteBuffer.getInt(32) & 0xFFFFFFFFL;
        long l3 = n4 == 0 ? l2 : (long)n4;
        int n5 = byteBuffer.getShort(22) & 0xFFFF;
        long l4 = (long)byteBuffer.getInt(36) & 0xFFFFFFFFL;
        long l5 = n5 == 0 ? l4 : (long)n5;
        short s = byteBuffer.getShort(14);
        byte by = byteBuffer.get(16);
        long l6 = l3 - ((long)s + (long)by * l5 + (long)n3);
        long l7 = l6 / (long)n2;
        BootSector bootSector = l7 > 65524L ? new Fat32BootSector(blockDevice, l) : new Fat16BootSector(blockDevice, l);
        bootSector.read();
        return bootSector;
    }

    public abstract FatType getFatType();

    public abstract long getSectorsPerFat();

    public abstract int getRootDirEntryCount();

    public abstract long getSectorCount();

    public abstract int getFileSystemTypeLabelOffset();

    public abstract int getExtendedBootSignatureOffset();

    public String getFileSystemTypeLabel() {
        StringBuilder stringBuilder = new StringBuilder(8);
        for (int i = 0; i < 8; ++i) {
            stringBuilder.append((char)this.get8(this.getFileSystemTypeLabelOffset() + i));
        }
        return stringBuilder.toString();
    }

    public final long getDataClusterCount() {
        return this.getDataSize() / (long)this.getBytesPerCluster();
    }

    private long getDataSize() {
        return this.getSectorCount() * (long)this.getBytesPerSector() - this.getFilesOffset();
    }

    public String getOemName() {
        int n;
        StringBuilder stringBuilder = new StringBuilder(8);
        for (int i = 0; i < 8 && (n = this.get8(3 + i)) != 0; ++i) {
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    public int getBytesPerSector() {
        return this.get16(11);
    }

    public int getBytesPerCluster() {
        return this.getSectorsPerCluster() * this.getBytesPerSector();
    }

    public int getSectorsPerCluster() {
        return this.get8(13);
    }

    public int getNrReservedSectors() {
        return this.get16(14);
    }

    public final int getNrFats() {
        return this.get8(16);
    }

    protected int getNrLogicalSectors() {
        return this.get16(19);
    }

    protected long getNrTotalSectors() {
        return this.get32(32);
    }

    public int getMediumDescriptor() {
        return this.get8(21);
    }

    public int getSectorsPerTrack() {
        return this.get16(24);
    }

    public int getNrHeads() {
        return this.get16(26);
    }

    public long getNrHiddenSectors() {
        return this.get32(28);
    }

    public long getOffset() {
        return this.offset;
    }

    public long getFatOffset(int n) {
        long l = this.getBytesPerSector();
        long l2 = this.getSectorsPerFat();
        long l3 = this.getNrReservedSectors();
        long l4 = l3 * l;
        long l5 = l2 * l;
        l4 += (long)n * l5;
        return l4 += this.getOffset();
    }

    public long getRootDirOffset() {
        long l = this.getBytesPerSector();
        long l2 = this.getSectorsPerFat();
        int n = this.getNrFats();
        long l3 = this.getFatOffset(0);
        return l3 += (long)n * l2 * l;
    }

    public long getFilesOffset() {
        return this.getRootDirOffset() + (long)(this.getRootDirEntryCount() * 32);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(1024);
        stringBuilder.append("Bootsector :\n");
        stringBuilder.append("oemName=");
        stringBuilder.append(this.getOemName());
        stringBuilder.append('\n');
        stringBuilder.append("medium descriptor = ");
        stringBuilder.append(this.getMediumDescriptor());
        stringBuilder.append('\n');
        stringBuilder.append("Nr heads = ");
        stringBuilder.append(this.getNrHeads());
        stringBuilder.append('\n');
        stringBuilder.append("Sectors per track = ");
        stringBuilder.append(this.getSectorsPerTrack());
        stringBuilder.append('\n');
        stringBuilder.append("Sector per cluster = ");
        stringBuilder.append(this.getSectorsPerCluster());
        stringBuilder.append('\n');
        stringBuilder.append("byte per sector = ");
        stringBuilder.append(this.getBytesPerSector());
        stringBuilder.append('\n');
        stringBuilder.append("Nr fats = ");
        stringBuilder.append(this.getNrFats());
        stringBuilder.append('\n');
        stringBuilder.append("Nr hidden sectors = ");
        stringBuilder.append(this.getNrHiddenSectors());
        stringBuilder.append('\n');
        stringBuilder.append("Nr logical sectors = ");
        stringBuilder.append(this.getNrLogicalSectors());
        stringBuilder.append('\n');
        stringBuilder.append("Nr reserved sector = ");
        stringBuilder.append(this.getNrReservedSectors());
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }
}

