/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.BrowseButton;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.GeneralPurposeGUI;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.conf.Settings;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

public class EditNativeCommandDialog
extends Dialog {
    private Text command;
    private Text parameters;
    private Text cwd;
    private Button waitFor;
    private int orderNr = -1;
    private Settings settings;
    protected Object result;
    protected Shell shell;

    public EditNativeCommandDialog(Shell shell) {
        super(shell, 0);
    }

    public void setCommand(NativeCommand nativeCommand) {
        this.result = nativeCommand;
        this.orderNr = nativeCommand.getOrderNr();
    }

    public Object open() {
        this.settings = Settings.getInstance();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "nativecommanddialog"));
        if (this.result == null) {
            this.shell.setText(this.settings.msg("dialog.nativecommand.title.add"));
        } else {
            this.shell.setText(this.settings.msg("dialog.nativecommand.title.edit"));
        }
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setText(this.settings.msg("dialog.nativecommand.command"));
        this.command = new Text(composite, 2048);
        this.command.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        BrowseButton browseButton = new BrowseButton(composite, 0);
        Label label2 = new Label(composite, 0);
        label2.setText(this.settings.msg("dialog.nativecommand.parameters"));
        this.parameters = new Text(composite, 2048);
        this.parameters.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label label3 = new Label(composite, 0);
        label3.setText(this.settings.msg("dialog.nativecommand.cwd"));
        this.cwd = new Text(composite, 2048);
        this.cwd.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        BrowseButton browseButton2 = new BrowseButton(composite, 0);
        browseButton.connect(this.shell, this.command, this.cwd, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.NATIVE_EXE, false, null);
        browseButton2.connect(this.shell, this.cwd, null, BrowseButton.BrowseType.DIR, BrowseButton.CanonicalType.NATIVE_EXE, false, null);
        Label label4 = new Label(composite, 0);
        label4.setText(this.settings.msg("dialog.nativecommand.waitfor"));
        this.waitFor = new Button(composite, 32);
        this.waitFor.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        Composite composite2 = new Composite((Composite)this.shell, 0);
        composite2.setLayout((Layout)new RowLayout());
        composite2.setLayoutData((Object)"South");
        Button button = new Button(composite2, 0);
        this.shell.setDefaultButton(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!EditNativeCommandDialog.this.isValid()) {
                    return;
                }
                EditNativeCommandDialog.this.result = new NativeCommand(new File(EditNativeCommandDialog.this.command.getText()), EditNativeCommandDialog.this.parameters.getText(), new File(EditNativeCommandDialog.this.cwd.getText()), EditNativeCommandDialog.this.waitFor.getSelection(), EditNativeCommandDialog.this.orderNr);
                EditNativeCommandDialog.this.shell.close();
            }
        });
        button.setText(this.settings.msg("button.ok"));
        Button button2 = new Button(composite2, 0);
        button2.setText(this.settings.msg("button.cancel"));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditNativeCommandDialog.this.result = null;
                EditNativeCommandDialog.this.shell.close();
            }
        });
        RowData rowData = new RowData();
        rowData.width = GeneralPurposeGUI.getWidth(button, button2);
        button.setLayoutData((Object)rowData);
        button2.setLayoutData((Object)rowData);
        if (this.result != null) {
            NativeCommand nativeCommand = (NativeCommand)this.result;
            this.command.setText(nativeCommand.getCommand().getPath());
            this.parameters.setText(nativeCommand.getParameters());
            this.cwd.setText(nativeCommand.getCwd().getPath());
            this.waitFor.setSelection(nativeCommand.isWaitFor());
        }
        this.command.setFocus();
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (StringUtils.isBlank((CharSequence)this.command.getText())) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.nativecommand.required.command"), (Control)this.command);
        } else if (StringUtils.isBlank((CharSequence)this.cwd.getText())) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.nativecommand.required.cwd"), (Control)this.cwd);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }
}

