/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import org.dbgl.exception.InvalidMountstringException;
import org.dbgl.gui.GeneralPurposeGUI;
import org.dbgl.model.Mount;
import org.dbgl.model.conf.Settings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public final class GrabButton {
    private final Button button;

    public GrabButton(Composite composite, int n) {
        Settings settings = Settings.getInstance();
        this.button = GeneralPurposeGUI.createIconButton(composite, n, settings, settings.msg("button.grab"), "grab.png");
    }

    public void connect(final Text text, final List list, final boolean bl) {
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = list.getSelectionIndex();
                if (n == -1 && list.getItemCount() == 1) {
                    list.select(0);
                    n = 0;
                }
                if (n != -1) {
                    try {
                        Mount mount = new Mount(list.getItem(n));
                        if (bl && mount.getMountingType() == Mount.MountingType.IMAGE) {
                            text.setText(mount.getPathAsString());
                        } else {
                            text.setText(mount.getPathAsString() + File.separatorChar);
                        }
                        text.selectAll();
                        text.setFocus();
                    }
                    catch (InvalidMountstringException invalidMountstringException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void setEnabled(boolean bl) {
        this.button.setEnabled(bl);
    }
}

