/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.dbgl.gui.MainWindow;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;
import org.eclipse.swt.SWT;

public class Launcher {
    public static void main(String[] stringArray) {
        String string;
        File file;
        System.out.print("Launching DBGL using " + PlatformUtils.JVM_ARCH + "-Bit VM " + PlatformUtils.JVM_VERSION + " on " + PlatformUtils.OS_NAME + " v" + PlatformUtils.OS_VERSION + PlatformUtils.OS_ARCH + ", " + "HSQL Database Engine" + " " + "1.8.1.3");
        File file2 = new File(System.getProperty("user.home")).getAbsoluteFile();
        if (System.getProperty("swt.library.path") == null && file2.isDirectory() && !PlatformUtils.isDirectoryWritable(file2) && (file = new File(string = "lib").getAbsoluteFile()).isDirectory() && PlatformUtils.isDirectoryWritable(file)) {
            System.out.print(", user.home '" + file2 + "' appears unwritable - switched swt.library.path to '" + string + "'");
            System.setProperty("swt.library.path", string);
        }
        Launcher.loadSWT();
        System.out.println(", SWT v" + SWT.getVersion() + SWT.getPlatform());
        new MainWindow().open();
    }

    public static void loadSWT() {
        try {
            File file = null;
            if (PlatformUtils.IS_WINDOWS) {
                file = new File("lib/swtwin32.jar");
                if (PlatformUtils.JVM_ARCH.equals("64")) {
                    file = new File("lib/swtwin64.jar");
                }
            } else if (PlatformUtils.IS_OSX) {
                file = new File("lib/swtmac32.jar");
                if (PlatformUtils.JVM_ARCH.equals("64")) {
                    file = new File("lib/swtmac64.jar");
                } else if (PlatformUtils.OS_ARCH.startsWith("ppc")) {
                    file = new File("lib/swtmaccb.jar");
                }
            } else if (PlatformUtils.IS_LINUX) {
                file = new File("lib/swtlin32.jar");
                if (PlatformUtils.JVM_ARCH.equals("64")) {
                    file = new File("lib/swtlin64.jar");
                }
            }
            if (file == null || !FileUtils.isExistingFile(file)) {
                file = new File("lib/swt.jar");
            }
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)ClassLoader.getSystemClassLoader(), file.toURI().toURL());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

