/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.db.Database;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.GeneralPurposeGUI;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.LogEntry;
import org.dbgl.model.conf.Settings;
import org.dbgl.swtdesigner.SWTImageManager;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public final class LogDialog
extends Dialog {
    private Shell shell;
    private Settings settings = Settings.getInstance();
    private List<LogEntry> logEntries;
    private Map<String, String> filterClauses = new LinkedHashMap<String, String>();
    private String orderByClause = " ORDER BY ID";
    private LogEntry clickedEntry;
    private Integer clickedColumn;

    public LogDialog(Shell shell, int n) {
        super(shell, n);
    }

    public LogDialog(Shell shell) {
        this(shell, 0);
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return null;
    }

    private void createContents() {
        TableColumn tableColumn;
        int n;
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new GridLayout(3, false));
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "log"));
        this.shell.setText(this.settings.msg("dialog.log.title"));
        final Table table = new Table((Composite)this.shell, 67584);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        final String[] stringArray = new String[]{this.settings.msg("dialog.log.columns.time"), this.settings.msg("dialog.log.columns.event"), this.settings.msg("dialog.log.columns.entitytype"), this.settings.msg("dialog.log.columns.entitytitle"), this.settings.msg("dialog.log.columns.entityid")};
        for (int i = 0; i < stringArray.length; ++i) {
            n = i;
            tableColumn = new TableColumn(table, 0);
            tableColumn.setText(stringArray[i]);
            tableColumn.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    switch (n) {
                        case 0: {
                            LogDialog.this.orderByClause = " ORDER BY ID";
                            break;
                        }
                        case 1: {
                            LogDialog.this.orderByClause = " ORDER BY EVENT";
                            break;
                        }
                        case 2: {
                            LogDialog.this.orderByClause = " ORDER BY ENTITY_TYPE";
                            break;
                        }
                        case 3: {
                            LogDialog.this.orderByClause = " ORDER BY ENTITY_TITLE";
                            break;
                        }
                        case 4: {
                            LogDialog.this.orderByClause = " ORDER BY ENTITY_ID";
                            break;
                        }
                    }
                    TableColumn tableColumn = (TableColumn)event.widget;
                    int n2 = 128;
                    if (tableColumn == table.getSortColumn() && table.getSortDirection() == 128) {
                        n2 = 1024;
                    }
                    if (n2 == 1024) {
                        LogDialog.this.orderByClause = LogDialog.this.orderByClause + " DESC";
                    }
                    LogDialog.this.repopulateEntries(table, tableColumn, n2);
                }
            });
        }
        final Menu menu = new Menu((Decorations)this.shell, 8);
        menu.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                MenuItem[] menuItemArray = menu.getItems();
                for (int i = 0; i < menuItemArray.length; ++i) {
                    menuItemArray[i].dispose();
                }
                if (LogDialog.this.clickedEntry != null && LogDialog.this.clickedColumn != null) {
                    MenuItem menuItem = new MenuItem(menu, 8);
                    switch (LogDialog.this.clickedColumn) {
                        case 0: {
                            menuItem.setText(stringArray[LogDialog.this.clickedColumn] + ": " + Settings.toString(LogDialog.this.clickedEntry.getTime()));
                            break;
                        }
                        case 1: {
                            menuItem.setText(stringArray[LogDialog.this.clickedColumn] + ": " + LogDialog.this.getEventName(LogDialog.this.clickedEntry.getEvent()));
                            break;
                        }
                        case 2: {
                            menuItem.setText(stringArray[LogDialog.this.clickedColumn] + ": " + LogDialog.this.getEntityTypeName(LogDialog.this.clickedEntry.getEntityType()));
                            break;
                        }
                        case 3: {
                            menuItem.setText(stringArray[LogDialog.this.clickedColumn] + ": " + LogDialog.this.clickedEntry.getEntityTitle());
                            break;
                        }
                        case 4: {
                            menuItem.setText(stringArray[LogDialog.this.clickedColumn] + ": " + LogDialog.this.clickedEntry.getEntityId());
                            break;
                        }
                    }
                    menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent selectionEvent) {
                            MenuItem menuItem = (MenuItem)selectionEvent.widget;
                            switch (LogDialog.this.clickedColumn) {
                                case 0: {
                                    Calendar calendar = Calendar.getInstance();
                                    calendar.setTime(LogDialog.this.clickedEntry.getTime());
                                    LogDialog.this.filterClauses.put("YEAR(TIME)=" + calendar.get(1) + " AND MONTH(TIME)=" + (calendar.get(2) + 1) + " AND DAY(TIME)=" + calendar.get(5), menuItem.getText());
                                    break;
                                }
                                case 1: {
                                    LogDialog.this.filterClauses.put("EVENT=" + LogDialog.this.clickedEntry.getEvent().ordinal(), menuItem.getText());
                                    break;
                                }
                                case 2: {
                                    LogDialog.this.filterClauses.put("ENTITY_TYPE=" + LogDialog.this.clickedEntry.getEntityType().ordinal(), menuItem.getText());
                                    break;
                                }
                                case 3: {
                                    LogDialog.this.filterClauses.put("ENTITY_TITLE='" + LogDialog.this.clickedEntry.getEntityTitle() + "'", menuItem.getText());
                                    break;
                                }
                                case 4: {
                                    LogDialog.this.filterClauses.put("ENTITY_ID=" + LogDialog.this.clickedEntry.getEntityId(), menuItem.getText());
                                    break;
                                }
                            }
                            LogDialog.this.repopulateEntries(table, table.getSortColumn(), table.getSortDirection());
                        }
                    });
                    if (!LogDialog.this.filterClauses.isEmpty()) {
                        new MenuItem(menu, 2);
                    }
                }
                for (final Map.Entry entry : LogDialog.this.filterClauses.entrySet()) {
                    MenuItem menuItem = new MenuItem(menu, 8);
                    menuItem.setText((String)entry.getValue());
                    menuItem.setImage(SWTImageManager.getResourceImage(LogDialog.this.shell.getDisplay(), "delete.png"));
                    menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent selectionEvent) {
                            LogDialog.this.filterClauses.remove(entry.getKey());
                            LogDialog.this.repopulateEntries(table, table.getSortColumn(), table.getSortDirection());
                        }
                    });
                }
            }
        });
        table.setMenu(menu);
        table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                LogDialog.this.clickedEntry = null;
                LogDialog.this.clickedColumn = null;
                Point point = new Point(event.x, event.y);
                TableItem tableItem = table.getItem(point);
                if (tableItem == null) {
                    return;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!tableItem.getBounds(i).contains(point)) continue;
                    LogDialog.this.clickedEntry = (LogEntry)LogDialog.this.logEntries.get(table.indexOf(tableItem));
                    LogDialog.this.clickedColumn = i;
                    break;
                }
            }
        });
        this.repopulateEntries(table, table.getColumn(0), 128);
        for (n = 0; n < stringArray.length; ++n) {
            table.getColumn(n).pack();
        }
        Button button = new Button((Composite)this.shell, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LogDialog.this.shell.close();
            }
        });
        this.shell.setDefaultButton(button);
        button.setText(this.settings.msg("button.ok"));
        tableColumn = new Button((Composite)this.shell, 2);
        tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter((Button)tableColumn){
            final /* synthetic */ Button val$enableButton;
            {
                this.val$enableButton = button;
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                LogDialog.this.settings.getSettings().setBooleanValue("log", "enabled", this.val$enableButton.getSelection());
                this.val$enableButton.setText(LogDialog.this.settings.msg(this.val$enableButton.getSelection() ? "dialog.log.enabled" : "dialog.log.disabled"));
            }
        });
        tableColumn.setSelection(this.settings.getSettings().getBooleanValue("log", "enabled"));
        tableColumn.setText(this.settings.msg(tableColumn.getSelection() ? "dialog.log.enabled" : "dialog.log.disabled"));
        Button button2 = new Button((Composite)this.shell, 0);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (GeneralPurposeDialogs.confirmMessage(LogDialog.this.shell, LogDialog.this.settings.msg("dialog.log.confirm.clear"))) {
                    try {
                        Database.getInstance().clearLog();
                        table.removeAll();
                    }
                    catch (SQLException sQLException) {
                        GeneralPurposeDialogs.warningMessage(LogDialog.this.shell, sQLException);
                    }
                }
            }
        });
        button2.setText(this.settings.msg("button.clear"));
        GridData gridData = new GridData(1, 4, true, false);
        gridData.widthHint = GeneralPurposeGUI.getWidth(button, button2);
        button.setLayoutData((Object)gridData);
        GridData gridData2 = new GridData();
        gridData2.widthHint = GeneralPurposeGUI.getWidth((Button)tableColumn, button2);
        tableColumn.setLayoutData((Object)gridData2);
        GridData gridData3 = new GridData();
        gridData3.widthHint = gridData2.widthHint;
        button2.setLayoutData((Object)gridData3);
    }

    private void repopulateEntries(Table table, TableColumn tableColumn, int n) {
        int n2 = table.getSelectionIndex() == -1 ? -1 : this.logEntries.get(table.getSelectionIndex()).getId();
        try {
            String string = this.filterClauses.isEmpty() ? "" : " WHERE " + StringUtils.join(this.filterClauses.keySet(), (String)" AND ");
            this.logEntries = Database.getInstance().readLogEntries(string, this.orderByClause);
        }
        catch (SQLException sQLException) {
            GeneralPurposeDialogs.warningMessage(this.shell, sQLException);
            this.logEntries = new ArrayList<LogEntry>();
        }
        table.removeAll();
        table.setSortColumn(tableColumn);
        table.setSortDirection(n);
        table.setItemCount(this.logEntries.size());
        int n3 = this.logEntries.size() - 1;
        for (int i = 0; i < this.logEntries.size(); ++i) {
            LogEntry logEntry = this.logEntries.get(i);
            TableItem tableItem = table.getItem(i);
            tableItem.setText(0, Settings.toString(logEntry.getTime(), 2));
            tableItem.setText(1, this.getEventName(logEntry.getEvent()));
            tableItem.setText(2, this.getEntityTypeName(logEntry.getEntityType()));
            tableItem.setText(3, logEntry.getEntityTitle());
            tableItem.setText(4, String.valueOf(logEntry.getEntityId()));
            if (n2 != this.logEntries.get(i).getId()) continue;
            n3 = i;
        }
        table.setSelection(n3);
        table.showSelection();
    }

    private String getEventName(LogEntry.Event event) {
        switch (event) {
            case ADD: {
                return this.settings.msg("dialog.log.columns.event.add");
            }
            case EDIT: {
                return this.settings.msg("dialog.log.columns.event.edit");
            }
            case REMOVE: {
                return this.settings.msg("dialog.log.columns.event.remove");
            }
            case DUPLICATE: {
                return this.settings.msg("dialog.log.columns.event.duplicate");
            }
            case RUN: {
                return this.settings.msg("dialog.log.columns.event.run");
            }
            case SETUP: {
                return this.settings.msg("dialog.log.columns.event.setup");
            }
        }
        return "";
    }

    private String getEntityTypeName(LogEntry.EntityType entityType) {
        switch (entityType) {
            case PROFILE: {
                return this.settings.msg("dialog.log.columns.entitytype.profile");
            }
            case DOSBOXVERSION: {
                return this.settings.msg("dialog.template.dosboxversion");
            }
            case TEMPLATE: {
                return this.settings.msg("dialog.profile.template");
            }
            case FILTER: {
                return this.settings.msg("dialog.log.columns.entitytype.filter");
            }
        }
        return "";
    }
}

