/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.util.Vector;
import org.dbgl.gui.GeneralPurposeGUI;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.UIThread;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class Wizard
extends Dialog {
    protected String dialogTitle;
    protected String dialog;
    protected int stepNr = 0;
    protected Vector<Control> steps;
    protected UIThread extensiveJobThread;
    protected boolean hasExtensiveJob;
    protected Composite wizardPanel;
    protected StackLayout wizardLayout;
    protected Button back;
    protected Button next;
    protected Button cancel;
    protected Shell shell;
    protected Settings settings = Settings.getInstance();
    protected Object result;

    public Wizard(Shell shell, int n, String string, String string2, boolean bl) {
        super(shell, n);
        this.steps = new Vector();
        this.hasExtensiveJob = bl;
        this.dialogTitle = string;
        this.dialog = string2;
    }

    protected final void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setText(this.dialogTitle);
        this.shell.setLayout((Layout)new GridLayout(4, false));
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, this.dialog));
        this.wizardPanel = new Composite((Composite)this.shell, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        this.wizardPanel.setLayoutData((Object)gridData);
        this.wizardLayout = new StackLayout();
        this.wizardPanel.setLayout((Layout)this.wizardLayout);
        this.fillPages();
        this.back = new Button((Composite)this.shell, 8);
        this.next = new Button((Composite)this.shell, 8);
        this.back.setText(this.settings.msg("button.back"));
        this.next.setText(this.settings.msg("button.next"));
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.widthHint = GeneralPurposeGUI.getWidth(this.back, this.next);
        this.back.setLayoutData((Object)gridData2);
        this.next.setLayoutData((Object)gridData2);
        this.back.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Wizard.this.previousStep();
            }
        });
        this.next.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Wizard.this.nextStep();
            }
        });
        this.cancel = new Button((Composite)this.shell, 8);
        this.cancel.setText(this.settings.msg("button.cancel"));
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.widthHint = GeneralPurposeGUI.getWidth(this.cancel);
        gridData3.horizontalIndent = 30;
        this.cancel.setLayoutData((Object)gridData3);
        this.cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Wizard.this.shell.close();
            }
        });
        this.shell.setDefaultButton(this.next);
        this.showCurrentStep();
    }

    protected abstract void fillPages();

    public Object open() {
        if (this.init()) {
            this.createContents();
            this.shell.open();
            this.shell.layout();
            Display display = this.getParent().getDisplay();
            while (!this.shell.isDisposed()) {
                if (this.extensiveJobThread != null && !this.extensiveJobThread.isAlive() && !this.next.getEnabled()) {
                    this.nextStep();
                }
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        this.onExit();
        return this.result;
    }

    protected boolean init() {
        return true;
    }

    protected void onExit() {
    }

    protected boolean isValidInput() {
        return true;
    }

    protected boolean actionAfterNext() {
        return true;
    }

    protected int stepSize(boolean bl) {
        return 1;
    }

    protected final boolean isFinished() {
        if (this.hasExtensiveJob) {
            return this.stepNr >= this.steps.size() + 1 && this.extensiveJobThread != null && !this.extensiveJobThread.isAlive();
        }
        return this.stepNr >= this.steps.size() - 1;
    }

    protected final void nextStep() {
        if (this.isValidInput() && this.actionAfterNext()) {
            if (this.isFinished()) {
                this.shell.close();
            } else {
                this.stepNr += this.stepSize(true);
                this.showCurrentStep();
            }
        }
    }

    protected final void previousStep() {
        this.stepNr -= this.stepSize(false);
        this.showCurrentStep();
    }

    protected final void showCurrentStep() {
        if (this.stepNr < this.steps.size()) {
            this.wizardLayout.topControl = this.steps.get(this.stepNr);
            this.wizardPanel.layout();
        }
        boolean bl = this.extensiveJobThread != null;
        boolean bl2 = this.isFinished();
        this.back.setEnabled(this.stepNr > 0 && !bl);
        this.next.setEnabled(!bl || bl2);
        this.cancel.setEnabled(!bl);
        this.next.setText(bl2 ? this.settings.msg("button.finish") : this.settings.msg("button.next"));
        if (this.stepNr > 0) {
            this.wizardLayout.topControl.setFocus();
        }
        if (bl && !bl2) {
            this.extensiveJobThread.start();
        }
    }

    protected final void addStep(Control control) {
        control.setParent(this.wizardPanel);
        this.steps.addElement(control);
    }
}

