/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import org.apache.commons.lang3.StringUtils;

public class ImgSizeCommand {
    private int bytesPerSector;
    private int sectorsPerTrack;
    private int heads;
    private int cylinders;

    public ImgSizeCommand(String string) {
        String[] stringArray = StringUtils.split((String)string, (char)',');
        if (stringArray.length == 4) {
            this.bytesPerSector = this.tryParse(stringArray[0]);
            this.sectorsPerTrack = this.tryParse(stringArray[1]);
            this.heads = this.tryParse(stringArray[2]);
            this.cylinders = this.tryParse(stringArray[3]);
        }
        if (this.bytesPerSector == 0 && this.sectorsPerTrack == 0 && this.heads == 0 && this.cylinders == 0) {
            this.bytesPerSector = 512;
            this.sectorsPerTrack = 63;
            this.heads = 16;
            this.cylinders = 142;
        }
    }

    public ImgSizeCommand(int n, int n2, int n3, int n4) {
        this.bytesPerSector = n;
        this.sectorsPerTrack = n2;
        this.heads = n3;
        this.cylinders = n4;
    }

    private int tryParse(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getBytesPerSector() {
        return this.bytesPerSector;
    }

    public int getSectorsPerTrack() {
        return this.sectorsPerTrack;
    }

    public int getHeads() {
        return this.heads;
    }

    public int getCylinders() {
        return this.cylinders;
    }

    public long getTotalSize() {
        return this.bytesPerSector * this.sectorsPerTrack * this.heads * this.cylinders;
    }

    public long getTotalSizeInMB() {
        return this.getTotalSize() / 0x100000L;
    }

    public String toString() {
        return this.bytesPerSector + "," + this.sectorsPerTrack + "," + this.heads + "," + this.cylinders;
    }
}

