/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import SevenZip.Archive.IArchiveExtractCallback;
import SevenZip.Archive.IInArchive;
import SevenZip.Archive.SevenZipEntry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.TreeMap;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.ProgressNotifyable;

public class SevenzipExtractFilesCallback
implements IArchiveExtractCallback {
    private ProgressNotifyable prog;
    private IInArchive archiveHandler;
    private Map<Integer, File> dstFileMap = new TreeMap<Integer, File>();

    public SevenzipExtractFilesCallback(ProgressNotifyable progressNotifyable, IInArchive iInArchive, Map<Integer, File> map) {
        this.prog = progressNotifyable;
        this.archiveHandler = iInArchive;
        this.dstFileMap = map;
    }

    @Override
    public int SetTotal(long l) {
        return 0;
    }

    @Override
    public int SetCompleted(long l) {
        this.prog.setProgress((int)(l / 1024L));
        return 0;
    }

    @Override
    public int PrepareOperation(int n) {
        return 0;
    }

    @Override
    public int SetOperationResult(int n) throws IOException {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                throw new IOException("Unsupported Method");
            }
            case 3: {
                throw new IOException("CRC Failed");
            }
            case 2: {
                throw new IOException("Data Error");
            }
        }
        throw new IOException("Unknown Error");
    }

    @Override
    public int GetStream(int n, OutputStream[] outputStreamArray, int n2) throws IOException {
        outputStreamArray[0] = null;
        if (n2 == 0) {
            SevenZipEntry sevenZipEntry = this.archiveHandler.getEntry(n);
            File file = this.dstFileMap.get(n);
            if (sevenZipEntry.isDirectory()) {
                if (file.isDirectory()) {
                    return 0;
                }
                if (file.mkdirs()) {
                    return 0;
                }
                return 1;
            }
            File file2 = file.getParentFile();
            if (file2 != null && !file2.isDirectory() && !file2.mkdirs()) {
                return 1;
            }
            if (file.exists()) {
                throw new IOException(Settings.getInstance().msg("general.error.filetobeextractedexists", new Object[]{file}));
            }
            outputStreamArray[0] = new FileOutputStream(file);
        }
        return 0;
    }
}

