/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.waldheinz.fs.fat;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.dbgl.waldheinz.fs.fat.BlockDevice;
import org.dbgl.waldheinz.fs.fat.Fat;

final class ClusterChain {
    protected final Fat fat;
    private final BlockDevice device;
    private final int clusterSize;
    protected final long dataOffset;
    private long startCluster;

    public ClusterChain(Fat fat, long l) {
        this.fat = fat;
        if (l != 0L) {
            this.fat.testCluster(l);
            if (this.fat.isFreeCluster(l)) {
                throw new IllegalArgumentException("cluster " + l + " is free");
            }
        }
        this.device = fat.getDevice();
        this.dataOffset = fat.getBootSector().getFilesOffset();
        this.startCluster = l;
        this.clusterSize = fat.getBootSector().getBytesPerCluster();
    }

    public int getClusterSize() {
        return this.clusterSize;
    }

    public Fat getFat() {
        return this.fat;
    }

    public BlockDevice getDevice() {
        return this.device;
    }

    public long getStartCluster() {
        return this.startCluster;
    }

    private long getDevOffset(long l, int n) {
        return this.dataOffset + (long)n + (l - 2L) * (long)this.clusterSize;
    }

    public long getLengthOnDisk() {
        if (this.getStartCluster() == 0L) {
            return 0L;
        }
        return this.getChainLength() * this.clusterSize;
    }

    public int getChainLength() {
        if (this.getStartCluster() == 0L) {
            return 0;
        }
        long[] lArray = this.getFat().getChain(this.getStartCluster());
        return lArray.length;
    }

    public void readData(long l, ByteBuffer byteBuffer) throws IOException {
        int n;
        int n2 = byteBuffer.remaining();
        if (this.startCluster == 0L && n2 > 0) {
            throw new EOFException();
        }
        long[] lArray = this.getFat().getChain(this.startCluster);
        BlockDevice blockDevice = this.getDevice();
        int n3 = (int)(l / (long)this.clusterSize);
        if (l % (long)this.clusterSize != 0L) {
            n = (int)(l % (long)this.clusterSize);
            int n4 = Math.min(n2, (int)((long)this.clusterSize - l % (long)this.clusterSize - 1L));
            byteBuffer.limit(byteBuffer.position() + n4);
            blockDevice.read(this.getDevOffset(lArray[n3], n), byteBuffer);
            n2 -= n4;
            ++n3;
        }
        while (n2 > 0) {
            n = Math.min(this.clusterSize, n2);
            byteBuffer.limit(byteBuffer.position() + n);
            blockDevice.read(this.getDevOffset(lArray[n3], 0), byteBuffer);
            n2 -= n;
            ++n3;
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ClusterChain)) {
            return false;
        }
        ClusterChain clusterChain = (ClusterChain)object;
        if (!(this.fat == clusterChain.fat || this.fat != null && this.fat.equals(clusterChain.fat))) {
            return false;
        }
        return this.startCluster == clusterChain.startCluster;
    }

    public int hashCode() {
        int n = 3;
        n = 79 * n + (this.fat != null ? this.fat.hashCode() : 0);
        n = 79 * n + (int)(this.startCluster ^ this.startCluster >>> 32);
        return n;
    }
}

