/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleActionEvent;
import org.eclipse.swt.accessibility.AccessibleActionListener;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleAttributeEvent;
import org.eclipse.swt.accessibility.AccessibleAttributeListener;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEditableTextEvent;
import org.eclipse.swt.accessibility.AccessibleEditableTextListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleHyperlinkEvent;
import org.eclipse.swt.accessibility.AccessibleHyperlinkListener;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTableCellEvent;
import org.eclipse.swt.accessibility.AccessibleTableCellListener;
import org.eclipse.swt.accessibility.AccessibleTableEvent;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.accessibility.AccessibleTextAttributeEvent;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextExtendedListener;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.accessibility.AccessibleValueEvent;
import org.eclipse.swt.accessibility.AccessibleValueListener;
import org.eclipse.swt.accessibility.Relation;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IAccessible;
import org.eclipse.swt.internal.ole.win32.IEnumVARIANT;
import org.eclipse.swt.internal.ole.win32.IServiceProvider;
import org.eclipse.swt.internal.ole.win32.VARIANT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TVITEM;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class Accessible {
    static final int MAX_RELATION_TYPES = 15;
    static final int TABLE_MODEL_CHANGE_SIZE = 5;
    static final int TEXT_CHANGE_SIZE = 4;
    static final int SCROLL_RATE = 100;
    static final boolean DEBUG = false;
    static final String PROPERTY_USEIA2 = "org.eclipse.swt.accessibility.UseIA2";
    static boolean UseIA2 = true;
    static int UniqueID = -16;
    int refCount = 0;
    int enumIndex = 0;
    Runnable timer;
    COMObject objIAccessible;
    COMObject objIEnumVARIANT;
    COMObject objIServiceProvider;
    COMObject objIAccessible2;
    COMObject objIAccessibleAction;
    COMObject objIAccessibleApplication;
    COMObject objIAccessibleEditableText;
    COMObject objIAccessibleHyperlink;
    COMObject objIAccessibleHypertext;
    COMObject objIAccessibleTable2;
    COMObject objIAccessibleTableCell;
    COMObject objIAccessibleText;
    COMObject objIAccessibleValue;
    IAccessible iaccessible;
    List<AccessibleListener> accessibleListeners;
    List<AccessibleControlListener> accessibleControlListeners;
    List<AccessibleTextListener> accessibleTextListeners;
    List<AccessibleActionListener> accessibleActionListeners;
    List<AccessibleEditableTextListener> accessibleEditableTextListeners;
    List<AccessibleHyperlinkListener> accessibleHyperlinkListeners;
    List<AccessibleTableListener> accessibleTableListeners;
    List<AccessibleTableCellListener> accessibleTableCellListeners;
    List<AccessibleTextExtendedListener> accessibleTextExtendedListeners;
    List<AccessibleValueListener> accessibleValueListeners;
    List<AccessibleAttributeListener> accessibleAttributeListeners;
    Relation[] relations = new Relation[15];
    Object[] variants;
    Accessible parent;
    List<Accessible> children = new ArrayList<Accessible>();
    Control control;
    int uniqueID = -1;
    int[] tableChange;
    Object[] textDeleted;
    Object[] textInserted;
    ToolItem item;

    public Accessible(Accessible accessible) {
        this.parent = Accessible.checkNull(accessible);
        this.control = accessible.control;
        accessible.children.add(this);
        this.AddRef();
    }

    @Deprecated
    protected Accessible() {
    }

    Accessible(Control control) {
        this.control = control;
        long[] lArray = new long[1];
        int n = COM.CreateStdAccessibleObject(control.handle, -4, COM.IIDIAccessible, lArray);
        if (lArray[0] == 0L) {
            return;
        }
        if (n != 0) {
            OLE.error(1001, n);
        }
        this.iaccessible = new IAccessible(lArray[0]);
        this.createIAccessible();
        this.AddRef();
    }

    Accessible(Accessible accessible, long l) {
        this(accessible);
        this.iaccessible = new IAccessible(l);
    }

    static Accessible checkNull(Accessible accessible) {
        if (accessible == null) {
            SWT.error(4);
        }
        return accessible;
    }

    void createIAccessible() {
        this.objIAccessible = new COMObject(new int[]{2, 0, 0, 1, 3, 5, 8, 1, 1, 2, 2, 2, 2, 2, 2, 2, 3, 2, 1, 1, 2, 2, 5, 3, 3, 1, 2, 2}){

            @Override
            public long method0(long[] lArray) {
                return Accessible.this.QueryInterface(lArray[0], lArray[1]);
            }

            @Override
            public long method1(long[] lArray) {
                return Accessible.this.AddRef();
            }

            @Override
            public long method2(long[] lArray) {
                return Accessible.this.Release();
            }

            @Override
            public long method7(long[] lArray) {
                return Accessible.this.get_accParent(lArray[0]);
            }

            @Override
            public long method8(long[] lArray) {
                return Accessible.this.get_accChildCount(lArray[0]);
            }

            @Override
            public long method9(long[] lArray) {
                return Accessible.this.get_accChild(lArray[0], lArray[1]);
            }

            @Override
            public long method10(long[] lArray) {
                return Accessible.this.get_accName(lArray[0], lArray[1]);
            }

            @Override
            public long method11(long[] lArray) {
                return Accessible.this.get_accValue(lArray[0], lArray[1]);
            }

            @Override
            public long method12(long[] lArray) {
                return Accessible.this.get_accDescription(lArray[0], lArray[1]);
            }

            @Override
            public long method13(long[] lArray) {
                return Accessible.this.get_accRole(lArray[0], lArray[1]);
            }

            @Override
            public long method14(long[] lArray) {
                return Accessible.this.get_accState(lArray[0], lArray[1]);
            }

            @Override
            public long method15(long[] lArray) {
                return Accessible.this.get_accHelp(lArray[0], lArray[1]);
            }

            @Override
            public long method16(long[] lArray) {
                return Accessible.this.get_accHelpTopic(lArray[0], lArray[1], lArray[2]);
            }

            @Override
            public long method17(long[] lArray) {
                return Accessible.this.get_accKeyboardShortcut(lArray[0], lArray[1]);
            }

            @Override
            public long method18(long[] lArray) {
                return Accessible.this.get_accFocus(lArray[0]);
            }

            @Override
            public long method19(long[] lArray) {
                return Accessible.this.get_accSelection(lArray[0]);
            }

            @Override
            public long method20(long[] lArray) {
                return Accessible.this.get_accDefaultAction(lArray[0], lArray[1]);
            }

            @Override
            public long method21(long[] lArray) {
                return Accessible.this.accSelect((int)lArray[0], lArray[1]);
            }

            @Override
            public long method22(long[] lArray) {
                return Accessible.this.accLocation(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4]);
            }

            @Override
            public long method23(long[] lArray) {
                return Accessible.this.accNavigate((int)lArray[0], lArray[1], lArray[2]);
            }

            @Override
            public long method24(long[] lArray) {
                return Accessible.this.accHitTest((int)lArray[0], (int)lArray[1], lArray[2]);
            }

            @Override
            public long method25(long[] lArray) {
                return Accessible.this.accDoDefaultAction(lArray[0]);
            }

            @Override
            public long method26(long[] lArray) {
                return Accessible.this.put_accName(lArray[0], lArray[1]);
            }

            @Override
            public long method27(long[] lArray) {
                return Accessible.this.put_accValue(lArray[0], lArray[1]);
            }
        };
        long l = this.objIAccessible.ppVtable;
        long[] lArray = new long[1];
        COM.MoveMemory(lArray, l, OS.PTR_SIZEOF);
        long[] lArray2 = new long[28];
        COM.MoveMemory(lArray2, lArray[0], OS.PTR_SIZEOF * lArray2.length);
        lArray2[9] = COM.get_accChild_CALLBACK(lArray2[9]);
        lArray2[10] = COM.get_accName_CALLBACK(lArray2[10]);
        lArray2[11] = COM.get_accValue_CALLBACK(lArray2[11]);
        lArray2[12] = COM.get_accDescription_CALLBACK(lArray2[12]);
        lArray2[13] = COM.get_accRole_CALLBACK(lArray2[13]);
        lArray2[14] = COM.get_accState_CALLBACK(lArray2[14]);
        lArray2[15] = COM.get_accHelp_CALLBACK(lArray2[15]);
        lArray2[16] = COM.get_accHelpTopic_CALLBACK(lArray2[16]);
        lArray2[17] = COM.get_accKeyboardShortcut_CALLBACK(lArray2[17]);
        lArray2[20] = COM.get_accDefaultAction_CALLBACK(lArray2[20]);
        lArray2[21] = COM.accSelect_CALLBACK(lArray2[21]);
        lArray2[22] = COM.accLocation_CALLBACK(lArray2[22]);
        lArray2[23] = COM.accNavigate_CALLBACK(lArray2[23]);
        lArray2[25] = COM.accDoDefaultAction_CALLBACK(lArray2[25]);
        lArray2[26] = COM.put_accName_CALLBACK(lArray2[26]);
        lArray2[27] = COM.put_accValue_CALLBACK(lArray2[27]);
        COM.MoveMemory(lArray[0], lArray2, OS.PTR_SIZEOF * lArray2.length);
    }

    void createIAccessible2() {
        this.objIAccessible2 = new COMObject(new int[]{2, 0, 0, 1, 3, 5, 8, 1, 1, 2, 2, 2, 2, 2, 2, 2, 3, 2, 1, 1, 2, 2, 5, 3, 3, 1, 2, 2, 1, 2, 3, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1}){

            @Override
            public long method0(long[] lArray) {
                return Accessible.this.QueryInterface(lArray[0], lArray[1]);
            }

            @Override
            public long method1(long[] lArray) {
                return Accessible.this.AddRef();
            }

            @Override
            public long method2(long[] lArray) {
                return Accessible.this.Release();
            }

            @Override
            public long method7(long[] lArray) {
                return Accessible.this.get_accParent(lArray[0]);
            }

            @Override
            public long method8(long[] lArray) {
                return Accessible.this.get_accChildCount(lArray[0]);
            }

            @Override
            public long method9(long[] lArray) {
                return Accessible.this.get_accChild(lArray[0], lArray[1]);
            }

            @Override
            public long method10(long[] lArray) {
                return Accessible.this.get_accName(lArray[0], lArray[1]);
            }

            @Override
            public long method11(long[] lArray) {
                return Accessible.this.get_accValue(lArray[0], lArray[1]);
            }

            @Override
            public long method12(long[] lArray) {
                return Accessible.this.get_accDescription(lArray[0], lArray[1]);
            }

            @Override
            public long method13(long[] lArray) {
                return Accessible.this.get_accRole(lArray[0], lArray[1]);
            }

            @Override
            public long method14(long[] lArray) {
                return Accessible.this.get_accState(lArray[0], lArray[1]);
            }

            @Override
            public long method15(long[] lArray) {
                return Accessible.this.get_accHelp(lArray[0], lArray[1]);
            }

            @Override
            public long method16(long[] lArray) {
                return Accessible.this.get_accHelpTopic(lArray[0], lArray[1], lArray[2]);
            }

            @Override
            public long method17(long[] lArray) {
                return Accessible.this.get_accKeyboardShortcut(lArray[0], lArray[1]);
            }

            @Override
            public long method18(long[] lArray) {
                return Accessible.this.get_accFocus(lArray[0]);
            }

            @Override
            public long method19(long[] lArray) {
                return Accessible.this.get_accSelection(lArray[0]);
            }

            @Override
            public long method20(long[] lArray) {
                return Accessible.this.get_accDefaultAction(lArray[0], lArray[1]);
            }

            @Override
            public long method21(long[] lArray) {
                return Accessible.this.accSelect((int)lArray[0], lArray[1]);
            }

            @Override
            public long method22(long[] lArray) {
                return Accessible.this.accLocation(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4]);
            }

            @Override
            public long method23(long[] lArray) {
                return Accessible.this.accNavigate((int)lArray[0], lArray[1], lArray[2]);
            }

            @Override
            public long method24(long[] lArray) {
                return Accessible.this.accHitTest((int)lArray[0], (int)lArray[1], lArray[2]);
            }

            @Override
            public long method25(long[] lArray) {
                return Accessible.this.accDoDefaultAction(lArray[0]);
            }

            @Override
            public long method26(long[] lArray) {
                return Accessible.this.put_accName(lArray[0], lArray[1]);
            }

            @Override
            public long method27(long[] lArray) {
                return Accessible.this.put_accValue(lArray[0], lArray[1]);
            }

            @Override
            public long method28(long[] lArray) {
                return Accessible.this.get_nRelations(lArray[0]);
            }

            @Override
            public long method29(long[] lArray) {
                return Accessible.this.get_relation((int)lArray[0], lArray[1]);
            }

            @Override
            public long method30(long[] lArray) {
                return Accessible.this.get_relations((int)lArray[0], lArray[1], lArray[2]);
            }

            @Override
            public long method31(long[] lArray) {
                return Accessible.this.get_role(lArray[0]);
            }

            @Override
            public long method32(long[] lArray) {
                return Accessible.this.scrollTo((int)lArray[0]);
            }

            @Override
            public long method33(long[] lArray) {
                return Accessible.this.scrollToPoint((int)lArray[0], (int)lArray[1], (int)lArray[2]);
            }

            @Override
            public long method34(long[] lArray) {
                return Accessible.this.get_groupPosition(lArray[0], lArray[1], lArray[2]);
            }

            @Override
            public long method35(long[] lArray) {
                return Accessible.this.get_states(lArray[0]);
            }

            @Override
            public long method36(long[] lArray) {
                return Accessible.this.get_extendedRole(lArray[0]);
            }

            @Override
            public long method37(long[] lArray) {
                return Accessible.this.get_localizedExtendedRole(lArray[0]);
            }

            @Override
            public long method38(long[] lArray) {
                return Accessible.this.get_nExtendedStates(lArray[0]);
            }

            @Override
            public long method39(long[] lArray) {
                return Accessible.this.get_extendedStates((int)lArray[0], lArray[1], lArray[2]);
            }

            @Override
            public long method40(long[] lArray) {
                return Accessible.this.get_localizedExtendedStates((int)lArray[0], lArray[1], lArray[2]);
            }

            @Override
            public long method41(long[] lArray) {
                return Accessible.this.get_uniqueID(lArray[0]);
            }

            @Override
            public long method42(long[] lArray) {
                return Accessible.this.get_windowHandle(lArray[0]);
            }

            @Override
            public long method43(long[] lArray) {
                return Accessible.this.get_indexInParent(lArray[0]);
            }

            @Override
            public long method44(long[] lArray) {
                return Accessible.this.get_locale(lArray[0]);
            }

            @Override
            public long method45(long[] lArray) {
                return Accessible.this.get_attributes(lArray[0]);
            }
        };
        long l = this.objIAccessible2.ppVtable;
        long[] lArray = new long[1];
        COM.MoveMemory(lArray, l, OS.PTR_SIZEOF);
        long[] lArray2 = new long[28];
        COM.MoveMemory(lArray2, lArray[0], OS.PTR_SIZEOF * lArray2.length);
        lArray2[9] = COM.get_accChild_CALLBACK(lArray2[9]);
        lArray2[10] = COM.get_accName_CALLBACK(lArray2[10]);
        lArray2[11] = COM.get_accValue_CALLBACK(lArray2[11]);
        lArray2[12] = COM.get_accDescription_CALLBACK(lArray2[12]);
        lArray2[13] = COM.get_accRole_CALLBACK(lArray2[13]);
        lArray2[14] = COM.get_accState_CALLBACK(lArray2[14]);
        lArray2[15] = COM.get_accHelp_CALLBACK(lArray2[15]);
        lArray2[16] = COM.get_accHelpTopic_CALLBACK(lArray2[16]);
        lArray2[17] = COM.get_accKeyboardShortcut_CALLBACK(lArray2[17]);
        lArray2[20] = COM.get_accDefaultAction_CALLBACK(lArray2[20]);
        lArray2[21] = COM.accSelect_CALLBACK(lArray2[21]);
        lArray2[22] = COM.accLocation_CALLBACK(lArray2[22]);
        lArray2[23] = COM.accNavigate_CALLBACK(lArray2[23]);
        lArray2[25] = COM.accDoDefaultAction_CALLBACK(lArray2[25]);
        lArray2[26] = COM.put_accName_CALLBACK(lArray2[26]);
        lArray2[27] = COM.put_accValue_CALLBACK(lArray2[27]);
        COM.MoveMemory(lArray[0], lArray2, OS.PTR_SIZEOF * lArray2.length);
    }

    void createIAccessibleAction() {
        this.objIAccessibleAction = new COMObject(new int[]{2, 0, 0, 1, 1, 2, 4, 2, 2}){

            @Override
            public long method0(long[] lArray) {
                return Accessible.this.QueryInterface(lArray[0], lArray[1]);
            }

            @Override
            public long method1(long[] lArray) {
                return Accessible.this.AddRef();
            }

            @Override
            public long method2(long[] lArray) {
                return Accessible.this.Release();
            }

            @Override
            public long method3(long[] lArray) {
                return Accessible.this.get_nActions(lArray[0]);
            }

            @Override
            public long method4(long[] lArray) {
                return Accessible.this.doAction((int)lArray[0]);
            }

            @Override
            public long method5(long[] lArray) {
                return Accessible.this.get_description((int)lArray[0], lArray[1]);
            }

            @Override
            public long method6(long[] lArray) {
                return Accessible.this.get_keyBinding((int)lArray[0], (int)lArray[1], lArray[2], lArray[3]);
            }

            @Override
            public long method7(long[] lArray) {
                return Accessible.this.get_name((int)lArray[0], lArray[1]);
            }

            @Override
            public long method8(long[] lArray) {
                return Accessible.this.get_localizedName((int)lArray[0], lArray[1]);
            }
        };
    }

    void createIAccessibleApplication() {
        this.objIAccessibleApplication = new COMObject(new int[]{2, 0, 0, 1, 1, 1, 1}){

            @Override
            public long method0(long[] lArray) {
                return Accessible.this.QueryInterface(lArray[0], lArray[1]);
            }

            @Override
            public long method1(long[] lArray) {
                return Accessible.this.AddRef();
            }

            @Override
            public long method2(long[] lArray) {
                return Accessible.this.Release();
            }

            @Override
            public long method3(long[] lArray) {
                return Accessible.this.get_appName(lArray[0]);
            }

            @Override
            public long method4(long[] lArray) {
                return Accessible.this.get_appVersion(lArray[0]);
            }

            @Override
            public long method5(long[] lArray) {
                return Accessible.this.get_toolkitName(lArray[0]);
            }

            @Override
            public long method6(long[] lArray) {
                return Accessible.this.get_toolkitVersion(lArray[0]);
            }
        };
    }

    void createIAccessibleEditableText() {
        this.objIAccessibleEditableText = new COMObject(new int[]{2, 0, 0, 2, 2, 2, 2, 1, 3, 3}){

            @Override
            public long method0(long[] lArray) {
                return Accessible.this.QueryInterface(lArray[0], lArray[1]);
            }

            @Override
            public long method1(long[] lArray) {
                return Accessible.this.AddRef();
            }

            @Override
            public long method2(long[] lArray) {
                return Accessible.this.Release();
            }

            @Override
            public long method3(long[] lArray) {
                return Accessible.this.copyText((int)lArray[0], (int)lArray[1]);
            }

            @Override
            public long method4(long[] lArray) {
                return Accessible.this.deleteText((int)lArray[0], (int)lArray[1]);
            }

            @Override
            public long method5(long[] lArray) {
                return Accessible.this.insertText((int)lArray[0], lArray[1]);
            }

            @Override
            public long method6(long[] lArray) {
                return Accessible.this.cutText((int)lArray[0], (int)lArray[1]);
            }

            @Override
            public long method7(long[] lArray) {
                return Accessible.this.pasteText((int)lArray[0]);
            }

            @Override
            public long method8(long[] lArray) {
                return Accessible.this.replaceText((int)lArray[0], (int)lArray[1], lArray[2]);
            }

            @Override
            public long method9(long[] lArray) {
                return Accessible.this.setAttributes((int)lArray[0], (int)lArray[1], lArray[2]);
            }
        };
    }

    void createIAccessibleHyperlink() {
        this.objIAccessibleHyperlink = new COMObject(new int[]{2, 0, 0, 1, 1, 2, 4, 2, 2, 2, 2, 1, 1, 1}){

            @Override
            public long method0(long[] lArray) {
                return Accessible.this.QueryInterface(lArray[0], lArray[1]);
            }

            @Override
            public long method1(long[] lArray) {
                return Accessible.this.AddRef();
            }

            @Override
            public long method2(long[] lArray) {
                return Accessible.this.Release();
            }

            @Override
            public long method3(long[] lArray) {
                return Accessible.this.get_nActions(lArray[0]);
            }

            @Override
            public long method4(long[] lArray) {
                return Accessible.this.doAction((int)lArray[0]);
            }

            @Override
            public long method5(long[] lArray) {
                return Accessible.this.get_description((int)lArray[0], lArray[1]);
            }

            @Override
            public long method6(long[] lArray) {
                return Accessible.this.get_keyBinding((int)lArray[0], (int)lArray[1], lArray[2], lArray[3]);
            }

            @Override
            public long method7(long[] lArray) {
                return Accessible.this.get_name((int)lArray[0], lArray[1]);
            }

            @Override
            public long method8(long[] lArray) {
                return Accessible.this.get_localizedName((int)lArray[0], lArray[1]);
            }

            @Override
            public long method9(long[] lArray) {
                return Accessible.this.get_anchor((int)lArray[0], lArray[1]);
            }

            @Override
            public long method10(long[] lArray) {
                return Accessible.this.get_anchorTarget((int)lArray[0], lArray[1]);
            }

            @Override
            public long method11(long[] lArray) {
                return Accessible.this.get_startIndex(lArray[0]);
            }

            @Override
            public long method12(long[] lArray) {
                return Accessible.this.get_endIndex(lArray[0]);
            }

            @Override
            public long method13(long[] lArray) {
                return Accessible.this.get_valid(lArray[0]);
            }
        };
    }

    void createIAccessibleHypertext() {
        this.objIAccessibleHypertext = new COMObject(new int[]{2, 0, 0, 2, 4, 1, 6, 1, 4, 3, 3, 5, 5, 5, 1, 1, 3, 1, 3, 5, 1, 1, 1, 2, 2}){

            @Override
            public long method0(long[] lArray) {
                return Accessible.this.QueryInterface(lArray[0], lArray[1]);
            }

            @Override
            public long method1(long[] lArray) {
                return Accessible.this.AddRef();
            }

            @Override
            public long method2(long[] lArray) {
                return Accessible.this.Release();
            }

            @Override
            public long method3(long[] lArray) {
                return Accessible.this.addSelection((int)lArray[0], (int)lArray[1]);
            }

            @Override
            public long method4(long[] lArray) {
                return Accessible.this.get_attributes((int)lArray[0], lArray[1], lArray[2], lArray[3]);
            }

            @Override
            public long method5(long[] lArray) {
                return Accessible.this.get_caretOffset(lArray[0]);
            }

            @Override
            public long method6(long[] lArray) {
                return Accessible.this.get_characterExtents((int)lArray[0], (int)lArray[1], lArray[2], lArray[3], lArray[4], lArray[5]);
            }

            @Override
            public long method7(long[] lArray) {
                return Accessible.this.get_nSelections(lArray[0]);
            }

            @Override
            public long method8(long[] lArray) {
                return Accessible.this.get_offsetAtPoint((int)lArray[0], (int)lArray[1], (int)lArray[2], lArray[3]);
            }

            @Override
            public long method9(long[] lArray) {
                return Accessible.this.get_selection((int)lArray[0], lArray[1], lArray[2]);
            }

            @Override
            public long method10(long[] lArray) {
                return Accessible.this.get_text((int)lArray[0], (int)lArray[1], lArray[2]);
            }

            @Override
            public long method11(long[] lArray) {
                return Accessible.this.get_textBeforeOffset((int)lArray[0], (int)lArray[1], lArray[2], lArray[3], lArray[4]);
            }

            @Override
            public long method12(long[] lArray) {
                return Accessible.this.get_textAfterOffset((int)lArray[0], (int)lArray[1], lArray[2], lArray[3], lArray[4]);
            }

            @Override
            public long method13(long[] lArray) {
                return Accessible.this.get_textAtOffset((int)lArray[0], (int)lArray[1], lArray[2], lArray[3], lArray[4]);
            }

            @Override
            public long method14(long[] lArray) {
                return Accessible.this.removeSelection((int)lArray[0]);
            }

            @Override
            public long method15(long[] lArray) {
                return Accessible.this.setCaretOffset((int)lArray[0]);
            }

            @Override
            public long method16(long[] lArray) {
                return Accessible.this.setSelection((int)lArray[0], (int)lArray[1], (int)lArray[2]);
            }

            @Override
            public long method17(long[] lArray) {
                return Accessible.this.get_nCharacters(lArray[0]);
            }

            @Override
            public long method18(long[] lArray) {
                return Accessible.this.scrollSubstringTo((int)lArray[0], (int)lArray[1], (int)lArray[2]);
            }

            @Override
            public long method19(long[] lArray) {
                return Accessible.this.scrollSubstringToPoint((int)lArray[0], (int)lArray[1], (int)lArray[2], (int)lArray[3], (int)lArray[4]);
            }

            @Override
            public long method20(long[] lArray) {
                return Accessible.this.get_newText(lArray[0]);
            }

            @Override
            public long method21(long[] lArray) {
                return Accessible.this.get_oldText(lArray[0]);
            }

            @Override
            public long method22(long[] lArray) {
                return Accessible.this.get_nHyperlinks(lArray[0]);
            }

            @Override
            public long method23(long[] lArray) {
                return Accessible.this.get_hyperlink((int)lArray[0], lArray[1]);
            }

            @Override
            public long method24(long[] lArray) {
                return Accessible.this.get_hyperlinkIndex((int)lArray[0], lArray[1]);
            }
        };
    }

    void createIAccessibleTable2() {
        this.objIAccessibleTable2 = new COMObject(new int[]{2, 0, 0, 3, 1, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 2, 2, 1, 1, 1, 1, 1}){

            @Override
            public long method0(long[] lArray) {
                return Accessible.this.QueryInterface(lArray[0], lArray[1]);
            }

            @Override
            public long method1(long[] lArray) {
                return Accessible.this.AddRef();
            }

            @Override
            public long method2(long[] lArray) {
                return Accessible.this.Release();
            }

            @Override
            public long method3(long[] lArray) {
                return Accessible.this.get_cellAt((int)lArray[0], (int)lArray[1], lArray[2]);
            }

            @Override
            public long method4(long[] lArray) {
                return Accessible.this.get_caption(lArray[0]);
            }

            @Override
            public long method5(long[] lArray) {
                return Accessible.this.get_columnDescription((int)lArray[0], lArray[1]);
            }

            @Override
            public long method6(long[] lArray) {
                return Accessible.this.get_nColumns(lArray[0]);
            }

            @Override
            public long method7(long[] lArray) {
                return Accessible.this.get_nRows(lArray[0]);
            }

            @Override
            public long method8(long[] lArray) {
                return Accessible.this.get_nSelectedCells(lArray[0]);
            }

            @Override
            public long method9(long[] lArray) {
                return Accessible.this.get_nSelectedColumns(lArray[0]);
            }

            @Override
            public long method10(long[] lArray) {
                return Accessible.this.get_nSelectedRows(lArray[0]);
            }

            @Override
            public long method11(long[] lArray) {
                return Accessible.this.get_rowDescription((int)lArray[0], lArray[1]);
            }

            @Override
            public long method12(long[] lArray) {
                return Accessible.this.get_selectedCells(lArray[0], lArray[1]);
            }

            @Override
            public long method13(long[] lArray) {
                return Accessible.this.get_selectedColumns(lArray[0], lArray[1]);
            }

            @Override
            public long method14(long[] lArray) {
                return Accessible.this.get_selectedRows(lArray[0], lArray[1]);
            }

            @Override
            public long method15(long[] lArray) {
                return Accessible.this.get_summary(lArray[0]);
            }

            @Override
            public long method16(long[] lArray) {
                return Accessible.this.get_isColumnSelected((int)lArray[0], lArray[1]);
            }

            @Override
            public long method17(long[] lArray) {
                return Accessible.this.get_isRowSelected((int)lArray[0], lArray[1]);
            }

            @Override
            public long method18(long[] lArray) {
                return Accessible.this.selectRow((int)lArray[0]);
            }

            @Override
            public long method19(long[] lArray) {
                return Accessible.this.selectColumn((int)lArray[0]);
            }

            @Override
            public long method20(long[] lArray) {
                return Accessible.this.unselectRow((int)lArray[0]);
            }

            @Override
            public long method21(long[] lArray) {
                return Accessible.this.unselectColumn((int)lArray[0]);
            }

            @Override
            public long method22(long[] lArray) {
                return Accessible.this.get_modelChange(lArray[0]);
            }
        };
    }

    void createIAccessibleTableCell() {
        this.objIAccessibleTableCell = new COMObject(new int[]{2, 0, 0, 1, 2, 1, 1, 2, 1, 1, 5, 1}){

            @Override
            public long method0(long[] lArray) {
                return Accessible.this.QueryInterface(lArray[0], lArray[1]);
            }

            @Override
            public long method1(long[] lArray) {
                return Accessible.this.AddRef();
            }

            @Override
            public long method2(long[] lArray) {
                return Accessible.this.Release();
            }

            @Override
            public long method3(long[] lArray) {
                return Accessible.this.get_columnExtent(lArray[0]);
            }

            @Override
            public long method4(long[] lArray) {
                return Accessible.this.get_columnHeaderCells(lArray[0], lArray[1]);
            }

            @Override
            public long method5(long[] lArray) {
                return Accessible.this.get_columnIndex(lArray[0]);
            }

            @Override
            public long method6(long[] lArray) {
                return Accessible.this.get_rowExtent(lArray[0]);
            }

            @Override
            public long method7(long[] lArray) {
                return Accessible.this.get_rowHeaderCells(lArray[0], lArray[1]);
            }

            @Override
            public long method8(long[] lArray) {
                return Accessible.this.get_rowIndex(lArray[0]);
            }

            @Override
            public long method9(long[] lArray) {
                return Accessible.this.get_isSelected(lArray[0]);
            }

            @Override
            public long method10(long[] lArray) {
                return Accessible.this.get_rowColumnExtents(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4]);
            }

            @Override
            public long method11(long[] lArray) {
                return Accessible.this.get_table(lArray[0]);
            }
        };
    }

    void createIAccessibleText() {
        this.objIAccessibleText = new COMObject(new int[]{2, 0, 0, 2, 4, 1, 6, 1, 4, 3, 3, 5, 5, 5, 1, 1, 3, 1, 3, 5, 1, 1}){

            @Override
            public long method0(long[] lArray) {
                return Accessible.this.QueryInterface(lArray[0], lArray[1]);
            }

            @Override
            public long method1(long[] lArray) {
                return Accessible.this.AddRef();
            }

            @Override
            public long method2(long[] lArray) {
                return Accessible.this.Release();
            }

            @Override
            public long method3(long[] lArray) {
                return Accessible.this.addSelection((int)lArray[0], (int)lArray[1]);
            }

            @Override
            public long method4(long[] lArray) {
                return Accessible.this.get_attributes((int)lArray[0], lArray[1], lArray[2], lArray[3]);
            }

            @Override
            public long method5(long[] lArray) {
                return Accessible.this.get_caretOffset(lArray[0]);
            }

            @Override
            public long method6(long[] lArray) {
                return Accessible.this.get_characterExtents((int)lArray[0], (int)lArray[1], lArray[2], lArray[3], lArray[4], lArray[5]);
            }

            @Override
            public long method7(long[] lArray) {
                return Accessible.this.get_nSelections(lArray[0]);
            }

            @Override
            public long method8(long[] lArray) {
                return Accessible.this.get_offsetAtPoint((int)lArray[0], (int)lArray[1], (int)lArray[2], lArray[3]);
            }

            @Override
            public long method9(long[] lArray) {
                return Accessible.this.get_selection((int)lArray[0], lArray[1], lArray[2]);
            }

            @Override
            public long method10(long[] lArray) {
                return Accessible.this.get_text((int)lArray[0], (int)lArray[1], lArray[2]);
            }

            @Override
            public long method11(long[] lArray) {
                return Accessible.this.get_textBeforeOffset((int)lArray[0], (int)lArray[1], lArray[2], lArray[3], lArray[4]);
            }

            @Override
            public long method12(long[] lArray) {
                return Accessible.this.get_textAfterOffset((int)lArray[0], (int)lArray[1], lArray[2], lArray[3], lArray[4]);
            }

            @Override
            public long method13(long[] lArray) {
                return Accessible.this.get_textAtOffset((int)lArray[0], (int)lArray[1], lArray[2], lArray[3], lArray[4]);
            }

            @Override
            public long method14(long[] lArray) {
                return Accessible.this.removeSelection((int)lArray[0]);
            }

            @Override
            public long method15(long[] lArray) {
                return Accessible.this.setCaretOffset((int)lArray[0]);
            }

            @Override
            public long method16(long[] lArray) {
                return Accessible.this.setSelection((int)lArray[0], (int)lArray[1], (int)lArray[2]);
            }

            @Override
            public long method17(long[] lArray) {
                return Accessible.this.get_nCharacters(lArray[0]);
            }

            @Override
            public long method18(long[] lArray) {
                return Accessible.this.scrollSubstringTo((int)lArray[0], (int)lArray[1], (int)lArray[2]);
            }

            @Override
            public long method19(long[] lArray) {
                return Accessible.this.scrollSubstringToPoint((int)lArray[0], (int)lArray[1], (int)lArray[2], (int)lArray[3], (int)lArray[4]);
            }

            @Override
            public long method20(long[] lArray) {
                return Accessible.this.get_newText(lArray[0]);
            }

            @Override
            public long method21(long[] lArray) {
                return Accessible.this.get_oldText(lArray[0]);
            }
        };
    }

    void createIAccessibleValue() {
        this.objIAccessibleValue = new COMObject(new int[]{2, 0, 0, 1, 1, 1, 1}){

            @Override
            public long method0(long[] lArray) {
                return Accessible.this.QueryInterface(lArray[0], lArray[1]);
            }

            @Override
            public long method1(long[] lArray) {
                return Accessible.this.AddRef();
            }

            @Override
            public long method2(long[] lArray) {
                return Accessible.this.Release();
            }

            @Override
            public long method3(long[] lArray) {
                return Accessible.this.get_currentValue(lArray[0]);
            }

            @Override
            public long method4(long[] lArray) {
                return Accessible.this.setCurrentValue(lArray[0]);
            }

            @Override
            public long method5(long[] lArray) {
                return Accessible.this.get_maximumValue(lArray[0]);
            }

            @Override
            public long method6(long[] lArray) {
                return Accessible.this.get_minimumValue(lArray[0]);
            }
        };
        long l = this.objIAccessibleValue.ppVtable;
        long[] lArray = new long[1];
        COM.MoveMemory(lArray, l, OS.PTR_SIZEOF);
        long[] lArray2 = new long[7];
        COM.MoveMemory(lArray2, lArray[0], OS.PTR_SIZEOF * lArray2.length);
        lArray2[4] = COM.CALLBACK_setCurrentValue(lArray2[4]);
        COM.MoveMemory(lArray[0], lArray2, OS.PTR_SIZEOF * lArray2.length);
    }

    void createIEnumVARIANT() {
        this.objIEnumVARIANT = new COMObject(new int[]{2, 0, 0, 3, 1, 0, 1}){

            @Override
            public long method0(long[] lArray) {
                return Accessible.this.QueryInterface(lArray[0], lArray[1]);
            }

            @Override
            public long method1(long[] lArray) {
                return Accessible.this.AddRef();
            }

            @Override
            public long method2(long[] lArray) {
                return Accessible.this.Release();
            }

            @Override
            public long method3(long[] lArray) {
                return Accessible.this.Next((int)lArray[0], lArray[1], lArray[2]);
            }

            @Override
            public long method4(long[] lArray) {
                return Accessible.this.Skip((int)lArray[0]);
            }

            @Override
            public long method5(long[] lArray) {
                return Accessible.this.Reset();
            }

            @Override
            public long method6(long[] lArray) {
                return Accessible.this.Clone(lArray[0]);
            }
        };
    }

    void createIServiceProvider() {
        this.objIServiceProvider = new COMObject(new int[]{2, 0, 0, 3}){

            @Override
            public long method0(long[] lArray) {
                return Accessible.this.QueryInterface(lArray[0], lArray[1]);
            }

            @Override
            public long method1(long[] lArray) {
                return Accessible.this.AddRef();
            }

            @Override
            public long method2(long[] lArray) {
                return Accessible.this.Release();
            }

            @Override
            public long method3(long[] lArray) {
                return Accessible.this.QueryService(lArray[0], lArray[1], lArray[2]);
            }
        };
    }

    public static Accessible internal_new_Accessible(Control control) {
        return new Accessible(control);
    }

    public void addAccessibleListener(AccessibleListener accessibleListener) {
        this.checkWidget();
        if (accessibleListener == null) {
            SWT.error(4);
        }
        if (this.accessibleListeners == null) {
            this.accessibleListeners = new ArrayList<AccessibleListener>();
        }
        this.accessibleListeners.add(accessibleListener);
    }

    public void addAccessibleControlListener(AccessibleControlListener accessibleControlListener) {
        this.checkWidget();
        if (accessibleControlListener == null) {
            SWT.error(4);
        }
        if (this.accessibleControlListeners == null) {
            this.accessibleControlListeners = new ArrayList<AccessibleControlListener>();
        }
        this.accessibleControlListeners.add(accessibleControlListener);
    }

    public void addAccessibleTextListener(AccessibleTextListener accessibleTextListener) {
        this.checkWidget();
        if (accessibleTextListener == null) {
            SWT.error(4);
        }
        if (accessibleTextListener instanceof AccessibleTextExtendedListener) {
            if (this.accessibleTextExtendedListeners == null) {
                this.accessibleTextExtendedListeners = new ArrayList<AccessibleTextExtendedListener>();
            }
            this.accessibleTextExtendedListeners.add((AccessibleTextExtendedListener)accessibleTextListener);
        } else {
            if (this.accessibleTextListeners == null) {
                this.accessibleTextListeners = new ArrayList<AccessibleTextListener>();
            }
            this.accessibleTextListeners.add(accessibleTextListener);
        }
    }

    public void addAccessibleActionListener(AccessibleActionListener accessibleActionListener) {
        this.checkWidget();
        if (accessibleActionListener == null) {
            SWT.error(4);
        }
        if (this.accessibleActionListeners == null) {
            this.accessibleActionListeners = new ArrayList<AccessibleActionListener>();
        }
        this.accessibleActionListeners.add(accessibleActionListener);
    }

    public void addAccessibleEditableTextListener(AccessibleEditableTextListener accessibleEditableTextListener) {
        this.checkWidget();
        if (accessibleEditableTextListener == null) {
            SWT.error(4);
        }
        if (this.accessibleEditableTextListeners == null) {
            this.accessibleEditableTextListeners = new ArrayList<AccessibleEditableTextListener>();
        }
        this.accessibleEditableTextListeners.add(accessibleEditableTextListener);
    }

    public void addAccessibleHyperlinkListener(AccessibleHyperlinkListener accessibleHyperlinkListener) {
        this.checkWidget();
        if (accessibleHyperlinkListener == null) {
            SWT.error(4);
        }
        if (this.accessibleHyperlinkListeners == null) {
            this.accessibleHyperlinkListeners = new ArrayList<AccessibleHyperlinkListener>();
        }
        this.accessibleHyperlinkListeners.add(accessibleHyperlinkListener);
    }

    public void addAccessibleTableListener(AccessibleTableListener accessibleTableListener) {
        this.checkWidget();
        if (accessibleTableListener == null) {
            SWT.error(4);
        }
        if (this.accessibleTableListeners == null) {
            this.accessibleTableListeners = new ArrayList<AccessibleTableListener>();
        }
        this.accessibleTableListeners.add(accessibleTableListener);
    }

    public void addAccessibleTableCellListener(AccessibleTableCellListener accessibleTableCellListener) {
        this.checkWidget();
        if (accessibleTableCellListener == null) {
            SWT.error(4);
        }
        if (this.accessibleTableCellListeners == null) {
            this.accessibleTableCellListeners = new ArrayList<AccessibleTableCellListener>();
        }
        this.accessibleTableCellListeners.add(accessibleTableCellListener);
    }

    public void addAccessibleValueListener(AccessibleValueListener accessibleValueListener) {
        this.checkWidget();
        if (accessibleValueListener == null) {
            SWT.error(4);
        }
        if (this.accessibleValueListeners == null) {
            this.accessibleValueListeners = new ArrayList<AccessibleValueListener>();
        }
        this.accessibleValueListeners.add(accessibleValueListener);
    }

    public void addAccessibleAttributeListener(AccessibleAttributeListener accessibleAttributeListener) {
        this.checkWidget();
        if (accessibleAttributeListener == null) {
            SWT.error(4);
        }
        if (this.accessibleAttributeListeners == null) {
            this.accessibleAttributeListeners = new ArrayList<AccessibleAttributeListener>();
        }
        this.accessibleAttributeListeners.add(accessibleAttributeListener);
    }

    public void addRelation(int n, Accessible accessible) {
        this.checkWidget();
        if (accessible == null) {
            SWT.error(4);
        }
        if (this.relations[n] == null) {
            this.relations[n] = new Relation(this, n);
        }
        this.relations[n].addTarget(accessible);
    }

    public void dispose() {
        if (this.parent == null) {
            return;
        }
        this.Release();
        this.parent.children.remove(this);
        this.parent = null;
    }

    long getAddress() {
        if (this.objIAccessible == null) {
            this.createIAccessible();
        }
        return this.objIAccessible.getAddress();
    }

    public Control getControl() {
        return this.control;
    }

    public void internal_dispose_Accessible() {
        if (this.iaccessible != null) {
            this.iaccessible.Release();
        }
        this.iaccessible = null;
        this.Release();
        for (int i = 0; i < this.children.size(); ++i) {
            Accessible accessible = this.children.get(i);
            accessible.dispose();
        }
    }

    public long internal_WM_GETOBJECT(long l, long l2) {
        if (this.objIAccessible == null) {
            return 0L;
        }
        if ((int)l2 == -4) {
            return COM.LresultFromObject(COM.IIDIAccessible, l, this.objIAccessible.getAddress());
        }
        return 0L;
    }

    public void removeAccessibleListener(AccessibleListener accessibleListener) {
        this.checkWidget();
        if (accessibleListener == null) {
            SWT.error(4);
        }
        if (this.accessibleListeners != null) {
            this.accessibleListeners.remove(accessibleListener);
            if (this.accessibleListeners.isEmpty()) {
                this.accessibleListeners = null;
            }
        }
    }

    public void removeAccessibleControlListener(AccessibleControlListener accessibleControlListener) {
        this.checkWidget();
        if (accessibleControlListener == null) {
            SWT.error(4);
        }
        if (this.accessibleControlListeners != null) {
            this.accessibleControlListeners.remove(accessibleControlListener);
            if (this.accessibleControlListeners.isEmpty()) {
                this.accessibleControlListeners = null;
            }
        }
    }

    public void removeAccessibleTextListener(AccessibleTextListener accessibleTextListener) {
        this.checkWidget();
        if (accessibleTextListener == null) {
            SWT.error(4);
        }
        if (accessibleTextListener instanceof AccessibleTextExtendedListener) {
            if (this.accessibleTextExtendedListeners != null) {
                this.accessibleTextExtendedListeners.remove(accessibleTextListener);
                if (this.accessibleTextExtendedListeners.isEmpty()) {
                    this.accessibleTextExtendedListeners = null;
                }
            }
        } else if (this.accessibleTextListeners != null) {
            this.accessibleTextListeners.remove(accessibleTextListener);
            if (this.accessibleTextListeners.isEmpty()) {
                this.accessibleTextListeners = null;
            }
        }
    }

    public void removeAccessibleActionListener(AccessibleActionListener accessibleActionListener) {
        this.checkWidget();
        if (accessibleActionListener == null) {
            SWT.error(4);
        }
        if (this.accessibleActionListeners != null) {
            this.accessibleActionListeners.remove(accessibleActionListener);
            if (this.accessibleActionListeners.isEmpty()) {
                this.accessibleActionListeners = null;
            }
        }
    }

    public void removeAccessibleEditableTextListener(AccessibleEditableTextListener accessibleEditableTextListener) {
        this.checkWidget();
        if (accessibleEditableTextListener == null) {
            SWT.error(4);
        }
        if (this.accessibleEditableTextListeners != null) {
            this.accessibleEditableTextListeners.remove(accessibleEditableTextListener);
            if (this.accessibleEditableTextListeners.isEmpty()) {
                this.accessibleEditableTextListeners = null;
            }
        }
    }

    public void removeAccessibleHyperlinkListener(AccessibleHyperlinkListener accessibleHyperlinkListener) {
        this.checkWidget();
        if (accessibleHyperlinkListener == null) {
            SWT.error(4);
        }
        if (this.accessibleHyperlinkListeners != null) {
            this.accessibleHyperlinkListeners.remove(accessibleHyperlinkListener);
            if (this.accessibleHyperlinkListeners.isEmpty()) {
                this.accessibleHyperlinkListeners = null;
            }
        }
    }

    public void removeAccessibleTableListener(AccessibleTableListener accessibleTableListener) {
        this.checkWidget();
        if (accessibleTableListener == null) {
            SWT.error(4);
        }
        if (this.accessibleTableListeners != null) {
            this.accessibleTableListeners.remove(accessibleTableListener);
            if (this.accessibleTableListeners.isEmpty()) {
                this.accessibleTableListeners = null;
            }
        }
    }

    public void removeAccessibleTableCellListener(AccessibleTableCellListener accessibleTableCellListener) {
        this.checkWidget();
        if (accessibleTableCellListener == null) {
            SWT.error(4);
        }
        if (this.accessibleTableCellListeners != null) {
            this.accessibleTableCellListeners.remove(accessibleTableCellListener);
            if (this.accessibleTableCellListeners.isEmpty()) {
                this.accessibleTableCellListeners = null;
            }
        }
    }

    public void removeAccessibleValueListener(AccessibleValueListener accessibleValueListener) {
        this.checkWidget();
        if (accessibleValueListener == null) {
            SWT.error(4);
        }
        if (this.accessibleValueListeners != null) {
            this.accessibleValueListeners.remove(accessibleValueListener);
            if (this.accessibleValueListeners.isEmpty()) {
                this.accessibleValueListeners = null;
            }
        }
    }

    public void removeAccessibleAttributeListener(AccessibleAttributeListener accessibleAttributeListener) {
        this.checkWidget();
        if (accessibleAttributeListener == null) {
            SWT.error(4);
        }
        if (this.accessibleAttributeListeners != null) {
            this.accessibleAttributeListeners.remove(accessibleAttributeListener);
            if (this.accessibleAttributeListeners.isEmpty()) {
                this.accessibleAttributeListeners = null;
            }
        }
    }

    public void removeRelation(int n, Accessible accessible) {
        Relation relation;
        this.checkWidget();
        if (accessible == null) {
            SWT.error(4);
        }
        if ((relation = this.relations[n]) != null) {
            relation.removeTarget(accessible);
            if (!relation.hasTargets()) {
                this.relations[n].Release();
                this.relations[n] = null;
            }
        }
    }

    public void sendEvent(int n, Object object) {
        this.checkWidget();
        if (!this.isATRunning()) {
            return;
        }
        if (!UseIA2) {
            return;
        }
        switch (n) {
            case 518: {
                if (!(object instanceof int[]) || ((int[])object).length != 5) break;
                this.tableChange = (int[])object;
                COM.NotifyWinEvent(278, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 524: {
                if (!(object instanceof Object[]) || ((Object[])object).length != 4) break;
                Object[] objectArray = (Object[])object;
                int n2 = (Integer)objectArray[0];
                switch (n2) {
                    case 1: {
                        this.textDeleted = (Object[])object;
                        COM.NotifyWinEvent(287, this.control.handle, -4, this.eventChildID());
                        break;
                    }
                    case 0: {
                        this.textInserted = (Object[])object;
                        COM.NotifyWinEvent(286, this.control.handle, -4, this.eventChildID());
                    }
                }
                break;
            }
            case 268: {
                if (!(object instanceof Integer)) break;
                COM.NotifyWinEvent(268, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 32782: {
                COM.NotifyWinEvent(32782, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 32778: {
                COM.NotifyWinEvent(32778, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 32777: {
                COM.NotifyWinEvent(32777, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 32788: {
                COM.NotifyWinEvent(32788, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 32779: {
                COM.NotifyWinEvent(32779, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 32780: {
                COM.NotifyWinEvent(32780, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 32781: {
                COM.NotifyWinEvent(32781, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 261: {
                COM.NotifyWinEvent(261, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 262: {
                COM.NotifyWinEvent(262, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 263: {
                COM.NotifyWinEvent(263, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 273: {
                COM.NotifyWinEvent(273, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 274: {
                COM.NotifyWinEvent(274, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 256: {
                COM.NotifyWinEvent(257, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 269: {
                COM.NotifyWinEvent(269, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 264: {
                COM.NotifyWinEvent(264, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 265: {
                COM.NotifyWinEvent(265, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 266: {
                COM.NotifyWinEvent(266, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 267: {
                COM.NotifyWinEvent(267, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 271: {
                COM.NotifyWinEvent(271, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 512: {
                COM.NotifyWinEvent(272, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 515: {
                COM.NotifyWinEvent(275, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 516: {
                COM.NotifyWinEvent(276, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 517: {
                COM.NotifyWinEvent(277, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 519: {
                COM.NotifyWinEvent(279, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 520: {
                COM.NotifyWinEvent(280, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 521: {
                COM.NotifyWinEvent(281, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 522: {
                COM.NotifyWinEvent(282, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 283: {
                COM.NotifyWinEvent(283, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 285: {
                COM.NotifyWinEvent(285, this.control.handle, -4, this.eventChildID());
            }
        }
    }

    public void sendEvent(int n, Object object, int n2) {
        this.checkWidget();
        if (!this.isATRunning()) {
            return;
        }
        if (!UseIA2) {
            return;
        }
        int n3 = n2 == -1 ? this.eventChildID() : this.childIDToOs(n2);
        switch (n) {
            case 32778: {
                COM.NotifyWinEvent(32778, this.control.handle, -4, n3);
                break;
            }
            case 32780: {
                COM.NotifyWinEvent(32780, this.control.handle, -4, n3);
                break;
            }
            case 32782: {
                COM.NotifyWinEvent(32782, this.control.handle, -4, n3);
                break;
            }
            case 32779: {
                COM.NotifyWinEvent(32779, this.control.handle, -4, n3);
                break;
            }
            case 32777: {
                COM.NotifyWinEvent(32777, this.control.handle, -4, n3);
                break;
            }
            case 32788: {
                COM.NotifyWinEvent(32788, this.control.handle, -4, n3);
                break;
            }
            case 32781: {
                COM.NotifyWinEvent(32781, this.control.handle, -4, n3);
            }
        }
    }

    public void selectionChanged() {
        this.checkWidget();
        if (!this.isATRunning()) {
            return;
        }
        COM.NotifyWinEvent(32777, this.control.handle, -4, this.eventChildID());
    }

    public void setFocus(int n) {
        this.checkWidget();
        if (!this.isATRunning()) {
            return;
        }
        int n2 = n == -1 ? this.eventChildID() : this.childIDToOs(n);
        COM.NotifyWinEvent(32773, this.control.handle, -4, n2);
    }

    public void textCaretMoved(int n) {
        this.checkWidget();
        if (this.timer == null) {
            this.timer = new Runnable(){

                @Override
                public void run() {
                    if (!Accessible.this.isATRunning()) {
                        return;
                    }
                    COM.NotifyWinEvent(32779, Accessible.this.control.handle, -8, Accessible.this.eventChildID());
                    if (!UseIA2) {
                        return;
                    }
                    COM.NotifyWinEvent(283, Accessible.this.control.handle, -4, Accessible.this.eventChildID());
                }
            };
        }
        this.control.getDisplay().timerExec(100, this.timer);
    }

    public void textChanged(int n, int n2, int n3) {
        this.checkWidget();
        if (!this.isATRunning()) {
            return;
        }
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.start = n2;
        accessibleTextEvent.end = n2 + n3;
        accessibleTextEvent.count = 0;
        accessibleTextEvent.type = 5;
        for (int i = 0; i < this.accessibleTextExtendedListenersSize(); ++i) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(i);
            accessibleTextExtendedListener.getText(accessibleTextEvent);
        }
        if (accessibleTextEvent.result != null) {
            Object[] objectArray = new Object[]{n, n2, n2 + n3, accessibleTextEvent.result};
            this.sendEvent(524, objectArray);
            return;
        }
        COM.NotifyWinEvent(32782, this.control.handle, -4, this.eventChildID());
    }

    public void textSelectionChanged() {
        this.checkWidget();
        if (!this.isATRunning()) {
            return;
        }
        COM.NotifyWinEvent(32788, this.control.handle, -4, this.eventChildID());
    }

    int QueryInterface(long l, long l2) {
        if (this.control != null && this.control.isDisposed()) {
            return -2147220995;
        }
        COM.MoveMemory(l2, new long[]{0L}, OS.PTR_SIZEOF);
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, l, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown)) {
            COM.MoveMemory(l2, new long[]{this.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIDispatch) || COM.IsEqualGUID(gUID, COM.IIDIAccessible)) {
            if (this.objIAccessible == null) {
                this.createIAccessible();
            }
            COM.MoveMemory(l2, new long[]{this.objIAccessible.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIEnumVARIANT)) {
            if (this.objIEnumVARIANT == null) {
                this.createIEnumVARIANT();
            }
            COM.MoveMemory(l2, new long[]{this.objIEnumVARIANT.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            this.enumIndex = 0;
            return 0;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIServiceProvider)) {
            if (!UseIA2) {
                return -2147467262;
            }
            if (this.accessibleActionListenersSize() > 0 || this.accessibleAttributeListenersSize() > 0 || this.accessibleHyperlinkListenersSize() > 0 || this.accessibleTableListenersSize() > 0 || this.accessibleTableCellListenersSize() > 0 || this.accessibleTextExtendedListenersSize() > 0 || this.accessibleValueListenersSize() > 0 || this.accessibleControlListenersSize() > 0 || this.getRelationCount() > 0 || this.control instanceof Button && (this.control.getStyle() & 0x10) != 0 || this.control instanceof Composite) {
                if (this.objIServiceProvider == null) {
                    this.createIServiceProvider();
                }
                COM.MoveMemory(l2, new long[]{this.objIServiceProvider.getAddress()}, OS.PTR_SIZEOF);
                this.AddRef();
                return 0;
            }
            return -2147467262;
        }
        int n = this.queryAccessible2Interfaces(gUID, l2);
        if (n != 1) {
            return n;
        }
        if (this.iaccessible != null) {
            long[] lArray = new long[1];
            n = this.iaccessible.QueryInterface(gUID, lArray);
            COM.MoveMemory(l2, lArray, OS.PTR_SIZEOF);
            return n;
        }
        return -2147467262;
    }

    int accessibleListenersSize() {
        return this.accessibleListeners == null ? 0 : this.accessibleListeners.size();
    }

    int accessibleControlListenersSize() {
        return this.accessibleControlListeners == null ? 0 : this.accessibleControlListeners.size();
    }

    int accessibleValueListenersSize() {
        return this.accessibleValueListeners == null ? 0 : this.accessibleValueListeners.size();
    }

    int accessibleTextExtendedListenersSize() {
        return this.accessibleTextExtendedListeners == null ? 0 : this.accessibleTextExtendedListeners.size();
    }

    int accessibleTextListenersSize() {
        return this.accessibleTextListeners == null ? 0 : this.accessibleTextListeners.size();
    }

    int accessibleTableCellListenersSize() {
        return this.accessibleTableCellListeners == null ? 0 : this.accessibleTableCellListeners.size();
    }

    int accessibleTableListenersSize() {
        return this.accessibleTableListeners == null ? 0 : this.accessibleTableListeners.size();
    }

    int accessibleHyperlinkListenersSize() {
        return this.accessibleHyperlinkListeners == null ? 0 : this.accessibleHyperlinkListeners.size();
    }

    int accessibleEditableTextListenersSize() {
        return this.accessibleEditableTextListeners == null ? 0 : this.accessibleEditableTextListeners.size();
    }

    int accessibleAttributeListenersSize() {
        return this.accessibleAttributeListeners == null ? 0 : this.accessibleAttributeListeners.size();
    }

    int accessibleActionListenersSize() {
        return this.accessibleActionListeners == null ? 0 : this.accessibleActionListeners.size();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            if (this.objIAccessible != null) {
                this.objIAccessible.dispose();
            }
            this.objIAccessible = null;
            if (this.objIEnumVARIANT != null) {
                this.objIEnumVARIANT.dispose();
            }
            this.objIEnumVARIANT = null;
            if (this.objIServiceProvider != null) {
                this.objIServiceProvider.dispose();
            }
            this.objIServiceProvider = null;
            if (this.objIAccessible2 != null) {
                this.objIAccessible2.dispose();
            }
            this.objIAccessible2 = null;
            if (this.objIAccessibleAction != null) {
                this.objIAccessibleAction.dispose();
            }
            this.objIAccessibleAction = null;
            if (this.objIAccessibleApplication != null) {
                this.objIAccessibleApplication.dispose();
            }
            this.objIAccessibleApplication = null;
            if (this.objIAccessibleEditableText != null) {
                this.objIAccessibleEditableText.dispose();
            }
            this.objIAccessibleEditableText = null;
            if (this.objIAccessibleHyperlink != null) {
                this.objIAccessibleHyperlink.dispose();
            }
            this.objIAccessibleHyperlink = null;
            if (this.objIAccessibleHypertext != null) {
                this.objIAccessibleHypertext.dispose();
            }
            this.objIAccessibleHypertext = null;
            if (this.objIAccessibleTable2 != null) {
                this.objIAccessibleTable2.dispose();
            }
            this.objIAccessibleTable2 = null;
            if (this.objIAccessibleTableCell != null) {
                this.objIAccessibleTableCell.dispose();
            }
            this.objIAccessibleTableCell = null;
            if (this.objIAccessibleText != null) {
                this.objIAccessibleText.dispose();
            }
            this.objIAccessibleText = null;
            if (this.objIAccessibleValue != null) {
                this.objIAccessibleValue.dispose();
            }
            this.objIAccessibleValue = null;
            for (int i = 0; i < this.relations.length; ++i) {
                if (this.relations[i] == null) continue;
                this.relations[i].Release();
            }
        }
        return this.refCount;
    }

    int QueryService(long l, long l2, long l3) {
        long[] lArray;
        int n;
        int n2;
        COM.MoveMemory(l3, new long[]{0L}, OS.PTR_SIZEOF);
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, l, GUID.sizeof);
        GUID gUID2 = new GUID();
        COM.MoveMemory(gUID2, l2, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessible)) {
            if (COM.IsEqualGUID(gUID2, COM.IIDIUnknown) || COM.IsEqualGUID(gUID2, COM.IIDIDispatch) | COM.IsEqualGUID(gUID2, COM.IIDIAccessible)) {
                if (this.objIAccessible == null) {
                    this.createIAccessible();
                }
                COM.MoveMemory(l3, new long[]{this.objIAccessible.getAddress()}, OS.PTR_SIZEOF);
                this.AddRef();
                return 0;
            }
            n2 = this.queryAccessible2Interfaces(gUID2, l3);
            if (n2 != 1) {
                return n2;
            }
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessible2) && (n2 = this.queryAccessible2Interfaces(gUID2, l3)) != 1) {
            return n2;
        }
        if (this.iaccessible != null && (n = this.iaccessible.QueryInterface(COM.IIDIServiceProvider, lArray = new long[1])) == 0) {
            IServiceProvider iServiceProvider = new IServiceProvider(lArray[0]);
            long[] lArray2 = new long[1];
            n = iServiceProvider.QueryService(gUID, gUID2, lArray2);
            COM.MoveMemory(l3, lArray2, OS.PTR_SIZEOF);
            return n;
        }
        return -2147467262;
    }

    int queryAccessible2Interfaces(GUID gUID, long l) {
        if (this.control != null && this.control.isDisposed()) {
            return -2147220995;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessible2)) {
            if (this.accessibleActionListenersSize() > 0 || this.accessibleAttributeListenersSize() > 0 || this.accessibleHyperlinkListenersSize() > 0 || this.accessibleTableListenersSize() > 0 || this.accessibleTableCellListenersSize() > 0 || this.accessibleTextExtendedListenersSize() > 0 || this.accessibleValueListenersSize() > 0 || this.accessibleControlListenersSize() > 0 || this.getRelationCount() > 0 || this.control instanceof Button && (this.control.getStyle() & 0x10) != 0 || this.control instanceof Composite) {
                if (this.objIAccessible2 == null) {
                    this.createIAccessible2();
                }
                COM.MoveMemory(l, new long[]{this.objIAccessible2.getAddress()}, OS.PTR_SIZEOF);
                this.AddRef();
                return 0;
            }
            return -2147467262;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessibleAction)) {
            if (this.accessibleActionListenersSize() > 0) {
                if (this.objIAccessibleAction == null) {
                    this.createIAccessibleAction();
                }
                COM.MoveMemory(l, new long[]{this.objIAccessibleAction.getAddress()}, OS.PTR_SIZEOF);
                this.AddRef();
                return 0;
            }
            return -2147467262;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessibleApplication)) {
            if (this.objIAccessibleApplication == null) {
                this.createIAccessibleApplication();
            }
            COM.MoveMemory(l, new long[]{this.objIAccessibleApplication.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessibleComponent)) {
            return -2147467262;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessibleEditableText)) {
            if (this.accessibleEditableTextListenersSize() > 0) {
                if (this.objIAccessibleEditableText == null) {
                    this.createIAccessibleEditableText();
                }
                COM.MoveMemory(l, new long[]{this.objIAccessibleEditableText.getAddress()}, OS.PTR_SIZEOF);
                this.AddRef();
                return 0;
            }
            return -2147467262;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessibleHyperlink)) {
            if (this.accessibleHyperlinkListenersSize() > 0) {
                if (this.objIAccessibleHyperlink == null) {
                    this.createIAccessibleHyperlink();
                }
                COM.MoveMemory(l, new long[]{this.objIAccessibleHyperlink.getAddress()}, OS.PTR_SIZEOF);
                this.AddRef();
                return 0;
            }
            return -2147467262;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessibleHypertext)) {
            if (this.accessibleTextExtendedListenersSize() > 0) {
                if (this.objIAccessibleHypertext == null) {
                    this.createIAccessibleHypertext();
                }
                COM.MoveMemory(l, new long[]{this.objIAccessibleHypertext.getAddress()}, OS.PTR_SIZEOF);
                this.AddRef();
                return 0;
            }
            return -2147467262;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessibleImage)) {
            return -2147467262;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessibleTable)) {
            return -2147467262;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessibleTable2)) {
            if (this.accessibleTableListenersSize() > 0) {
                if (this.objIAccessibleTable2 == null) {
                    this.createIAccessibleTable2();
                }
                COM.MoveMemory(l, new long[]{this.objIAccessibleTable2.getAddress()}, OS.PTR_SIZEOF);
                this.AddRef();
                return 0;
            }
            return -2147467262;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessibleTableCell)) {
            if (this.accessibleTableCellListenersSize() > 0) {
                if (this.objIAccessibleTableCell == null) {
                    this.createIAccessibleTableCell();
                }
                COM.MoveMemory(l, new long[]{this.objIAccessibleTableCell.getAddress()}, OS.PTR_SIZEOF);
                this.AddRef();
                return 0;
            }
            return -2147467262;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessibleText)) {
            if (this.accessibleTextExtendedListenersSize() > 0 || this.accessibleAttributeListenersSize() > 0) {
                if (this.objIAccessibleText == null) {
                    this.createIAccessibleText();
                }
                COM.MoveMemory(l, new long[]{this.objIAccessibleText.getAddress()}, OS.PTR_SIZEOF);
                this.AddRef();
                return 0;
            }
            return -2147467262;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessibleValue)) {
            if (this.accessibleValueListenersSize() > 0) {
                if (this.objIAccessibleValue == null) {
                    this.createIAccessibleValue();
                }
                COM.MoveMemory(l, new long[]{this.objIAccessibleValue.getAddress()}, OS.PTR_SIZEOF);
                this.AddRef();
                return 0;
            }
            return -2147467262;
        }
        return 1;
    }

    int accDoDefaultAction(long l) {
        if (this.accessibleActionListenersSize() > 0) {
            VARIANT vARIANT = this.getVARIANT(l);
            if (vARIANT.vt != 3) {
                return -2147024809;
            }
            if (vARIANT.lVal == 0) {
                return this.doAction(0);
            }
        }
        int n = -2147352573;
        if (this.iaccessible != null && (n = this.iaccessible.accDoDefaultAction(l)) == -2147024809) {
            n = -2147352573;
        }
        return n;
    }

    int accHitTest(int n, int n2, long l) {
        int n3 = -2;
        long l2 = 0L;
        if (this.iaccessible != null) {
            int n4 = this.iaccessible.accHitTest(n, n2, l);
            if (n4 == 0) {
                VARIANT vARIANT = this.getVARIANT(l);
                if (vARIANT.vt == 3) {
                    n3 = vARIANT.lVal;
                } else if (vARIANT.vt == 9) {
                    l2 = vARIANT.lVal;
                }
            }
            if (this.accessibleControlListenersSize() == 0) {
                return n4;
            }
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n3 == -2 ? -2 : this.osToChildID(n3);
        accessibleControlEvent.x = n;
        accessibleControlEvent.y = n2;
        for (int i = 0; i < this.accessibleControlListenersSize(); ++i) {
            AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(i);
            accessibleControlListener.getChildAtPoint(accessibleControlEvent);
        }
        Accessible accessible = accessibleControlEvent.accessible;
        if (accessible != null) {
            accessible.AddRef();
            this.setPtrVARIANT(l, (short)9, accessible.getAddress());
            return 0;
        }
        int n5 = accessibleControlEvent.childID;
        if (n5 == -2) {
            if (l2 != 0L) {
                return 0;
            }
            this.setIntVARIANT(l, (short)0, 0);
            return 1;
        }
        this.setIntVARIANT(l, (short)3, this.childIDToOs(n5));
        return 0;
    }

    int accLocation(long l, long l2, long l3, long l4, long l5) {
        Object object;
        VARIANT vARIANT = this.getVARIANT(l5);
        if (vARIANT.vt != 3) {
            return -2147024809;
        }
        int n = 0;
        Object object2 = 0;
        int n2 = 0;
        int n3 = 0;
        if (this.iaccessible != null) {
            int n4 = this.iaccessible.accLocation(l, l2, l3, l4, l5);
            if (n4 == -2147024809) {
                n4 = -2147352573;
            }
            if (this.accessibleControlListenersSize() == 0) {
                return n4;
            }
            if (n4 == 0) {
                int[] nArray = new int[1];
                object = new int[1];
                int[] nArray2 = new int[1];
                int[] nArray3 = new int[1];
                COM.MoveMemory(nArray, l, 4);
                COM.MoveMemory((int[])object, l2, 4);
                COM.MoveMemory(nArray2, l3, 4);
                COM.MoveMemory(nArray3, l4, 4);
                n = nArray[0];
                object2 = object[0];
                n2 = nArray2[0];
                n3 = nArray3[0];
            }
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = this.osToChildID(vARIANT.lVal);
        accessibleControlEvent.x = n;
        accessibleControlEvent.y = object2;
        accessibleControlEvent.width = n2;
        accessibleControlEvent.height = n3;
        for (int i = 0; i < this.accessibleControlListenersSize(); ++i) {
            object = this.accessibleControlListeners.get(i);
            object.getLocation(accessibleControlEvent);
        }
        OS.MoveMemory(l, new int[]{accessibleControlEvent.x}, 4);
        OS.MoveMemory(l2, new int[]{accessibleControlEvent.y}, 4);
        OS.MoveMemory(l3, new int[]{accessibleControlEvent.width}, 4);
        OS.MoveMemory(l4, new int[]{accessibleControlEvent.height}, 4);
        return 0;
    }

    int accNavigate(int n, long l, long l2) {
        int n2 = -2147352573;
        if (this.iaccessible != null && (n2 = this.iaccessible.accNavigate(n, l, l2)) == -2147024809) {
            n2 = -2147352573;
        }
        return n2;
    }

    int accSelect(int n, long l) {
        int n2 = -2147352573;
        if (this.iaccessible != null && (n2 = this.iaccessible.accSelect(n, l)) == -2147024809) {
            n2 = -2147352573;
        }
        return n2;
    }

    int get_accChild(long l, long l2) {
        Object object;
        Object object2;
        VARIANT vARIANT = this.getVARIANT(l);
        if (vARIANT.vt != 3) {
            return -2147024809;
        }
        if (vARIANT.lVal == 0) {
            this.AddRef();
            COM.MoveMemory(l2, new long[]{this.getAddress()}, OS.PTR_SIZEOF);
            return 0;
        }
        final int n = this.osToChildID(vARIANT.lVal);
        int n2 = 1;
        Accessible accessible = null;
        if (this.iaccessible != null) {
            ToolItem toolItem;
            n2 = this.iaccessible.get_accChild(l, l2);
            if (n2 == -2147024809) {
                n2 = 1;
            }
            if (n2 == 0 && this.control instanceof ToolBar && (toolItem = ((ToolBar)(object2 = (ToolBar)this.control)).getItem(n)) != null && (toolItem.getStyle() & 4) != 0) {
                object = new long[1];
                COM.MoveMemory((long[])object, l2, OS.PTR_SIZEOF);
                boolean bl = false;
                for (int i = 0; i < this.children.size(); ++i) {
                    Accessible accessible2 = this.children.get(i);
                    if (accessible2.item != toolItem) continue;
                    accessible2.dispose();
                    accessible2.item = null;
                    bl = true;
                    break;
                }
                accessible = new Accessible(this, (long)object[0]);
                accessible.item = toolItem;
                if (!bl) {
                    toolItem.addListener(12, new Listener(){

                        @Override
                        public void handleEvent(Event event) {
                            for (int i = 0; i < Accessible.this.children.size(); ++i) {
                                Accessible accessible = Accessible.this.children.get(i);
                                if (accessible.item != toolItem) continue;
                                accessible.dispose();
                            }
                        }
                    });
                }
                accessible.addAccessibleListener(new AccessibleAdapter(){

                    @Override
                    public void getName(AccessibleEvent accessibleEvent) {
                        if (accessibleEvent.childID == -1) {
                            AccessibleEvent accessibleEvent2 = new AccessibleEvent(Accessible.this);
                            accessibleEvent2.childID = n;
                            for (int i = 0; i < Accessible.this.accessibleListenersSize(); ++i) {
                                AccessibleListener accessibleListener = Accessible.this.accessibleListeners.get(i);
                                accessibleListener.getName(accessibleEvent2);
                            }
                            accessibleEvent.result = accessibleEvent2.result;
                        }
                    }
                });
            }
        }
        object2 = new AccessibleControlEvent(this);
        ((AccessibleControlEvent)object2).childID = n;
        for (int i = 0; i < this.accessibleControlListenersSize(); ++i) {
            object = this.accessibleControlListeners.get(i);
            object.getChild((AccessibleControlEvent)object2);
        }
        Accessible accessible3 = ((AccessibleControlEvent)object2).accessible;
        if (accessible3 == null) {
            accessible3 = accessible;
        }
        if (accessible3 != null) {
            accessible3.AddRef();
            COM.MoveMemory(l2, new long[]{accessible3.getAddress()}, OS.PTR_SIZEOF);
            return 0;
        }
        return n2;
    }

    int get_accChildCount(long l) {
        int n = 0;
        if (this.iaccessible != null) {
            int n2 = this.iaccessible.get_accChildCount(l);
            if (n2 == 0) {
                int[] nArray = new int[1];
                COM.MoveMemory(nArray, l, 4);
                n = nArray[0];
            }
            if (this.accessibleControlListenersSize() == 0) {
                return n2;
            }
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = -1;
        accessibleControlEvent.detail = n;
        for (int i = 0; i < this.accessibleControlListenersSize(); ++i) {
            AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(i);
            accessibleControlListener.getChildCount(accessibleControlEvent);
        }
        COM.MoveMemory(l, new int[]{accessibleControlEvent.detail}, 4);
        return 0;
    }

    int get_accDefaultAction(long l, long l2) {
        Object object;
        int n;
        Object object2;
        VARIANT vARIANT = this.getVARIANT(l);
        if (vARIANT.vt != 3) {
            return -2147024809;
        }
        int n2 = -2147352573;
        String string = null;
        if (this.iaccessible != null) {
            n2 = this.iaccessible.get_accDefaultAction(l, l2);
            if (n2 == -2147024809) {
                n2 = 1;
            }
            if (this.accessibleControlListenersSize() == 0) {
                return n2;
            }
            if (n2 == 0) {
                object2 = new long[1];
                COM.MoveMemory((long[])object2, l2, OS.PTR_SIZEOF);
                n = COM.SysStringByteLen((long)object2[0]);
                if (n > 0) {
                    object = new char[(n + 1) / 2];
                    COM.MoveMemory((char[])object, (long)object2[0], n);
                    string = new String((char[])object);
                }
            }
        }
        object2 = new AccessibleControlEvent(this);
        ((AccessibleControlEvent)object2).childID = this.osToChildID(vARIANT.lVal);
        ((AccessibleControlEvent)object2).result = string;
        for (n = 0; n < this.accessibleControlListenersSize(); ++n) {
            object = this.accessibleControlListeners.get(n);
            object.getDefaultAction((AccessibleControlEvent)object2);
        }
        if ((((AccessibleControlEvent)object2).result == null || ((AccessibleControlEvent)object2).result.length() == 0) && vARIANT.lVal == 0) {
            n2 = this.get_name(0, l2);
        }
        if (((AccessibleControlEvent)object2).result == null) {
            return n2;
        }
        if (((AccessibleControlEvent)object2).result.length() == 0) {
            return 1;
        }
        this.setString(l2, ((AccessibleControlEvent)object2).result);
        return 0;
    }

    int get_accDescription(long l, long l2) {
        Tree tree;
        int n;
        Object object;
        int n2;
        Object object2;
        VARIANT vARIANT = this.getVARIANT(l);
        if (vARIANT.vt != 3) {
            return -2147024809;
        }
        int n3 = -2147352573;
        String string = null;
        if (this.iaccessible != null) {
            n3 = this.iaccessible.get_accDescription(l, l2);
            if (n3 == -2147024809) {
                n3 = 1;
            }
            if (this.accessibleListenersSize() == 0 && !(this.control instanceof Tree)) {
                return n3;
            }
            if (n3 == 0) {
                object2 = new long[1];
                COM.MoveMemory((long[])object2, l2, OS.PTR_SIZEOF);
                n2 = COM.SysStringByteLen((long)object2[0]);
                if (n2 > 0) {
                    object = new char[(n2 + 1) / 2];
                    COM.MoveMemory((char[])object, (long)object2[0], n2);
                    string = new String((char[])object);
                }
            }
        }
        object2 = new AccessibleEvent(this);
        ((AccessibleEvent)object2).childID = this.osToChildID(vARIANT.lVal);
        ((AccessibleEvent)object2).result = string;
        if (vARIANT.lVal != 0 && this.control instanceof Tree && (n = (tree = (Tree)this.control).getColumnCount()) > 1) {
            long l3 = this.control.handle;
            long l4 = 0L;
            l4 = OS.COMCTL32_MAJOR >= 6 ? OS.SendMessage(l3, 4394, (long)vARIANT.lVal, 0L) : (long)vARIANT.lVal;
            Widget widget = tree.getDisplay().findWidget(l3, l4);
            ((AccessibleEvent)object2).result = "";
            if (widget != null && widget instanceof TreeItem) {
                TreeItem treeItem = (TreeItem)widget;
                for (int i = 1; i < n; ++i) {
                    ((AccessibleEvent)object2).result = ((AccessibleEvent)object2).result + tree.getColumn(i).getText() + ": " + treeItem.getText(i);
                    if (i + 1 >= n) continue;
                    ((AccessibleEvent)object2).result = ((AccessibleEvent)object2).result + ", ";
                }
            }
        }
        for (n2 = 0; n2 < this.accessibleListenersSize(); ++n2) {
            object = this.accessibleListeners.get(n2);
            object.getDescription((AccessibleEvent)object2);
        }
        if (((AccessibleEvent)object2).result == null) {
            return n3;
        }
        if (((AccessibleEvent)object2).result.length() == 0) {
            return 1;
        }
        this.setString(l2, ((AccessibleEvent)object2).result);
        return 0;
    }

    int get_accFocus(long l) {
        int n = -2;
        if (this.iaccessible != null) {
            int n2 = this.iaccessible.get_accFocus(l);
            if (n2 == 0) {
                VARIANT vARIANT = this.getVARIANT(l);
                if (vARIANT.vt == 3) {
                    n = vARIANT.lVal;
                }
            }
            if (this.accessibleControlListenersSize() == 0) {
                return n2;
            }
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n == -2 ? -2 : this.osToChildID(n);
        for (int i = 0; i < this.accessibleControlListenersSize(); ++i) {
            AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(i);
            accessibleControlListener.getFocus(accessibleControlEvent);
        }
        Accessible accessible = accessibleControlEvent.accessible;
        if (accessible != null) {
            accessible.AddRef();
            this.setPtrVARIANT(l, (short)9, accessible.getAddress());
            return 0;
        }
        int n3 = accessibleControlEvent.childID;
        if (n3 == -2) {
            this.setIntVARIANT(l, (short)0, 0);
            return 1;
        }
        if (n3 == -1) {
            this.AddRef();
            this.setIntVARIANT(l, (short)3, 0);
            return 0;
        }
        this.setIntVARIANT(l, (short)3, this.childIDToOs(n3));
        return 0;
    }

    int get_accHelp(long l, long l2) {
        Object object;
        int n;
        Object object2;
        VARIANT vARIANT = this.getVARIANT(l);
        if (vARIANT.vt != 3) {
            return -2147024809;
        }
        int n2 = -2147352573;
        String string = null;
        if (this.iaccessible != null) {
            n2 = this.iaccessible.get_accHelp(l, l2);
            if (n2 == -2147024809) {
                n2 = 1;
            }
            if (this.accessibleListenersSize() == 0) {
                return n2;
            }
            if (n2 == 0) {
                object2 = new long[1];
                COM.MoveMemory((long[])object2, l2, OS.PTR_SIZEOF);
                n = COM.SysStringByteLen((long)object2[0]);
                if (n > 0) {
                    object = new char[(n + 1) / 2];
                    COM.MoveMemory((char[])object, (long)object2[0], n);
                    string = new String((char[])object);
                }
            }
        }
        object2 = new AccessibleEvent(this);
        ((AccessibleEvent)object2).childID = this.osToChildID(vARIANT.lVal);
        ((AccessibleEvent)object2).result = string;
        for (n = 0; n < this.accessibleListenersSize(); ++n) {
            object = this.accessibleListeners.get(n);
            object.getHelp((AccessibleEvent)object2);
        }
        if (((AccessibleEvent)object2).result == null) {
            return n2;
        }
        if (((AccessibleEvent)object2).result.length() == 0) {
            return 1;
        }
        this.setString(l2, ((AccessibleEvent)object2).result);
        return 0;
    }

    int get_accHelpTopic(long l, long l2, long l3) {
        int n = -2147352573;
        if (this.iaccessible != null && (n = this.iaccessible.get_accHelpTopic(l, l2, l3)) == -2147024809) {
            n = -2147352573;
        }
        return n;
    }

    int get_accKeyboardShortcut(long l, long l2) {
        Object object;
        int n;
        Object object2;
        VARIANT vARIANT = this.getVARIANT(l);
        if (vARIANT.vt != 3) {
            return -2147024809;
        }
        int n2 = -2147352573;
        String string = null;
        if (this.iaccessible != null) {
            n2 = this.iaccessible.get_accKeyboardShortcut(l, l2);
            if (n2 == -2147024809) {
                n2 = 1;
            }
            if (this.accessibleListenersSize() == 0 && !(this.control instanceof TabFolder)) {
                return n2;
            }
            if (n2 == 0) {
                object2 = new long[1];
                COM.MoveMemory((long[])object2, l2, OS.PTR_SIZEOF);
                n = COM.SysStringByteLen((long)object2[0]);
                if (n > 0) {
                    object = new char[(n + 1) / 2];
                    COM.MoveMemory((char[])object, (long)object2[0], n);
                    string = new String((char[])object);
                }
            }
        }
        object2 = new AccessibleEvent(this);
        ((AccessibleEvent)object2).childID = this.osToChildID(vARIANT.lVal);
        ((AccessibleEvent)object2).result = string;
        if (vARIANT.lVal == 0 && this.control instanceof TabFolder) {
            ((AccessibleEvent)object2).result = SWT.getMessage("SWT_SwitchPage_Shortcut");
        }
        for (n = 0; n < this.accessibleListenersSize(); ++n) {
            object = this.accessibleListeners.get(n);
            object.getKeyboardShortcut((AccessibleEvent)object2);
        }
        if (((AccessibleEvent)object2).result == null) {
            return n2;
        }
        if (((AccessibleEvent)object2).result.length() == 0) {
            return 1;
        }
        this.setString(l2, ((AccessibleEvent)object2).result);
        return 0;
    }

    int get_accName(long l, long l2) {
        Object object;
        int n;
        Object object2;
        if (this.control != null && this.control.isDisposed()) {
            return -2147220995;
        }
        VARIANT vARIANT = this.getVARIANT(l);
        if (vARIANT.vt != 3) {
            return -2147024809;
        }
        int n2 = 1;
        String string = null;
        if (this.iaccessible != null) {
            n2 = this.iaccessible.get_accName(l, l2);
            if (n2 == 0) {
                object2 = new long[1];
                COM.MoveMemory((long[])object2, l2, OS.PTR_SIZEOF);
                n = COM.SysStringByteLen((long)object2[0]);
                if (n > 0) {
                    object = new char[(n + 1) / 2];
                    COM.MoveMemory((char[])object, (long)object2[0], n);
                    string = new String((char[])object);
                }
            }
            if (n2 == -2147024809) {
                n2 = 1;
            }
            if (this.accessibleListenersSize() == 0 && !(this.control instanceof Text)) {
                return n2;
            }
        }
        object2 = new AccessibleEvent(this);
        ((AccessibleEvent)object2).childID = this.osToChildID(vARIANT.lVal);
        ((AccessibleEvent)object2).result = string;
        if (this.control instanceof Text && (this.control.getStyle() & 0x80) != 0 && string == null) {
            ((AccessibleEvent)object2).result = ((Text)this.control).getMessage();
        }
        for (n = 0; n < this.accessibleListenersSize(); ++n) {
            object = this.accessibleListeners.get(n);
            object.getName((AccessibleEvent)object2);
        }
        if (((AccessibleEvent)object2).result == null) {
            return n2;
        }
        if (((AccessibleEvent)object2).result.length() == 0) {
            return 1;
        }
        this.setString(l2, ((AccessibleEvent)object2).result);
        return 0;
    }

    int get_accParent(long l) {
        int n = -2147352573;
        if (this.iaccessible != null) {
            n = this.iaccessible.get_accParent(l);
        }
        if (this.parent != null) {
            this.parent.AddRef();
            COM.MoveMemory(l, new long[]{this.parent.getAddress()}, OS.PTR_SIZEOF);
            n = 0;
        }
        return n;
    }

    int get_accRole(long l, long l2) {
        int n;
        if (this.control != null && this.control.isDisposed()) {
            return -2147220995;
        }
        VARIANT vARIANT = this.getVARIANT(l);
        if (vARIANT.vt != 3) {
            return -2147024809;
        }
        int n2 = 10;
        if (this.iaccessible != null && (n = this.iaccessible.get_accRole(l, l2)) == 0) {
            VARIANT vARIANT2 = this.getVARIANT(l2);
            if (vARIANT2.vt == 3) {
                n2 = vARIANT2.lVal;
            }
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = this.osToChildID(vARIANT.lVal);
        accessibleControlEvent.detail = this.osToRole(n2);
        if ((this.control instanceof Tree || this.control instanceof Table) && vARIANT.lVal != 0 && (this.control.getStyle() & 0x20) != 0) {
            accessibleControlEvent.detail = 44;
        }
        for (int i = 0; i < this.accessibleControlListenersSize(); ++i) {
            AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(i);
            accessibleControlListener.getRole(accessibleControlEvent);
        }
        this.setIntVARIANT(l2, (short)3, this.roleToOs(accessibleControlEvent.detail));
        return 0;
    }

    int get_accSelection(long l) {
        int n = -2;
        long l2 = 0L;
        if (this.iaccessible != null) {
            int n2 = this.iaccessible.get_accSelection(l);
            if (this.accessibleControlListenersSize() == 0) {
                return n2;
            }
            if (n2 == 0) {
                VARIANT vARIANT = this.getVARIANT(l);
                if (vARIANT.vt == 3) {
                    n = this.osToChildID(vARIANT.lVal);
                } else if (vARIANT.vt == 9) {
                    l2 = vARIANT.lVal;
                } else if (vARIANT.vt == 13) {
                    n = -3;
                }
            }
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n;
        for (int i = 0; i < this.accessibleControlListenersSize(); ++i) {
            AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(i);
            accessibleControlListener.getSelection(accessibleControlEvent);
        }
        Accessible accessible = accessibleControlEvent.accessible;
        if (accessible != null) {
            accessible.AddRef();
            this.setPtrVARIANT(l, (short)9, accessible.getAddress());
            return 0;
        }
        int n3 = accessibleControlEvent.childID;
        if (n3 == -2) {
            if (l2 != 0L) {
                return 0;
            }
            this.setIntVARIANT(l, (short)0, 0);
            return 1;
        }
        if (n3 == -3) {
            return 0;
        }
        if (n3 == -1) {
            this.AddRef();
            this.setPtrVARIANT(l, (short)9, this.getAddress());
            return 0;
        }
        this.setIntVARIANT(l, (short)3, this.childIDToOs(n3));
        return 0;
    }

    int get_accState(long l, long l2) {
        int n;
        Object object;
        int n2;
        if (this.control != null && this.control.isDisposed()) {
            return -2147220995;
        }
        VARIANT vARIANT = this.getVARIANT(l);
        if (vARIANT.vt != 3) {
            return -2147024809;
        }
        int n3 = 0;
        if (this.iaccessible != null && (n2 = this.iaccessible.get_accState(l, l2)) == 0) {
            object = this.getVARIANT(l2);
            if (((VARIANT)object).vt == 3) {
                n3 = ((VARIANT)object).lVal;
            }
        }
        n2 = 0;
        object = new AccessibleControlEvent(this);
        ((AccessibleControlEvent)object).childID = this.osToChildID(vARIANT.lVal);
        ((AccessibleControlEvent)object).detail = this.osToState(n3);
        if (vARIANT.lVal != 0) {
            Object object2;
            if (this.control instanceof Tree && (this.control.getStyle() & 0x20) != 0) {
                boolean bl;
                long l3 = this.control.handle;
                object2 = new TVITEM();
                ((TVITEM)object2).mask = 24;
                ((TVITEM)object2).stateMask = 61440;
                ((TVITEM)object2).hItem = OS.COMCTL32_MAJOR >= 6 ? OS.SendMessage(l3, 4394, (long)vARIANT.lVal, 0L) : (long)vARIANT.lVal;
                long l4 = OS.SendMessage(l3, OS.TVM_GETITEM, 0L, (TVITEM)object2);
                boolean bl2 = bl = l4 != 0L && (((TVITEM)object2).state >> 12 & 1) == 0;
                if (bl) {
                    ((AccessibleControlEvent)object).detail |= 0x10;
                }
                n2 = ((TVITEM)object2).state >> 12 > 2 ? 1 : 0;
            } else if (this.control instanceof Table && (this.control.getStyle() & 0x20) != 0) {
                Table table = (Table)this.control;
                int n4 = ((AccessibleControlEvent)object).childID;
                if (0 <= n4 && n4 < table.getItemCount()) {
                    object2 = table.getItem(n4);
                    if (((TableItem)object2).getChecked()) {
                        ((AccessibleControlEvent)object).detail |= 0x10;
                    }
                    if (((TableItem)object2).getGrayed()) {
                        n2 = 1;
                    }
                }
            }
        }
        for (n = 0; n < this.accessibleControlListenersSize(); ++n) {
            AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(n);
            accessibleControlListener.getState((AccessibleControlEvent)object);
        }
        n = this.stateToOs(((AccessibleControlEvent)object).detail);
        if ((n & 0x10) != 0 && n2 != 0) {
            n &= 0xFFFFFFEF;
            n |= 0x20;
        }
        this.setIntVARIANT(l2, (short)3, n);
        return 0;
    }

    int get_accValue(long l, long l2) {
        Object object;
        int n;
        Object object2;
        if (this.control != null && this.control.isDisposed()) {
            return -2147220995;
        }
        VARIANT vARIANT = this.getVARIANT(l);
        if (vARIANT.vt != 3) {
            return -2147024809;
        }
        int n2 = -2147352573;
        String string = null;
        if (this.iaccessible != null) {
            n2 = this.iaccessible.get_accValue(l, l2);
            if (n2 == 0) {
                object2 = new long[1];
                COM.MoveMemory((long[])object2, l2, OS.PTR_SIZEOF);
                n = COM.SysStringByteLen((long)object2[0]);
                if (n > 0) {
                    object = new char[(n + 1) / 2];
                    COM.MoveMemory((char[])object, (long)object2[0], n);
                    string = new String((char[])object);
                }
            }
            if (n2 == -2147024809) {
                n2 = -2147352573;
            }
            if (this.accessibleControlListenersSize() == 0 && !(this.control instanceof Text)) {
                return n2;
            }
        }
        object2 = new AccessibleControlEvent(this);
        ((AccessibleControlEvent)object2).childID = this.osToChildID(vARIANT.lVal);
        ((AccessibleControlEvent)object2).result = string;
        if (this.control instanceof Text && (this.control.getStyle() & 0x80) != 0 && !this.control.isFocusControl()) {
            ((AccessibleControlEvent)object2).result = ((Text)this.control).getMessage();
        }
        for (n = 0; n < this.accessibleControlListenersSize(); ++n) {
            object = this.accessibleControlListeners.get(n);
            object.getValue((AccessibleControlEvent)object2);
        }
        if (((AccessibleControlEvent)object2).result == null) {
            return n2;
        }
        this.setString(l2, ((AccessibleControlEvent)object2).result);
        return 0;
    }

    int put_accName(long l, long l2) {
        return -2147467263;
    }

    int put_accValue(long l, long l2) {
        VARIANT vARIANT = this.getVARIANT(l);
        if (vARIANT.vt != 3) {
            return -2147024809;
        }
        int n = -2147352573;
        if (vARIANT.lVal == 0 && this.accessibleEditableTextListenersSize() > 0) {
            AccessibleEditableTextEvent accessibleEditableTextEvent = new AccessibleEditableTextEvent(this);
            accessibleEditableTextEvent.start = 0;
            accessibleEditableTextEvent.end = this.getCharacterCount();
            if (accessibleEditableTextEvent.end >= 0) {
                int n2 = COM.SysStringByteLen(l2);
                char[] cArray = new char[(n2 + 1) / 2];
                OS.MoveMemory(cArray, l2, n2);
                accessibleEditableTextEvent.string = new String(cArray);
                for (int i = 0; i < this.accessibleEditableTextListenersSize(); ++i) {
                    AccessibleEditableTextListener accessibleEditableTextListener = this.accessibleEditableTextListeners.get(i);
                    accessibleEditableTextListener.replaceText(accessibleEditableTextEvent);
                }
                if (accessibleEditableTextEvent.result != null && accessibleEditableTextEvent.result.equals("OK")) {
                    n = 0;
                }
            }
        }
        if (n != 0 && this.iaccessible != null && (n = this.iaccessible.put_accValue(l, l2)) == -2147024809) {
            n = -2147352573;
        }
        return n;
    }

    int Next(int n, long l, long l2) {
        int n2;
        Object[] objectArray;
        if (this.iaccessible != null && this.accessibleControlListenersSize() == 0) {
            long[] lArray = new long[1];
            int n3 = this.iaccessible.QueryInterface(COM.IIDIEnumVARIANT, lArray);
            if (n3 != 0) {
                return n3;
            }
            IEnumVARIANT iEnumVARIANT = new IEnumVARIANT(lArray[0]);
            int[] nArray = new int[1];
            n3 = iEnumVARIANT.Next(n, l, nArray);
            iEnumVARIANT.Release();
            COM.MoveMemory(l2, nArray, 4);
            return n3;
        }
        if (l == 0L) {
            return -2147024809;
        }
        if (l2 == 0L && n != 1) {
            return -2147024809;
        }
        if (this.enumIndex == 0) {
            objectArray = new AccessibleControlEvent(this);
            objectArray.childID = -1;
            for (n2 = 0; n2 < this.accessibleControlListenersSize(); ++n2) {
                AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(n2);
                accessibleControlListener.getChildren((AccessibleControlEvent)objectArray);
            }
            this.variants = objectArray.children;
        }
        objectArray = null;
        if (this.variants != null && n >= 1) {
            n2 = this.enumIndex + n - 1;
            if (n2 > this.variants.length - 1) {
                n2 = this.variants.length - 1;
            }
            if (this.enumIndex <= n2) {
                objectArray = new Object[n2 - this.enumIndex + 1];
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = this.variants[this.enumIndex];
                    objectArray[i] = object instanceof Integer ? Integer.valueOf(this.childIDToOs((Integer)object)) : object;
                    ++this.enumIndex;
                }
            }
        }
        if (objectArray != null) {
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                AccessibleControlEvent accessibleControlEvent = objectArray[n2];
                if (accessibleControlEvent instanceof Integer) {
                    int n4 = (Integer)((Object)accessibleControlEvent);
                    this.setIntVARIANT(l + (long)(n2 * VARIANT.sizeof), (short)3, n4);
                    continue;
                }
                Accessible accessible = (Accessible)((Object)accessibleControlEvent);
                accessible.AddRef();
                this.setPtrVARIANT(l + (long)(n2 * VARIANT.sizeof), (short)9, accessible.getAddress());
            }
            if (l2 != 0L) {
                COM.MoveMemory(l2, new int[]{objectArray.length}, 4);
            }
            if (objectArray.length == n) {
                return 0;
            }
        } else if (l2 != 0L) {
            COM.MoveMemory(l2, new int[]{0}, 4);
        }
        return 1;
    }

    int Skip(int n) {
        if (this.iaccessible != null && this.accessibleControlListenersSize() == 0) {
            long[] lArray = new long[1];
            int n2 = this.iaccessible.QueryInterface(COM.IIDIEnumVARIANT, lArray);
            if (n2 != 0) {
                return n2;
            }
            IEnumVARIANT iEnumVARIANT = new IEnumVARIANT(lArray[0]);
            n2 = iEnumVARIANT.Skip(n);
            iEnumVARIANT.Release();
            return n2;
        }
        if (n < 1) {
            return -2147024809;
        }
        this.enumIndex += n;
        if (this.enumIndex > this.variants.length - 1) {
            this.enumIndex = this.variants.length - 1;
            return 1;
        }
        return 0;
    }

    int Reset() {
        if (this.iaccessible != null && this.accessibleControlListenersSize() == 0) {
            long[] lArray = new long[1];
            int n = this.iaccessible.QueryInterface(COM.IIDIEnumVARIANT, lArray);
            if (n != 0) {
                return n;
            }
            IEnumVARIANT iEnumVARIANT = new IEnumVARIANT(lArray[0]);
            n = iEnumVARIANT.Reset();
            iEnumVARIANT.Release();
            return n;
        }
        this.enumIndex = 0;
        return 0;
    }

    int Clone(long l) {
        if (this.iaccessible != null && this.accessibleControlListenersSize() == 0) {
            long[] lArray = new long[1];
            int n = this.iaccessible.QueryInterface(COM.IIDIEnumVARIANT, lArray);
            if (n != 0) {
                return n;
            }
            IEnumVARIANT iEnumVARIANT = new IEnumVARIANT(lArray[0]);
            long[] lArray2 = new long[1];
            n = iEnumVARIANT.Clone(lArray2);
            iEnumVARIANT.Release();
            COM.MoveMemory(l, lArray2, OS.PTR_SIZEOF);
            return n;
        }
        if (l == 0L) {
            return -2147024809;
        }
        COM.MoveMemory(l, new long[]{this.objIEnumVARIANT.getAddress()}, OS.PTR_SIZEOF);
        this.AddRef();
        return 0;
    }

    int get_nRelations(long l) {
        int n = this.getRelationCount();
        COM.MoveMemory(l, new int[]{n}, 4);
        return 0;
    }

    int get_relation(int n, long l) {
        int n2 = -1;
        for (int i = 0; i < 15; ++i) {
            Relation relation = this.relations[i];
            if (relation != null) {
                ++n2;
            }
            if (n2 != n) continue;
            relation.AddRef();
            COM.MoveMemory(l, new long[]{relation.getAddress()}, OS.PTR_SIZEOF);
            return 0;
        }
        return -2147024809;
    }

    int get_relations(int n, long l, long l2) {
        int n2 = 0;
        for (int i = 0; i < 15 && n2 != n; ++i) {
            Relation relation = this.relations[i];
            if (relation == null) continue;
            relation.AddRef();
            COM.MoveMemory(l + (long)(n2 * OS.PTR_SIZEOF), new long[]{relation.getAddress()}, OS.PTR_SIZEOF);
            ++n2;
        }
        COM.MoveMemory(l2, new int[]{n2}, 4);
        return 0;
    }

    int get_role(long l) {
        int n = this.getRole();
        if (n == 0) {
            n = this.getDefaultRole();
        }
        COM.MoveMemory(l, new int[]{n}, 4);
        return 0;
    }

    int scrollTo(int n) {
        if (n < 4 || n > 6) {
            return -2147024809;
        }
        return -2147467263;
    }

    int scrollToPoint(int n, int n2, int n3) {
        if (n != 0) {
            return -2147024809;
        }
        return -2147467263;
    }

    int get_groupPosition(long l, long l2, long l3) {
        int n;
        int n2;
        if (this.control != null && this.control.isDisposed()) {
            return -2147220995;
        }
        AccessibleAttributeEvent accessibleAttributeEvent = new AccessibleAttributeEvent(this);
        accessibleAttributeEvent.groupIndex = -1;
        accessibleAttributeEvent.groupCount = -1;
        accessibleAttributeEvent.groupLevel = -1;
        for (n2 = 0; n2 < this.accessibleAttributeListenersSize(); ++n2) {
            AccessibleAttributeListener accessibleAttributeListener = this.accessibleAttributeListeners.get(n2);
            accessibleAttributeListener.getAttributes(accessibleAttributeEvent);
        }
        n2 = accessibleAttributeEvent.groupLevel != -1 ? accessibleAttributeEvent.groupLevel : 0;
        int n3 = accessibleAttributeEvent.groupCount != -1 ? accessibleAttributeEvent.groupCount : 0;
        int n4 = n = accessibleAttributeEvent.groupIndex != -1 ? accessibleAttributeEvent.groupIndex : 0;
        if (n3 == 0 && n == 0 && this.control instanceof Button && (this.control.getStyle() & 0x10) != 0) {
            Control[] controlArray = this.control.getParent().getChildren();
            n = 1;
            n3 = 1;
            for (int i = 0; i < controlArray.length; ++i) {
                Control control = controlArray[i];
                if (!(control instanceof Button) || (control.getStyle() & 0x10) == 0) continue;
                if (control == this.control) {
                    n = n3;
                    continue;
                }
                ++n3;
            }
        }
        COM.MoveMemory(l, new int[]{n2}, 4);
        COM.MoveMemory(l2, new int[]{n3}, 4);
        COM.MoveMemory(l3, new int[]{n}, 4);
        if (n2 == 0 && n3 == 0 && n == 0) {
            return 1;
        }
        return 0;
    }

    int get_states(long l) {
        int n;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = -1;
        for (n = 0; n < this.accessibleControlListenersSize(); ++n) {
            AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(n);
            accessibleControlListener.getState(accessibleControlEvent);
        }
        n = accessibleControlEvent.detail;
        int n2 = 0;
        if ((n & 0x4000000) != 0) {
            n2 |= 1;
        }
        if ((n & 0x8000000) != 0) {
            n2 |= 0x2000;
        }
        if ((n & 0x10000000) != 0) {
            n2 |= 0x200;
        }
        if ((n & 0x2000000) != 0) {
            n2 |= 0x800;
        }
        if ((n & 0x20000000) != 0) {
            n2 |= 0x40;
        }
        if ((n & 0x40000000) != 0) {
            n2 |= 0x8000;
        }
        if (this.getRole() == 42 && this.accessibleTextExtendedListenersSize() > 0) {
            n2 |= 8;
        }
        COM.MoveMemory(l, new int[]{n2}, 4);
        return 0;
    }

    int get_extendedRole(long l) {
        this.setString(l, null);
        return 1;
    }

    int get_localizedExtendedRole(long l) {
        this.setString(l, null);
        return 1;
    }

    int get_nExtendedStates(long l) {
        COM.MoveMemory(l, new int[]{0}, 4);
        return 0;
    }

    int get_extendedStates(int n, long l, long l2) {
        this.setString(l, null);
        COM.MoveMemory(l2, new int[]{0}, 4);
        return 1;
    }

    int get_localizedExtendedStates(int n, long l, long l2) {
        this.setString(l, null);
        COM.MoveMemory(l2, new int[]{0}, 4);
        return 1;
    }

    int get_uniqueID(long l) {
        if (this.uniqueID == -1) {
            this.uniqueID = UniqueID--;
        }
        COM.MoveMemory(l, new long[]{this.uniqueID}, 4);
        return 0;
    }

    int get_windowHandle(long l) {
        COM.MoveMemory(l, new long[]{this.control.handle}, OS.PTR_SIZEOF);
        return 0;
    }

    int get_indexInParent(long l) {
        int n;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = -5;
        accessibleControlEvent.detail = -1;
        for (n = 0; n < this.accessibleControlListenersSize(); ++n) {
            AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(n);
            accessibleControlListener.getChild(accessibleControlEvent);
        }
        n = accessibleControlEvent.detail;
        if (n == -1) {
            // empty if block
        }
        COM.MoveMemory(l, new int[]{n}, 4);
        return n == -1 ? 1 : 0;
    }

    int get_locale(long l) {
        Locale locale = Locale.getDefault();
        char[] cArray = (locale.getLanguage() + "\u0000").toCharArray();
        long l2 = COM.SysAllocString(cArray);
        COM.MoveMemory(l, new long[]{l2}, OS.PTR_SIZEOF);
        cArray = (locale.getCountry() + "\u0000").toCharArray();
        l2 = COM.SysAllocString(cArray);
        COM.MoveMemory(l + (long)OS.PTR_SIZEOF, new long[]{l2}, OS.PTR_SIZEOF);
        cArray = (locale.getVariant() + "\u0000").toCharArray();
        l2 = COM.SysAllocString(cArray);
        COM.MoveMemory(l + (long)(2 * OS.PTR_SIZEOF), new long[]{l2}, OS.PTR_SIZEOF);
        return 0;
    }

    int get_attributes(long l) {
        AccessibleAttributeEvent accessibleAttributeEvent = new AccessibleAttributeEvent(this);
        for (int i = 0; i < this.accessibleAttributeListenersSize(); ++i) {
            AccessibleAttributeListener accessibleAttributeListener = this.accessibleAttributeListeners.get(i);
            accessibleAttributeListener.getAttributes(accessibleAttributeEvent);
        }
        String string = "";
        string = string + "margin-left:" + accessibleAttributeEvent.leftMargin + ";";
        string = string + "margin-top:" + accessibleAttributeEvent.topMargin + ";";
        string = string + "margin-right:" + accessibleAttributeEvent.rightMargin + ";";
        string = string + "margin-bottom:" + accessibleAttributeEvent.bottomMargin + ";";
        if (accessibleAttributeEvent.tabStops != null) {
            for (int i = 0; i < accessibleAttributeEvent.tabStops.length; ++i) {
                string = string + "tab-stop:position=" + accessibleAttributeEvent.tabStops[i] + ";";
            }
        }
        if (accessibleAttributeEvent.justify) {
            string = string + "text-align:justify;";
        }
        string = string + "text-align:" + (accessibleAttributeEvent.alignment == 16384 ? "left" : (accessibleAttributeEvent.alignment == 131072 ? "right" : "center")) + ";";
        string = string + "text-indent:" + accessibleAttributeEvent.indent + ";";
        if (accessibleAttributeEvent.attributes != null) {
            int n = 0;
            while (n + 1 < accessibleAttributeEvent.attributes.length) {
                string = string + accessibleAttributeEvent.attributes[n] + ":" + accessibleAttributeEvent.attributes[n + 1] + ";";
                n += 2;
            }
        }
        if (this.getRole() == 42) {
            string = string + "text-model:a1;";
        }
        this.setString(l, string);
        if (string.length() == 0) {
            return 1;
        }
        return 0;
    }

    int get_nActions(long l) {
        AccessibleActionEvent accessibleActionEvent = new AccessibleActionEvent(this);
        for (int i = 0; i < this.accessibleActionListenersSize(); ++i) {
            AccessibleActionListener accessibleActionListener = this.accessibleActionListeners.get(i);
            accessibleActionListener.getActionCount(accessibleActionEvent);
        }
        COM.MoveMemory(l, new int[]{accessibleActionEvent.count}, 4);
        return 0;
    }

    int doAction(int n) {
        AccessibleActionEvent accessibleActionEvent = new AccessibleActionEvent(this);
        accessibleActionEvent.index = n;
        for (int i = 0; i < this.accessibleActionListenersSize(); ++i) {
            AccessibleActionListener accessibleActionListener = this.accessibleActionListeners.get(i);
            accessibleActionListener.doAction(accessibleActionEvent);
        }
        if (accessibleActionEvent.result == null || !accessibleActionEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int get_description(int n, long l) {
        AccessibleActionEvent accessibleActionEvent = new AccessibleActionEvent(this);
        accessibleActionEvent.index = n;
        for (int i = 0; i < this.accessibleActionListenersSize(); ++i) {
            AccessibleActionListener accessibleActionListener = this.accessibleActionListeners.get(i);
            accessibleActionListener.getDescription(accessibleActionEvent);
        }
        this.setString(l, accessibleActionEvent.result);
        if (accessibleActionEvent.result == null || accessibleActionEvent.result.length() == 0) {
            return 1;
        }
        return 0;
    }

    int get_keyBinding(int n, int n2, long l, long l2) {
        AccessibleActionEvent accessibleActionEvent = new AccessibleActionEvent(this);
        accessibleActionEvent.index = n;
        for (int i = 0; i < this.accessibleActionListenersSize(); ++i) {
            AccessibleActionListener accessibleActionListener = this.accessibleActionListeners.get(i);
            accessibleActionListener.getKeyBinding(accessibleActionEvent);
        }
        String string = accessibleActionEvent.result;
        int n3 = 0;
        if (string != null) {
            n3 = string.length();
        }
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3 && n5 != n2) {
            String string2;
            int n6 = string.indexOf(59, n4);
            if (n6 == -1) {
                n6 = n3;
            }
            if ((string2 = string.substring(n4, n6)).length() > 0) {
                this.setString(l + (long)(n5 * OS.PTR_SIZEOF), string2);
                ++n5;
            }
            n4 = n6 + 1;
        }
        COM.MoveMemory(l2, new int[]{n5}, 4);
        if (n5 == 0) {
            this.setString(l, null);
            return 1;
        }
        return 0;
    }

    int get_name(int n, long l) {
        AccessibleActionEvent accessibleActionEvent = new AccessibleActionEvent(this);
        accessibleActionEvent.index = n;
        accessibleActionEvent.localized = false;
        for (int i = 0; i < this.accessibleActionListenersSize(); ++i) {
            AccessibleActionListener accessibleActionListener = this.accessibleActionListeners.get(i);
            accessibleActionListener.getName(accessibleActionEvent);
        }
        if (accessibleActionEvent.result == null || accessibleActionEvent.result.length() == 0) {
            this.setString(l, null);
            return 1;
        }
        this.setString(l, accessibleActionEvent.result);
        return 0;
    }

    int get_localizedName(int n, long l) {
        AccessibleActionEvent accessibleActionEvent = new AccessibleActionEvent(this);
        accessibleActionEvent.index = n;
        accessibleActionEvent.localized = true;
        for (int i = 0; i < this.accessibleActionListenersSize(); ++i) {
            AccessibleActionListener accessibleActionListener = this.accessibleActionListeners.get(i);
            accessibleActionListener.getName(accessibleActionEvent);
        }
        if (accessibleActionEvent.result == null || accessibleActionEvent.result.length() == 0) {
            this.setString(l, null);
            return 1;
        }
        this.setString(l, accessibleActionEvent.result);
        return 0;
    }

    int get_appName(long l) {
        String string = Display.getAppName();
        if (string == null || string.length() == 0) {
            this.setString(l, null);
            return 1;
        }
        this.setString(l, string);
        return 0;
    }

    int get_appVersion(long l) {
        String string = Display.getAppVersion();
        if (string == null || string.length() == 0) {
            this.setString(l, null);
            return 1;
        }
        this.setString(l, string);
        return 0;
    }

    int get_toolkitName(long l) {
        String string = "SWT";
        this.setString(l, string);
        return 0;
    }

    int get_toolkitVersion(long l) {
        String string = "" + SWT.getVersion();
        this.setString(l, string);
        return 0;
    }

    int copyText(int n, int n2) {
        AccessibleEditableTextEvent accessibleEditableTextEvent = new AccessibleEditableTextEvent(this);
        accessibleEditableTextEvent.start = n == -1 ? this.getCharacterCount() : n;
        accessibleEditableTextEvent.end = n2 == -1 ? this.getCharacterCount() : n2;
        for (int i = 0; i < this.accessibleEditableTextListenersSize(); ++i) {
            AccessibleEditableTextListener accessibleEditableTextListener = this.accessibleEditableTextListeners.get(i);
            accessibleEditableTextListener.copyText(accessibleEditableTextEvent);
        }
        if (accessibleEditableTextEvent.result == null || !accessibleEditableTextEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int deleteText(int n, int n2) {
        AccessibleEditableTextEvent accessibleEditableTextEvent = new AccessibleEditableTextEvent(this);
        accessibleEditableTextEvent.start = n == -1 ? this.getCharacterCount() : n;
        accessibleEditableTextEvent.end = n2 == -1 ? this.getCharacterCount() : n2;
        accessibleEditableTextEvent.string = "";
        for (int i = 0; i < this.accessibleEditableTextListenersSize(); ++i) {
            AccessibleEditableTextListener accessibleEditableTextListener = this.accessibleEditableTextListeners.get(i);
            accessibleEditableTextListener.replaceText(accessibleEditableTextEvent);
        }
        if (accessibleEditableTextEvent.result == null || !accessibleEditableTextEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int insertText(int n, long l) {
        AccessibleEditableTextEvent accessibleEditableTextEvent = new AccessibleEditableTextEvent(this);
        accessibleEditableTextEvent.end = accessibleEditableTextEvent.start = n == -1 ? this.getCharacterCount() : n;
        accessibleEditableTextEvent.string = this.getString(l);
        for (int i = 0; i < this.accessibleEditableTextListenersSize(); ++i) {
            AccessibleEditableTextListener accessibleEditableTextListener = this.accessibleEditableTextListeners.get(i);
            accessibleEditableTextListener.replaceText(accessibleEditableTextEvent);
        }
        if (accessibleEditableTextEvent.result == null || !accessibleEditableTextEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int cutText(int n, int n2) {
        AccessibleEditableTextEvent accessibleEditableTextEvent = new AccessibleEditableTextEvent(this);
        accessibleEditableTextEvent.start = n == -1 ? this.getCharacterCount() : n;
        accessibleEditableTextEvent.end = n2 == -1 ? this.getCharacterCount() : n2;
        for (int i = 0; i < this.accessibleEditableTextListenersSize(); ++i) {
            AccessibleEditableTextListener accessibleEditableTextListener = this.accessibleEditableTextListeners.get(i);
            accessibleEditableTextListener.cutText(accessibleEditableTextEvent);
        }
        if (accessibleEditableTextEvent.result == null || !accessibleEditableTextEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int pasteText(int n) {
        AccessibleEditableTextEvent accessibleEditableTextEvent = new AccessibleEditableTextEvent(this);
        accessibleEditableTextEvent.end = accessibleEditableTextEvent.start = n == -1 ? this.getCharacterCount() : n;
        for (int i = 0; i < this.accessibleEditableTextListenersSize(); ++i) {
            AccessibleEditableTextListener accessibleEditableTextListener = this.accessibleEditableTextListeners.get(i);
            accessibleEditableTextListener.pasteText(accessibleEditableTextEvent);
        }
        if (accessibleEditableTextEvent.result == null || !accessibleEditableTextEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int replaceText(int n, int n2, long l) {
        AccessibleEditableTextEvent accessibleEditableTextEvent = new AccessibleEditableTextEvent(this);
        accessibleEditableTextEvent.start = n == -1 ? this.getCharacterCount() : n;
        accessibleEditableTextEvent.end = n2 == -1 ? this.getCharacterCount() : n2;
        accessibleEditableTextEvent.string = this.getString(l);
        for (int i = 0; i < this.accessibleEditableTextListenersSize(); ++i) {
            AccessibleEditableTextListener accessibleEditableTextListener = this.accessibleEditableTextListeners.get(i);
            accessibleEditableTextListener.replaceText(accessibleEditableTextEvent);
        }
        if (accessibleEditableTextEvent.result == null || !accessibleEditableTextEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int setAttributes(int n, int n2, long l) {
        AccessibleTextAttributeEvent accessibleTextAttributeEvent = new AccessibleTextAttributeEvent(this);
        String string = this.getString(l);
        if (string != null && string.length() > 0) {
            String[] stringArray;
            accessibleTextAttributeEvent.start = n == -1 ? this.getCharacterCount() : n;
            accessibleTextAttributeEvent.end = n2 == -1 ? this.getCharacterCount() : n2;
            TextStyle textStyle = new TextStyle();
            FontData fontData = null;
            int n3 = 10;
            String[] stringArray2 = new String[]{};
            int n4 = 0;
            int n5 = string.indexOf(59);
            while (n5 != -1 && n5 < string.length()) {
                String string2 = string.substring(n4, n5).trim();
                int n6 = string2.indexOf(58);
                if (n6 != -1 && n6 + 1 < string2.length()) {
                    stringArray = new String[stringArray2.length + 2];
                    System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
                    stringArray[stringArray2.length] = string2.substring(0, n6).trim();
                    stringArray[stringArray2.length + 1] = string2.substring(n6 + 1).trim();
                    stringArray2 = stringArray;
                }
                n4 = n5 + 1;
                n5 = string.indexOf(59, n4);
            }
            int n7 = 0;
            while (n7 + 1 < stringArray2.length) {
                String string3 = stringArray2[n7];
                stringArray = stringArray2[n7 + 1];
                if (string3.equals("text-position")) {
                    if (stringArray.equals("super")) {
                        textStyle.rise = n3 / 2;
                    } else if (stringArray.equals("sub")) {
                        textStyle.rise = -n3 / 2;
                    }
                } else if (string3.equals("text-underline-type")) {
                    textStyle.underline = true;
                    if (stringArray.equals("double")) {
                        textStyle.underlineStyle = 1;
                    } else if (stringArray.equals("single") && textStyle.underlineStyle != 3 && textStyle.underlineStyle != 2) {
                        textStyle.underlineStyle = 0;
                    }
                } else if (string3.equals("text-underline-style") && stringArray.equals("wave")) {
                    textStyle.underline = true;
                    textStyle.underlineStyle = 3;
                } else if (string3.equals("invalid") && stringArray.equals("true")) {
                    textStyle.underline = true;
                    textStyle.underlineStyle = 2;
                } else if (string3.equals("text-line-through-type")) {
                    if (stringArray.equals("single")) {
                        textStyle.strikeout = true;
                    }
                } else if (string3.equals("font-family")) {
                    if (fontData == null) {
                        fontData = new FontData();
                    }
                    fontData.setName((String)stringArray);
                } else if (string3.equals("font-size")) {
                    try {
                        String[] stringArray3 = stringArray.endsWith("pt") ? stringArray.substring(0, stringArray.length() - 2) : stringArray;
                        n3 = Integer.parseInt((String)stringArray3);
                        if (fontData == null) {
                            fontData = new FontData();
                        }
                        fontData.setHeight(n3);
                        if (textStyle.rise > 0) {
                            textStyle.rise = n3 / 2;
                        } else if (textStyle.rise < 0) {
                            textStyle.rise = -n3 / 2;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string3.equals("font-style")) {
                    if (stringArray.equals("italic")) {
                        if (fontData == null) {
                            fontData = new FontData();
                        }
                        fontData.setStyle(fontData.getStyle() | 2);
                    }
                } else if (string3.equals("font-weight")) {
                    if (stringArray.equals("bold")) {
                        if (fontData == null) {
                            fontData = new FontData();
                        }
                        fontData.setStyle(fontData.getStyle() | 1);
                    } else {
                        try {
                            int n8 = Integer.parseInt((String)stringArray);
                            if (fontData == null) {
                                fontData = new FontData();
                            }
                            if (n8 > 400) {
                                fontData.setStyle(fontData.getStyle() | 1);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else if (string3.equals("color")) {
                    textStyle.foreground = this.colorFromString((String)stringArray);
                } else if (string3.equals("background-color")) {
                    textStyle.background = this.colorFromString((String)stringArray);
                }
                n7 += 2;
            }
            if (stringArray2.length > 0) {
                accessibleTextAttributeEvent.attributes = stringArray2;
                if (fontData != null) {
                    textStyle.font = new Font((Device)this.control.getDisplay(), fontData);
                }
                if (!textStyle.equals(new TextStyle())) {
                    accessibleTextAttributeEvent.textStyle = textStyle;
                }
            }
            for (n7 = 0; n7 < this.accessibleEditableTextListenersSize(); ++n7) {
                AccessibleEditableTextListener accessibleEditableTextListener = this.accessibleEditableTextListeners.get(n7);
                accessibleEditableTextListener.setTextAttributes(accessibleTextAttributeEvent);
            }
            if (textStyle.font != null) {
                textStyle.font.dispose();
            }
            if (textStyle.foreground != null) {
                textStyle.foreground.dispose();
            }
            if (textStyle.background != null) {
                textStyle.background.dispose();
            }
        }
        if (accessibleTextAttributeEvent.result == null || !accessibleTextAttributeEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int get_anchor(int n, long l) {
        AccessibleHyperlinkEvent accessibleHyperlinkEvent = new AccessibleHyperlinkEvent(this);
        accessibleHyperlinkEvent.index = n;
        for (int i = 0; i < this.accessibleHyperlinkListenersSize(); ++i) {
            AccessibleHyperlinkListener accessibleHyperlinkListener = this.accessibleHyperlinkListeners.get(i);
            accessibleHyperlinkListener.getAnchor(accessibleHyperlinkEvent);
        }
        Accessible accessible = accessibleHyperlinkEvent.accessible;
        if (accessible != null) {
            accessible.AddRef();
            this.setPtrVARIANT(l, (short)9, accessible.getAddress());
            return 0;
        }
        this.setStringVARIANT(l, accessibleHyperlinkEvent.result);
        if (accessibleHyperlinkEvent.result == null) {
            return 1;
        }
        return 0;
    }

    int get_anchorTarget(int n, long l) {
        AccessibleHyperlinkEvent accessibleHyperlinkEvent = new AccessibleHyperlinkEvent(this);
        accessibleHyperlinkEvent.index = n;
        for (int i = 0; i < this.accessibleHyperlinkListenersSize(); ++i) {
            AccessibleHyperlinkListener accessibleHyperlinkListener = this.accessibleHyperlinkListeners.get(i);
            accessibleHyperlinkListener.getAnchorTarget(accessibleHyperlinkEvent);
        }
        Accessible accessible = accessibleHyperlinkEvent.accessible;
        if (accessible != null) {
            accessible.AddRef();
            this.setPtrVARIANT(l, (short)9, accessible.getAddress());
            return 0;
        }
        this.setStringVARIANT(l, accessibleHyperlinkEvent.result);
        if (accessibleHyperlinkEvent.result == null) {
            return 1;
        }
        return 0;
    }

    int get_startIndex(long l) {
        AccessibleHyperlinkEvent accessibleHyperlinkEvent = new AccessibleHyperlinkEvent(this);
        for (int i = 0; i < this.accessibleHyperlinkListenersSize(); ++i) {
            AccessibleHyperlinkListener accessibleHyperlinkListener = this.accessibleHyperlinkListeners.get(i);
            accessibleHyperlinkListener.getStartIndex(accessibleHyperlinkEvent);
        }
        COM.MoveMemory(l, new int[]{accessibleHyperlinkEvent.index}, 4);
        return 0;
    }

    int get_endIndex(long l) {
        AccessibleHyperlinkEvent accessibleHyperlinkEvent = new AccessibleHyperlinkEvent(this);
        for (int i = 0; i < this.accessibleHyperlinkListenersSize(); ++i) {
            AccessibleHyperlinkListener accessibleHyperlinkListener = this.accessibleHyperlinkListeners.get(i);
            accessibleHyperlinkListener.getEndIndex(accessibleHyperlinkEvent);
        }
        COM.MoveMemory(l, new int[]{accessibleHyperlinkEvent.index}, 4);
        return 0;
    }

    int get_valid(long l) {
        return -2147467263;
    }

    int get_nHyperlinks(long l) {
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        for (int i = 0; i < this.accessibleTextExtendedListenersSize(); ++i) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(i);
            accessibleTextExtendedListener.getHyperlinkCount(accessibleTextEvent);
        }
        COM.MoveMemory(l, new int[]{accessibleTextEvent.count}, 4);
        return 0;
    }

    int get_hyperlink(int n, long l) {
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.index = n;
        for (int i = 0; i < this.accessibleTextExtendedListenersSize(); ++i) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(i);
            accessibleTextExtendedListener.getHyperlink(accessibleTextEvent);
        }
        Accessible accessible = accessibleTextEvent.accessible;
        if (accessible == null) {
            this.setIntVARIANT(l, (short)0, 0);
            return -2147024809;
        }
        accessible.AddRef();
        COM.MoveMemory(l, new long[]{accessible.getAddress()}, OS.PTR_SIZEOF);
        return 0;
    }

    int get_hyperlinkIndex(int n, long l) {
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.offset = n;
        accessibleTextEvent.index = -1;
        for (int i = 0; i < this.accessibleTextExtendedListenersSize(); ++i) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(i);
            accessibleTextExtendedListener.getHyperlinkIndex(accessibleTextEvent);
        }
        COM.MoveMemory(l, new int[]{accessibleTextEvent.index}, 4);
        if (accessibleTextEvent.index == -1) {
            return 1;
        }
        return 0;
    }

    int get_cellAt(int n, int n2, long l) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        accessibleTableEvent.row = n;
        accessibleTableEvent.column = n2;
        for (int i = 0; i < this.accessibleTableListenersSize(); ++i) {
            AccessibleTableListener accessibleTableListener = this.accessibleTableListeners.get(i);
            accessibleTableListener.getCell(accessibleTableEvent);
        }
        Accessible accessible = accessibleTableEvent.accessible;
        if (accessible == null) {
            return -2147024809;
        }
        accessible.AddRef();
        COM.MoveMemory(l, new long[]{accessible.getAddress()}, OS.PTR_SIZEOF);
        return 0;
    }

    int get_caption(long l) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        for (int i = 0; i < this.accessibleTableListenersSize(); ++i) {
            AccessibleTableListener accessibleTableListener = this.accessibleTableListeners.get(i);
            accessibleTableListener.getCaption(accessibleTableEvent);
        }
        Accessible accessible = accessibleTableEvent.accessible;
        if (accessible == null) {
            COM.MoveMemory(l, new long[]{0L}, OS.PTR_SIZEOF);
            return 1;
        }
        accessible.AddRef();
        COM.MoveMemory(l, new long[]{accessible.getAddress()}, OS.PTR_SIZEOF);
        return 0;
    }

    int get_columnDescription(int n, long l) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        accessibleTableEvent.column = n;
        for (int i = 0; i < this.accessibleTableListenersSize(); ++i) {
            AccessibleTableListener accessibleTableListener = this.accessibleTableListeners.get(i);
            accessibleTableListener.getColumnDescription(accessibleTableEvent);
        }
        this.setString(l, accessibleTableEvent.result);
        if (accessibleTableEvent.result == null) {
            return 1;
        }
        return 0;
    }

    int get_nColumns(long l) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        for (int i = 0; i < this.accessibleTableListenersSize(); ++i) {
            AccessibleTableListener accessibleTableListener = this.accessibleTableListeners.get(i);
            accessibleTableListener.getColumnCount(accessibleTableEvent);
        }
        COM.MoveMemory(l, new int[]{accessibleTableEvent.count}, 4);
        return 0;
    }

    int get_nRows(long l) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        for (int i = 0; i < this.accessibleTableListenersSize(); ++i) {
            AccessibleTableListener accessibleTableListener = this.accessibleTableListeners.get(i);
            accessibleTableListener.getRowCount(accessibleTableEvent);
        }
        COM.MoveMemory(l, new int[]{accessibleTableEvent.count}, 4);
        return 0;
    }

    int get_nSelectedCells(long l) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        for (int i = 0; i < this.accessibleTableListenersSize(); ++i) {
            AccessibleTableListener accessibleTableListener = this.accessibleTableListeners.get(i);
            accessibleTableListener.getSelectedCellCount(accessibleTableEvent);
        }
        COM.MoveMemory(l, new int[]{accessibleTableEvent.count}, 4);
        return 0;
    }

    int get_nSelectedColumns(long l) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        for (int i = 0; i < this.accessibleTableListenersSize(); ++i) {
            AccessibleTableListener accessibleTableListener = this.accessibleTableListeners.get(i);
            accessibleTableListener.getSelectedColumnCount(accessibleTableEvent);
        }
        COM.MoveMemory(l, new int[]{accessibleTableEvent.count}, 4);
        return 0;
    }

    int get_nSelectedRows(long l) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        for (int i = 0; i < this.accessibleTableListenersSize(); ++i) {
            AccessibleTableListener accessibleTableListener = this.accessibleTableListeners.get(i);
            accessibleTableListener.getSelectedRowCount(accessibleTableEvent);
        }
        COM.MoveMemory(l, new int[]{accessibleTableEvent.count}, 4);
        return 0;
    }

    int get_rowDescription(int n, long l) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        accessibleTableEvent.row = n;
        for (int i = 0; i < this.accessibleTableListenersSize(); ++i) {
            AccessibleTableListener accessibleTableListener = this.accessibleTableListeners.get(i);
            accessibleTableListener.getRowDescription(accessibleTableEvent);
        }
        this.setString(l, accessibleTableEvent.result);
        if (accessibleTableEvent.result == null) {
            return 1;
        }
        return 0;
    }

    int get_selectedCells(long l, long l2) {
        int n;
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        for (n = 0; n < this.accessibleTableListenersSize(); ++n) {
            AccessibleTableListener accessibleTableListener = this.accessibleTableListeners.get(n);
            accessibleTableListener.getSelectedCells(accessibleTableEvent);
        }
        if (accessibleTableEvent.accessibles == null || accessibleTableEvent.accessibles.length == 0) {
            COM.MoveMemory(l, new long[]{0L}, OS.PTR_SIZEOF);
            COM.MoveMemory(l2, new int[]{0}, 4);
            return 1;
        }
        n = accessibleTableEvent.accessibles.length;
        long l3 = COM.CoTaskMemAlloc(n * OS.PTR_SIZEOF);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Accessible accessible = accessibleTableEvent.accessibles[i];
            if (accessible == null) continue;
            accessible.AddRef();
            COM.MoveMemory(l3 + (long)(i * OS.PTR_SIZEOF), new long[]{accessible.getAddress()}, OS.PTR_SIZEOF);
            ++n2;
        }
        COM.MoveMemory(l, new long[]{l3}, OS.PTR_SIZEOF);
        COM.MoveMemory(l2, new int[]{n2}, 4);
        return 0;
    }

    int get_selectedColumns(long l, long l2) {
        int n;
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        for (n = 0; n < this.accessibleTableListenersSize(); ++n) {
            AccessibleTableListener accessibleTableListener = this.accessibleTableListeners.get(n);
            accessibleTableListener.getSelectedColumns(accessibleTableEvent);
        }
        int n2 = n = accessibleTableEvent.selected == null ? 0 : accessibleTableEvent.selected.length;
        if (n == 0) {
            COM.MoveMemory(l, new long[]{0L}, OS.PTR_SIZEOF);
            COM.MoveMemory(l2, new int[]{0}, 4);
            return 1;
        }
        long l3 = COM.CoTaskMemAlloc(n * 4);
        COM.MoveMemory(l3, accessibleTableEvent.selected, n * 4);
        COM.MoveMemory(l, new long[]{l3}, OS.PTR_SIZEOF);
        COM.MoveMemory(l2, new int[]{n}, 4);
        return 0;
    }

    int get_selectedRows(long l, long l2) {
        int n;
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        for (n = 0; n < this.accessibleTableListenersSize(); ++n) {
            AccessibleTableListener accessibleTableListener = this.accessibleTableListeners.get(n);
            accessibleTableListener.getSelectedRows(accessibleTableEvent);
        }
        int n2 = n = accessibleTableEvent.selected == null ? 0 : accessibleTableEvent.selected.length;
        if (n == 0) {
            COM.MoveMemory(l, new long[]{0L}, OS.PTR_SIZEOF);
            COM.MoveMemory(l2, new int[]{0}, 4);
            return 1;
        }
        long l3 = COM.CoTaskMemAlloc(n * 4);
        COM.MoveMemory(l3, accessibleTableEvent.selected, n * 4);
        COM.MoveMemory(l, new long[]{l3}, OS.PTR_SIZEOF);
        COM.MoveMemory(l2, new int[]{n}, 4);
        return 0;
    }

    int get_summary(long l) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        for (int i = 0; i < this.accessibleTableListenersSize(); ++i) {
            AccessibleTableListener accessibleTableListener = this.accessibleTableListeners.get(i);
            accessibleTableListener.getSummary(accessibleTableEvent);
        }
        Accessible accessible = accessibleTableEvent.accessible;
        if (accessible == null) {
            COM.MoveMemory(l, new long[]{0L}, OS.PTR_SIZEOF);
            return 1;
        }
        accessible.AddRef();
        COM.MoveMemory(l, new long[]{accessible.getAddress()}, OS.PTR_SIZEOF);
        return 0;
    }

    int get_isColumnSelected(int n, long l) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        accessibleTableEvent.column = n;
        for (int i = 0; i < this.accessibleTableListenersSize(); ++i) {
            AccessibleTableListener accessibleTableListener = this.accessibleTableListeners.get(i);
            accessibleTableListener.isColumnSelected(accessibleTableEvent);
        }
        COM.MoveMemory(l, new int[]{accessibleTableEvent.isSelected ? 1 : 0}, 4);
        return 0;
    }

    int get_isRowSelected(int n, long l) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        accessibleTableEvent.row = n;
        for (int i = 0; i < this.accessibleTableListenersSize(); ++i) {
            AccessibleTableListener accessibleTableListener = this.accessibleTableListeners.get(i);
            accessibleTableListener.isRowSelected(accessibleTableEvent);
        }
        COM.MoveMemory(l, new int[]{accessibleTableEvent.isSelected ? 1 : 0}, 4);
        return 0;
    }

    int selectRow(int n) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        accessibleTableEvent.row = n;
        for (int i = 0; i < this.accessibleTableListenersSize(); ++i) {
            AccessibleTableListener accessibleTableListener = this.accessibleTableListeners.get(i);
            accessibleTableListener.setSelectedRow(accessibleTableEvent);
        }
        if (accessibleTableEvent.result == null || !accessibleTableEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int selectColumn(int n) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        accessibleTableEvent.column = n;
        for (int i = 0; i < this.accessibleTableListenersSize(); ++i) {
            AccessibleTableListener accessibleTableListener = this.accessibleTableListeners.get(i);
            accessibleTableListener.setSelectedColumn(accessibleTableEvent);
        }
        if (accessibleTableEvent.result == null || !accessibleTableEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int unselectRow(int n) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        accessibleTableEvent.row = n;
        for (int i = 0; i < this.accessibleTableListenersSize(); ++i) {
            AccessibleTableListener accessibleTableListener = this.accessibleTableListeners.get(i);
            accessibleTableListener.deselectRow(accessibleTableEvent);
        }
        if (accessibleTableEvent.result == null || !accessibleTableEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int unselectColumn(int n) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        accessibleTableEvent.column = n;
        for (int i = 0; i < this.accessibleTableListenersSize(); ++i) {
            AccessibleTableListener accessibleTableListener = this.accessibleTableListeners.get(i);
            accessibleTableListener.deselectColumn(accessibleTableEvent);
        }
        if (accessibleTableEvent.result == null || !accessibleTableEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int get_modelChange(long l) {
        if (this.tableChange == null) {
            COM.MoveMemory(l, new long[]{0L}, OS.PTR_SIZEOF);
            return 1;
        }
        COM.MoveMemory(l, this.tableChange, this.tableChange.length * 4);
        return 0;
    }

    int get_columnExtent(long l) {
        AccessibleTableCellEvent accessibleTableCellEvent = new AccessibleTableCellEvent(this);
        for (int i = 0; i < this.accessibleTableCellListenersSize(); ++i) {
            AccessibleTableCellListener accessibleTableCellListener = this.accessibleTableCellListeners.get(i);
            accessibleTableCellListener.getColumnSpan(accessibleTableCellEvent);
        }
        COM.MoveMemory(l, new int[]{accessibleTableCellEvent.count}, 4);
        return 0;
    }

    int get_columnHeaderCells(long l, long l2) {
        int n;
        AccessibleTableCellEvent accessibleTableCellEvent = new AccessibleTableCellEvent(this);
        for (n = 0; n < this.accessibleTableCellListenersSize(); ++n) {
            AccessibleTableCellListener accessibleTableCellListener = this.accessibleTableCellListeners.get(n);
            accessibleTableCellListener.getColumnHeaders(accessibleTableCellEvent);
        }
        if (accessibleTableCellEvent.accessibles == null || accessibleTableCellEvent.accessibles.length == 0) {
            COM.MoveMemory(l, new long[]{0L}, OS.PTR_SIZEOF);
            COM.MoveMemory(l2, new int[]{0}, 4);
            return 1;
        }
        n = accessibleTableCellEvent.accessibles.length;
        long l3 = COM.CoTaskMemAlloc(n * OS.PTR_SIZEOF);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Accessible accessible = accessibleTableCellEvent.accessibles[i];
            if (accessible == null) continue;
            accessible.AddRef();
            COM.MoveMemory(l3 + (long)(i * OS.PTR_SIZEOF), new long[]{accessible.getAddress()}, OS.PTR_SIZEOF);
            ++n2;
        }
        COM.MoveMemory(l, new long[]{l3}, OS.PTR_SIZEOF);
        COM.MoveMemory(l2, new int[]{n2}, 4);
        return 0;
    }

    int get_columnIndex(long l) {
        AccessibleTableCellEvent accessibleTableCellEvent = new AccessibleTableCellEvent(this);
        for (int i = 0; i < this.accessibleTableCellListenersSize(); ++i) {
            AccessibleTableCellListener accessibleTableCellListener = this.accessibleTableCellListeners.get(i);
            accessibleTableCellListener.getColumnIndex(accessibleTableCellEvent);
        }
        COM.MoveMemory(l, new int[]{accessibleTableCellEvent.index}, 4);
        return 0;
    }

    int get_rowExtent(long l) {
        AccessibleTableCellEvent accessibleTableCellEvent = new AccessibleTableCellEvent(this);
        for (int i = 0; i < this.accessibleTableCellListenersSize(); ++i) {
            AccessibleTableCellListener accessibleTableCellListener = this.accessibleTableCellListeners.get(i);
            accessibleTableCellListener.getRowSpan(accessibleTableCellEvent);
        }
        COM.MoveMemory(l, new int[]{accessibleTableCellEvent.count}, 4);
        return 0;
    }

    int get_rowHeaderCells(long l, long l2) {
        int n;
        AccessibleTableCellEvent accessibleTableCellEvent = new AccessibleTableCellEvent(this);
        for (n = 0; n < this.accessibleTableCellListenersSize(); ++n) {
            AccessibleTableCellListener accessibleTableCellListener = this.accessibleTableCellListeners.get(n);
            accessibleTableCellListener.getRowHeaders(accessibleTableCellEvent);
        }
        if (accessibleTableCellEvent.accessibles == null || accessibleTableCellEvent.accessibles.length == 0) {
            COM.MoveMemory(l, new long[]{0L}, OS.PTR_SIZEOF);
            COM.MoveMemory(l2, new int[]{0}, 4);
            return 1;
        }
        n = accessibleTableCellEvent.accessibles.length;
        long l3 = COM.CoTaskMemAlloc(n * OS.PTR_SIZEOF);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Accessible accessible = accessibleTableCellEvent.accessibles[i];
            if (accessible == null) continue;
            accessible.AddRef();
            COM.MoveMemory(l3 + (long)(i * OS.PTR_SIZEOF), new long[]{accessible.getAddress()}, OS.PTR_SIZEOF);
            ++n2;
        }
        COM.MoveMemory(l, new long[]{l3}, OS.PTR_SIZEOF);
        COM.MoveMemory(l2, new int[]{n2}, 4);
        return 0;
    }

    int get_rowIndex(long l) {
        AccessibleTableCellEvent accessibleTableCellEvent = new AccessibleTableCellEvent(this);
        for (int i = 0; i < this.accessibleTableCellListenersSize(); ++i) {
            AccessibleTableCellListener accessibleTableCellListener = this.accessibleTableCellListeners.get(i);
            accessibleTableCellListener.getRowIndex(accessibleTableCellEvent);
        }
        COM.MoveMemory(l, new int[]{accessibleTableCellEvent.index}, 4);
        return 0;
    }

    int get_isSelected(long l) {
        AccessibleTableCellEvent accessibleTableCellEvent = new AccessibleTableCellEvent(this);
        for (int i = 0; i < this.accessibleTableCellListenersSize(); ++i) {
            AccessibleTableCellListener accessibleTableCellListener = this.accessibleTableCellListeners.get(i);
            accessibleTableCellListener.isSelected(accessibleTableCellEvent);
        }
        COM.MoveMemory(l, new int[]{accessibleTableCellEvent.isSelected ? 1 : 0}, 4);
        return 0;
    }

    int get_rowColumnExtents(long l, long l2, long l3, long l4, long l5) {
        return -2147352573;
    }

    int get_table(long l) {
        AccessibleTableCellEvent accessibleTableCellEvent = new AccessibleTableCellEvent(this);
        for (int i = 0; i < this.accessibleTableCellListenersSize(); ++i) {
            AccessibleTableCellListener accessibleTableCellListener = this.accessibleTableCellListeners.get(i);
            accessibleTableCellListener.getTable(accessibleTableCellEvent);
        }
        Accessible accessible = accessibleTableCellEvent.accessible;
        if (accessible == null) {
            COM.MoveMemory(l, new long[]{0L}, OS.PTR_SIZEOF);
            return 1;
        }
        accessible.AddRef();
        COM.MoveMemory(l, new long[]{accessible.getAddress()}, OS.PTR_SIZEOF);
        return 0;
    }

    int addSelection(int n, int n2) {
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.start = n == -1 ? this.getCharacterCount() : n;
        accessibleTextEvent.end = n2 == -1 ? this.getCharacterCount() : n2;
        for (int i = 0; i < this.accessibleTextExtendedListenersSize(); ++i) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(i);
            accessibleTextExtendedListener.addSelection(accessibleTextEvent);
        }
        if (accessibleTextEvent.result == null || !accessibleTextEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int get_attributes(int n, long l, long l2, long l3) {
        Object object;
        AccessibleTextAttributeEvent accessibleTextAttributeEvent = new AccessibleTextAttributeEvent(this);
        accessibleTextAttributeEvent.offset = n == -1 ? this.getCharacterCount() : n;
        for (int i = 0; i < this.accessibleAttributeListenersSize(); ++i) {
            object = this.accessibleAttributeListeners.get(i);
            object.getTextAttributes(accessibleTextAttributeEvent);
        }
        String string = "";
        object = accessibleTextAttributeEvent.textStyle;
        if (object != null) {
            Object object2;
            Font font;
            if (((TextStyle)object).rise != 0) {
                string = string + "text-position:";
                string = ((TextStyle)object).rise > 0 ? string + "super" : string + "sub";
            }
            if (((TextStyle)object).underline) {
                string = string + "text-underline-type:";
                switch (((TextStyle)object).underlineStyle) {
                    case 0: {
                        string = string + "single;";
                        break;
                    }
                    case 1: {
                        string = string + "double;";
                        break;
                    }
                    case 3: {
                        string = string + "single;text-underline-style:wave;";
                        break;
                    }
                    case 2: {
                        string = string + "single;text-underline-style:wave;invalid:true;";
                        break;
                    }
                    default: {
                        string = string + "none;";
                    }
                }
            }
            if (((TextStyle)object).strikeout) {
                string = string + "text-line-through-type:single;";
            }
            if ((font = ((TextStyle)object).font) != null && !font.isDisposed()) {
                object2 = font.getFontData()[0];
                string = string + "font-family:" + ((FontData)object2).getName() + ";";
                string = string + "font-size:" + ((FontData)object2).getHeight() + "pt;";
                string = string + "font-style:" + (((FontData)object2).data.lfItalic != 0 ? "italic" : "normal") + ";";
                string = string + "font-weight:" + ((FontData)object2).data.lfWeight + ";";
            }
            if ((object2 = ((TextStyle)object).foreground) != null && !((Color)object2).isDisposed()) {
                string = string + "color:rgb(" + ((Color)object2).getRed() + "," + ((Color)object2).getGreen() + "," + ((Color)object2).getBlue() + ");";
            }
            if ((object2 = ((TextStyle)object).background) != null && !((Color)object2).isDisposed()) {
                string = string + "background-color:rgb(" + ((Color)object2).getRed() + "," + ((Color)object2).getGreen() + "," + ((Color)object2).getBlue() + ");";
            }
        }
        if (accessibleTextAttributeEvent.attributes != null) {
            int n2 = 0;
            while (n2 + 1 < accessibleTextAttributeEvent.attributes.length) {
                string = string + accessibleTextAttributeEvent.attributes[n2] + ":" + accessibleTextAttributeEvent.attributes[n2 + 1] + ";";
                n2 += 2;
            }
        }
        COM.MoveMemory(l, new int[]{accessibleTextAttributeEvent.start}, 4);
        COM.MoveMemory(l2, new int[]{accessibleTextAttributeEvent.end}, 4);
        this.setString(l3, string);
        if (string.length() == 0) {
            return 1;
        }
        return 0;
    }

    int get_caretOffset(long l) {
        int n = this.getCaretOffset();
        COM.MoveMemory(l, new int[]{n}, 4);
        if (n == -1) {
            return 1;
        }
        return 0;
    }

    int get_characterExtents(int n, int n2, long l, long l2, long l3, long l4) {
        int n3 = this.getCharacterCount();
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.start = n == -1 ? n3 : (n < 0 ? 0 : n);
        accessibleTextEvent.end = n == -1 || n >= n3 ? n3 : n + 1;
        for (int i = 0; i < this.accessibleTextExtendedListenersSize(); ++i) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(i);
            accessibleTextExtendedListener.getTextBounds(accessibleTextEvent);
        }
        COM.MoveMemory(l, new int[]{accessibleTextEvent.x}, 4);
        COM.MoveMemory(l2, new int[]{accessibleTextEvent.y}, 4);
        COM.MoveMemory(l3, new int[]{accessibleTextEvent.width}, 4);
        COM.MoveMemory(l4, new int[]{accessibleTextEvent.height}, 4);
        if (accessibleTextEvent.width == 0 && accessibleTextEvent.height == 0) {
            return -2147024809;
        }
        return 0;
    }

    int get_nSelections(long l) {
        AccessibleTextListener accessibleTextListener;
        int n;
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.count = -1;
        for (n = 0; n < this.accessibleTextExtendedListenersSize(); ++n) {
            accessibleTextListener = this.accessibleTextExtendedListeners.get(n);
            accessibleTextListener.getSelectionCount(accessibleTextEvent);
        }
        if (accessibleTextEvent.count == -1) {
            accessibleTextEvent.childID = -1;
            accessibleTextEvent.offset = -1;
            accessibleTextEvent.length = 0;
            for (n = 0; n < this.accessibleTextListenersSize(); ++n) {
                accessibleTextListener = this.accessibleTextListeners.get(n);
                accessibleTextListener.getSelectionRange(accessibleTextEvent);
            }
            accessibleTextEvent.count = accessibleTextEvent.offset != -1 && accessibleTextEvent.length > 0 ? 1 : 0;
        }
        COM.MoveMemory(l, new int[]{accessibleTextEvent.count}, 4);
        return 0;
    }

    int get_offsetAtPoint(int n, int n2, int n3, long l) {
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.x = n;
        accessibleTextEvent.y = n2;
        accessibleTextEvent.offset = -1;
        for (int i = 0; i < this.accessibleTextExtendedListenersSize(); ++i) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(i);
            accessibleTextExtendedListener.getOffsetAtPoint(accessibleTextEvent);
        }
        COM.MoveMemory(l, new int[]{accessibleTextEvent.offset}, 4);
        if (accessibleTextEvent.offset == -1) {
            return 1;
        }
        return 0;
    }

    int get_selection(int n, long l, long l2) {
        AccessibleTextListener accessibleTextListener;
        int n2;
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.index = n;
        accessibleTextEvent.start = -1;
        accessibleTextEvent.end = -1;
        for (n2 = 0; n2 < this.accessibleTextExtendedListenersSize(); ++n2) {
            accessibleTextListener = this.accessibleTextExtendedListeners.get(n2);
            accessibleTextListener.getSelection(accessibleTextEvent);
        }
        if (accessibleTextEvent.start == -1 && n == 0) {
            accessibleTextEvent.childID = -1;
            accessibleTextEvent.offset = -1;
            accessibleTextEvent.length = 0;
            for (n2 = 0; n2 < this.accessibleTextListenersSize(); ++n2) {
                accessibleTextListener = this.accessibleTextListeners.get(n2);
                accessibleTextListener.getSelectionRange(accessibleTextEvent);
            }
            accessibleTextEvent.start = accessibleTextEvent.offset;
            accessibleTextEvent.end = accessibleTextEvent.offset + accessibleTextEvent.length;
        }
        COM.MoveMemory(l, new int[]{accessibleTextEvent.start}, 4);
        COM.MoveMemory(l2, new int[]{accessibleTextEvent.end}, 4);
        if (accessibleTextEvent.start == -1) {
            return 1;
        }
        return 0;
    }

    int get_text(int n, int n2, long l) {
        int n3;
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.start = n == -1 ? this.getCharacterCount() : n;
        int n4 = accessibleTextEvent.end = n2 == -1 ? this.getCharacterCount() : n2;
        if (accessibleTextEvent.start > accessibleTextEvent.end) {
            n3 = accessibleTextEvent.start;
            accessibleTextEvent.start = accessibleTextEvent.end;
            accessibleTextEvent.end = n3;
        }
        accessibleTextEvent.count = 0;
        accessibleTextEvent.type = 5;
        for (n3 = 0; n3 < this.accessibleTextExtendedListenersSize(); ++n3) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(n3);
            accessibleTextExtendedListener.getText(accessibleTextEvent);
        }
        if (accessibleTextEvent.result == null) {
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = -1;
            for (int i = 0; i < this.accessibleControlListenersSize(); ++i) {
                AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(i);
                accessibleControlListener.getRole(accessibleControlEvent);
                accessibleControlListener.getValue(accessibleControlEvent);
            }
            if (accessibleControlEvent.detail == 42) {
                accessibleTextEvent.result = accessibleControlEvent.result;
            }
        }
        this.setString(l, accessibleTextEvent.result);
        if (accessibleTextEvent.result == null) {
            return -2147024809;
        }
        return 0;
    }

    int get_textBeforeOffset(int n, int n2, long l, long l2, long l3) {
        int n3;
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        int n4 = this.getCharacterCount();
        accessibleTextEvent.end = accessibleTextEvent.start = n == -1 ? n4 : (n == -2 ? this.getCaretOffset() : n);
        accessibleTextEvent.count = -1;
        switch (n2) {
            case 0: {
                accessibleTextEvent.type = 0;
                break;
            }
            case 1: {
                accessibleTextEvent.type = 1;
                break;
            }
            case 2: {
                accessibleTextEvent.type = 2;
                break;
            }
            case 3: {
                accessibleTextEvent.type = 3;
                break;
            }
            case 4: {
                accessibleTextEvent.type = 4;
                break;
            }
            default: {
                return -2147024809;
            }
        }
        int n5 = accessibleTextEvent.start;
        int n6 = accessibleTextEvent.end;
        for (n3 = 0; n3 < this.accessibleTextExtendedListenersSize(); ++n3) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(n3);
            accessibleTextExtendedListener.getText(accessibleTextEvent);
        }
        if (accessibleTextEvent.end < n4) {
            switch (n2) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    AccessibleTextExtendedListener accessibleTextExtendedListener;
                    int n7;
                    n3 = accessibleTextEvent.start;
                    accessibleTextEvent.start = n5;
                    accessibleTextEvent.end = n6;
                    accessibleTextEvent.count = 0;
                    for (n7 = 0; n7 < this.accessibleTextExtendedListenersSize(); ++n7) {
                        accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(n7);
                        accessibleTextExtendedListener.getText(accessibleTextEvent);
                    }
                    accessibleTextEvent.end = accessibleTextEvent.start;
                    accessibleTextEvent.start = n3;
                    accessibleTextEvent.type = 5;
                    accessibleTextEvent.count = 0;
                    for (n7 = 0; n7 < this.accessibleTextExtendedListenersSize(); ++n7) {
                        accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(n7);
                        accessibleTextExtendedListener.getText(accessibleTextEvent);
                    }
                    break;
                }
            }
        }
        COM.MoveMemory(l, new int[]{accessibleTextEvent.start}, 4);
        COM.MoveMemory(l2, new int[]{accessibleTextEvent.end}, 4);
        this.setString(l3, accessibleTextEvent.result);
        if (accessibleTextEvent.result == null) {
            return 1;
        }
        return 0;
    }

    int get_textAfterOffset(int n, int n2, long l, long l2, long l3) {
        int n3;
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        int n4 = this.getCharacterCount();
        accessibleTextEvent.end = accessibleTextEvent.start = n == -1 ? n4 : (n == -2 ? this.getCaretOffset() : n);
        accessibleTextEvent.count = 1;
        switch (n2) {
            case 0: {
                accessibleTextEvent.type = 0;
                break;
            }
            case 1: {
                accessibleTextEvent.type = 1;
                break;
            }
            case 2: {
                accessibleTextEvent.type = 2;
                break;
            }
            case 3: {
                accessibleTextEvent.type = 3;
                break;
            }
            case 4: {
                accessibleTextEvent.type = 4;
                break;
            }
            default: {
                return -2147024809;
            }
        }
        int n5 = accessibleTextEvent.start;
        int n6 = accessibleTextEvent.end;
        for (n3 = 0; n3 < this.accessibleTextExtendedListenersSize(); ++n3) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(n3);
            accessibleTextExtendedListener.getText(accessibleTextEvent);
        }
        if (accessibleTextEvent.end < n4) {
            switch (n2) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    AccessibleTextExtendedListener accessibleTextExtendedListener;
                    int n7;
                    n3 = accessibleTextEvent.start;
                    accessibleTextEvent.start = n5;
                    accessibleTextEvent.end = n6;
                    accessibleTextEvent.count = 2;
                    for (n7 = 0; n7 < this.accessibleTextExtendedListenersSize(); ++n7) {
                        accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(n7);
                        accessibleTextExtendedListener.getText(accessibleTextEvent);
                    }
                    accessibleTextEvent.end = accessibleTextEvent.start;
                    accessibleTextEvent.start = n3;
                    accessibleTextEvent.type = 5;
                    accessibleTextEvent.count = 0;
                    for (n7 = 0; n7 < this.accessibleTextExtendedListenersSize(); ++n7) {
                        accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(n7);
                        accessibleTextExtendedListener.getText(accessibleTextEvent);
                    }
                    break;
                }
            }
        }
        COM.MoveMemory(l, new int[]{accessibleTextEvent.start}, 4);
        COM.MoveMemory(l2, new int[]{accessibleTextEvent.end}, 4);
        this.setString(l3, accessibleTextEvent.result);
        if (accessibleTextEvent.result == null) {
            return 1;
        }
        return 0;
    }

    int get_textAtOffset(int n, int n2, long l, long l2, long l3) {
        int n3;
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        int n4 = this.getCharacterCount();
        accessibleTextEvent.end = accessibleTextEvent.start = n == -1 ? n4 : (n == -2 ? this.getCaretOffset() : n);
        accessibleTextEvent.count = 0;
        switch (n2) {
            case 0: {
                accessibleTextEvent.type = 0;
                break;
            }
            case 1: {
                accessibleTextEvent.type = 1;
                break;
            }
            case 2: {
                accessibleTextEvent.type = 2;
                break;
            }
            case 3: {
                accessibleTextEvent.type = 3;
                break;
            }
            case 4: {
                accessibleTextEvent.type = 4;
                break;
            }
            case 5: {
                accessibleTextEvent.type = 5;
                accessibleTextEvent.start = 0;
                accessibleTextEvent.end = n4;
                accessibleTextEvent.count = 0;
                break;
            }
            default: {
                return -2147024809;
            }
        }
        int n5 = accessibleTextEvent.start;
        int n6 = accessibleTextEvent.end;
        for (n3 = 0; n3 < this.accessibleTextExtendedListenersSize(); ++n3) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(n3);
            accessibleTextExtendedListener.getText(accessibleTextEvent);
        }
        if (accessibleTextEvent.end < n4) {
            switch (n2) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    AccessibleTextExtendedListener accessibleTextExtendedListener;
                    int n7;
                    n3 = accessibleTextEvent.start;
                    accessibleTextEvent.start = n5;
                    accessibleTextEvent.end = n6;
                    accessibleTextEvent.count = 1;
                    for (n7 = 0; n7 < this.accessibleTextExtendedListenersSize(); ++n7) {
                        accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(n7);
                        accessibleTextExtendedListener.getText(accessibleTextEvent);
                    }
                    accessibleTextEvent.end = accessibleTextEvent.start;
                    accessibleTextEvent.start = n3;
                    accessibleTextEvent.type = 5;
                    accessibleTextEvent.count = 0;
                    for (n7 = 0; n7 < this.accessibleTextExtendedListenersSize(); ++n7) {
                        accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(n7);
                        accessibleTextExtendedListener.getText(accessibleTextEvent);
                    }
                    break;
                }
            }
        }
        COM.MoveMemory(l, new int[]{accessibleTextEvent.start}, 4);
        COM.MoveMemory(l2, new int[]{accessibleTextEvent.end}, 4);
        this.setString(l3, accessibleTextEvent.result);
        if (accessibleTextEvent.result == null) {
            return 1;
        }
        return 0;
    }

    int removeSelection(int n) {
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.index = n;
        for (int i = 0; i < this.accessibleTextExtendedListenersSize(); ++i) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(i);
            accessibleTextExtendedListener.removeSelection(accessibleTextEvent);
        }
        if (accessibleTextEvent.result == null || !accessibleTextEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int setCaretOffset(int n) {
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.offset = n == -1 ? this.getCharacterCount() : n;
        for (int i = 0; i < this.accessibleTextExtendedListenersSize(); ++i) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(i);
            accessibleTextExtendedListener.setCaretOffset(accessibleTextEvent);
        }
        if (accessibleTextEvent.result == null || !accessibleTextEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int setSelection(int n, int n2, int n3) {
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.index = n;
        accessibleTextEvent.start = n2 == -1 ? this.getCharacterCount() : n2;
        accessibleTextEvent.end = n3 == -1 ? this.getCharacterCount() : n3;
        for (int i = 0; i < this.accessibleTextExtendedListenersSize(); ++i) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(i);
            accessibleTextExtendedListener.setSelection(accessibleTextEvent);
        }
        if (accessibleTextEvent.result == null || !accessibleTextEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int get_nCharacters(long l) {
        int n = this.getCharacterCount();
        COM.MoveMemory(l, new int[]{n}, 4);
        return 0;
    }

    int scrollSubstringTo(int n, int n2, int n3) {
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.start = n;
        accessibleTextEvent.end = n2;
        switch (n3) {
            case 0: {
                accessibleTextEvent.type = 0;
                break;
            }
            case 1: {
                accessibleTextEvent.type = 1;
                break;
            }
            case 2: {
                accessibleTextEvent.type = 2;
                break;
            }
            case 3: {
                accessibleTextEvent.type = 3;
                break;
            }
            case 4: {
                accessibleTextEvent.type = 4;
                break;
            }
            case 5: {
                accessibleTextEvent.type = 5;
                break;
            }
            case 6: {
                accessibleTextEvent.type = 6;
            }
        }
        for (int i = 0; i < this.accessibleTextExtendedListenersSize(); ++i) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(i);
            accessibleTextExtendedListener.scrollText(accessibleTextEvent);
        }
        if (accessibleTextEvent.result == null || !accessibleTextEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int scrollSubstringToPoint(int n, int n2, int n3, int n4, int n5) {
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.start = n;
        accessibleTextEvent.end = n2;
        accessibleTextEvent.type = 7;
        accessibleTextEvent.x = n4;
        accessibleTextEvent.y = n5;
        for (int i = 0; i < this.accessibleTextExtendedListenersSize(); ++i) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(i);
            accessibleTextExtendedListener.scrollText(accessibleTextEvent);
        }
        if (accessibleTextEvent.result == null || !accessibleTextEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int get_newText(long l) {
        String string = null;
        int n = 0;
        int n2 = 0;
        if (this.textInserted != null) {
            string = (String)this.textInserted[3];
            n = (Integer)this.textInserted[1];
            n2 = (Integer)this.textInserted[2];
        }
        this.setString(l, string);
        COM.MoveMemory(l + (long)OS.PTR_SIZEOF, new int[]{n}, 4);
        COM.MoveMemory(l + (long)OS.PTR_SIZEOF + 4L, new int[]{n2}, 4);
        if (this.textInserted == null) {
            return 1;
        }
        return 0;
    }

    int get_oldText(long l) {
        String string = null;
        int n = 0;
        int n2 = 0;
        if (this.textDeleted != null) {
            string = (String)this.textDeleted[3];
            n = (Integer)this.textDeleted[1];
            n2 = (Integer)this.textDeleted[2];
        }
        this.setString(l, string);
        COM.MoveMemory(l + (long)OS.PTR_SIZEOF, new int[]{n}, 4);
        COM.MoveMemory(l + (long)OS.PTR_SIZEOF + 4L, new int[]{n2}, 4);
        if (this.textDeleted == null) {
            return 1;
        }
        return 0;
    }

    int get_currentValue(long l) {
        AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(this);
        for (int i = 0; i < this.accessibleValueListenersSize(); ++i) {
            AccessibleValueListener accessibleValueListener = this.accessibleValueListeners.get(i);
            accessibleValueListener.getCurrentValue(accessibleValueEvent);
        }
        this.setNumberVARIANT(l, accessibleValueEvent.value);
        return 0;
    }

    int setCurrentValue(long l) {
        AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(this);
        accessibleValueEvent.value = this.getNumberVARIANT(l);
        for (int i = 0; i < this.accessibleValueListenersSize(); ++i) {
            AccessibleValueListener accessibleValueListener = this.accessibleValueListeners.get(i);
            accessibleValueListener.setCurrentValue(accessibleValueEvent);
        }
        return 0;
    }

    int get_maximumValue(long l) {
        AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(this);
        for (int i = 0; i < this.accessibleValueListenersSize(); ++i) {
            AccessibleValueListener accessibleValueListener = this.accessibleValueListeners.get(i);
            accessibleValueListener.getMaximumValue(accessibleValueEvent);
        }
        this.setNumberVARIANT(l, accessibleValueEvent.value);
        return 0;
    }

    int get_minimumValue(long l) {
        AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(this);
        for (int i = 0; i < this.accessibleValueListenersSize(); ++i) {
            AccessibleValueListener accessibleValueListener = this.accessibleValueListeners.get(i);
            accessibleValueListener.getMinimumValue(accessibleValueEvent);
        }
        this.setNumberVARIANT(l, accessibleValueEvent.value);
        return 0;
    }

    int eventChildID() {
        if (this.parent == null) {
            return 0;
        }
        if (this.uniqueID == -1) {
            this.uniqueID = UniqueID--;
        }
        return this.uniqueID;
    }

    void checkUniqueID(int n) {
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n;
        for (int i = 0; i < this.accessibleControlListenersSize(); ++i) {
            AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(i);
            accessibleControlListener.getChild(accessibleControlEvent);
        }
        Accessible accessible = accessibleControlEvent.accessible;
        if (accessible != null && accessible.uniqueID == -1) {
            accessible.uniqueID = n;
        }
    }

    int childIDToOs(int n) {
        if (n == -1) {
            return 0;
        }
        int n2 = n + 1;
        if (this.control instanceof Tree) {
            n2 = OS.COMCTL32_MAJOR < 6 ? n : (int)OS.SendMessage(this.control.handle, 4395, (long)n, 0L);
        }
        this.checkUniqueID(n2);
        return n2;
    }

    int osToChildID(int n) {
        if (n == 0) {
            return -1;
        }
        if (!(this.control instanceof Tree)) {
            return n - 1;
        }
        if (OS.COMCTL32_MAJOR < 6) {
            return n;
        }
        return (int)OS.SendMessage(this.control.handle, 4394, (long)n, 0L);
    }

    int stateToOs(int n) {
        int n2 = 0;
        if ((n & 2) != 0) {
            n2 |= 2;
        }
        if ((n & 0x200000) != 0) {
            n2 |= 0x200000;
        }
        if ((n & 0x1000000) != 0) {
            n2 |= 0x1000000;
        }
        if ((n & 4) != 0) {
            n2 |= 4;
        }
        if ((n & 0x100000) != 0) {
            n2 |= 0x100000;
        }
        if ((n & 8) != 0) {
            n2 |= 8;
        }
        if ((n & 0x10) != 0) {
            n2 |= 0x10;
        }
        if ((n & 0x200) != 0) {
            n2 |= 0x200;
        }
        if ((n & 0x400) != 0) {
            n2 |= 0x400;
        }
        if ((n & 0x80) != 0) {
            n2 |= 0x80;
        }
        if ((n & 0x800) != 0) {
            n2 |= 0x800;
        }
        if ((n & 0x40) != 0) {
            n2 |= 0x40;
        }
        if ((n & 0x8000) != 0) {
            n2 |= 0x8000;
        }
        if ((n & 0x10000) != 0) {
            n2 |= 0x10000;
        }
        if ((n & 0x20000) != 0) {
            n2 |= 0x20000;
        }
        if ((n & 0x400000) != 0) {
            n2 |= 0x400000;
        }
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        return n2;
    }

    int osToState(int n) {
        int n2 = 0;
        if ((n & 2) != 0) {
            n2 |= 2;
        }
        if ((n & 0x200000) != 0) {
            n2 |= 0x200000;
        }
        if ((n & 0x1000000) != 0) {
            n2 |= 0x1000000;
        }
        if ((n & 4) != 0) {
            n2 |= 4;
        }
        if ((n & 0x100000) != 0) {
            n2 |= 0x100000;
        }
        if ((n & 8) != 0) {
            n2 |= 8;
        }
        if ((n & 0x10) != 0) {
            n2 |= 0x10;
        }
        if ((n & 0x200) != 0) {
            n2 |= 0x200;
        }
        if ((n & 0x400) != 0) {
            n2 |= 0x400;
        }
        if ((n & 0x80) != 0) {
            n2 |= 0x80;
        }
        if ((n & 0x800) != 0) {
            n2 |= 0x800;
        }
        if ((n & 0x40) != 0) {
            n2 |= 0x40;
        }
        if ((n & 0x8000) != 0) {
            n2 |= 0x8000;
        }
        if ((n & 0x10000) != 0) {
            n2 |= 0x10000;
        }
        if ((n & 0x20000) != 0) {
            n2 |= 0x20000;
        }
        if ((n & 0x400000) != 0) {
            n2 |= 0x400000;
        }
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        return n2;
    }

    int roleToOs(int n) {
        switch (n) {
            case 10: {
                return 10;
            }
            case 9: {
                return 9;
            }
            case 2: {
                return 2;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 21: {
                return 21;
            }
            case 13: {
                return 13;
            }
            case 3: {
                return 3;
            }
            case 18: {
                return 18;
            }
            case 41: {
                return 41;
            }
            case 43: {
                return 43;
            }
            case 44: {
                return 44;
            }
            case 45: {
                return 45;
            }
            case 62: {
                return 62;
            }
            case 46: {
                return 46;
            }
            case 42: {
                return 42;
            }
            case 22: {
                return 22;
            }
            case 33: {
                return 33;
            }
            case 34: {
                return 34;
            }
            case 24: {
                return 24;
            }
            case 29: {
                return 29;
            }
            case 25: {
                return 25;
            }
            case 26: {
                return 26;
            }
            case 35: {
                return 35;
            }
            case 36: {
                return 36;
            }
            case 60: {
                return 60;
            }
            case 37: {
                return 37;
            }
            case 48: {
                return 48;
            }
            case 51: {
                return 51;
            }
            case 30: {
                return 30;
            }
            case 8: {
                return 8;
            }
            case 54: {
                return 54;
            }
            case 27: {
                return 27;
            }
            case 15: {
                return 15;
            }
            case 40: {
                return 40;
            }
            case 20: {
                return 20;
            }
            case 28: {
                return 28;
            }
            case 52: {
                return 52;
            }
            case 23: {
                return 23;
            }
            case 61: {
                return 61;
            }
            case 47: {
                return 47;
            }
            case 1025: {
                return 10;
            }
            case 1027: {
                return 12;
            }
            case 1073: {
                return 12;
            }
            case 1029: {
                return 47;
            }
            case 1038: {
                return 10;
            }
            case 1040: {
                return 10;
            }
            case 1043: {
                return 10;
            }
            case 1044: {
                return 10;
            }
            case 1053: {
                return 10;
            }
            case 1054: {
                return 10;
            }
            case 1060: {
                return 10;
            }
        }
        return 10;
    }

    int osToRole(int n) {
        switch (n) {
            case 10: {
                return 10;
            }
            case 9: {
                return 9;
            }
            case 2: {
                return 2;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 21: {
                return 21;
            }
            case 13: {
                return 13;
            }
            case 3: {
                return 3;
            }
            case 18: {
                return 18;
            }
            case 41: {
                return 41;
            }
            case 43: {
                return 43;
            }
            case 44: {
                return 44;
            }
            case 45: {
                return 45;
            }
            case 62: {
                return 62;
            }
            case 46: {
                return 46;
            }
            case 42: {
                return 42;
            }
            case 22: {
                return 22;
            }
            case 33: {
                return 33;
            }
            case 34: {
                return 34;
            }
            case 24: {
                return 24;
            }
            case 29: {
                return 29;
            }
            case 25: {
                return 25;
            }
            case 26: {
                return 26;
            }
            case 35: {
                return 35;
            }
            case 36: {
                return 36;
            }
            case 60: {
                return 60;
            }
            case 37: {
                return 37;
            }
            case 48: {
                return 48;
            }
            case 51: {
                return 51;
            }
            case 30: {
                return 30;
            }
            case 8: {
                return 8;
            }
            case 54: {
                return 54;
            }
            case 27: {
                return 27;
            }
            case 15: {
                return 15;
            }
            case 40: {
                return 40;
            }
            case 20: {
                return 20;
            }
            case 28: {
                return 28;
            }
            case 52: {
                return 52;
            }
            case 23: {
                return 23;
            }
            case 61: {
                return 61;
            }
            case 47: {
                return 47;
            }
        }
        return 10;
    }

    Color colorFromString(String string) {
        try {
            int n = string.indexOf(40);
            int n2 = string.indexOf(44);
            int n3 = string.indexOf(44, n2 + 1);
            int n4 = string.indexOf(41);
            int n5 = Integer.parseInt(string.substring(n + 1, n2));
            int n6 = Integer.parseInt(string.substring(n2 + 1, n3));
            int n7 = Integer.parseInt(string.substring(n3 + 1, n4));
            return new Color(this.control.getDisplay(), n5, n6, n7);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    int getCaretOffset() {
        AccessibleTextListener accessibleTextListener;
        int n;
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.offset = -1;
        for (n = 0; n < this.accessibleTextExtendedListenersSize(); ++n) {
            accessibleTextListener = this.accessibleTextExtendedListeners.get(n);
            accessibleTextListener.getCaretOffset(accessibleTextEvent);
        }
        if (accessibleTextEvent.offset == -1) {
            for (n = 0; n < this.accessibleTextListenersSize(); ++n) {
                accessibleTextEvent.childID = -1;
                accessibleTextListener = this.accessibleTextListeners.get(n);
                accessibleTextListener.getCaretOffset(accessibleTextEvent);
            }
        }
        return accessibleTextEvent.offset;
    }

    int getCharacterCount() {
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.count = -1;
        for (int i = 0; i < this.accessibleTextExtendedListenersSize(); ++i) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = this.accessibleTextExtendedListeners.get(i);
            accessibleTextExtendedListener.getCharacterCount(accessibleTextEvent);
        }
        if (accessibleTextEvent.count == -1) {
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = -1;
            for (int i = 0; i < this.accessibleControlListenersSize(); ++i) {
                AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(i);
                accessibleControlListener.getRole(accessibleControlEvent);
                accessibleControlListener.getValue(accessibleControlEvent);
            }
            accessibleTextEvent.count = accessibleControlEvent.detail == 42 && accessibleControlEvent.result != null ? accessibleControlEvent.result.length() : 0;
        }
        return accessibleTextEvent.count;
    }

    int getRelationCount() {
        int n = 0;
        for (int i = 0; i < 15; ++i) {
            if (this.relations[i] == null) continue;
            ++n;
        }
        return n;
    }

    int getRole() {
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = -1;
        for (int i = 0; i < this.accessibleControlListenersSize(); ++i) {
            AccessibleControlListener accessibleControlListener = this.accessibleControlListeners.get(i);
            accessibleControlListener.getRole(accessibleControlEvent);
        }
        return accessibleControlEvent.detail;
    }

    int getDefaultRole() {
        int n = 10;
        if (this.iaccessible != null) {
            long l = OS.GlobalAlloc(64, VARIANT.sizeof);
            this.setIntVARIANT(l, (short)3, 0);
            long l2 = OS.GlobalAlloc(64, VARIANT.sizeof);
            int n2 = this.iaccessible.get_accRole(l, l2);
            if (n2 == 0) {
                VARIANT vARIANT = this.getVARIANT(l2);
                if (vARIANT.vt == 3) {
                    n = vARIANT.lVal;
                }
            }
            OS.GlobalFree(l);
            OS.GlobalFree(l2);
        }
        return n;
    }

    String getString(long l) {
        long[] lArray = new long[1];
        OS.MoveMemory(lArray, l, OS.PTR_SIZEOF);
        int n = COM.SysStringByteLen(lArray[0]);
        if (n == 0) {
            return "";
        }
        char[] cArray = new char[(n + 1) / 2];
        OS.MoveMemory(cArray, lArray[0], n);
        return new String(cArray);
    }

    VARIANT getVARIANT(long l) {
        VARIANT vARIANT = new VARIANT();
        COM.MoveMemory(vARIANT, l, VARIANT.sizeof);
        return vARIANT;
    }

    Number getNumberVARIANT(long l) {
        VARIANT vARIANT = new VARIANT();
        COM.MoveMemory(vARIANT, l, VARIANT.sizeof);
        if (vARIANT.vt == 20) {
            return new Long(vARIANT.lVal);
        }
        return vARIANT.lVal;
    }

    void setIntVARIANT(long l, short s, int n) {
        if (s == 3 || s == 0) {
            COM.MoveMemory(l, new short[]{s}, 2);
            COM.MoveMemory(l + 8L, new int[]{n}, 4);
        }
    }

    void setPtrVARIANT(long l, short s, long l2) {
        if (s == 9 || s == 13) {
            COM.MoveMemory(l, new short[]{s}, 2);
            COM.MoveMemory(l + 8L, new long[]{l2}, OS.PTR_SIZEOF);
        }
    }

    void setNumberVARIANT(long l, Number number) {
        if (number == null) {
            COM.MoveMemory(l, new short[]{0}, 2);
            COM.MoveMemory(l + 8L, new int[]{0}, 4);
        } else if (number instanceof Double) {
            COM.MoveMemory(l, new short[]{5}, 2);
            COM.MoveMemory(l + 8L, new double[]{number.doubleValue()}, 8);
        } else if (number instanceof Float) {
            COM.MoveMemory(l, new short[]{4}, 2);
            COM.MoveMemory(l + 8L, new float[]{number.floatValue()}, 4);
        } else if (number instanceof Long) {
            COM.MoveMemory(l, new short[]{20}, 2);
            COM.MoveMemory(l + 8L, new long[]{number.longValue()}, 8);
        } else {
            COM.MoveMemory(l, new short[]{3}, 2);
            COM.MoveMemory(l + 8L, new int[]{number.intValue()}, 4);
        }
    }

    void setString(long l, String string) {
        long l2 = 0L;
        if (string != null) {
            char[] cArray = (string + "\u0000").toCharArray();
            l2 = COM.SysAllocString(cArray);
        }
        COM.MoveMemory(l, new long[]{l2}, OS.PTR_SIZEOF);
    }

    void setStringVARIANT(long l, String string) {
        long l2 = 0L;
        if (string != null) {
            char[] cArray = (string + "\u0000").toCharArray();
            l2 = COM.SysAllocString(cArray);
        }
        COM.MoveMemory(l, new short[]{l2 == 0L ? (short)0 : 8}, 2);
        COM.MoveMemory(l + 8L, new long[]{l2}, OS.PTR_SIZEOF);
    }

    void checkWidget() {
        if (!this.isValidThread()) {
            SWT.error(22);
        }
        if (this.control.isDisposed()) {
            SWT.error(24);
        }
    }

    boolean isATRunning() {
        return true;
    }

    boolean isValidThread() {
        return this.control.getDisplay().getThread() == Thread.currentThread();
    }

    static void print(String string) {
    }

    String getRoleString(int n) {
        return "Unknown role (" + n + ")";
    }

    String getStateString(int n) {
        if (n == 0) {
            return " no state bits set";
        }
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    String getIA2StatesString(int n) {
        if (n == 0) {
            return " no state bits set";
        }
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    String getEventString(int n) {
        return "Unknown event (" + n + ")";
    }

    private String hresult(int n) {
        return " HRESULT=" + n;
    }

    boolean interesting(GUID gUID) {
        return false;
    }

    String guidString(GUID gUID) {
        return gUID.toString();
    }

    static GUID IIDFromString(String string) {
        return null;
    }

    public String toString() {
        String string = super.toString();
        return string;
    }

    static {
        String string = System.getProperty(PROPERTY_USEIA2);
        if (string != null && string.equalsIgnoreCase("false")) {
            UseIA2 = false;
        }
    }
}

