/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.util.Collections;
import java.util.List;
import org.dbgl.db.Database;
import org.dbgl.gui.EditProfileDialog;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.GeneralPurposeGUI;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.interfaces.Configurable;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.util.searchengine.SearchEngineThread;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

public class EditMultiProfileDialog
extends EditProfileDialog {
    private Label profileLabel;
    private ProgressBar progressBar;
    private Text logText;
    private static final int AMOUNT_OF_THREADS = 4;
    private Thread[] mbt = new Thread[4];
    private List<Configurable> profs;
    private WebSearchEngine engine;

    public EditMultiProfileDialog(Shell shell) {
        super(shell);
    }

    public void setData(List<Configurable> list, WebSearchEngine webSearchEngine) {
        this.profs = list;
        this.engine = webSearchEngine;
    }

    @Override
    public Object open() {
        this.settings = Settings.getInstance();
        this.dbase = Database.getInstance();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            boolean bl = true;
            if (this.mbt != null) {
                for (int i = 0; i < 4; ++i) {
                    bl &= this.mbt[i] != null && !this.mbt[i].isAlive();
                }
            }
            if (bl) {
                if (this.logText.getCharCount() > 0 && !this.cancelButton.getText().equals(this.settings.msg("button.finish"))) {
                    GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.multiprofile.reviewlog"));
                    this.profileLabel.setText(this.settings.msg("dialog.multiprofile.reviewlog"));
                    this.profileLabel.pack();
                    this.cancelButton.setText(this.settings.msg("button.finish"));
                    this.shell.setDefaultButton(this.cancelButton);
                    this.progressBar.setSelection(this.progressBar.getMaximum());
                    this.mbt = new Thread[4];
                } else {
                    this.shell.close();
                }
            }
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    @Override
    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "multiprofiledialog"));
        this.shell.setText(this.settings.msg("dialog.multiprofile.title.edit", new Object[]{this.profs.size()}));
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        this.createGeneralTab(tabFolder);
        this.createOkCancelButtons();
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditMultiProfileDialog.this.okButton.setEnabled(false);
                EditMultiProfileDialog.this.cancelButton.setEnabled(false);
                int n = EditMultiProfileDialog.this.profs.size();
                if (EditMultiProfileDialog.this.engine != null) {
                    n += EditMultiProfileDialog.this.profs.size();
                }
                EditMultiProfileDialog.this.progressBar.setMaximum(n);
                int n2 = 0;
                for (Configurable configurable : EditMultiProfileDialog.this.profs) {
                    ExpProfile expProfile = (ExpProfile)configurable;
                    StringBuffer stringBuffer = new StringBuffer();
                    EditMultiProfileDialog.this.profileLabel.setText(Settings.getInstance().msg("dialog.multiprofile.updating", new Object[]{expProfile.getTitle()}));
                    EditMultiProfileDialog.this.profileLabel.pack();
                    try {
                        expProfile.getConf().injectOrUpdateProfile(expProfile);
                        expProfile.getConf().save();
                        EditMultiProfileDialog.this.dbase.addOrEditProfile(expProfile.getTitle(), expProfile.getDeveloperName(), expProfile.getPublisherName(), expProfile.getGenre(), expProfile.getYear(), expProfile.getStatus(), expProfile.getNotes(), expProfile.isDefault(), expProfile.getSetup(), expProfile.getSetupParameters(), expProfile.getDbversionId(), expProfile.getLinks(), expProfile.getLinkTitles(), expProfile.getCustomStrings(), expProfile.getCustomInts(), expProfile.getId());
                    }
                    catch (Exception exception) {
                        stringBuffer.append(StringRelatedUtils.toString(exception));
                    }
                    if (stringBuffer.length() > 0) {
                        EditMultiProfileDialog.this.logText.append(stringBuffer.append('\n').toString());
                    }
                    EditMultiProfileDialog.this.progressBar.setSelection(++n2);
                }
                final List list = Collections.synchronizedList(EditMultiProfileDialog.this.profs);
                EditMultiProfileDialog.this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        list.clear();
                        EditMultiProfileDialog.access$502(EditMultiProfileDialog.this, null);
                    }
                });
                EditMultiProfileDialog.this.cancelButton.setEnabled(true);
                EditMultiProfileDialog.this.result = "";
                if (EditMultiProfileDialog.this.engine != null) {
                    for (int i = 0; i < 4; ++i) {
                        ((EditMultiProfileDialog)EditMultiProfileDialog.this).mbt[i] = new SearchEngineThread(EditMultiProfileDialog.this.engine, list, EditMultiProfileDialog.this.logText, EditMultiProfileDialog.this.progressBar, EditMultiProfileDialog.this.profileLabel);
                        EditMultiProfileDialog.this.mbt[i].start();
                    }
                } else {
                    EditMultiProfileDialog.access$502(EditMultiProfileDialog.this, null);
                }
            }
        });
    }

    @Override
    protected void createGeneralTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(this.settings.msg("dialog.template.tab.general"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout());
        tabItem.setControl((Control)composite);
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(this.settings.msg("dialog.dfendimport.progress"));
        group.setLayout((Layout)new GridLayout());
        this.progressBar = new ProgressBar((Composite)group, 0);
        this.progressBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.profileLabel = new Label((Composite)group, 0);
        this.logText = new Text((Composite)group, 2826);
        this.logText.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    @Override
    protected void createOkCancelButtons() {
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayout((Layout)new GridLayout(2, true));
        composite.setLayoutData((Object)"South");
        this.okButton = new Button(composite, 0);
        this.shell.setDefaultButton(this.okButton);
        this.okButton.setText(this.settings.msg("button.ok"));
        this.cancelButton = new Button(composite, 0);
        this.cancelButton.setText(this.settings.msg("button.cancel"));
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (EditMultiProfileDialog.this.result == null) {
                    EditMultiProfileDialog.this.shell.close();
                }
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = GeneralPurposeGUI.getWidth(this.okButton, this.cancelButton);
        this.okButton.setLayoutData((Object)gridData);
        this.cancelButton.setLayoutData((Object)gridData);
    }

    static /* synthetic */ Thread[] access$502(EditMultiProfileDialog editMultiProfileDialog, Thread[] threadArray) {
        editMultiProfileDialog.mbt = threadArray;
        return threadArray;
    }
}

