/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.connect.Messaging;
import org.dbgl.db.Database;
import org.dbgl.gui.AboutDialog;
import org.dbgl.gui.AddGameWizardDialog;
import org.dbgl.gui.DFendImportDialog;
import org.dbgl.gui.DeleteProfilesDialog;
import org.dbgl.gui.EditDosboxVersionDialog;
import org.dbgl.gui.EditFilterDialog;
import org.dbgl.gui.EditProfileDialog;
import org.dbgl.gui.EditTemplateDialog;
import org.dbgl.gui.ExportDialog;
import org.dbgl.gui.ExportListDialog;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.GeneralPurposeGUI;
import org.dbgl.gui.ImportDialog;
import org.dbgl.gui.LogDialog;
import org.dbgl.gui.MigrateDialog;
import org.dbgl.gui.ProfileLoader;
import org.dbgl.gui.ProfilesList;
import org.dbgl.gui.SettingsDialog;
import org.dbgl.gui.Thumb;
import org.dbgl.interfaces.ReOrderable;
import org.dbgl.model.Constants;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpTemplate;
import org.dbgl.model.Filter;
import org.dbgl.model.KeyTitleDefault;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.OrderingVector;
import org.dbgl.model.Profile;
import org.dbgl.model.SearchResult;
import org.dbgl.model.Template;
import org.dbgl.model.ThumbInfo;
import org.dbgl.model.ViewType;
import org.dbgl.model.conf.Conf;
import org.dbgl.model.conf.SectionsWrapper;
import org.dbgl.model.conf.Settings;
import org.dbgl.swtdesigner.SWTImageManager;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.util.XmlUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import swing2swt.layout.BorderLayout;

public final class MainWindow
implements ReOrderable {
    private static final String[] ICOS_DBGL = new String[]{"ico/016.png", "ico/024.png", "ico/032.png", "ico/048.png", "ico/064.png", "ico/128.png", "ico/256.png"};
    static String[] columnNames;
    private Display display;
    private Shell shell;
    private OrderingVector orderingVector = null;
    private String filterClause = null;
    private List<Profile> profilesList;
    private List<DosboxVersion> dbversionsList;
    private List<Template> templatesList;
    private List<Filter> filtersList;
    private Database dbase = null;
    private Settings settings = null;
    private SectionsWrapper ssettings = null;
    private File currentThumbFile = null;
    private int thumbHeight;
    private ToolItem displayNotes;
    private ToolItem displayScreenshots;
    private int[] columnIds;
    private ProfilesList profile_table;
    private Table dbversion_table;
    private Table template_table;
    private CTabFolder filterFolder;
    private ToolItem setupToolItem;
    private ToolItem viewSelector;
    private Text notesField;
    private Composite thumbsToolBar;
    private Menu menu_thumb;
    private Link[] link;
    private Menu viewProfileSubMenu;
    private Menu viewDosboxSubMenu;
    private Menu viewTemplateSubMenu;
    private final SelectionAdapter addProfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MainWindow.this.doAddProfile();
        }
    };
    private final SelectionAdapter editProfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MainWindow.this.doEditProfile();
        }
    };
    private final SelectionAdapter removeProfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MainWindow.this.doRemoveProfile();
        }
    };
    private final SelectionAdapter setupProfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MainWindow.this.doRunProfile(0, false);
        }
    };
    private final SelectionAdapter addWizardAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MainWindow.this.doStartGameWizard();
        }
    };
    private final SelectionAdapter runProfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MainWindow.this.doRunProfile(-1, false);
        }
    };
    private final SelectionAdapter prepareProfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MainWindow.this.doRunProfile(-1, true);
        }
    };
    private final SelectionAdapter selectProfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MainWindow.this.displayProfileInformation(false);
        }
    };
    private final SelectionAdapter duplicateProfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MainWindow.this.doDuplicateProfile();
        }
    };
    private final SelectionAdapter toggleProfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MainWindow.this.doToggleFavoriteProfile();
        }
    };
    private final SelectionAdapter shortcutProfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MainWindow.this.doCreateShortcut();
        }
    };
    private final SelectionAdapter openProfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            int n = MainWindow.this.profile_table.getSelectionIndex();
            if (n != -1) {
                Profile profile = (Profile)MainWindow.this.profilesList.get(n);
                try {
                    Conf conf = new Conf(profile, (DosboxVersion)DosboxVersion.findById(MainWindow.this.dbversionsList, profile.getDbversionId()), System.err);
                    PlatformUtils.openDirForViewing(conf.getAutoexec().getCanonicalMainDir());
                }
                catch (IOException iOException) {
                    GeneralPurposeDialogs.warningMessage(MainWindow.this.shell, iOException);
                }
            }
        }
    };
    private final SelectionAdapter openCapturesAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            int n = MainWindow.this.profile_table.getSelectionIndex();
            if (n != -1) {
                Profile profile = (Profile)MainWindow.this.profilesList.get(n);
                PlatformUtils.openDirForViewing(profile.getCanonicalCaptures());
            }
        }
    };
    private final MouseAdapter mouseAdapter = new MouseAdapter(){

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            MainWindow.this.doRunProfile(-1, false);
        }
    };
    private final MouseAdapter filterMouseAdapter = new MouseAdapter(){

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            MainWindow.this.doEditFilter();
        }
    };
    private final KeyAdapter keyAdapter = new KeyAdapter(){

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.keyCode == 127 || keyEvent.stateMask == SWT.MOD1 && Character.toLowerCase(keyEvent.keyCode) == 114) {
                MainWindow.this.doRemoveProfile();
            } else if (keyEvent.keyCode == 0x1000009 || keyEvent.stateMask == SWT.MOD1 && Character.toLowerCase(keyEvent.keyCode) == 110) {
                MainWindow.this.doAddProfile();
            } else if (keyEvent.keyCode == 0x100000B) {
                MainWindow.this.doEditProfile(true);
            } else if (keyEvent.stateMask == SWT.MOD1 && Character.toLowerCase(keyEvent.keyCode) == 109) {
                MainWindow.this.doToggleFavoriteProfile();
            } else if (keyEvent.stateMask == SWT.MOD1 && Character.toLowerCase(keyEvent.keyCode) == 100) {
                MainWindow.this.doDuplicateProfile();
            } else if (keyEvent.stateMask == SWT.MOD1 && Character.toLowerCase(keyEvent.keyCode) == 97) {
                MainWindow.this.profile_table.selectAll();
            } else if (keyEvent.stateMask == SWT.MOD1 && Character.toLowerCase(keyEvent.keyCode) == 102) {
                MainWindow.this.doAddFilter();
            } else if (keyEvent.stateMask == SWT.MOD1 && Character.toLowerCase(keyEvent.keyCode) == 99) {
                MainWindow.this.doViewProfileConf();
            } else if (keyEvent.stateMask == SWT.MOD1 && Character.toLowerCase(keyEvent.keyCode) == 119) {
                MainWindow.this.doStartGameWizard();
            }
        }
    };
    private final TraverseListener travListener = new TraverseListener(){

        public void keyTraversed(TraverseEvent traverseEvent) {
            if (traverseEvent.stateMask == SWT.MOD1 && traverseEvent.detail == 4) {
                MainWindow.this.doEditProfile();
            } else if (traverseEvent.stateMask == 131072 && traverseEvent.detail == 4) {
                MainWindow.this.doRunProfile(0, false);
            } else if (traverseEvent.detail == 4) {
                MainWindow.this.doRunProfile(-1, false);
            }
        }
    };
    private final SelectionAdapter dfendAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MainWindow.this.doDFendImport();
        }
    };
    private final SelectionAdapter migrateAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MainWindow.this.doMigrate();
        }
    };
    private final SelectionAdapter locateDosboxAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MainWindow.this.doLocateDosbox(true);
        }
    };
    private final SelectionAdapter exportListAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MainWindow.this.doExportProfilesList();
        }
    };
    private final SelectionAdapter importConfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MainWindow.this.doImportConfigfile();
        }
    };
    private final SelectionAdapter exportTemplatesAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MainWindow.this.doExportTemplates();
        }
    };
    private final SelectionAdapter importDefaultTemplatesAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MainWindow.this.doImportDefaultTemplates(true);
        }
    };
    private final SelectionAdapter exportAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MainWindow.this.doExportProfiles();
        }
    };
    private final SelectionAdapter importAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MainWindow.this.doImportProfiles();
        }
    };
    private final SelectionAdapter cleanupAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            try {
                if (GeneralPurposeDialogs.confirmMessage(MainWindow.this.shell, MainWindow.this.settings.msg("dialog.main.confirm.databasecleanup"))) {
                    int n = MainWindow.this.dbase.cleanup();
                    GeneralPurposeDialogs.infoMessage(MainWindow.this.shell, MainWindow.this.settings.msg("dialog.main.notice.databasecleanupok", new Object[]{n}));
                }
            }
            catch (SQLException sQLException) {
                GeneralPurposeDialogs.warningMessage(MainWindow.this.shell, sQLException);
            }
        }
    };
    private final SelectionAdapter settingsAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MainWindow.this.doOpenSettingsDialog();
        }
    };
    private final SelectionAdapter logAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MainWindow.this.doOpenLogDialog();
        }
    };
    private final SelectionAdapter exitAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MainWindow.this.shell.close();
        }
    };
    private final SelectionAdapter addFilterAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MainWindow.this.doAddFilter();
        }
    };
    private final SelectionAdapter editFilterAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MainWindow.this.doEditFilter();
        }
    };
    private final SelectionAdapter openAboutAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MainWindow.this.doOpenAbout();
        }
    };

    public void open() {
        this.dbase = Database.getInstance();
        this.settings = Settings.getInstance();
        this.ssettings = this.settings.getSettings();
        if (PlatformUtils.IS_OSX) {
            Display.setAppName((String)"DBGL");
            Display.setAppVersion((String)Constants.PROGRAM_VERSION);
        }
        this.display = Display.getDefault();
        this.createContents();
        if (Database.isInitializedNewDatabase()) {
            this.doLocateDosbox(false);
            if (this.dbversionsList.size() > 0) {
                this.doImportDefaultTemplates(false);
            }
        }
        Messaging messaging = null;
        if (this.ssettings.getBooleanValue("communication", "port_enabled")) {
            messaging = new Messaging(this.ssettings.getIntValue("communication", "port"), this);
            messaging.start();
        }
        this.shell.open();
        this.shell.layout();
        this.profile_table.setSelection(this.ssettings.getIntValue("gui", "selectedprofile"));
        this.displayProfileInformation(false);
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        SWTImageManager.dispose();
        this.display.dispose();
        if (messaging != null) {
            messaging.close();
        }
        try {
            this.settings.save();
        }
        catch (IOException iOException) {
            GeneralPurposeDialogs.warningMessage(this.shell, iOException);
        }
        try {
            this.dbase.shutdown();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void createContents() {
        TabFolder tabFolder;
        this.initColumnIds();
        this.orderingVector = new OrderingVector(this.ssettings.getIntValues("gui", "sortcolumn"), this.ssettings.getBooleanValues("gui", "sortascending"));
        this.shell = new Shell();
        this.shell.setImages(SWTImageManager.getResourceImages(this.display, ICOS_DBGL));
        try {
            tabFolder = this.dbase.findInvalidProfiles();
            if (tabFolder.size() > 0) {
                Iterator<KeyTitleDefault> iterator = new ArrayList<String>();
                for (Profile profile : tabFolder) {
                    iterator.add((KeyTitleDefault)((Object)profile.getTitle()));
                }
                if (GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.main.confirm.removeinvalidprofiles", new Object[]{tabFolder.size(), StringUtils.join(iterator, (String)", ")}))) {
                    for (Profile profile : tabFolder) {
                        this.dbase.removeProfile(profile);
                    }
                }
            }
            this.dbversionsList = this.dbase.readDosboxVersionsList();
            this.templatesList = this.dbase.readTemplatesList();
            this.filtersList = this.dbase.readFiltersList();
            this.filtersList.add(0, new Filter(-1, this.settings.msg("dialog.main.allprofiles"), null));
            this.filterClause = this.filtersList.get(this.ssettings.getIntValue("gui", "filtertab")).getFilter();
            this.profilesList = this.dbase.readProfilesList(this.orderingVector.toClause(), this.filterClause);
        }
        catch (SQLException sQLException) {
            GeneralPurposeDialogs.warningMessage(this.shell, sQLException);
        }
        this.shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                boolean bl = MainWindow.this.shell.getMaximized();
                if (!bl) {
                    Rectangle rectangle = MainWindow.this.shell.getBounds();
                    MainWindow.this.ssettings.setIntValue("gui", "width", rectangle.width);
                    MainWindow.this.ssettings.setIntValue("gui", "height", rectangle.height);
                    MainWindow.this.ssettings.setIntValue("gui", "x", rectangle.x);
                    MainWindow.this.ssettings.setIntValue("gui", "y", rectangle.y);
                }
                MainWindow.this.ssettings.setBooleanValue("gui", "maximized", bl);
            }
        });
        this.shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent controlEvent) {
                if (!MainWindow.this.shell.getMaximized()) {
                    Rectangle rectangle = MainWindow.this.shell.getBounds();
                    MainWindow.this.ssettings.setIntValue("gui", "x", rectangle.x);
                    MainWindow.this.ssettings.setIntValue("gui", "y", rectangle.y);
                }
            }
        });
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.setLocation(this.ssettings.getIntValue("gui", "x"), this.ssettings.getIntValue("gui", "y"));
        if (this.ssettings.getBooleanValue("gui", "maximized")) {
            this.shell.setMaximized(true);
        } else {
            this.shell.setSize(this.ssettings.getIntValue("gui", "width"), this.ssettings.getIntValue("gui", "height"));
        }
        this.shell.setText(this.settings.msg("main.title", new Object[]{Constants.PROGRAM_VERSION}));
        this.createFileMenu();
        tabFolder = new TabFolder((Composite)this.shell, 0);
        this.createProfilesTab(tabFolder);
        this.createDosboxVersionsTab(tabFolder);
        this.createTemplatesTab(tabFolder);
        this.shell.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                if (tabFolder.getSelectionIndex() == 0) {
                    MainWindow.this.profile_table.setFocus();
                    MainWindow.this.displayProfileInformation(true);
                }
            }
        });
        for (Profile profile : this.profilesList) {
            this.addProfileToTable(profile);
        }
        for (DosboxVersion dosboxVersion : this.dbversionsList) {
            this.addDosboxVersionToTable(dosboxVersion);
        }
        for (Template template : this.templatesList) {
            this.addTemplateToTable(template);
        }
        this.profile_table.setFocus();
    }

    @Override
    public void doReorder(int n, int n2) {
        Set<Integer> set = this.getSelectedProfileIds();
        try {
            this.orderingVector.addOrdering(this.columnIds[n], n2 == 128);
            this.profilesList = this.dbase.readProfilesList(this.orderingVector.toClause(), this.filterClause);
        }
        catch (SQLException sQLException) {
            GeneralPurposeDialogs.warningMessage(this.shell, sQLException);
        }
        for (int i = 0; i < this.profilesList.size(); ++i) {
            this.setTableItem(this.profile_table.getItem(i), this.profilesList.get(i));
        }
        this.profile_table.setSelection(this.getIndicesByIds(set));
        this.ssettings.setIntValues("gui", "sortcolumn", this.orderingVector.getColumns());
        this.ssettings.setBooleanValues("gui", "sortascending", this.orderingVector.getAscendings());
    }

    private void displayLinks(String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < this.link.length; ++i) {
            if (stringArray[i] == null || "".equals(stringArray[i])) {
                this.link[i].setText("");
                this.link[i].setToolTipText(null);
                ((GridData)this.link[i].getLayoutData()).exclude = true;
                this.link[i].pack();
                continue;
            }
            String string = stringArray[i];
            String string2 = stringArray[i];
            if (string.indexOf("://") == -1) {
                string = "file://" + FileUtils.canonicalToData(string).getPath();
                string2 = FileUtils.makeRelativeToDosroot(FileUtils.canonicalToData(string2)).getPath();
            }
            if (stringArray2[i] != null && !"".equals(stringArray2[i])) {
                string2 = stringArray2[i];
            }
            StringBuffer stringBuffer = new StringBuffer("<a href=\"").append(string).append("\">").append(string2).append("</a>");
            this.link[i].setText(stringBuffer.toString());
            this.link[i].setToolTipText(string);
            ((GridData)this.link[i].getLayoutData()).exclude = false;
        }
        this.link[0].getParent().layout();
        this.link[0].getParent().getParent().layout();
    }

    private void displayScreenshots(Profile profile, ProfilesList.ProfilesListItem profilesListItem, boolean bl) {
        for (Control control : this.thumbsToolBar.getChildren()) {
            control.setMenu(null);
            control.dispose();
        }
        this.thumbsToolBar.pack();
        if (profile != null) {
            File[] fileArray;
            ThumbInfo thumbInfo = (ThumbInfo)profilesListItem.getData();
            if (bl) {
                thumbInfo.resetCachedInfo();
            }
            for (File file : fileArray = thumbInfo.getAllThumbs()) {
                String string = file.getName().toLowerCase();
                string = this.ssettings.getBooleanValue("gui", "screenshotsfilename") ? ' ' + string.substring(0, string.lastIndexOf(46)) + ' ' : null;
                final Button button = new Button(this.thumbsToolBar, 0x800000);
                button.setToolTipText(file.getPath());
                button.setImage(SWTImageManager.getResizedImage(this.display, this.thumbHeight, file.getPath(), string));
                button.pack();
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        Thumb thumb = new Thumb(MainWindow.this.shell);
                        thumb.setThumb(button.getToolTipText());
                        thumb.open();
                    }
                });
                button.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDown(MouseEvent mouseEvent) {
                        MainWindow.this.currentThumbFile = new File(button.getToolTipText());
                    }
                });
                button.setMenu(this.menu_thumb);
            }
            if (!bl && thumbInfo.isUpdated()) {
                profilesListItem.setData(thumbInfo);
            }
        }
        this.thumbsToolBar.setVisible(this.thumbsToolBar.getChildren().length != 0);
        this.thumbsToolBar.pack();
    }

    private void doAddProfile() {
        this.doAddProfile(null);
    }

    private void doAddProfile(String string) {
        if (this.checkDefaultDBVersion() == null) {
            return;
        }
        if (string == null || FileUtils.isBooterImage(string) || FileUtils.isExecutable(string) || FileUtils.isConfFile(string)) {
            Object object;
            EditProfileDialog editProfileDialog = new EditProfileDialog(this.shell);
            if (string != null) {
                editProfileDialog.sendToProfile(string);
            }
            if ((object = editProfileDialog.open()) instanceof Profile) {
                this.updateWithAddedProfile((Profile)object);
            }
        } else if (FileUtils.isArchive(string)) {
            ImportDialog importDialog = new ImportDialog(this.shell, this.dbversionsList, new File(string));
            Boolean bl = (Boolean)importDialog.open();
            if (bl != null) {
                if (bl.booleanValue()) {
                    this.rebuildProfilesTable();
                } else {
                    this.updateProfilesList(this.getSelectedProfileIds());
                }
                this.displayProfileInformation(true);
            }
        } else {
            GeneralPurposeDialogs.warningMessage(this.shell, this.settings.msg("general.error.cannotimportunknownfile"));
        }
    }

    public void addProfile(final String string) {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.doAddProfile(string);
            }
        });
    }

    private void doAddDosboxVersion() {
        EditDosboxVersionDialog editDosboxVersionDialog = new EditDosboxVersionDialog(this.shell, DosboxVersion.findDefault(this.dbversionsList) == null);
        DosboxVersion dosboxVersion = (DosboxVersion)editDosboxVersionDialog.open();
        if (dosboxVersion != null) {
            this.updateDosboxVersionList(dosboxVersion);
        }
    }

    private void doAddTemplate() {
        if (this.checkDefaultDBVersion() == null) {
            return;
        }
        EditTemplateDialog editTemplateDialog = new EditTemplateDialog(this.shell);
        Template template = (Template)editTemplateDialog.open();
        if (template != null) {
            this.updateTemplateList(template);
        }
    }

    private void doAddFilter() {
        Filter filter;
        EditFilterDialog editFilterDialog = new EditFilterDialog(this.shell);
        if (this.profile_table.getSelectionCount() > 1) {
            editFilterDialog.setIds(this.getSelectedProfileIds());
        }
        if ((filter = (Filter)editFilterDialog.open()) != null) {
            this.filtersList.add(filter);
            this.addFilterTab(filter).setControl(this.profile_table.getControl());
            this.filterFolder.setSelection(this.filterFolder.getItemCount() - 1);
            this.updateProfilesAfterTabAction();
        }
    }

    private void doToggleFavoriteProfile() {
        int n = this.profile_table.getSelectionIndex();
        if (n != -1) {
            Profile profile = this.profilesList.get(n);
            try {
                this.dbase.toggleFavorite(profile.getId());
            }
            catch (SQLException sQLException) {
                GeneralPurposeDialogs.warningMessage(this.shell, sQLException);
            }
            profile.toggleDefault();
            this.profilesList.set(n, profile);
            this.setTableItem(this.profile_table.getItem(n), profile);
        }
    }

    private void doToggleDefaultVersion() {
        int n = this.dbversion_table.getSelectionIndex();
        if (n != -1) {
            DosboxVersion dosboxVersion = this.dbversionsList.get(n);
            dosboxVersion.toggleDefault();
            try {
                this.dbase.addOrEditDosboxVersion(dosboxVersion.getTitle(), dosboxVersion.getPath(), dosboxVersion.getConf(), dosboxVersion.isMultiConfig(), dosboxVersion.isUsingCurses(), dosboxVersion.isDefault(), dosboxVersion.getParameters(), dosboxVersion.getVersion(), dosboxVersion.getId());
            }
            catch (SQLException sQLException) {
                GeneralPurposeDialogs.warningMessage(this.shell, sQLException);
            }
            this.updateDosboxVersionList(dosboxVersion);
        }
    }

    private void doToggleDefaultTemplate() {
        int n = this.template_table.getSelectionIndex();
        if (n != -1) {
            Template template = this.templatesList.get(n);
            template.toggleDefault();
            try {
                this.dbase.addOrEditTemplate(template.getTitle(), template.getDbversionId(), template.isDefault(), template.getId());
            }
            catch (SQLException sQLException) {
                GeneralPurposeDialogs.warningMessage(this.shell, sQLException);
            }
            this.updateTemplateList(template);
        }
    }

    private void doEditProfile() {
        this.doEditProfile(false);
    }

    private void doEditProfile(boolean bl) {
        int n = this.profile_table.getSelectionIndex();
        if (n != -1) {
            if (this.profile_table.getSelectionCount() > 1) {
                ProfileLoader profileLoader = new ProfileLoader(this.shell, this.getSelectedProfiles(), true);
                if (profileLoader.open() != null) {
                    EditProfileDialog editProfileDialog = new EditProfileDialog(this.shell);
                    editProfileDialog.setConfigurables(profileLoader.getResultAsConfigurables());
                    editProfileDialog.setMultiProfileCombined(profileLoader.getMultiProfileCombined());
                    if (editProfileDialog.open() != null) {
                        this.updateProfilesList(this.getSelectedProfileIds());
                        this.displayProfileInformation(false);
                    }
                }
            } else {
                Profile profile;
                EditProfileDialog editProfileDialog = new EditProfileDialog(this.shell);
                editProfileDialog.setProfile(this.profilesList.get(n));
                if (bl) {
                    editProfileDialog.focusTitle();
                }
                if ((profile = (Profile)editProfileDialog.open()) != null) {
                    this.updateProfileListAfterEdit(n, profile);
                    this.displayProfileInformation(false);
                }
            }
        }
    }

    private void updateProfileListAfterEdit(int n, Profile profile) {
        boolean bl = true;
        if (this.ssettings.getBooleanValue("gui", "autosortonupdate") || this.filterFolder.getSelectionIndex() > 0) {
            try {
                this.profilesList = this.dbase.readProfilesList(this.orderingVector.toClause(), this.filterClause);
                if (n != Profile.findIndexById(this.profilesList, profile.getId())) {
                    bl = false;
                }
            }
            catch (SQLException sQLException) {
                GeneralPurposeDialogs.warningMessage(this.shell, sQLException);
            }
        }
        if (bl) {
            this.profilesList.set(n, profile);
            this.setTableItem(this.profile_table.getItem(n), profile);
        } else {
            this.updateProfilesList(new HashSet<Integer>(Arrays.asList(profile.getId())));
        }
    }

    private void doDuplicateProfile() {
        int n = this.profile_table.getSelectionIndex();
        if (n != -1) {
            Profile profile = this.profilesList.get(n);
            this.updateWithAddedProfile(EditProfileDialog.duplicateProfile(profile, this.dbversionsList, this.dbase, this.shell));
        }
    }

    private void doDuplicateTemplate() {
        Template template;
        Template template2;
        int n = this.template_table.getSelectionIndex();
        if (n != -1 && (template2 = EditProfileDialog.duplicateTemplate(template = this.templatesList.get(n), this.dbversionsList, this.dbase, this.shell)) != null) {
            this.updateTemplateList(template2);
        }
    }

    private void updateWithAddedProfile(Profile profile) {
        if (profile != null) {
            if (this.ssettings.getBooleanValue("gui", "autosortonupdate") || this.filterFolder.getSelectionIndex() > 0) {
                this.updateProfilesList(new HashSet<Integer>(Arrays.asList(profile.getId())));
            } else {
                this.profilesList.add(profile);
                this.addProfileToTable(profile);
                this.profile_table.setSelection(this.profile_table.getItemCount() - 1);
                this.profile_table.setFocus();
            }
            this.displayProfileInformation(false);
        }
    }

    private void doEditDosboxVersion() {
        int n = this.dbversion_table.getSelectionIndex();
        if (n != -1) {
            EditDosboxVersionDialog editDosboxVersionDialog = new EditDosboxVersionDialog(this.shell, false);
            editDosboxVersionDialog.setDosboxVersion(this.dbversionsList.get(n));
            DosboxVersion dosboxVersion = (DosboxVersion)editDosboxVersionDialog.open();
            if (dosboxVersion != null) {
                this.updateDosboxVersionList(dosboxVersion);
            }
        }
    }

    private void doEditFilter() {
        int n = this.filterFolder.getSelectionIndex();
        if (n > 0) {
            EditFilterDialog editFilterDialog = new EditFilterDialog(this.shell);
            editFilterDialog.setFilter(this.filtersList.get(n));
            Filter filter = (Filter)editFilterDialog.open();
            if (filter != null) {
                this.filtersList.set(n, filter);
                this.filterFolder.getSelection().setText("    " + filter.getTitle() + "    ");
                this.updateProfilesAfterTabAction();
            }
        }
    }

    private void updateProfilesList(Set<Integer> set) {
        try {
            this.profilesList = this.dbase.readProfilesList(this.orderingVector.toClause(), this.filterClause);
        }
        catch (SQLException sQLException) {
            GeneralPurposeDialogs.warningMessage(this.shell, sQLException);
        }
        this.profile_table.setRedraw(false);
        this.profile_table.removeAll();
        for (Profile profile : this.profilesList) {
            this.addProfileToTable(profile);
        }
        this.profile_table.setSelection(this.getIndicesByIds(set));
        this.profile_table.setRedraw(true);
        this.profile_table.setFocus();
    }

    private void updateDosboxVersionList(DosboxVersion dosboxVersion) {
        try {
            this.dbversionsList = this.dbase.readDosboxVersionsList();
        }
        catch (SQLException sQLException) {
            GeneralPurposeDialogs.warningMessage(this.shell, sQLException);
        }
        this.dbversion_table.removeAll();
        for (DosboxVersion dosboxVersion2 : this.dbversionsList) {
            this.addDosboxVersionToTable(dosboxVersion2);
        }
        this.dbversion_table.setSelection(DosboxVersion.findIndexById(this.dbversionsList, dosboxVersion.getId()));
        this.dbversion_table.setFocus();
    }

    private void updateTemplateList(Template template) {
        try {
            this.templatesList = this.dbase.readTemplatesList();
        }
        catch (SQLException sQLException) {
            GeneralPurposeDialogs.warningMessage(this.shell, sQLException);
        }
        this.template_table.removeAll();
        for (Template template2 : this.templatesList) {
            this.addTemplateToTable(template2);
        }
        this.template_table.setSelection(Template.findIndexById(this.templatesList, template.getId()));
        this.template_table.setFocus();
    }

    private void doEditTemplate() {
        int n = this.template_table.getSelectionIndex();
        if (n != -1) {
            EditTemplateDialog editTemplateDialog = new EditTemplateDialog(this.shell);
            editTemplateDialog.setTemplate(this.templatesList.get(n));
            Template template = (Template)editTemplateDialog.open();
            if (template != null) {
                this.updateTemplateList(template);
            }
        }
    }

    private void doRemoveProfile() {
        int n = this.profile_table.getSelectionIndex();
        if (n != -1) {
            DeleteProfilesDialog deleteProfilesDialog = new DeleteProfilesDialog(this.shell);
            deleteProfilesDialog.setProfilesToBeDeleted(this.getSelectedProfiles(), this.dbversionsList);
            if (deleteProfilesDialog.open() != null) {
                int[] nArray = this.profile_table.getSelectionIndices();
                Arrays.sort(nArray);
                for (int i = nArray.length - 1; i >= 0; --i) {
                    this.profile_table.remove(nArray[i]);
                    this.profilesList.remove(nArray[i]);
                }
                if (nArray[0] > 0) {
                    this.profile_table.setSelection(nArray[0] - 1);
                }
                this.displayProfileInformation(false);
            }
        }
    }

    private void doRemoveDosboxVersion() {
        int n = this.dbversion_table.getSelectionIndex();
        if (n != -1 && GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.main.confirm.removedosboxversion"))) {
            try {
                this.dbase.removeDosboxVersion(this.dbversionsList.get(n));
                this.dbversion_table.remove(n);
                this.dbversionsList.remove(n);
            }
            catch (SQLException sQLException) {
                GeneralPurposeDialogs.warningMessage(this.shell, sQLException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemoveTemplate() {
        int n = this.template_table.getSelectionIndex();
        if (n != -1 && GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.main.confirm.removetemplate"))) {
            Template template = this.templatesList.get(n);
            try {
                this.dbase.startTransaction();
                this.dbase.removeNativeCommands(-1, template.getId());
                this.dbase.removeTemplate(template);
                this.dbase.commitTransaction();
                this.template_table.remove(n);
                this.templatesList.remove(n);
                File file = FileUtils.constructCanonicalTemplateFileLocation(template.getId());
                if (GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.main.confirm.removetemplateconf", new Object[]{file}))) {
                    FileUtils.removeFile(file);
                }
            }
            catch (SQLException sQLException) {
                try {
                    this.dbase.rollbackTransaction();
                }
                catch (SQLException sQLException2) {
                    GeneralPurposeDialogs.warningMessage(this.shell, sQLException2);
                }
                GeneralPurposeDialogs.warningMessage(this.shell, sQLException);
            }
            finally {
                this.dbase.finishTransaction();
            }
        }
    }

    private void addProfileToTable(Profile profile) {
        ProfilesList profilesList = this.profile_table;
        profilesList.getClass();
        ProfilesList.ProfilesListItem profilesListItem = new ProfilesList.ProfilesListItem(profilesList, this.profile_table);
        this.setTableItem(profilesListItem, profile);
    }

    private void addDosboxVersionToTable(DosboxVersion dosboxVersion) {
        TableItem tableItem = new TableItem(this.dbversion_table, 2048);
        this.setTableItem(tableItem, dosboxVersion);
    }

    private void addTemplateToTable(Template template) {
        TableItem tableItem = new TableItem(this.template_table, 2048);
        this.setTableItem(tableItem, template);
    }

    private void setTableItem(ProfilesList.ProfilesListItem profilesListItem, Profile profile) {
        for (int i = 0; i < this.columnIds.length; ++i) {
            String string;
            switch (this.columnIds[i]) {
                case 0: {
                    string = profile.getTitle();
                    break;
                }
                case 1: {
                    string = profile.hasSetupString();
                    break;
                }
                case 2: {
                    string = profile.getDeveloperName();
                    break;
                }
                case 3: {
                    string = profile.getPublisherName();
                    break;
                }
                case 4: {
                    string = profile.getGenre();
                    break;
                }
                case 5: {
                    string = profile.getYear();
                    break;
                }
                case 6: {
                    string = profile.getStatus();
                    break;
                }
                case 7: {
                    string = profile.isDefaultString();
                    break;
                }
                case 8: {
                    string = String.valueOf(profile.getId());
                    break;
                }
                case 9: {
                    string = String.valueOf(profile.getDbversionId());
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    string = profile.getCustomString(this.columnIds[i] - 10);
                    break;
                }
                case 18: {
                    string = profile.getCustomInt(0) + " %";
                    break;
                }
                case 19: {
                    string = String.valueOf(profile.getCustomInt(1));
                    break;
                }
                case 21: {
                    string = DosboxVersion.findById(this.dbversionsList, profile.getDbversionId()).getTitle();
                    break;
                }
                case 22: {
                    string = Settings.toString(profile.getStats().getCreated(), 3);
                    break;
                }
                case 23: {
                    string = Settings.toString(profile.getStats().getModified(), 3);
                    break;
                }
                case 24: {
                    string = Settings.toString(profile.getStats().getLastrun(), 3);
                    break;
                }
                case 25: {
                    string = Settings.toString(profile.getStats().getLastsetup(), 3);
                    break;
                }
                case 26: {
                    string = String.valueOf(profile.getStats().getRuns());
                    break;
                }
                case 27: {
                    string = String.valueOf(profile.getStats().getSetups());
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    string = profile.getCustomString(this.columnIds[i] - 10 - 10);
                    break;
                }
                default: {
                    string = "";
                }
            }
            if (this.columnIds[i] == 20) continue;
            profilesListItem.setText(i, this.columnIds[i], string);
        }
        profilesListItem.setData(new ThumbInfo(profile.getCaptures()));
    }

    private void setTableItem(TableItem tableItem, DosboxVersion dosboxVersion) {
        tableItem.setText(0, dosboxVersion.getTitle());
        tableItem.setText(1, dosboxVersion.getVersion());
        tableItem.setText(2, dosboxVersion.getPath());
        tableItem.setText(3, dosboxVersion.isDefaultString());
        tableItem.setText(4, String.valueOf(dosboxVersion.getId()));
        tableItem.setText(5, Settings.toString(dosboxVersion.getStats().getCreated(), 3));
        tableItem.setText(6, Settings.toString(dosboxVersion.getStats().getModified(), 3));
        tableItem.setText(7, Settings.toString(dosboxVersion.getStats().getLastrun(), 3));
        tableItem.setText(8, String.valueOf(dosboxVersion.getStats().getRuns()));
    }

    private void setTableItem(TableItem tableItem, Template template) {
        tableItem.setText(0, template.getTitle());
        tableItem.setText(1, template.isDefaultString());
        tableItem.setText(2, String.valueOf(template.getId()));
        tableItem.setText(3, Settings.toString(template.getStats().getCreated(), 3));
        tableItem.setText(4, Settings.toString(template.getStats().getModified(), 3));
        tableItem.setText(5, Settings.toString(template.getStats().getLastrun(), 3));
        tableItem.setText(6, String.valueOf(template.getStats().getRuns()));
    }

    private void doRunProfile(int n, boolean bl) {
        int n2 = this.profile_table.getSelectionIndex();
        if (n2 != -1) {
            Profile profile = this.profilesList.get(n2);
            if (n == -1 || profile.hasSetup(n)) {
                try {
                    List<NativeCommand> list = this.dbase.readNativeCommandsList(profile.getId(), -1);
                    FileUtils.doRunProfile(profile, this.dbversionsList, MainWindow.getEnv(this.ssettings), n, bl, list, this.display);
                    profile = n == -1 ? this.dbase.runProfile(profile) : this.dbase.setupProfile(profile);
                    this.updateProfileListAfterEdit(n2, profile);
                }
                catch (IOException | SQLException exception) {
                    GeneralPurposeDialogs.warningMessage(this.shell, exception);
                }
            }
        }
    }

    private void doRunDosbox() {
        int n = this.dbversion_table.getSelectionIndex();
        if (n != -1) {
            DosboxVersion dosboxVersion = this.dbversionsList.get(n);
            try {
                FileUtils.doRunDosbox(dosboxVersion, MainWindow.getEnv(this.ssettings));
                this.dbase.runDosboxVersion(dosboxVersion);
                this.updateDosboxVersionList(dosboxVersion);
            }
            catch (IOException | SQLException exception) {
                GeneralPurposeDialogs.warningMessage(this.shell, exception);
            }
        }
    }

    private void doRunTemplate() {
        int n = this.template_table.getSelectionIndex();
        if (n != -1) {
            Template template = this.templatesList.get(n);
            try {
                List<NativeCommand> list = this.dbase.readNativeCommandsList(-1, template.getId());
                FileUtils.doRunTemplate(template, this.dbversionsList, MainWindow.getEnv(this.ssettings), list, this.display);
                this.dbase.runTemplate(template);
                this.updateTemplateList(template);
            }
            catch (IOException | SQLException exception) {
                GeneralPurposeDialogs.warningMessage(this.shell, exception);
            }
        }
    }

    private DosboxVersion checkDefaultDBVersion() {
        DosboxVersion dosboxVersion = DosboxVersion.findDefault(this.dbversionsList);
        if (dosboxVersion == null) {
            GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.main.required.defaultdosboxversion"));
        }
        return dosboxVersion;
    }

    private void doDFendImport() {
        DosboxVersion dosboxVersion = this.checkDefaultDBVersion();
        if (dosboxVersion == null) {
            return;
        }
        if (this.ssettings.getIntValue("profiledefaults", "confpath") == 1) {
            GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.main.notice.dfendimportconflocation", new Object[]{SettingsDialog.confLocations[0]}));
        }
        DFendImportDialog dFendImportDialog = new DFendImportDialog(this.shell);
        dFendImportDialog.setDefaultDosboxVersion(dosboxVersion);
        if (dFendImportDialog.open() != null) {
            this.updateProfilesList(this.getSelectedProfileIds());
            this.displayProfileInformation(true);
        }
    }

    private void doMigrate() {
        GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.main.notice.premigration"));
        String string = (String)new MigrateDialog(this.shell).open();
        if (string != null) {
            this.updateProfilesList(this.getSelectedProfileIds());
            this.displayProfileInformation(true);
            GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.main.notice.postmigration", new Object[]{string, FileUtils.getDosRoot()}));
        }
    }

    private void doLocateDosbox(boolean bl) {
        SearchResult searchResult = PlatformUtils.findDosbox();
        if (searchResult.result == SearchResult.ResultType.NOTFOUND) {
            GeneralPurposeDialogs.warningMessage(this.shell, this.settings.msg("dialog.locatedosbox.notice.notfound"));
            return;
        }
        if (searchResult.result == SearchResult.ResultType.COMPLETE && !bl) {
            try {
                DosboxVersion dosboxVersion = this.dbase.addOrEditDosboxVersion(searchResult.dosbox.getTitle(), searchResult.dosbox.getPath(), searchResult.dosbox.getConf(), searchResult.dosbox.isMultiConfig(), searchResult.dosbox.isUsingCurses(), searchResult.dosbox.isDefault(), searchResult.dosbox.getParameters(), searchResult.dosbox.getVersion(), searchResult.dosbox.getId());
                this.updateDosboxVersionList(dosboxVersion);
            }
            catch (SQLException sQLException) {
                GeneralPurposeDialogs.warningMessage(this.shell, sQLException);
            }
        } else {
            EditDosboxVersionDialog editDosboxVersionDialog = new EditDosboxVersionDialog(this.shell, DosboxVersion.findDefault(this.dbversionsList) == null);
            editDosboxVersionDialog.setDosboxVersion(searchResult.dosbox);
            DosboxVersion dosboxVersion = (DosboxVersion)editDosboxVersionDialog.open();
            if (dosboxVersion != null) {
                this.updateDosboxVersionList(dosboxVersion);
            }
        }
    }

    private void displayProfileInformation(boolean bl) {
        int n = this.profile_table.getSelectionIndex();
        if (n == -1) {
            if (this.displayScreenshots.getSelection()) {
                this.displayScreenshots(null, null, bl);
            }
            if (this.displayNotes.getSelection()) {
                this.notesField.setText("");
                this.displayLinks(new String[]{null, null, null, null, null, null, null, null}, new String[]{null, null, null, null, null, null, null, null});
            }
            this.updateViewProfileSubmenu(null);
            this.setupToolItem.setEnabled(false);
        } else {
            this.ssettings.setIntValue("gui", "selectedprofile", n);
            Profile profile = this.profilesList.get(n);
            if (this.displayScreenshots.getSelection()) {
                this.displayScreenshots(profile, this.profile_table.getItem(n), bl);
            } else if (bl) {
                ThumbInfo thumbInfo = (ThumbInfo)this.profile_table.getItem(n).getData();
                thumbInfo.resetCachedInfo();
            }
            if (bl) {
                this.profile_table.redraw();
            }
            if (this.displayNotes.getSelection()) {
                this.notesField.setText(profile.getNotes());
                this.displayLinks(profile.getLinks(), profile.getLinkTitles());
            }
            this.updateViewProfileSubmenu(profile);
            this.setupToolItem.setEnabled(profile.hasSetup(0));
        }
    }

    private void doRemoveThumb() {
        if (GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.main.confirm.removethumb", new Object[]{this.currentThumbFile}))) {
            FileUtils.removeFile(this.currentThumbFile);
            SWTImageManager.flush(this.currentThumbFile.getPath());
            this.displayProfileInformation(true);
        }
        this.currentThumbFile = null;
    }

    private void doCreateShortcut() {
        int[] nArray = this.profile_table.getSelectionIndices();
        for (int i = 0; i < nArray.length; ++i) {
            try {
                PlatformUtils.createShortcut(this.profilesList.get(nArray[i]), this.dbversionsList);
                continue;
            }
            catch (IOException iOException) {
                GeneralPurposeDialogs.warningMessage(this.shell, iOException);
            }
        }
    }

    private void addDBColumn(String string, int n) {
        final String string2 = "column2_" + (n + 1) + "width";
        final TableColumn tableColumn = new TableColumn(this.dbversion_table, 0);
        tableColumn.setWidth(this.ssettings.getIntValue("gui", string2));
        tableColumn.setText(string);
        tableColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                MainWindow.this.ssettings.setIntValue("gui", string2, tableColumn.getWidth());
            }
        });
    }

    private void addTemplateColumn(String string, int n) {
        final String string2 = "column3_" + (n + 1) + "width";
        final TableColumn tableColumn = new TableColumn(this.template_table, 0);
        tableColumn.setWidth(this.ssettings.getIntValue("gui", string2));
        tableColumn.setText(string);
        tableColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                MainWindow.this.ssettings.setIntValue("gui", string2, tableColumn.getWidth());
            }
        });
    }

    private void doOpenSettingsDialog() {
        SettingsDialog settingsDialog = new SettingsDialog(this.shell);
        if (((Boolean)settingsDialog.open()).booleanValue()) {
            this.rebuildProfilesTable();
        }
        this.notesField.setFont(GeneralPurposeGUI.stringToFont((Device)this.display, this.notesField.getFont(), this.ssettings.getValues("gui", "notesfont")));
    }

    private void doOpenLogDialog() {
        new LogDialog(this.shell).open();
    }

    private void rebuildProfilesTable() {
        Set<Integer> set = this.getSelectedProfileIds();
        this.initColumnIds();
        this.disposeProfilesList();
        this.constructProfilesList();
        this.updateProfilesList(set);
    }

    private void doImportConfigfile() {
        FileDialog fileDialog = new FileDialog(this.shell, 4096);
        fileDialog.setFilterNames(new String[]{this.settings.msg("filetype.conf"), this.settings.msg("filetype.exe") + ", " + this.settings.msg("filetype.booterimage"), "*"});
        fileDialog.setFilterExtensions(new String[]{"*.conf;*.CONF", "*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT;*.cp2;*.CP2;*.dcf;*.DCF;*.img;*.IMG;*.jrc;*.JRC;*.td0;*.TD0", "*"});
        String string = fileDialog.open();
        if (string != null) {
            this.doAddProfile(string);
        }
    }

    private void doExportTemplates() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            ArrayList<ExpTemplate> arrayList = new ArrayList<ExpTemplate>();
            for (Template template : this.templatesList) {
                Conf conf = new Conf(template, DosboxVersion.findById(this.dbversionsList, template.getDbversionId()), printStream);
                arrayList.add(new ExpTemplate(-1, conf, template));
            }
            DOMSource dOMSource = new DOMSource(XmlUtils.getFullTemplatesXML(arrayList, this.dbversionsList, "DBGL default templates", "", "rcblanke"));
            XmlUtils.saveDomSource(dOMSource, FileUtils.getDefaultTemplatesXmlFile(), null);
            if (byteArrayOutputStream.size() > 0) {
                GeneralPurposeDialogs.warningMessage(this.shell, byteArrayOutputStream.toString());
                byteArrayOutputStream.reset();
            }
        }
        catch (Exception exception) {
            GeneralPurposeDialogs.fatalMessage(this.shell, exception.toString(), exception);
        }
    }

    private void doImportDefaultTemplates(boolean bl) {
        if (!bl || GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.importdefaulttemplates.confirm.start"))) {
            try {
                KeyTitleDefault keyTitleDefault;
                Object object2;
                if (this.checkDefaultDBVersion() == null) {
                    return;
                }
                File file = FileUtils.getDefaultTemplatesXmlFile();
                if (!FileUtils.isExistingFile(file)) {
                    throw new IOException(this.settings.msg("general.error.openfile", new Object[]{file}));
                }
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = documentBuilder.parse(file);
                XPath xPath = XPathFactory.newInstance().newXPath();
                String string = xPath.evaluate("/document/export/format-version", document);
                String string2 = xPath.evaluate("/document/export/title", document);
                String string3 = xPath.evaluate("/document/export/author", document);
                String string4 = xPath.evaluate("/document/export/notes", document);
                String string5 = xPath.evaluate("/document/export/generator-title", document);
                String string6 = xPath.evaluate("/document/export/generator-version", document);
                Date date = XmlUtils.datetimeFormatter.parse(xPath.evaluate("/document/export/creationdatetime", document));
                System.out.println(this.settings.msg("dialog.import.importing", new Object[]{StringUtils.join((Object[])new String[]{string2, string, string3, string4, string5, string6, date.toString()}, (char)' ')}));
                NodeList nodeList = (NodeList)xPath.evaluate("/document/template", document, XPathConstants.NODESET);
                ArrayList<ExpTemplate> arrayList = new ArrayList<ExpTemplate>();
                TreeSet<DosboxVersion> treeSet = new TreeSet<DosboxVersion>();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    object2 = (Element)nodeList.item(i);
                    Element object3 = XmlUtils.getNode((Element)object2, "dosbox");
                    keyTitleDefault = new DosboxVersion(i, XmlUtils.getTextValue(object3, "title"), "", "", true, false, false, "", XmlUtils.getTextValue(object3, "version"), null, null, null, 0);
                    treeSet.add((DosboxVersion)keyTitleDefault);
                    arrayList.add(new ExpTemplate((Element)object2, ImportDialog.getDosboxVersionId((DosboxVersion)keyTitleDefault, treeSet)));
                }
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                for (DosboxVersion dosboxVersion : treeSet) {
                    arrayList2.add(dosboxVersion.findBestMatchId(this.dbversionsList));
                }
                object2 = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream((OutputStream)object2);
                keyTitleDefault = null;
                for (ExpTemplate expTemplate : arrayList) {
                    expTemplate.setDbversionId(ImportDialog.getMappedDosboxVersionId(treeSet, arrayList2, expTemplate.getDbversionId()));
                    DosboxVersion dosboxVersion = DosboxVersion.findById(this.dbversionsList, expTemplate.getDbversionId());
                    keyTitleDefault = this.dbase.addOrEditTemplate(expTemplate.getTitle(), expTemplate.getDbversionId(), expTemplate.isDefault(), -1);
                    Conf conf = new Conf(expTemplate.getImportedFullConfig(), expTemplate.getImportedIncrConfig(), false, FileUtils.getDefaultTemplatesXmlFile().getPath(), keyTitleDefault.getId(), dosboxVersion, printStream);
                    conf.save();
                }
                this.updateTemplateList((Template)keyTitleDefault);
                if (((ByteArrayOutputStream)object2).size() > 0) {
                    GeneralPurposeDialogs.warningMessage(this.shell, ((ByteArrayOutputStream)object2).toString());
                    ((ByteArrayOutputStream)object2).reset();
                } else if (bl) {
                    GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.import.notice.importok"));
                }
            }
            catch (XPathExpressionException | SAXException exception) {
                GeneralPurposeDialogs.fatalMessage(this.shell, this.settings.msg("dialog.importdefaulttemplates.error.defaultxmlinvalidformat", new Object[]{exception.toString()}), exception);
            }
            catch (Exception exception) {
                GeneralPurposeDialogs.fatalMessage(this.shell, exception.toString(), exception);
            }
        }
    }

    private void initColumnIds() {
        int n;
        int n2;
        columnNames = new String[32];
        MainWindow.columnNames[0] = this.settings.msg("dialog.main.profiles.column.title");
        MainWindow.columnNames[1] = this.settings.msg("dialog.main.profiles.column.setup");
        MainWindow.columnNames[2] = this.settings.msg("dialog.main.profiles.column.developer");
        MainWindow.columnNames[3] = this.settings.msg("dialog.main.profiles.column.publisher");
        MainWindow.columnNames[4] = this.settings.msg("dialog.main.profiles.column.genre");
        MainWindow.columnNames[5] = this.settings.msg("dialog.main.profiles.column.year");
        MainWindow.columnNames[6] = this.settings.msg("dialog.main.profiles.column.status");
        MainWindow.columnNames[7] = this.settings.msg("dialog.main.profiles.column.favorite");
        MainWindow.columnNames[8] = this.settings.msg("dialog.main.profiles.column.id");
        MainWindow.columnNames[9] = this.settings.msg("dialog.main.profiles.column.dosboxversionid");
        for (n2 = 0; n2 < 10; ++n2) {
            MainWindow.columnNames[n2 + 10] = this.ssettings.getValue("gui", "custom" + (n2 + 1));
        }
        MainWindow.columnNames[20] = this.settings.msg("dialog.main.profiles.column.screenshot");
        MainWindow.columnNames[21] = this.settings.msg("dialog.main.profiles.column.dosboxversiontitle");
        MainWindow.columnNames[22] = this.settings.msg("dialog.main.generic.column.created");
        MainWindow.columnNames[23] = this.settings.msg("dialog.main.generic.column.lastmodify");
        MainWindow.columnNames[24] = this.settings.msg("dialog.main.generic.column.lastrun");
        MainWindow.columnNames[25] = this.settings.msg("dialog.main.generic.column.lastsetup");
        MainWindow.columnNames[26] = this.settings.msg("dialog.main.generic.column.runs");
        MainWindow.columnNames[27] = this.settings.msg("dialog.main.generic.column.setups");
        for (n2 = 0; n2 < 4; ++n2) {
            MainWindow.columnNames[n2 + 10 + 10 + 8] = this.ssettings.getValue("gui", "custom" + (n2 + 10 + 1));
        }
        n2 = 0;
        for (n = 0; n < columnNames.length; ++n) {
            if (!this.ssettings.getBooleanValue("gui", "column" + (n + 1) + "visible")) continue;
            ++n2;
        }
        n = 0;
        this.columnIds = new int[n2];
        for (int i = 0; i < columnNames.length; ++i) {
            if (!this.ssettings.getBooleanValue("gui", "column" + (i + 1) + "visible")) continue;
            this.columnIds[n++] = i;
        }
    }

    private Menu createDosboxVersionsSubmenu(Menu menu, final int n, final boolean bl) {
        final Menu menu2 = new Menu(menu);
        for (int i = 0; i < this.dbversionsList.size(); ++i) {
            final MenuItem menuItem = new MenuItem(menu2, 0);
            menuItem.setText(this.dbversionsList.get(i).getTitle());
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    int n2 = MainWindow.this.profile_table.getSelectionIndex();
                    if (n2 != -1) {
                        Profile profile = (Profile)MainWindow.this.profilesList.get(n2);
                        DosboxVersion dosboxVersion = (DosboxVersion)MainWindow.this.dbversionsList.get(menu2.indexOf(menuItem));
                        try {
                            List<NativeCommand> list = MainWindow.this.dbase.readNativeCommandsList(profile.getId(), -1);
                            FileUtils.doRunProfile(profile, dosboxVersion, (Map<String, String>)MainWindow.getEnv(MainWindow.this.ssettings), n, bl, list, MainWindow.this.display);
                        }
                        catch (IOException | SQLException exception) {
                            GeneralPurposeDialogs.warningMessage(MainWindow.this.shell, exception);
                        }
                    }
                }
            });
        }
        return menu2;
    }

    private void updateViewProfileSubmenu(final Profile profile) {
        MenuItem menuItem = this.viewProfileSubMenu.getParentItem();
        this.viewProfileSubMenu.dispose();
        this.viewProfileSubMenu = new Menu(menuItem);
        menuItem.setMenu(this.viewProfileSubMenu);
        if (profile != null) {
            for (int i = 0; i < profile.getLinks().length; ++i) {
                String string;
                String string2 = profile.getLink(i);
                if (string2.length() <= 0) continue;
                final MenuItem menuItem2 = new MenuItem(this.viewProfileSubMenu, 0);
                String string3 = string2;
                String string4 = string2;
                if (string3.indexOf("://") == -1) {
                    string3 = "file://" + FileUtils.canonicalToData(string3).getPath();
                    string4 = FileUtils.makeRelativeToDosroot(FileUtils.canonicalToData(string4)).getPath();
                }
                if ((string = profile.getLinkTitle(i)) != null && !"".equals(string)) {
                    string4 = string;
                }
                menuItem2.setData((Object)string3);
                menuItem2.setText(StringUtils.abbreviateMiddle((String)string4, (String)"....", (int)80));
                menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        PlatformUtils.openForBrowsing((String)menuItem2.getData());
                    }
                });
            }
            MenuItem menuItem3 = new MenuItem(this.viewProfileSubMenu, 0);
            menuItem3.setText(this.settings.msg("dialog.main.profile.view.conf"));
            menuItem3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    PlatformUtils.openForEditing(profile.getCanonicalConfFile());
                }
            });
        }
    }

    private void updateViewDosboxSubmenu(final DosboxVersion dosboxVersion) {
        MenuItem menuItem = this.viewDosboxSubMenu.getParentItem();
        this.viewDosboxSubMenu.dispose();
        this.viewDosboxSubMenu = new Menu(menuItem);
        menuItem.setMenu(this.viewDosboxSubMenu);
        if (dosboxVersion != null) {
            MenuItem menuItem2 = new MenuItem(this.viewDosboxSubMenu, 0);
            menuItem2.setText(this.settings.msg("dialog.main.profile.view.conf"));
            menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    PlatformUtils.openForEditing(dosboxVersion.getCanonicalConfFile());
                }
            });
        }
    }

    private void updateViewTemplateSubmenu(final Template template) {
        MenuItem menuItem = this.viewTemplateSubMenu.getParentItem();
        this.viewTemplateSubMenu.dispose();
        this.viewTemplateSubMenu = new Menu(menuItem);
        menuItem.setMenu(this.viewTemplateSubMenu);
        if (template != null) {
            MenuItem menuItem2 = new MenuItem(this.viewTemplateSubMenu, 0);
            menuItem2.setText(this.settings.msg("dialog.main.profile.view.conf"));
            menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    PlatformUtils.openForEditing(FileUtils.constructCanonicalTemplateFileLocation(template.getId()));
                }
            });
        }
    }

    private void doExportProfilesList() {
        new ExportListDialog(this.shell, this.dbversionsList, this.profilesList).open();
    }

    private void createProfilesTab(TabFolder tabFolder) {
        Filter filter2;
        Object object;
        ViewType viewType3;
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(this.settings.msg("dialog.main.profiles"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        tabItem.setControl((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        RowLayout rowLayout = new RowLayout();
        rowLayout.spacing = 20;
        rowLayout.marginLeft = 0;
        rowLayout.marginBottom = 0;
        rowLayout.marginTop = 0;
        composite2.setLayout((Layout)rowLayout);
        ToolBar toolBar = new ToolBar(composite2, 256);
        final ToolBar toolBar2 = new ToolBar(composite2, 256);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.addprofile"), "tb_new.png", (SelectionListener)this.addProfAdapter);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.editprofile"), "tb_edit.png", (SelectionListener)this.editProfAdapter);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.removeprofile"), "tb_delete.png", (SelectionListener)this.removeProfAdapter);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.runprofile"), "tb_run.png", (SelectionListener)this.runProfAdapter);
        this.setupToolItem = GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.runprofilesetup"), "tb_setup.png", (SelectionListener)this.setupProfAdapter);
        GeneralPurposeGUI.createSeparatorToolItem(toolBar, 40);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.addwizard"), "tb_wizard.png", (SelectionListener)this.addWizardAdapter);
        final ViewType[] viewTypeArray = new ViewType[]{new ViewType(ProfilesList.ProfilesListType.TABLE.toString(), "table.png", this.settings.msg("dialog.main.profiles.viewtype.table")), new ViewType(ProfilesList.ProfilesListType.SMALL_TILES.toString(), "tiles_small.png", this.settings.msg("dialog.main.profiles.viewtype.smalltiles")), new ViewType(ProfilesList.ProfilesListType.MEDIUM_TILES.toString(), "tiles_medium.png", this.settings.msg("dialog.main.profiles.viewtype.mediumtiles")), new ViewType(ProfilesList.ProfilesListType.LARGE_TILES.toString(), "tiles_large.png", this.settings.msg("dialog.main.profiles.viewtype.largetiles")), new ViewType(ProfilesList.ProfilesListType.SMALL_BOXES.toString(), "boxes_small.png", this.settings.msg("dialog.main.profiles.viewtype.smallboxes")), new ViewType(ProfilesList.ProfilesListType.MEDIUM_BOXES.toString(), "boxes_medium.png", this.settings.msg("dialog.main.profiles.viewtype.mediumboxes")), new ViewType(ProfilesList.ProfilesListType.LARGE_BOXES.toString(), "boxes_large.png", this.settings.msg("dialog.main.profiles.viewtype.largeboxes"))};
        ViewType viewType2 = this.settings.getSettings().getValue("gui", "viewstyle").equalsIgnoreCase(viewTypeArray[0].getName()) ? viewTypeArray[0] : viewTypeArray[1];
        this.viewSelector = new ToolItem(toolBar2, 4);
        this.viewSelector.setImage(SWTImageManager.getResourceImage(this.shell.getDisplay(), viewType2.getImage()));
        this.viewSelector.setToolTipText(viewType2.getDisplayName());
        final Menu menu = new Menu((Decorations)this.shell, 8);
        for (ViewType viewType3 : viewTypeArray) {
            object = new MenuItem(menu, 8);
            object.setImage(SWTImageManager.getResourceImage(this.shell.getDisplay(), viewType3.getImage()));
            object.setText(viewType3.getDisplayName());
            object.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    MenuItem menuItem = (MenuItem)selectionEvent.widget;
                    ViewType viewType = viewTypeArray[menuItem.getParent().indexOf(menuItem)];
                    if (!MainWindow.this.settings.getSettings().getValue("gui", "viewstyle").equalsIgnoreCase(viewType.getName())) {
                        MainWindow.this.toggleProfileViewType(viewType, MainWindow.this.selectProfAdapter, MainWindow.this.mouseAdapter, MainWindow.this.keyAdapter, MainWindow.this.travListener, MainWindow.this.addProfAdapter, MainWindow.this.editProfAdapter, MainWindow.this.removeProfAdapter, MainWindow.this.setupProfAdapter, MainWindow.this.runProfAdapter, MainWindow.this.prepareProfAdapter, MainWindow.this.duplicateProfAdapter, MainWindow.this.toggleProfAdapter, MainWindow.this.shortcutProfAdapter, MainWindow.this.openProfAdapter);
                    }
                }
            });
        }
        this.viewSelector.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    Rectangle rectangle = MainWindow.this.viewSelector.getBounds();
                    Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
                    point = toolBar2.toDisplay(point);
                    menu.setLocation(point.x, point.y);
                    menu.setVisible(true);
                } else {
                    for (int i = 0; i < viewTypeArray.length; ++i) {
                        if (!MainWindow.this.settings.getSettings().getValue("gui", "viewstyle").equalsIgnoreCase(viewTypeArray[i].getName())) continue;
                        MainWindow.this.toggleProfileViewType(viewTypeArray[(i + 1) % viewTypeArray.length], MainWindow.this.selectProfAdapter, MainWindow.this.mouseAdapter, MainWindow.this.keyAdapter, MainWindow.this.travListener, MainWindow.this.addProfAdapter, MainWindow.this.editProfAdapter, MainWindow.this.removeProfAdapter, MainWindow.this.setupProfAdapter, MainWindow.this.runProfAdapter, MainWindow.this.prepareProfAdapter, MainWindow.this.duplicateProfAdapter, MainWindow.this.toggleProfAdapter, MainWindow.this.shortcutProfAdapter, MainWindow.this.openProfAdapter);
                        break;
                    }
                }
            }
        });
        ViewType[] viewTypeArray2 = new ToolItem(toolBar2, 2);
        viewTypeArray2.setWidth(4);
        this.displayScreenshots = new ToolItem(toolBar2, 32);
        this.displayScreenshots.setImage(SWTImageManager.getResourceImage(this.shell.getDisplay(), "screenshots.png"));
        this.displayScreenshots.setToolTipText(this.settings.msg("dialog.main.profiles.togglebutton.screenshots"));
        ToolItem toolItem = new ToolItem(toolBar2, 2);
        toolItem.setWidth(4);
        this.displayNotes = new ToolItem(toolBar2, 32);
        this.displayNotes.setImage(SWTImageManager.getResourceImage(this.shell.getDisplay(), "notes.png"));
        this.displayNotes.setToolTipText(this.settings.msg("dialog.main.profiles.togglebutton.notes"));
        final SashForm sashForm = new SashForm(composite, 0);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        viewType3 = new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                MainWindow.this.ssettings.setIntValues("gui", "sashweights", sashForm.getWeights());
            }
        };
        object = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PlatformUtils.openForBrowsing(selectionEvent.text);
            }
        };
        this.filterFolder = new CTabFolder((Composite)sashForm, 2048);
        this.filterFolder.setUnselectedCloseVisible(true);
        this.filterFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MainWindow.this.updateProfilesAfterTabAction();
            }
        });
        this.filterFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent cTabFolderEvent) {
                if (GeneralPurposeDialogs.confirmMessage(MainWindow.this.shell, MainWindow.this.settings.msg("dialog.main.confirm.removefilter", new Object[]{((CTabItem)cTabFolderEvent.item).getText().trim()}))) {
                    boolean bl = cTabFolderEvent.item == MainWindow.this.filterFolder.getSelection();
                    try {
                        int n = (Integer)cTabFolderEvent.item.getData();
                        MainWindow.this.dbase.removeFilter((Filter)Filter.findById(MainWindow.this.filtersList, n));
                        MainWindow.this.filtersList.remove(Filter.findIndexById(MainWindow.this.filtersList, n));
                    }
                    catch (SQLException sQLException) {
                        GeneralPurposeDialogs.warningMessage(MainWindow.this.shell, sQLException);
                    }
                    if (bl) {
                        MainWindow.this.filterFolder.setSelection(0);
                        MainWindow.this.updateProfilesAfterTabAction();
                    }
                } else {
                    cTabFolderEvent.doit = false;
                }
            }
        });
        this.filterFolder.addMouseListener((MouseListener)this.filterMouseAdapter);
        for (Filter filter2 : this.filtersList) {
            this.addFilterTab(filter2);
        }
        this.filterFolder.setSelection(this.ssettings.getIntValue("gui", "filtertab"));
        this.filterFolder.getSelection().setToolTipText(this.settings.msg("dialog.filter.notice.results", new Object[]{this.profilesList.size()}));
        this.constructProfilesList();
        Composite composite3 = new Composite((Composite)sashForm, 0);
        filter2 = new GridLayout();
        ((GridLayout)filter2).horizontalSpacing = 0;
        ((GridLayout)filter2).verticalSpacing = 0;
        ((GridLayout)filter2).marginWidth = 0;
        ((GridLayout)filter2).marginHeight = 0;
        composite3.setLayout((Layout)filter2);
        composite3.addControlListener((ControlListener)viewType3);
        this.notesField = new Text(composite3, 2634);
        this.notesField.setLayoutData((Object)new GridData(4, 4, true, true));
        this.notesField.setFont(GeneralPurposeGUI.stringToFont((Device)this.display, this.notesField.getFont(), this.ssettings.getValues("gui", "notesfont")));
        sashForm.setWeights(this.ssettings.getIntValues("gui", "sashweights"));
        Composite composite4 = new Composite(composite3, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginWidth = 0;
        gridLayout2.marginHeight = 1;
        gridLayout2.verticalSpacing = 2;
        composite4.setLayout((Layout)gridLayout2);
        composite4.setLayoutData((Object)new GridData(4, 1, true, false));
        this.link = new Link[8];
        for (int i = 0; i < this.link.length; ++i) {
            this.link[i] = new Link(composite4, 0);
            this.link[i].setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.link[i].addSelectionListener((SelectionListener)object);
        }
        this.thumbHeight = this.ssettings.getIntValue("gui", "screenshotsheight");
        final ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 2304);
        scrolledComposite.setMinHeight(this.thumbHeight + 20);
        final GridData gridData = new GridData(4, 128, true, false, 1, 1);
        scrolledComposite.setLayoutData((Object)gridData);
        this.thumbsToolBar = new Composite((Composite)scrolledComposite, 0);
        this.thumbsToolBar.setLayout((Layout)new RowLayout(256));
        scrolledComposite.setContent((Control)this.thumbsToolBar);
        scrolledComposite.getHorizontalBar().setPageIncrement(300);
        scrolledComposite.getHorizontalBar().setIncrement(50);
        this.displayScreenshots.setSelection(this.settings.getSettings().getBooleanValue("gui", "screenshotsvisible"));
        gridData.exclude = !this.displayScreenshots.getSelection();
        this.displayScreenshots.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ToolItem toolItem = (ToolItem)selectionEvent.widget;
                gridData.exclude = !toolItem.getSelection();
                scrolledComposite.getParent().layout();
                MainWindow.this.settings.getSettings().setBooleanValue("gui", "screenshotsvisible", toolItem.getSelection());
                MainWindow.this.displayProfileInformation(false);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.displayNotes.setSelection(this.settings.getSettings().getBooleanValue("gui", "notesvisible"));
        sashForm.setMaximizedControl((Control)(this.displayNotes.getSelection() ? null : this.filterFolder));
        this.displayNotes.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ToolItem toolItem = (ToolItem)selectionEvent.widget;
                sashForm.setMaximizedControl(toolItem.getSelection() ? null : MainWindow.this.filterFolder);
                MainWindow.this.settings.getSettings().setBooleanValue("gui", "notesvisible", toolItem.getSelection());
                MainWindow.this.displayProfileInformation(false);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.menu_thumb = new Menu((Control)this.thumbsToolBar);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (MainWindow.this.currentThumbFile != null) {
                    MainWindow.this.doRemoveThumb();
                }
            }
        };
        SelectionAdapter selectionAdapter2 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (MainWindow.this.currentThumbFile != null) {
                    PlatformUtils.openDirForViewing(MainWindow.this.currentThumbFile.getParentFile());
                }
            }
        };
        SelectionAdapter selectionAdapter3 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                for (ProfilesList.ProfilesListItem profilesListItem : MainWindow.this.profile_table.getItems()) {
                    profilesListItem.resetCachedInfo();
                }
                SWTImageManager.dispose();
                MainWindow.this.displayProfileInformation(true);
            }
        };
        GeneralPurposeGUI.createIconMenuItem(this.menu_thumb, 0, this.settings, this.settings.msg("dialog.main.thumb.remove"), "delete.png", (SelectionListener)selectionAdapter);
        new MenuItem(this.menu_thumb, 2);
        GeneralPurposeGUI.createIconMenuItem(this.menu_thumb, 0, this.settings, this.settings.msg("dialog.main.thumb.openfolder"), "folder.png", (SelectionListener)selectionAdapter2);
        GeneralPurposeGUI.createIconMenuItem(this.menu_thumb, 0, this.settings, this.settings.msg("dialog.main.thumb.refresh"), "refresh.png", (SelectionListener)selectionAdapter3);
    }

    private void toggleProfileViewType(ViewType viewType, SelectionAdapter selectionAdapter, MouseAdapter mouseAdapter, KeyAdapter keyAdapter, TraverseListener traverseListener, SelectionAdapter selectionAdapter2, SelectionAdapter selectionAdapter3, SelectionAdapter selectionAdapter4, SelectionAdapter selectionAdapter5, SelectionAdapter selectionAdapter6, SelectionAdapter selectionAdapter7, SelectionAdapter selectionAdapter8, SelectionAdapter selectionAdapter9, SelectionAdapter selectionAdapter10, SelectionAdapter selectionAdapter11) {
        this.viewSelector.setImage(SWTImageManager.getResourceImage(this.shell.getDisplay(), viewType.getImage()));
        this.viewSelector.setToolTipText(viewType.getDisplayName());
        this.settings.getSettings().setValue("gui", "viewstyle", viewType.getName().toLowerCase());
        Set<Integer> set = this.getSelectedProfileIds();
        this.viewSelector.setEnabled(false);
        Display.getCurrent().timerExec(250, new Runnable(){

            @Override
            public void run() {
                MainWindow.this.viewSelector.setEnabled(true);
            }
        });
        this.disposeProfilesList();
        this.constructProfilesList();
        this.updateProfilesList(set);
        this.filterFolder.layout(true);
    }

    private void disposeProfilesList() {
        for (CTabItem cTabItem : this.filterFolder.getItems()) {
            cTabItem.setControl(null);
        }
        this.profile_table.dispose();
    }

    private void constructProfilesList() {
        CTabItem cTabItem2;
        this.profile_table = this.settings.getSettings().getValue("gui", "viewstyle").equalsIgnoreCase(ProfilesList.ProfilesListType.SMALL_TILES.toString()) ? new ProfilesList((Composite)this.filterFolder, ProfilesList.ProfilesListType.SMALL_TILES) : (this.settings.getSettings().getValue("gui", "viewstyle").equalsIgnoreCase(ProfilesList.ProfilesListType.MEDIUM_TILES.toString()) ? new ProfilesList((Composite)this.filterFolder, ProfilesList.ProfilesListType.MEDIUM_TILES) : (this.settings.getSettings().getValue("gui", "viewstyle").equalsIgnoreCase(ProfilesList.ProfilesListType.LARGE_TILES.toString()) ? new ProfilesList((Composite)this.filterFolder, ProfilesList.ProfilesListType.LARGE_TILES) : (this.settings.getSettings().getValue("gui", "viewstyle").equalsIgnoreCase(ProfilesList.ProfilesListType.SMALL_BOXES.toString()) ? new ProfilesList((Composite)this.filterFolder, ProfilesList.ProfilesListType.SMALL_BOXES) : (this.settings.getSettings().getValue("gui", "viewstyle").equalsIgnoreCase(ProfilesList.ProfilesListType.MEDIUM_BOXES.toString()) ? new ProfilesList((Composite)this.filterFolder, ProfilesList.ProfilesListType.MEDIUM_BOXES) : (this.settings.getSettings().getValue("gui", "viewstyle").equalsIgnoreCase(ProfilesList.ProfilesListType.LARGE_BOXES.toString()) ? new ProfilesList((Composite)this.filterFolder, ProfilesList.ProfilesListType.LARGE_BOXES) : new ProfilesList((Composite)this.filterFolder, ProfilesList.ProfilesListType.TABLE, this, this.columnIds, columnNames))))));
        for (CTabItem cTabItem2 : this.filterFolder.getItems()) {
            cTabItem2.setControl(this.profile_table.getControl());
        }
        this.profile_table.addMouseListener(this.mouseAdapter);
        this.profile_table.addKeyListener(this.keyAdapter);
        this.profile_table.addTraverseListener(this.travListener);
        this.profile_table.addSelectionListener(this.selectProfAdapter);
        int n = 19;
        DropTarget dropTarget = new DropTarget(this.profile_table.getControl(), n);
        Transfer[] transferArray = new Transfer[]{FileTransfer.getInstance()};
        dropTarget.setTransfer(transferArray);
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent dropTargetEvent) {
                String[] stringArray = (String[])dropTargetEvent.data;
                if (stringArray != null && stringArray.length == 1) {
                    MainWindow.this.doAddProfile(stringArray[0]);
                }
            }
        });
        cTabItem2 = new Menu(this.profile_table.getControl());
        this.profile_table.setMenu((Menu)cTabItem2);
        new MenuItem((Menu)cTabItem2, 2);
        GeneralPurposeGUI.createIconMenuItem((Menu)cTabItem2, 0, this.settings, this.settings.msg("dialog.main.profile.openfolder"), "folder.png", (SelectionListener)this.openProfAdapter);
        GeneralPurposeGUI.createIconMenuItem((Menu)cTabItem2, 0, this.settings, this.settings.msg("dialog.main.profile.opencapturesfolder"), "folder.png", (SelectionListener)this.openCapturesAdapter);
        MenuItem menuItem = GeneralPurposeGUI.createIconMenuItem((Menu)cTabItem2, 64, this.settings, this.settings.msg("dialog.main.profile.view"), "zoom.png", null);
        this.viewProfileSubMenu = new Menu(menuItem);
        menuItem.setMenu(this.viewProfileSubMenu);
        new MenuItem((Menu)cTabItem2, 2);
        GeneralPurposeGUI.createIconMenuItem((Menu)cTabItem2, 0, this.settings, this.settings.msg("dialog.main.profile.add"), "new.png", (SelectionListener)this.addProfAdapter);
        GeneralPurposeGUI.createIconMenuItem((Menu)cTabItem2, 0, this.settings, this.settings.msg("dialog.main.profile.edit"), "edit.png", (SelectionListener)this.editProfAdapter);
        GeneralPurposeGUI.createIconMenuItem((Menu)cTabItem2, 0, this.settings, this.settings.msg("dialog.main.profile.duplicate"), "duplicate.png", (SelectionListener)this.duplicateProfAdapter);
        GeneralPurposeGUI.createIconMenuItem((Menu)cTabItem2, 0, this.settings, this.settings.msg("dialog.main.profile.remove"), "delete.png", (SelectionListener)this.removeProfAdapter);
        new MenuItem((Menu)cTabItem2, 2);
        GeneralPurposeGUI.createIconMenuItem((Menu)cTabItem2, 0, this.settings, this.settings.msg("dialog.main.profile.togglefavorite"), "favorite.png", (SelectionListener)this.toggleProfAdapter);
        if (PlatformUtils.IS_WINDOWS || PlatformUtils.IS_LINUX) {
            new MenuItem((Menu)cTabItem2, 2);
            GeneralPurposeGUI.createIconMenuItem((Menu)cTabItem2, 0, this.settings, this.settings.msg("dialog.main.profile.createshortcut"), "shortcut.png", (SelectionListener)this.shortcutProfAdapter);
        }
        cTabItem2.addMenuListener((MenuListener)new MenuAdapter((Menu)cTabItem2){
            final /* synthetic */ Menu val$menu;
            {
                this.val$menu = menu;
            }

            public void menuShown(MenuEvent menuEvent) {
                if (MainWindow.this.profile_table.getSelectionIndex() != -1) {
                    MenuItem menuItem;
                    Profile profile = (Profile)MainWindow.this.profilesList.get(MainWindow.this.profile_table.getSelectionIndex());
                    for (MenuItem menuItem2 : this.val$menu.getItems()) {
                        if (menuItem2.getStyle() == 2) break;
                        menuItem2.dispose();
                    }
                    if (MainWindow.this.dbversionsList.size() > 1) {
                        menuItem = GeneralPurposeGUI.createIconTopMenuItem(this.val$menu, 64, MainWindow.this.settings, MainWindow.this.settings.msg("dialog.main.profile.startmanuallywith"), null, null);
                        menuItem.setMenu(MainWindow.this.createDosboxVersionsSubmenu(this.val$menu, -1, true));
                    }
                    GeneralPurposeGUI.createIconTopMenuItem(this.val$menu, 0, MainWindow.this.settings, MainWindow.this.settings.msg("dialog.main.profile.startmanually"), null, (SelectionListener)MainWindow.this.prepareProfAdapter);
                    if (profile.hasSetup(2)) {
                        if (MainWindow.this.dbversionsList.size() > 1) {
                            menuItem = GeneralPurposeGUI.createIconTopMenuItem(this.val$menu, 64, MainWindow.this.settings, new File(profile.getSetup(2)).getName(), null, null);
                            menuItem.setMenu(MainWindow.this.createDosboxVersionsSubmenu(this.val$menu, 2, false));
                        }
                        GeneralPurposeGUI.createIconTopMenuItem(this.val$menu, 0, MainWindow.this.settings, new File(profile.getSetup(2)).getName(), null, (SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent selectionEvent) {
                                MainWindow.this.doRunProfile(2, false);
                            }
                        });
                    }
                    if (profile.hasSetup(1)) {
                        if (MainWindow.this.dbversionsList.size() > 1) {
                            menuItem = GeneralPurposeGUI.createIconTopMenuItem(this.val$menu, 64, MainWindow.this.settings, new File(profile.getSetup(1)).getName(), null, null);
                            menuItem.setMenu(MainWindow.this.createDosboxVersionsSubmenu(this.val$menu, 1, false));
                        }
                        GeneralPurposeGUI.createIconTopMenuItem(this.val$menu, 0, MainWindow.this.settings, new File(profile.getSetup(1)).getName(), null, (SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent selectionEvent) {
                                MainWindow.this.doRunProfile(1, false);
                            }
                        });
                    }
                    boolean bl = profile.hasSetup(0);
                    MainWindow.this.setupToolItem.setEnabled(bl);
                    if (bl) {
                        if (MainWindow.this.dbversionsList.size() > 1) {
                            MenuItem menuItem3 = GeneralPurposeGUI.createIconTopMenuItem(this.val$menu, 64, MainWindow.this.settings, MainWindow.this.settings.msg("dialog.main.profile.setupwith"), null, null);
                            menuItem3.setMenu(MainWindow.this.createDosboxVersionsSubmenu(this.val$menu, 0, false));
                        }
                        GeneralPurposeGUI.createIconTopMenuItem(this.val$menu, 0, MainWindow.this.settings, MainWindow.this.settings.msg("dialog.main.profile.setup"), "setup.png", (SelectionListener)MainWindow.this.setupProfAdapter);
                    }
                    if (MainWindow.this.dbversionsList.size() > 1) {
                        MenuItem menuItem4 = GeneralPurposeGUI.createIconTopMenuItem(this.val$menu, 64, MainWindow.this.settings, MainWindow.this.settings.msg("dialog.main.profile.runwith"), null, null);
                        menuItem4.setMenu(MainWindow.this.createDosboxVersionsSubmenu(this.val$menu, -1, false));
                    }
                    GeneralPurposeGUI.createIconTopMenuItem(this.val$menu, 0, MainWindow.this.settings, MainWindow.this.settings.msg("dialog.main.profile.run"), "run.png", (SelectionListener)MainWindow.this.runProfAdapter);
                }
            }
        });
    }

    protected void doStartGameWizard() {
        this.updateWithAddedProfile((Profile)new AddGameWizardDialog(this.shell, 0).open());
    }

    private CTabItem addFilterTab(Filter filter) {
        CTabItem cTabItem = new CTabItem(this.filterFolder, filter.getFilter() == null ? 0 : 64);
        cTabItem.setText("    " + filter.getTitle() + "    ");
        cTabItem.setData((Object)filter.getId());
        return cTabItem;
    }

    private void createDosboxVersionsTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(this.settings.msg("dialog.main.dosboxversions"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new BorderLayout(0, 0));
        tabItem.setControl((Control)composite);
        ToolBar toolBar = new ToolBar(composite, 0);
        toolBar.setLayoutData((Object)"North");
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MainWindow.this.doAddDosboxVersion();
            }
        };
        SelectionAdapter selectionAdapter2 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MainWindow.this.doEditDosboxVersion();
            }
        };
        SelectionAdapter selectionAdapter3 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MainWindow.this.doRemoveDosboxVersion();
            }
        };
        SelectionAdapter selectionAdapter4 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MainWindow.this.doRunDosbox();
            }
        };
        SelectionAdapter selectionAdapter5 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MainWindow.this.doToggleDefaultVersion();
            }
        };
        SelectionAdapter selectionAdapter6 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = MainWindow.this.dbversion_table.getSelectionIndex();
                if (n != -1) {
                    PlatformUtils.openDirForViewing(((DosboxVersion)MainWindow.this.dbversionsList.get(n)).getCanonicalConfFile().getParentFile());
                }
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                MainWindow.this.doRunDosbox();
            }
        };
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 127 || keyEvent.stateMask == SWT.MOD1 && Character.toLowerCase(keyEvent.keyCode) == 114) {
                    MainWindow.this.doRemoveDosboxVersion();
                } else if (keyEvent.keyCode == 0x1000009 || keyEvent.stateMask == SWT.MOD1 && Character.toLowerCase(keyEvent.keyCode) == 110) {
                    MainWindow.this.doAddDosboxVersion();
                } else if (keyEvent.stateMask == SWT.MOD1 && Character.toLowerCase(keyEvent.keyCode) == 109) {
                    MainWindow.this.doToggleDefaultVersion();
                }
            }
        };
        TraverseListener traverseListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.stateMask == SWT.MOD1 && traverseEvent.detail == 4) {
                    MainWindow.this.doEditDosboxVersion();
                } else if (traverseEvent.detail == 4) {
                    MainWindow.this.doRunDosbox();
                }
            }
        };
        SelectionAdapter selectionAdapter7 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = MainWindow.this.dbversion_table.getSelectionIndex();
                if (n != -1) {
                    MainWindow.this.updateViewDosboxSubmenu((DosboxVersion)MainWindow.this.dbversionsList.get(n));
                }
            }
        };
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.addversion"), "tb_new.png", (SelectionListener)selectionAdapter);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.editversion"), "tb_edit.png", (SelectionListener)selectionAdapter2);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.removeversion"), "tb_delete.png", (SelectionListener)selectionAdapter3);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.runversion"), "tb_run.png", (SelectionListener)selectionAdapter4);
        this.dbversion_table = new Table(composite, 67584);
        this.dbversion_table.setLinesVisible(true);
        this.dbversion_table.setHeaderVisible(true);
        this.addDBColumn(this.settings.msg("dialog.main.dosboxversions.column.title"), 0);
        this.addDBColumn(this.settings.msg("dialog.main.dosboxversions.column.version"), 1);
        this.addDBColumn(this.settings.msg("dialog.main.dosboxversions.column.path"), 2);
        this.addDBColumn(this.settings.msg("dialog.main.dosboxversions.column.default"), 3);
        this.addDBColumn(this.settings.msg("dialog.main.dosboxversions.column.id"), 4);
        this.addDBColumn(this.settings.msg("dialog.main.generic.column.created"), 5);
        this.addDBColumn(this.settings.msg("dialog.main.generic.column.lastmodify"), 6);
        this.addDBColumn(this.settings.msg("dialog.main.generic.column.lastrun"), 7);
        this.addDBColumn(this.settings.msg("dialog.main.generic.column.runs"), 8);
        Menu menu = new Menu((Control)this.dbversion_table);
        this.dbversion_table.setMenu(menu);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.dosboxversion.run"), "run.png", (SelectionListener)selectionAdapter4);
        new MenuItem(menu, 2);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.dosboxversion.openfolder"), "folder.png", (SelectionListener)selectionAdapter6);
        MenuItem menuItem = GeneralPurposeGUI.createIconMenuItem(menu, 64, this.settings, this.settings.msg("dialog.main.profile.view"), "zoom.png", null);
        this.viewDosboxSubMenu = new Menu(menuItem);
        menuItem.setMenu(this.viewDosboxSubMenu);
        new MenuItem(menu, 2);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.dosboxversion.add"), "new.png", (SelectionListener)selectionAdapter);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.dosboxversion.edit"), "edit.png", (SelectionListener)selectionAdapter2);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.dosboxversion.remove"), "delete.png", (SelectionListener)selectionAdapter3);
        new MenuItem(menu, 2);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.dosboxversion.toggledefault"), "home.png", (SelectionListener)selectionAdapter5);
        this.dbversion_table.addKeyListener((KeyListener)keyAdapter);
        this.dbversion_table.addTraverseListener(traverseListener);
        this.dbversion_table.addMouseListener((MouseListener)mouseAdapter);
        this.dbversion_table.addSelectionListener((SelectionListener)selectionAdapter7);
    }

    private void createTemplatesTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(this.settings.msg("dialog.main.templates"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new BorderLayout(0, 0));
        tabItem.setControl((Control)composite);
        ToolBar toolBar = new ToolBar(composite, 0);
        toolBar.setLayoutData((Object)"North");
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MainWindow.this.doAddTemplate();
            }
        };
        SelectionAdapter selectionAdapter2 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MainWindow.this.doEditTemplate();
            }
        };
        SelectionAdapter selectionAdapter3 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MainWindow.this.doDuplicateTemplate();
            }
        };
        SelectionAdapter selectionAdapter4 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MainWindow.this.doRemoveTemplate();
            }
        };
        SelectionAdapter selectionAdapter5 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MainWindow.this.doRunTemplate();
            }
        };
        SelectionAdapter selectionAdapter6 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MainWindow.this.doToggleDefaultTemplate();
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                MainWindow.this.doRunTemplate();
            }
        };
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 127 || keyEvent.stateMask == SWT.MOD1 && Character.toLowerCase(keyEvent.keyCode) == 114) {
                    MainWindow.this.doRemoveTemplate();
                } else if (keyEvent.keyCode == 0x1000009 || keyEvent.stateMask == SWT.MOD1 && Character.toLowerCase(keyEvent.keyCode) == 110) {
                    MainWindow.this.doAddTemplate();
                } else if (keyEvent.stateMask == SWT.MOD1 && Character.toLowerCase(keyEvent.keyCode) == 109) {
                    MainWindow.this.doToggleDefaultTemplate();
                }
            }
        };
        TraverseListener traverseListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.stateMask == SWT.MOD1 && traverseEvent.detail == 4) {
                    MainWindow.this.doEditTemplate();
                } else if (traverseEvent.detail == 4) {
                    MainWindow.this.doRunTemplate();
                }
            }
        };
        SelectionAdapter selectionAdapter7 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = MainWindow.this.template_table.getSelectionIndex();
                if (n != -1) {
                    MainWindow.this.updateViewTemplateSubmenu((Template)MainWindow.this.templatesList.get(n));
                }
            }
        };
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.addtemplate"), "tb_new.png", (SelectionListener)selectionAdapter);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.edittemplate"), "tb_edit.png", (SelectionListener)selectionAdapter2);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.removetemplate"), "tb_delete.png", (SelectionListener)selectionAdapter4);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.runtemplate"), "tb_run.png", (SelectionListener)selectionAdapter5);
        this.template_table = new Table(composite, 67584);
        this.template_table.setLinesVisible(true);
        this.template_table.setHeaderVisible(true);
        this.addTemplateColumn(this.settings.msg("dialog.main.templates.column.title"), 0);
        this.addTemplateColumn(this.settings.msg("dialog.main.templates.column.default"), 1);
        this.addTemplateColumn(this.settings.msg("dialog.main.templates.column.id"), 2);
        this.addTemplateColumn(this.settings.msg("dialog.main.generic.column.created"), 3);
        this.addTemplateColumn(this.settings.msg("dialog.main.generic.column.lastmodify"), 4);
        this.addTemplateColumn(this.settings.msg("dialog.main.generic.column.lastrun"), 5);
        this.addTemplateColumn(this.settings.msg("dialog.main.generic.column.runs"), 6);
        Menu menu = new Menu((Control)this.template_table);
        this.template_table.setMenu(menu);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.template.run"), "run.png", (SelectionListener)selectionAdapter5);
        new MenuItem(menu, 2);
        MenuItem menuItem = GeneralPurposeGUI.createIconMenuItem(menu, 64, this.settings, this.settings.msg("dialog.main.profile.view"), "zoom.png", null);
        this.viewTemplateSubMenu = new Menu(menuItem);
        menuItem.setMenu(this.viewTemplateSubMenu);
        new MenuItem(menu, 2);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.template.add"), "new.png", (SelectionListener)selectionAdapter);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.template.edit"), "edit.png", (SelectionListener)selectionAdapter2);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.template.duplicate"), "duplicate.png", (SelectionListener)selectionAdapter3);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.template.remove"), "delete.png", (SelectionListener)selectionAdapter4);
        new MenuItem(menu, 2);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.template.toggledefault"), "home.png", (SelectionListener)selectionAdapter6);
        this.template_table.addKeyListener((KeyListener)keyAdapter);
        this.template_table.addTraverseListener(traverseListener);
        this.template_table.addMouseListener((MouseListener)mouseAdapter);
        this.template_table.addSelectionListener((SelectionListener)selectionAdapter7);
    }

    private void doOpenAbout() {
        new AboutDialog(this.shell, 0).open();
    }

    private void createFileMenu() {
        MenuItem menuItem;
        MenuItem menuItem2;
        MenuItem menuItem3;
        MenuItem menuItem4;
        Menu menu;
        Menu menu2 = this.display.getMenuBar();
        if (menu2 == null) {
            menu2 = new Menu((Decorations)this.shell, 2);
            this.shell.setMenuBar(menu2);
        }
        if ((menu = this.display.getSystemMenu()) != null) {
            menuItem4 = MainWindow.getMenuItemById(menu, -2);
            menuItem4.addSelectionListener((SelectionListener)this.settingsAdapter);
            menuItem3 = MainWindow.getMenuItemById(menu, -1);
            menuItem3.addSelectionListener((SelectionListener)this.openAboutAdapter);
            int n = menu.indexOf(MainWindow.getMenuItemById(menu, -2));
            menuItem2 = new MenuItem(menu, 64, n + 1);
            menuItem2.setText(this.settings.msg("dialog.main.menu.log"));
            menuItem2.addSelectionListener((SelectionListener)this.logAdapter);
            menuItem = new MenuItem(menu, 64, n + 2);
            menuItem.setText(this.settings.msg("dialog.main.menu.databasecleanup"));
            menuItem.addSelectionListener((SelectionListener)this.cleanupAdapter);
        } else {
            menuItem4 = new MenuItem(menu2, 64);
            menuItem4.setText(this.settings.msg("dialog.main.menu.file"));
            menuItem3 = new Menu(menuItem4);
            menuItem4.setMenu((Menu)menuItem3);
            GeneralPurposeGUI.createIconMenuItem((Menu)menuItem3, 0, this.settings, this.settings.msg("dialog.main.menu.adjustsettings"), "settings.png", (SelectionListener)this.settingsAdapter);
            GeneralPurposeGUI.createIconMenuItem((Menu)menuItem3, 0, this.settings, this.settings.msg("dialog.main.menu.log"), "log.png", (SelectionListener)this.logAdapter);
            GeneralPurposeGUI.createIconMenuItem((Menu)menuItem3, 0, this.settings, this.settings.msg("dialog.main.menu.databasecleanup"), "clean.png", (SelectionListener)this.cleanupAdapter);
            GeneralPurposeGUI.createIconMenuItem((Menu)menuItem3, 0, this.settings, this.settings.msg("dialog.main.menu.exit"), "stop.png", (SelectionListener)this.exitAdapter);
        }
        menuItem4 = new MenuItem(menu2, 64);
        menuItem4.setText(this.settings.msg("dialog.main.menu.profiles"));
        menuItem3 = new Menu(menuItem4);
        menuItem4.setMenu((Menu)menuItem3);
        GeneralPurposeGUI.createIconMenuItem((Menu)menuItem3, 0, this.settings, this.settings.msg("dialog.main.menu.import"), "import.png", SWT.MOD1 | SWT.MOD3 | 0x49, (SelectionListener)this.importAdapter);
        GeneralPurposeGUI.createIconMenuItem((Menu)menuItem3, 0, this.settings, this.settings.msg("dialog.main.menu.importprofile"), "import.png", (SelectionListener)this.importConfAdapter);
        GeneralPurposeGUI.createIconMenuItem((Menu)menuItem3, 0, this.settings, this.settings.msg("dialog.main.menu.importdfendprofiles"), "dfend.png", (SelectionListener)this.dfendAdapter);
        new MenuItem((Menu)menuItem3, 2);
        GeneralPurposeGUI.createIconMenuItem((Menu)menuItem3, 0, this.settings, this.settings.msg("dialog.main.menu.export"), "checkout.png", SWT.MOD1 | SWT.MOD3 | 0x45, (SelectionListener)this.exportAdapter);
        GeneralPurposeGUI.createIconMenuItem((Menu)menuItem3, 0, this.settings, this.settings.msg("dialog.main.menu.exportprofileslist"), "checkout.png", (SelectionListener)this.exportListAdapter);
        new MenuItem((Menu)menuItem3, 2);
        GeneralPurposeGUI.createIconMenuItem((Menu)menuItem3, 0, this.settings, this.settings.msg("dialog.main.menu.migrateprofiles"), "case.png", (SelectionListener)this.migrateAdapter);
        MenuItem menuItem5 = new MenuItem(menu2, 64);
        menuItem5.setText(this.settings.msg("dialog.main.menu.dosboxversions"));
        menuItem2 = new Menu(menuItem5);
        menuItem5.setMenu((Menu)menuItem2);
        GeneralPurposeGUI.createIconMenuItem((Menu)menuItem2, 0, this.settings, this.settings.msg("dialog.main.menu.locatedosbox"), "zoom.png", (SelectionListener)this.locateDosboxAdapter);
        menuItem = new MenuItem(menu2, 64);
        menuItem.setText(this.settings.msg("dialog.main.menu.templates"));
        Menu menu3 = new Menu(menuItem);
        menuItem.setMenu(menu3);
        if (PlatformUtils.IS_WINDOWS && PlatformUtils.IS_LINUX) {
            GeneralPurposeGUI.createIconMenuItem(menu3, 0, this.settings, this.settings.msg("dialog.main.menu.exporttemplates"), "checkout.png", (SelectionListener)this.exportTemplatesAdapter);
        }
        GeneralPurposeGUI.createIconMenuItem(menu3, 0, this.settings, this.settings.msg("dialog.main.menu.importdefaulttemplates"), "import.png", (SelectionListener)this.importDefaultTemplatesAdapter);
        MenuItem menuItem6 = new MenuItem(menu2, 64);
        menuItem6.setText(this.settings.msg("dialog.main.menu.filter"));
        Menu menu4 = new Menu(menuItem6);
        menuItem6.setMenu(menu4);
        GeneralPurposeGUI.createIconMenuItem(menu4, 0, this.settings, this.settings.msg("dialog.main.menu.addfilter"), "filter.png", (SelectionListener)this.addFilterAdapter);
        GeneralPurposeGUI.createIconMenuItem(menu4, 0, this.settings, this.settings.msg("dialog.main.menu.editfilter"), "editfilter.png", (SelectionListener)this.editFilterAdapter);
        if (menu == null) {
            MenuItem menuItem7 = new MenuItem(menu2, 64);
            menuItem7.setText(this.settings.msg("dialog.main.menu.help"));
            Menu menu5 = new Menu(menuItem7);
            menuItem7.setMenu(menu5);
            GeneralPurposeGUI.createIconMenuItem(menu5, 0, this.settings, this.settings.msg("dialog.main.menu.about"), "about.png", (SelectionListener)this.openAboutAdapter);
        }
    }

    private static MenuItem getMenuItemById(Menu menu, int n) {
        for (MenuItem menuItem : menu.getItems()) {
            if (menuItem.getID() != n) continue;
            return menuItem;
        }
        return null;
    }

    private void doExportProfiles() {
        ProfileLoader profileLoader;
        if (this.profile_table.getSelectionIndex() != -1 && (profileLoader = new ProfileLoader(this.shell, this.getSelectedProfiles(), false)).open() != null) {
            new ExportDialog(this.shell, this.dbversionsList, profileLoader.getResult()).open();
        }
    }

    private void doImportProfiles() {
        FileDialog fileDialog = new FileDialog(this.shell, 4096);
        fileDialog.setFilterNames(new String[]{"GamePack Archives", "DOSBox configuration files", "Executables, Booter Disk Images", "*"});
        fileDialog.setFilterExtensions(new String[]{"*.zip;*.ZIP;*.7z;*.7Z", "*.conf;*.CONF", "*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT;*.cp2;*.CP2;*.dcf;*.DCF;*.img;*.IMG;*.jrc;*.JRC;*.td0;*.TD0", "*"});
        String string = fileDialog.open();
        if (string != null) {
            this.doAddProfile(string);
        }
    }

    private static Map<String, String> getEnv(SectionsWrapper sectionsWrapper) {
        if (sectionsWrapper.getBooleanValue("environment", "use")) {
            return StringRelatedUtils.stringArrayToMap(sectionsWrapper.getValues("environment", "value"));
        }
        return null;
    }

    private void updateProfilesAfterTabAction() {
        int n = this.filterFolder.getSelectionIndex();
        this.ssettings.setValue("gui", "filtertab", String.valueOf(n));
        this.filterClause = this.filtersList.get(n).getFilter();
        this.updateProfilesList(this.getSelectedProfileIds());
        for (CTabItem cTabItem : this.filterFolder.getItems()) {
            cTabItem.setToolTipText(null);
        }
        this.filterFolder.getSelection().setToolTipText(this.settings.msg("dialog.filter.notice.results", new Object[]{this.profilesList.size()}));
        this.displayProfileInformation(false);
    }

    private void doViewProfileConf() {
        int n = this.profile_table.getSelectionIndex();
        if (n != -1) {
            PlatformUtils.openForEditing(this.profilesList.get(n).getCanonicalConfFile());
        }
    }

    private Set<Integer> getSelectedProfileIds() {
        int[] nArray = this.profile_table.getSelectionIndices();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int n : nArray) {
            hashSet.add(this.profilesList.get(n).getId());
        }
        return hashSet;
    }

    private List<Profile> getSelectedProfiles() {
        int[] nArray = this.profile_table.getSelectionIndices();
        ArrayList<Profile> arrayList = new ArrayList<Profile>();
        for (int n : nArray) {
            arrayList.add(this.profilesList.get(n));
        }
        return arrayList;
    }

    private int[] getIndicesByIds(Set<Integer> set) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.profilesList.size(); ++i) {
            if (!set.contains(this.profilesList.get(i).getId())) continue;
            arrayList.add(i);
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return nArray;
    }

    public static void openSendToProfileDialog(String string) {
        Database database = Database.getInstance();
        Shell shell = new Shell();
        shell.setMinimized(true);
        shell.open();
        try {
            List<DosboxVersion> list = database.readDosboxVersionsList();
            if (DosboxVersion.findDefault(list) == null) {
                GeneralPurposeDialogs.infoMessage(shell, Settings.getInstance().msg("dialog.main.required.defaultdosboxversion"));
                try {
                    database.shutdown();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return;
            }
            if (FileUtils.isGamePackArchiveFile(string)) {
                ImportDialog importDialog = new ImportDialog(shell, list, new File(string));
                importDialog.open();
            } else {
                EditProfileDialog editProfileDialog = new EditProfileDialog(shell);
                editProfileDialog.sendToProfile(string);
                editProfileDialog.open();
            }
        }
        catch (SQLException sQLException) {
            GeneralPurposeDialogs.warningMessage(shell, sQLException);
        }
        try {
            database.shutdown();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

