/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.GeneralPurposeGUI;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.conf.SectionsWrapper;
import org.dbgl.model.conf.Settings;
import org.dbgl.model.conf.SharedConf;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.StringRelatedUtils;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import swing2swt.layout.BorderLayout;

public final class ShareConfDialog
extends Dialog {
    private Text author;
    private Text gameTitle;
    private Text gameVersion;
    private Text gameYear;
    private Text explanation;
    private Text notes;
    private Tree incrConf;
    private SharedConf sharedConf;
    private Shell shell;
    private Settings settings;

    public ShareConfDialog(Shell shell, String string, String string2, String string3, String string4, DosboxVersion dosboxVersion) {
        super(shell, 0);
        this.sharedConf = new SharedConf("", "", string, "", string2, string3, string4, "", dosboxVersion.getTitle(), dosboxVersion.getVersion());
    }

    public Object open() {
        this.settings = Settings.getInstance();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.sharedConf;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "shareconfdialog"));
        this.shell.setText(this.settings.msg("dialog.confsharing.title"));
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(this.settings.msg("dialog.confsharing.tab.info"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        tabItem.setControl((Control)composite);
        Label label = new Label(composite, 0);
        label.setText(this.settings.msg("dialog.confsharing.author"));
        this.author = new Text(composite, 2048);
        this.author.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label label2 = new Label(composite, 0);
        label2.setText(this.settings.msg("dialog.confsharing.gametitle"));
        this.gameTitle = new Text(composite, 2048);
        this.gameTitle.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label label3 = new Label(composite, 0);
        label3.setText(this.settings.msg("dialog.confsharing.gameversion"));
        this.gameVersion = new Text(composite, 2048);
        this.gameVersion.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label label4 = new Label(composite, 0);
        label4.setText(this.settings.msg("dialog.confsharing.gameyear"));
        this.gameYear = new Text(composite, 2048);
        this.gameYear.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label label5 = new Label(composite, 0);
        label5.setText(this.settings.msg("dialog.confsharing.explanation"));
        this.incrConf = new Tree(composite, 2080);
        this.incrConf.setLayoutData((Object)new GridData(4, 4, false, true));
        this.explanation = new Text(composite, 2626);
        this.explanation.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label6 = new Label(composite, 0);
        label6.setText(this.settings.msg("dialog.confsharing.notes"));
        this.notes = new Text(composite, 2626);
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        gridData.minimumHeight = 3 * this.notes.getLineHeight();
        this.notes.setLayoutData((Object)gridData);
        Composite composite2 = new Composite((Composite)this.shell, 0);
        composite2.setLayout((Layout)new GridLayout(2, true));
        composite2.setLayoutData((Object)"South");
        Button button = new Button(composite2, 0);
        this.shell.setDefaultButton(button);
        button.setText(this.settings.msg("button.ok"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!ShareConfDialog.this.isValid()) {
                    return;
                }
                try {
                    ShareConfDialog.this.sharedConf.setAuthor(ShareConfDialog.this.author.getText());
                    ShareConfDialog.this.sharedConf.setGameTitle(ShareConfDialog.this.gameTitle.getText());
                    ShareConfDialog.this.sharedConf.setGameVersion(ShareConfDialog.this.gameVersion.getText());
                    ShareConfDialog.this.sharedConf.setGameYear(ShareConfDialog.this.gameYear.getText());
                    ShareConfDialog.this.sharedConf.setIncrConf(ShareConfDialog.this.extractConfFromTree(ShareConfDialog.this.incrConf));
                    ShareConfDialog.this.sharedConf.setExplanation(ShareConfDialog.this.explanation.getText());
                    ShareConfDialog.this.sharedConf.setNotes(ShareConfDialog.this.notes.getText());
                    Client client = ClientBuilder.newClient();
                    SharedConf sharedConf = (SharedConf)client.target(ShareConfDialog.this.settings.getSettings().getValue("confsharing", "endpoint")).path("/submissions").request().post(Entity.entity((Object)ShareConfDialog.this.sharedConf, (String)"application/xml"), SharedConf.class);
                    GeneralPurposeDialogs.infoMessage(ShareConfDialog.this.shell, ShareConfDialog.this.settings.msg("dialog.confsharing.confirmation", new Object[]{sharedConf.getGameTitle()}));
                    client.close();
                }
                catch (Exception exception) {
                    GeneralPurposeDialogs.fatalMessage(ShareConfDialog.this.shell, ShareConfDialog.this.settings.msg("dialog.confsharing.error.submit", new Object[]{StringRelatedUtils.toString(exception)}), exception);
                }
                ShareConfDialog.this.settings.getSettings().setValue("confsharing", "author", ShareConfDialog.this.author.getText());
                ShareConfDialog.this.shell.close();
            }
        });
        Button button2 = new Button(composite2, 0);
        button2.setText(this.settings.msg("button.cancel"));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ShareConfDialog.this.sharedConf = null;
                ShareConfDialog.this.shell.close();
            }
        });
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.widthHint = GeneralPurposeGUI.getWidth(button, button2);
        button.setLayoutData((Object)gridData2);
        button2.setLayoutData((Object)gridData2);
        this.author.setText(this.settings.getSettings().getValue("confsharing", "author"));
        this.gameTitle.setText(this.sharedConf.getGameTitle());
        this.gameYear.setText(this.sharedConf.getGameYear());
        this.fillStringIntoTree(this.sharedConf.getIncrConf(), this.incrConf);
        if (StringUtils.isBlank((CharSequence)this.sharedConf.getIncrConf())) {
            this.explanation.setText("N/A");
        }
        if (StringUtils.isBlank((CharSequence)this.gameTitle.getText())) {
            this.gameTitle.setFocus();
        } else if (StringUtils.isBlank((CharSequence)this.gameYear.getText())) {
            this.gameYear.setFocus();
        } else if (StringUtils.isBlank((CharSequence)this.explanation.getText())) {
            this.explanation.setFocus();
        } else {
            this.notes.setFocus();
        }
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (StringUtils.isBlank((CharSequence)this.author.getText())) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.confsharing.required.author"), (Control)this.author);
        }
        if (StringUtils.isBlank((CharSequence)this.gameTitle.getText())) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.confsharing.required.gametitle"), (Control)this.gameTitle);
        }
        if (StringUtils.isBlank((CharSequence)this.gameYear.getText())) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.confsharing.required.gameyear"), (Control)this.gameYear);
        }
        if (StringUtils.isBlank((CharSequence)this.explanation.getText())) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.confsharing.required.explanation"), (Control)this.explanation);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }

    private void fillStringIntoTree(String string, Tree tree) {
        String[] stringArray = StringUtils.split((String)string, (String)PlatformUtils.EOLN);
        TreeItem treeItem = null;
        for (String string2 : stringArray) {
            if (string2.startsWith("[")) {
                treeItem = new TreeItem(tree, 0);
                treeItem.setText(string2);
                treeItem.setChecked(true);
                continue;
            }
            TreeItem treeItem2 = new TreeItem(treeItem, 0);
            treeItem2.setText(string2);
            treeItem2.setChecked(true);
        }
        for (String string2 : tree.getItems()) {
            string2.setExpanded(true);
        }
        tree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    TreeItem treeItem = (TreeItem)event.item;
                    if (treeItem.getParentItem() == null) {
                        treeItem.setGrayed(false);
                        for (TreeItem treeItem2 : treeItem.getItems()) {
                            treeItem2.setChecked(treeItem.getChecked());
                        }
                    } else {
                        TreeItem treeItem3;
                        int n = ShareConfDialog.this.getCheckedItemsCount(treeItem3 = treeItem.getParentItem());
                        treeItem3.setChecked(n > 0);
                        treeItem3.setGrayed(n > 0 && n < treeItem3.getItemCount());
                    }
                }
            }
        });
    }

    private int getCheckedItemsCount(TreeItem treeItem) {
        int n = 0;
        for (TreeItem treeItem2 : treeItem.getItems()) {
            if (!treeItem2.getChecked()) continue;
            ++n;
        }
        return n;
    }

    private String extractConfFromTree(Tree tree) {
        SectionsWrapper sectionsWrapper = new SectionsWrapper();
        for (TreeItem treeItem : tree.getItems()) {
            if (!treeItem.getChecked()) continue;
            for (TreeItem treeItem2 : treeItem.getItems()) {
                if (!treeItem2.getChecked()) continue;
                String[] stringArray = StringUtils.split((String)treeItem2.getText(), (char)'=');
                sectionsWrapper.setValue(StringUtils.substring((String)treeItem.getText(), (int)1, (int)-1), stringArray[0], stringArray[1]);
            }
        }
        return sectionsWrapper.toString();
    }
}

