/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import org.dbgl.model.conf.Settings;
import org.dbgl.swtdesigner.SWTImageManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class Thumb
extends Dialog {
    private static final int DIALOG_WIDTH_EXT = 24;
    private static final int DIALOG_HEIGHT_EXT = 50;
    private Shell shell;
    private Display display;
    private Image thumbImage = null;
    private String filename;

    public Thumb(Shell shell, int n) {
        super(shell, n);
        this.display = shell.getDisplay();
    }

    public Thumb(Shell shell) {
        this(shell, 0);
    }

    public void setThumb(String string) {
        this.filename = string;
        Image image = SWTImageManager.getImage(this.display, string);
        ImageData imageData = image.getImageData();
        int n = imageData.width;
        int n2 = imageData.height;
        double d = Math.min((double)this.display.getClientArea().width / (double)(n + 48), (double)this.display.getClientArea().height / (double)(n2 + 100));
        this.thumbImage = new Image((Device)this.display, imageData.scaledTo((int)((double)n * d), (int)((double)n2 * d)));
        image.dispose();
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        if (this.thumbImage != null && !this.thumbImage.isDisposed()) {
            this.thumbImage.dispose();
        }
        return null;
    }

    protected void createContents() {
        if (this.thumbImage != null) {
            this.shell = new Shell(this.getParent(), 67680);
            this.shell.setLayout((Layout)new FillLayout());
            this.shell.setSize(this.thumbImage.getImageData().width + 24, this.thumbImage.getImageData().height + 50);
            this.shell.setText(Settings.getInstance().msg("dialog.screenshot.title", new Object[]{this.filename}));
            Rectangle rectangle = this.display.getBounds();
            Rectangle rectangle2 = this.shell.getBounds();
            this.shell.setLocation(rectangle.x + (rectangle.width - rectangle2.width) / 2, rectangle.y + (rectangle.height - rectangle2.height) / 2);
            Button button = new Button((Composite)this.shell, 0x800000);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    Thumb.this.shell.close();
                }
            });
            button.setImage(this.thumbImage);
            button.pack();
        }
    }
}

