/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.dbgl.interfaces.Configurable;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.Conf;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExpProfile
extends Profile
implements Configurable {
    private Conf conf;
    private File baseDir;
    private File gameDir;
    private String importedFullConfig;
    private String importedIncrConfig;
    private String mapperfile;
    private List<NativeCommand> nativeCommandsList;
    private int importedId;

    public ExpProfile(Conf conf, List<NativeCommand> list) {
        super(null, false);
        this.conf = conf;
        this.nativeCommandsList = list;
        this.baseDir = null;
        this.gameDir = null;
        this.dbversionId = conf.getDbversion().getId();
    }

    public ExpProfile(int n, Conf conf, File file, List<NativeCommand> list, Profile profile) {
        super(n, profile.getConfPathAndFile(), profile.getCaptures(), profile);
        this.conf = conf;
        this.baseDir = FileUtils.makeRelativeToDosroot(new File("."));
        this.gameDir = file;
        this.nativeCommandsList = list;
    }

    public ExpProfile(Element element, int n, boolean bl, String string) {
        super(XmlUtils.getTextValue(element, "title"), Boolean.valueOf(XmlUtils.getTextValue(XmlUtils.getNode(element, "meta-info"), "favorite")));
        Object object;
        Element element2;
        this.importedId = Integer.valueOf(XmlUtils.getTextValue(element, "id"));
        this.confPathAndFile = PlatformUtils.pathToNativePath(XmlUtils.getTextValue(XmlUtils.getNode(element, "config-file"), "raw"));
        this.captures = PlatformUtils.pathToNativePath(XmlUtils.getTextValue(XmlUtils.getNode(element, "captures"), "raw"));
        this.baseDir = FileUtils.makeRelativeToDosroot(new File("."));
        this.gameDir = new File(PlatformUtils.pathToNativePath(XmlUtils.getTextValue(XmlUtils.getNode(element, "game-dir"), "raw")));
        if (string.equals("1.0")) {
            this.setup = new String[]{PlatformUtils.pathToNativePath(XmlUtils.getTextValue(element, "setup")), "", ""};
            this.setupParams = new String[]{XmlUtils.getTextValue(element, "setup-parameters"), "", ""};
        } else {
            this.setup = new String[]{PlatformUtils.pathToNativePath(XmlUtils.getTextValue(element, "setup")), PlatformUtils.pathToNativePath(XmlUtils.getTextValue(element, "altexe1")), PlatformUtils.pathToNativePath(XmlUtils.getTextValue(element, "altexe2"))};
            this.setupParams = new String[]{XmlUtils.getTextValue(element, "setup-parameters"), XmlUtils.getTextValue(element, "altexe1-parameters"), XmlUtils.getTextValue(element, "altexe2-parameters")};
            element2 = XmlUtils.getNode(element, "keymapper-file");
            if (element2 != null) {
                this.mapperfile = PlatformUtils.pathToNativePath(XmlUtils.getTextValue(element2, "raw"));
            }
        }
        element2 = XmlUtils.getNode(element, "meta-info");
        this.developerName = XmlUtils.getTextValue(element2, "developer");
        this.publisherName = XmlUtils.getTextValue(element2, "publisher");
        this.year = XmlUtils.getTextValue(element2, "year");
        this.genre = XmlUtils.getTextValue(element2, "genre");
        this.status = XmlUtils.getTextValue(element2, "status");
        this.notes = XmlUtils.getTextValue(element2, "notes");
        this.customString = XmlUtils.getNode(element2, "custom11") != null ? new String[]{XmlUtils.getTextValue(element2, "custom1"), XmlUtils.getTextValue(element2, "custom2"), XmlUtils.getTextValue(element2, "custom3"), XmlUtils.getTextValue(element2, "custom4"), XmlUtils.getTextValue(element2, "custom5"), XmlUtils.getTextValue(element2, "custom6"), XmlUtils.getTextValue(element2, "custom7"), XmlUtils.getTextValue(element2, "custom8"), XmlUtils.getTextValue(element2, "custom11"), XmlUtils.getTextValue(element2, "custom12"), XmlUtils.getTextValue(element2, "custom13"), XmlUtils.getTextValue(element2, "custom14")} : new String[]{XmlUtils.getTextValue(element2, "custom1"), XmlUtils.getTextValue(element2, "custom2"), XmlUtils.getTextValue(element2, "custom3"), XmlUtils.getTextValue(element2, "custom4"), XmlUtils.getTextValue(element2, "custom5"), XmlUtils.getTextValue(element2, "custom6"), XmlUtils.getTextValue(element2, "custom7"), XmlUtils.getTextValue(element2, "custom8"), "", "", "", ""};
        this.customInt = new int[]{Integer.valueOf(XmlUtils.getTextValue(element2, "custom9")), Integer.valueOf(XmlUtils.getTextValue(element2, "custom10"))};
        this.link = new String[8];
        this.linkTitle = new String[8];
        for (int i = 0; i < 8; ++i) {
            if (string.equals("1.0") && i >= 4) {
                this.link[i] = "";
                this.linkTitle[i] = "";
                continue;
            }
            object = XmlUtils.getNode(element2, "link" + (i + 1));
            this.link[i] = PlatformUtils.pathToNativePath(XmlUtils.getTextValue((Element)object, "raw"));
            this.linkTitle[i] = XmlUtils.getTextValue((Element)object, "title");
        }
        this.importedFullConfig = XmlUtils.getTextValue(element, "full-configuration");
        this.importedIncrConfig = XmlUtils.getTextValue(element, "incremental-configuration");
        this.dbversionId = n;
        if (bl) {
            this.nativeCommandsList = new ArrayList<NativeCommand>();
            Element element3 = XmlUtils.getNode(element, "native-commands");
            if (element3 != null) {
                object = element3.getChildNodes();
                for (int i = 0; i < object.getLength(); ++i) {
                    Node node = object.item(i);
                    if (!(node instanceof Element)) continue;
                    Element element4 = (Element)object.item(i);
                    String string2 = XmlUtils.getTextValue(element4, "cwd");
                    String string3 = XmlUtils.getTextValue(element4, "command");
                    this.nativeCommandsList.add(new NativeCommand(new File(string3), XmlUtils.getTextValue(element4, "parameters"), string2 == null ? null : new File(string2), Boolean.valueOf(XmlUtils.getTextValue(element4, "waitfor")), Integer.valueOf(XmlUtils.getTextValue(element4, "ordernr"))));
                }
            }
            NativeCommand.insertDosboxCommand(this.nativeCommandsList);
        }
    }

    public ExpProfile(ExpProfile expProfile, ExpProfile expProfile2, Conf conf) {
        super(expProfile, expProfile2);
        this.conf = conf;
    }

    public ExpProfile(ExpProfile expProfile, Profile profile) {
        super(expProfile, profile, false);
        this.conf = expProfile.conf;
    }

    public void setDbversionId(int n) {
        this.dbversionId = n;
    }

    public int getImportedId() {
        return this.importedId;
    }

    public void setImportedId(int n) {
        this.importedId = n;
    }

    public String getCapturesExport() {
        return FileUtils.constructCapturesDir(this.getId());
    }

    public String getMapperExport() {
        return FileUtils.constructMapperFile(this.getId());
    }

    public String getMapperfile() {
        return this.mapperfile;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getGameDir() {
        return this.gameDir;
    }

    public void setBaseDir(File file) {
        this.baseDir = file;
    }

    public void setGameDir(File file) {
        this.gameDir = file;
    }

    public String getImportedFullConfig() {
        return this.importedFullConfig;
    }

    public String getImportedIncrConfig() {
        return this.importedIncrConfig;
    }

    @Override
    public Conf getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Conf conf) {
        this.conf = conf;
    }

    public Element getXml(Document document, List<DosboxVersion> list) {
        Element element;
        int n;
        Element element2;
        boolean bl = this.conf == null;
        Element element3 = document.createElement("profile");
        XmlUtils.addCDataElement(document, element3, "title", this.getTitle());
        XmlUtils.addElement(document, element3, "id", String.valueOf(this.getId()));
        Element element4 = document.createElement("captures");
        XmlUtils.addElement(document, element4, "raw", this.getCapturesExport());
        if (bl) {
            XmlUtils.addElement(document, element4, "url", this.getCapturesAsUrl());
        }
        element3.appendChild(element4);
        Element element5 = document.createElement("config-file");
        XmlUtils.addElement(document, element5, "raw", FileUtils.makeRelativeToData(new File(this.getConfPathAndFile())).getPath());
        if (bl) {
            XmlUtils.addElement(document, element5, "url", this.getConfFileAsUrl());
        }
        element3.appendChild(element5);
        if (this.conf != null && this.conf.getCustomMapperFile() != null) {
            element2 = document.createElement("keymapper-file");
            XmlUtils.addElement(document, element2, "raw", this.getMapperExport());
            element3.appendChild(element2);
        }
        if (this.gameDir != null) {
            element2 = document.createElement("game-dir");
            XmlUtils.addElement(document, element2, "raw", PlatformUtils.toDosboxPath(this.gameDir.getPath()));
            element3.appendChild(element2);
        }
        XmlUtils.addElement(document, element3, "setup", this.getSetup(0));
        XmlUtils.addElement(document, element3, "altexe1", this.getSetup(1));
        XmlUtils.addElement(document, element3, "altexe2", this.getSetup(2));
        XmlUtils.addElement(document, element3, "setup-parameters", this.getSetupParameters(0));
        XmlUtils.addElement(document, element3, "altexe1-parameters", this.getSetupParameters(1));
        XmlUtils.addElement(document, element3, "altexe2-parameters", this.getSetupParameters(2));
        element2 = document.createElement("meta-info");
        XmlUtils.addCDataElement(document, element2, "developer", this.getDeveloperName());
        XmlUtils.addCDataElement(document, element2, "publisher", this.getPublisherName());
        XmlUtils.addCDataElement(document, element2, "year", this.getYear());
        XmlUtils.addCDataElement(document, element2, "genre", this.getGenre());
        XmlUtils.addCDataElement(document, element2, "status", this.getStatus());
        XmlUtils.addElement(document, element2, "favorite", String.valueOf(this.isDefault()));
        XmlUtils.addCDataElement(document, element2, "notes", XmlUtils.cleanEolnForXml(this.getNotes()));
        int n2 = 8;
        int n3 = 4;
        for (n = 0; n < n2; ++n) {
            XmlUtils.addCDataElement(document, element2, "custom" + (n + 1), this.getCustomString(n));
        }
        for (n = 0; n < 2; ++n) {
            XmlUtils.addElement(document, element2, "custom" + (n + 1 + n2), String.valueOf(this.getCustomInt(n)));
        }
        for (n = 0; n < n3; ++n) {
            XmlUtils.addCDataElement(document, element2, "custom" + (n + 1 + n2 + 2), this.getCustomString(n2 + n));
        }
        for (n = 0; n < 8; ++n) {
            element = document.createElement("link" + (n + 1));
            XmlUtils.addElement(document, element, "raw", this.getLink(n));
            if (bl) {
                XmlUtils.addElement(document, element, "url", this.getLinkAsUrl(n));
            }
            XmlUtils.addCDataElement(document, element, "title", this.getLinkTitle(n));
            element2.appendChild(element);
        }
        element3.appendChild(element2);
        if (this.conf != null) {
            XmlUtils.addCDataElement(document, element3, "full-configuration", XmlUtils.cleanEolnForXml(this.conf.toFullConfString(false)));
            XmlUtils.addCDataElement(document, element3, "incremental-configuration", XmlUtils.cleanEolnForXml(this.conf.toIncrConfString(false)));
        }
        DosboxVersion dosboxVersion = DosboxVersion.findById(list, this.getDbversionId());
        element = document.createElement("dosbox");
        XmlUtils.addCDataElement(document, element, "title", dosboxVersion.getValue());
        XmlUtils.addElement(document, element, "version", dosboxVersion.getVersion());
        element3.appendChild(element);
        if (this.nativeCommandsList != null && this.nativeCommandsList.size() > 1) {
            Element element6 = document.createElement("native-commands");
            for (NativeCommand nativeCommand : this.nativeCommandsList) {
                if (nativeCommand.getCommand() == null) continue;
                Element element7 = document.createElement("native-command");
                XmlUtils.addElement(document, element7, "command", nativeCommand.getCommand().getPath());
                XmlUtils.addElement(document, element7, "parameters", nativeCommand.getParameters());
                XmlUtils.addElement(document, element7, "cwd", nativeCommand.getCwd().getPath());
                XmlUtils.addElement(document, element7, "waitfor", String.valueOf(nativeCommand.isWaitFor()));
                XmlUtils.addElement(document, element7, "ordernr", String.valueOf(nativeCommand.getOrderNr()));
                element6.appendChild(element7);
            }
            element3.appendChild(element6);
        }
        return element3;
    }

    @Override
    public List<NativeCommand> getNativeCommandsList() {
        return this.nativeCommandsList;
    }

    @Override
    public void setNativeCommandsList(List<NativeCommand> list) {
        this.nativeCommandsList = list;
    }
}

