/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.dbgl.util.FileUtils;

public class ThumbInfo {
    private String captures;
    private File canonicalCaptures;
    private File[] files;
    private String mainThumb;
    private boolean updated;

    public ThumbInfo(String string) {
        this.captures = string;
    }

    private void prepareInfo() {
        if (this.canonicalCaptures == null) {
            this.canonicalCaptures = FileUtils.canonicalToData(this.captures);
            this.updated = true;
        }
        if (this.files == null) {
            ArrayList<File> arrayList = new ArrayList<File>();
            File[] fileArray = this.canonicalCaptures.listFiles();
            if (fileArray != null && fileArray.length > 0) {
                Arrays.sort(fileArray, new FileUtils.FileComparator());
                for (File file : fileArray) {
                    if (!FileUtils.isPicture(file.getName())) continue;
                    arrayList.add(file);
                }
            }
            this.files = arrayList.toArray(new File[arrayList.size()]);
            this.updated = true;
        }
    }

    public String getMainThumb() {
        this.prepareInfo();
        if (this.mainThumb == null) {
            if (this.files.length == 0) {
                return null;
            }
            this.mainThumb = this.files[0].getPath();
            this.updated = true;
        }
        return this.mainThumb;
    }

    public File[] getAllThumbs() {
        this.prepareInfo();
        return this.files;
    }

    public void resetCachedInfo() {
        this.files = null;
        this.mainThumb = null;
    }

    public boolean isUpdated() {
        boolean bl = this.updated;
        this.updated = false;
        return bl;
    }
}

