/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.swtdesigner;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dbgl.swtdesigner.GifDecoder;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public final class SWTImageManager {
    private static final Map<String, Image> imageMap = new HashMap<String, Image>();
    public static final String IMG_TB_NEW = "tb_new.png";
    public static final String IMG_TB_EDIT = "tb_edit.png";
    public static final String IMG_TB_DELETE = "tb_delete.png";
    public static final String IMG_TB_RUN = "tb_run.png";
    public static final String IMG_TB_SETUP = "tb_setup.png";
    public static final String IMG_TB_ADDGAMEWIZARD = "tb_wizard.png";
    public static final String IMG_RUN = "run.png";
    public static final String IMG_SETUP = "setup.png";
    public static final String IMG_FOLDER = "folder.png";
    public static final String IMG_ZOOM = "zoom.png";
    public static final String IMG_NEW = "new.png";
    public static final String IMG_EDIT = "edit.png";
    public static final String IMG_DUPLICATE = "duplicate.png";
    public static final String IMG_DELETE = "delete.png";
    public static final String IMG_FAVORITE = "favorite.png";
    public static final String IMG_SHORTCUT = "shortcut.png";
    public static final String IMG_REFRESH = "refresh.png";
    public static final String IMG_HOME = "home.png";
    public static final String IMG_DFEND = "dfend.png";
    public static final String IMG_MIGRATE = "case.png";
    public static final String IMG_TABLEEXPORT = "checkout.png";
    public static final String IMG_IMPORT = "import.png";
    public static final String IMG_CLEAN = "clean.png";
    public static final String IMG_SETTINGS = "settings.png";
    public static final String IMG_LOG = "log.png";
    public static final String IMG_EXIT = "stop.png";
    public static final String IMG_FILTER = "filter.png";
    public static final String IMG_EDITFILTER = "editfilter.png";
    public static final String IMG_ABOUT = "about.png";
    public static final String IMG_GRAB = "grab.png";
    public static final String IMG_MOBYGAMES = "moby.png";
    public static final String IMG_POUET = "pouet.png";
    public static final String IMG_HOTUD = "hotud.png";
    public static final String IMG_THEGAMESDB = "thegamesdb.png";
    public static final String IMG_SHARE = "share.png";
    public static final String IMG_UNDO = "undo.png";
    public static final String IMG_TOPDOG = "topdog.png";
    public static final String IMG_TILES_LARGE = "tiles_large.png";
    public static final String IMG_TILES_MEDIUM = "tiles_medium.png";
    public static final String IMG_TILES_SMALL = "tiles_small.png";
    public static final String IMG_BOXES_LARGE = "boxes_large.png";
    public static final String IMG_BOXES_MEDIUM = "boxes_medium.png";
    public static final String IMG_BOXES_SMALL = "boxes_small.png";
    public static final String IMG_TABLE = "table.png";
    public static final String IMG_SCREENSHOTS = "screenshots.png";
    public static final String IMG_NOTES = "notes.png";

    public static void dispose() {
        for (Image image : imageMap.values()) {
            image.dispose();
        }
        imageMap.clear();
    }

    public static void flush(String string) {
        Iterator<String> iterator = imageMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (!string2.startsWith(string)) continue;
            imageMap.get(string2).dispose();
            iterator.remove();
        }
    }

    public static Image getResourceImage(Display display, String string) {
        return new Image((Device)display, imageMap.getClass().getResourceAsStream("/img/" + string));
    }

    public static Image[] getResourceImages(Display display, String[] stringArray) {
        Image[] imageArray = new Image[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            imageArray[i] = SWTImageManager.getResourceImage(display, stringArray[i]);
        }
        return imageArray;
    }

    public static Image getImage(Display display, String string) {
        try {
            if (string.toLowerCase().endsWith(".ico")) {
                ImageLoader imageLoader = new ImageLoader();
                imageLoader.load(string);
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                for (int i = 0; i < imageLoader.data.length; ++i) {
                    if (imageLoader.data[i].width < n || imageLoader.data[i].depth < n2) continue;
                    n = imageLoader.data[i].width;
                    n2 = imageLoader.data[i].depth;
                    n3 = i;
                }
                return new Image((Device)display, imageLoader.data[n3]);
            }
            Image image = new Image((Device)display, string);
            if (string.toLowerCase().endsWith(".gif") && image.getImageData().type == -1) {
                throw new SWTException();
            }
            return image;
        }
        catch (SWTException sWTException) {
            GifDecoder gifDecoder = new GifDecoder();
            int n = gifDecoder.read(string);
            if (n == 0 || n == 1 && gifDecoder.frameCount > 0) {
                BufferedImage bufferedImage = gifDecoder.getFrame(0);
                int[] nArray = ((DataBufferInt)bufferedImage.getData().getDataBuffer()).getData();
                ImageData imageData = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), 24, new PaletteData(0xFF0000, 65280, 255));
                imageData.setPixels(0, 0, nArray.length, nArray, 0);
                return new Image((Device)display, imageData);
            }
            return SWTImageManager.getEmptyImage(display, 10, 10);
        }
        catch (Exception exception) {
            return SWTImageManager.getEmptyImage(display, 10, 10);
        }
    }

    public static ImageData getImageData(String string) throws IOException {
        try {
            return new ImageData(WebSearchEngine.getInputStream(string));
        }
        catch (SWTException sWTException) {
            GifDecoder gifDecoder = new GifDecoder();
            gifDecoder.read(WebSearchEngine.getInputStream(string));
            BufferedImage bufferedImage = gifDecoder.getFrame(0);
            int[] nArray = ((DataBufferInt)bufferedImage.getData().getDataBuffer()).getData();
            ImageData imageData = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), 24, new PaletteData(0xFF0000, 65280, 255));
            imageData.setPixels(0, 0, nArray.length, nArray, 0);
            return imageData;
        }
    }

    public static ImageData[] getAnimatedImageData(String string) throws IOException {
        GifDecoder gifDecoder = new GifDecoder();
        gifDecoder.read(WebSearchEngine.getInputStream(string));
        int n = gifDecoder.getFrameCount();
        if (gifDecoder.getDelay(0) < 500) {
            n = 1;
        }
        ImageData[] imageDataArray = new ImageData[n];
        for (int i = 0; i < n; ++i) {
            BufferedImage bufferedImage = gifDecoder.getFrame(i);
            int[] nArray = ((DataBufferInt)bufferedImage.getData().getDataBuffer()).getData();
            imageDataArray[i] = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), 24, new PaletteData(0xFF0000, 65280, 255));
            imageDataArray[i].setPixels(0, 0, nArray.length, nArray, 0);
        }
        return imageDataArray;
    }

    public static Image getEmptyImage(Display display, int n, int n2) {
        Image image = new Image((Device)display, n, n2);
        GC gC = new GC((Drawable)image);
        gC.setBackground(display.getSystemColor(22));
        gC.fillRectangle(0, 0, n, n2);
        gC.dispose();
        return image;
    }

    public static void save(ImageData imageData, String string) throws SWTException {
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{imageData};
        if (string.toUpperCase().endsWith(".JPG")) {
            imageLoader.save(string, 4);
        } else {
            imageLoader.save(string, 5);
        }
    }

    public static Image getWidthLimitedImage(Display display, int n, ImageData imageData) {
        Image image = new Image((Device)display, imageData);
        int n2 = image.getBounds().width;
        int n3 = image.getBounds().height;
        double d = (double)n / (double)n2;
        int n4 = (int)((double)n3 * d);
        Image image2 = new Image((Device)display, n, n4);
        GC gC = new GC((Drawable)image2);
        gC.setAntialias(1);
        gC.drawImage(image, 0, 0, n2, n3, 0, 0, n, n4);
        gC.dispose();
        image.dispose();
        return image2;
    }

    public static Image getResizedImage(Display display, int n, String string, String string2) {
        String string3 = string + n + string2;
        Image image = imageMap.get(string3);
        if (image == null) {
            Image image2 = SWTImageManager.getImage(display, string);
            int n2 = image2.getBounds().width;
            int n3 = image2.getBounds().height;
            double d = (double)n / (double)n3;
            int n4 = (int)((double)n2 * d);
            image = new Image((Device)display, n4, n);
            GC gC = new GC((Drawable)image);
            gC.setAntialias(1);
            gC.drawImage(image2, 0, 0, n2, n3, 0, 0, n4, n);
            if (string2 != null) {
                Point point = gC.textExtent(string2);
                gC.setBackground(display.getSystemColor(2));
                gC.setForeground(display.getSystemColor(1));
                gC.setAlpha(180);
                gC.drawString(string2, n4 - point.x - 2, n - point.y - 2, false);
            }
            gC.dispose();
            image2.dispose();
            imageMap.put(string3, image);
        }
        return image;
    }

    public static Image getResizedImage(Display display, int n, int n2, boolean bl, String string) {
        String string2 = string + n + n2 + bl;
        Image image = imageMap.get(string2);
        if (image == null) {
            Image image2 = SWTImageManager.getImage(display, string);
            int n3 = image2.getBounds().width;
            int n4 = image2.getBounds().height;
            double d = Math.max((double)n / (double)n3, (double)n2 / (double)n4);
            int n5 = bl ? (int)(((double)n3 * d - (double)n) / d) : 0;
            int n6 = bl ? (int)(((double)n4 * d - (double)n2) / d) : 0;
            image = new Image((Device)display, n, n2);
            GC gC = new GC((Drawable)image);
            gC.setAntialias(1);
            gC.drawImage(image2, n5 / 2, n6 / 2, n3 - n5, n4 - n6, 0, 0, n, n2);
            gC.dispose();
            image2.dispose();
            imageMap.put(string2, image);
        }
        return image;
    }

    public static Image createDisabledImage(Image image) {
        return new Image(image.getDevice(), image, 1);
    }
}

