/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.Conf;
import org.dbgl.util.FileUtils;
import org.dbgl.util.UIThread;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public final class MigrateThread
extends UIThread {
    private final File from;

    public MigrateThread(Text text, ProgressBar progressBar, Label label, File file) throws SQLException {
        super(text, progressBar, label);
        this.from = file;
        this.objects = this.dbase.readProfilesList(" ORDER BY LOWER(GAM.TITLE)", null);
        this.progressBar.setMaximum(this.objects.size());
    }

    @Override
    public void doFancyStuff(Object object, StringBuffer stringBuffer) throws IOException, SQLException {
        String[] stringArray;
        Profile profile = (Profile)object;
        this.displayTitle(this.settings.msg("dialog.migration.migrating", new Object[]{profile.getTitle()}));
        File file = profile.getCanonicalConfFile();
        DosboxVersion dosboxVersion = (DosboxVersion)DosboxVersion.findById(this.dbversions, profile.getDbversionId());
        Conf conf = new Conf(profile, dosboxVersion, this.ps);
        conf.getAutoexec().migrateToDosroot(this.from, false);
        conf.save();
        String string = profile.getConfPathAndFile();
        if (new File(profile.getConfPathAndFile()).isAbsolute() && !(stringArray = FileUtils.makeRelativeTo(file, this.from)).isAbsolute()) {
            string = FileUtils.DOSROOT_DIR + stringArray.getPath();
        }
        profile = this.dbase.updateProfileConf(string, profile.getCaptures(), profile.getId());
        stringArray = profile.getSetup();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() <= 0) continue;
            stringArray[i] = FileUtils.makeRelativeTo(new File(stringArray[i]), this.from).getPath();
        }
        String[] stringArray2 = profile.getLinks();
        for (int i = 0; i < stringArray2.length; ++i) {
            File file2;
            if (stringArray2[i].toLowerCase().startsWith("file://")) {
                stringArray2[i] = stringArray2[i].substring(7);
            }
            if (stringArray2[i].equals("") || stringArray2[i].contains("://") || (file2 = FileUtils.makeRelativeTo(new File(stringArray2[i]), this.from)).isAbsolute() || file2.getPath().startsWith(FileUtils.DOSROOT_DIR)) continue;
            stringArray2[i] = FileUtils.DOSROOT_DIR + file2.getPath();
        }
        profile = this.dbase.updateProfileSetupAndLinks(stringArray, stringArray2, profile.getId());
    }

    @Override
    public String getTitle(Object object) {
        return ((Profile)object).getTitle();
    }

    @Override
    public void preFinish() {
    }
}

