/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.dbgl.service.TextService;
import org.dbgl.util.StringRelatedUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class GeneralPurposeDialogs {
    private static List<String> errorMessages;
    private static Control wgt;
    private static TabItem tab;

    public static void fatalMessage(Shell shell, String theMessage) {
        GeneralPurposeDialogs.fatalMessage(shell, System.err, theMessage, null);
    }

    public static void fatalMessage(Shell shell, String theMessage, Exception exception) {
        GeneralPurposeDialogs.fatalMessage(shell, System.err, theMessage, exception);
    }

    private static void fatalMessage(Shell shell, PrintStream ps, String theMessage, Exception exception) {
        if (shell != null) {
            MessageBox messageBox = new MessageBox(shell, 65569);
            messageBox.setText(TextService.getInstance().get("general.fatalerror"));
            messageBox.setMessage(theMessage);
            messageBox.open();
        }
        ps.println(TextService.getInstance().get("general.fatalerror") + ": " + theMessage);
        if (exception != null) {
            exception.printStackTrace(ps);
        }
    }

    public static void warningMessage(Shell shell, String theMessage) {
        GeneralPurposeDialogs.warningMessage(shell, System.err, theMessage, null);
    }

    public static void warningMessage(Shell shell, Exception exception) {
        GeneralPurposeDialogs.warningMessage(shell, System.err, StringRelatedUtils.toString(exception), exception);
    }

    public static void warningMessage(Shell shell, String theMessage, Exception exception) {
        GeneralPurposeDialogs.warningMessage(shell, System.err, theMessage, exception);
    }

    private static void warningMessage(Shell shell, PrintStream ps, String theMessage, Exception exception) {
        if (shell != null) {
            MessageBox messageBox = new MessageBox(shell, 65576);
            messageBox.setText(TextService.getInstance().get("general.warning"));
            messageBox.setMessage(theMessage);
            messageBox.open();
        }
        ps.println(TextService.getInstance().get("general.warning") + ": " + theMessage);
        if (exception != null) {
            exception.printStackTrace(ps);
        }
    }

    public static void infoMessage(Shell shell, String theMessage) {
        GeneralPurposeDialogs.infoMessage(shell, System.out, theMessage);
    }

    private static void infoMessage(Shell shell, PrintStream ps, String theMessage) {
        if (shell != null) {
            MessageBox messageBox = new MessageBox(shell, 65570);
            messageBox.setText(TextService.getInstance().get("general.information"));
            messageBox.setMessage(theMessage);
            messageBox.open();
        }
        ps.println(TextService.getInstance().get("general.information") + ": " + theMessage);
    }

    public static boolean confirmMessage(Shell shell, String theMessage) {
        MessageBox messageBox = new MessageBox(shell, 65736);
        messageBox.setText(TextService.getInstance().get("general.confirmation"));
        messageBox.setMessage(theMessage);
        return messageBox.open() == 64;
    }

    public static void initErrorDialog() {
        errorMessages = new ArrayList<String>();
        wgt = null;
        tab = null;
    }

    public static void addError(String msg, Control widget) {
        GeneralPurposeDialogs.addError(msg, widget, null);
    }

    public static void addError(String msg, Control widget, TabItem tabItem) {
        if (errorMessages.isEmpty()) {
            wgt = widget;
            tab = tabItem;
        }
        errorMessages.add(msg);
    }

    public static boolean hasErrors() {
        return !errorMessages.isEmpty();
    }

    public static boolean displayErrorDialog(Shell shell) {
        boolean errors;
        boolean bl = errors = !errorMessages.isEmpty();
        if (errors) {
            if (tab != null) {
                TabFolder folder = tab.getParent();
                folder.setSelection(tab);
            }
            GeneralPurposeDialogs.infoMessage(shell, StringRelatedUtils.stringArrayToString(errorMessages.toArray(new String[errorMessages.size()]), "\n"));
            wgt.setFocus();
        }
        return errors;
    }
}

