/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.abstractdialog;

import org.dbgl.gui.abstractdialog.SizeControlledDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class WizardDialog<T>
extends SizeControlledDialog<T> {
    private final StackLayout wizardLayout_ = new StackLayout();
    protected Composite contents_;
    protected Button backButton_;
    protected Button nextButton_;
    protected Button cancelButton_;
    protected int step_ = 0;

    public WizardDialog(Shell parent, String dialogName) {
        super(parent, dialogName);
    }

    @Override
    protected void onShellInit() {
        super.onShellInit();
        this.shell_.setLayout((Layout)new GridLayout());
        this.contents_ = WizardDialog.createComposite((Composite)this.shell_, new GridData(4, 4, true, true));
        this.contents_.setLayout((Layout)this.wizardLayout_);
        Composite buttons_ = WizardDialog.createInnerComposite((Composite)this.shell_, new GridData(4, 4, true, false), 2);
        Composite backNextButtons_ = WizardDialog.createInnerComposite(buttons_, new GridData(1, 4, false, false), 2);
        this.backButton_ = WizardDialog.createButton(backNextButtons_, this.text_.get("button.back"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WizardDialog.this.goBack();
            }
        });
        this.nextButton_ = WizardDialog.createButton(backNextButtons_, this.text_.get("button.next"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WizardDialog.this.goForward();
            }
        });
        this.shell_.setDefaultButton(this.nextButton_);
        GridLayout gridLayoutOtherButtons = new GridLayout(2, true);
        gridLayoutOtherButtons.marginWidth = 80;
        gridLayoutOtherButtons.marginHeight = 0;
        Composite otherButtons_ = WizardDialog.createComposite(buttons_, new GridData(1, 4, false, false), (Layout)gridLayoutOtherButtons);
        this.cancelButton_ = WizardDialog.createButton(otherButtons_, this.text_.get("button.cancel"), (SelectionListener)this.closeShellAdapter);
        WizardDialog.setLayoutDataButtons(this.backButton_, this.nextButton_, this.cancelButton_);
    }

    protected void addStep(Group group) {
        group.setParent(this.contents_);
    }

    @Override
    protected void onShellOpened() {
        this.activateCurrentStep();
    }

    protected int stepSize(int step, boolean forward) {
        return 1;
    }

    protected void goBack() {
        this.step_ -= this.stepSize(this.step_, false);
        this.activateCurrentStep();
    }

    protected void goForward() {
        if (this.onNext(this.step_)) {
            if (this.step_ >= this.totalSteps() - 1) {
                this.shell_.close();
            } else {
                this.step_ += this.stepSize(this.step_, true);
                this.activateCurrentStep();
            }
        }
    }

    protected abstract boolean onNext(int var1);

    protected void activateCurrentStep() {
        if (this.step_ < this.contents_.getChildren().length) {
            this.wizardLayout_.topControl = this.contents_.getChildren()[this.step_];
            this.contents_.layout();
        }
        this.backButton_.setEnabled(this.step_ > 0);
        this.nextButton_.setText(this.step_ < this.totalSteps() - 1 ? this.text_.get("button.next") : this.text_.get("button.finish"));
        if (this.step_ > 0) {
            this.wizardLayout_.topControl.setFocus();
        }
    }

    protected int totalSteps() {
        return this.contents_.getChildren().length;
    }
}

