/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.controls;

import java.util.List;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import org.dbgl.model.entity.ITitledEntity;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class AutoSelectCombo {
    private final Combo combo_;
    private int currentLength_;
    private boolean mutex_;

    public AutoSelectCombo(Composite composite, Object layoutData, List<ITitledEntity> possibleValues) {
        this.combo_ = new Combo(composite, 0);
        this.combo_.setLayoutData(layoutData);
        this.combo_.setVisibleItemCount(15);
        possibleValues.stream().forEach(x -> this.combo_.add(x.getTitle()));
        this.combo_.pack();
        this.currentLength_ = 0;
        this.mutex_ = false;
        this.combo_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (!AutoSelectCombo.this.mutex_) {
                    OptionalInt opt;
                    String text = AutoSelectCombo.this.combo_.getText();
                    int newLength = text.length();
                    if (newLength > AutoSelectCombo.this.currentLength_ && (opt = IntStream.range(0, AutoSelectCombo.this.combo_.getItemCount()).filter(i -> AutoSelectCombo.this.combo_.getItem(i).toLowerCase().startsWith(text.toLowerCase())).findFirst()).isPresent()) {
                        AutoSelectCombo.this.mutex_ = true;
                        AutoSelectCombo.this.combo_.setText(text + AutoSelectCombo.this.combo_.getItem(opt.getAsInt()).substring(newLength));
                        AutoSelectCombo.this.combo_.setSelection(new Point(newLength, AutoSelectCombo.this.combo_.getText().length()));
                        AutoSelectCombo.this.mutex_ = false;
                    }
                    AutoSelectCombo.this.currentLength_ = newLength;
                }
            }
        });
    }

    public String getText() {
        return this.combo_.getText();
    }

    public void setText(String text) {
        this.combo_.setText(text);
        this.currentLength_ = text.length();
    }

    public Control getControl() {
        return this.combo_;
    }
}

