/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.controls;

import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.controls.ChangeTrackingControl;
import org.dbgl.gui.interfaces.DaControlConvertor;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.conf.Configuration;
import org.dbgl.model.conf.GenerationAwareConfiguration;
import org.dbgl.model.entity.TemplateProfileBase;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class DaControl
extends ChangeTrackingControl {
    private final String section_;
    private final String sectionNew_;
    private final String item_;
    private final String itemNew_;
    private final boolean isOnOff_;
    private final DaControlConvertor convertor_;

    private DaControl(Label label, Control[] controls, String sectionOld, String itemOld, String sectionNew, String itemNew, boolean isOnOff, DaControlConvertor convertor) {
        super(label, controls);
        this.section_ = sectionOld;
        this.sectionNew_ = sectionNew;
        this.item_ = itemOld;
        this.itemNew_ = itemNew;
        this.isOnOff_ = isOnOff;
        this.convertor_ = convertor;
    }

    public DaControl(Label label, Control control, String section, String item) {
        this(label, new Control[]{control}, section, item, null, null, false, defaultConvertor);
    }

    public DaControl(Label label, Control control, String section, String item, DaControlConvertor convertor) {
        this(label, new Control[]{control}, section, item, null, null, false, convertor);
    }

    public DaControl(Label label, Control[] controls, String section, String item) {
        this(label, controls, section, item, null, null, false, defaultConvertor);
    }

    public DaControl(Label label, Control[] controls, String section, String item, DaControlConvertor convertor) {
        this(label, controls, section, item, null, null, false, convertor);
    }

    public DaControl(Label label, Control control, String section, String itemOld, String itemNew) {
        this(label, new Control[]{control}, section, itemOld, null, itemNew, false, defaultConvertor);
    }

    public DaControl(Label label, Control control, String sectionOld, String itemOld, String sectionNew, String itemNew) {
        this(label, new Control[]{control}, sectionOld, itemOld, sectionNew, itemNew, false, defaultConvertor);
    }

    public DaControl(Label label, Control control, String sectionOld, String itemOld, String sectionNew, String itemNew, DaControlConvertor convertor) {
        this(label, new Control[]{control}, sectionOld, itemOld, sectionNew, itemNew, false, convertor);
    }

    public DaControl(Label label, Control control, String section, String item, boolean isOnOff) {
        this(label, new Control[]{control}, section, item, null, null, isOnOff, defaultConvertor);
    }

    @Override
    public String getCurrentValue() {
        String[] fieldValues = (String[])Stream.of(this.controls_).map(x -> DaControl.getFieldValue(x, this.isOnOff_)).filter(x -> x != null).toArray(String[]::new);
        return fieldValues.length == this.controls_.length ? this.convertor_.toConfValue(fieldValues) : null;
    }

    private String getSectionInConf(Configuration configuration) {
        return StringUtils.isNotBlank((CharSequence)this.sectionNew_) && StringUtils.isNotBlank((CharSequence)this.itemNew_) && configuration.hasValue(this.sectionNew_, this.itemNew_) ? this.sectionNew_ : this.section_;
    }

    private String getItemInConf(Configuration configuration) {
        return StringUtils.isNotBlank((CharSequence)this.itemNew_) && (configuration.hasValue(this.section_, this.itemNew_) || StringUtils.isNotBlank((CharSequence)this.sectionNew_) && configuration.hasValue(this.sectionNew_, this.itemNew_)) ? this.itemNew_ : this.item_;
    }

    public String getConfLabel() {
        StringBuffer result = new StringBuffer("[");
        result.append(StringUtils.isNotBlank((CharSequence)this.sectionNew_) ? this.sectionNew_ : this.section_);
        result.append("] ");
        result.append(StringUtils.isNotBlank((CharSequence)this.itemNew_) ? this.itemNew_ : this.item_);
        return result.toString();
    }

    public void enableOrDisable(DosboxVersion dosbox) {
        GenerationAwareConfiguration configuration = dosbox.getConfiguration();
        boolean dosboxHasConfigurationSetting = configuration.hasValue(this.getSectionInConf(configuration), this.getItemInConf(configuration));
        Stream.of(this.controls_).forEach(x -> x.setEnabled(dosboxHasConfigurationSetting));
    }

    public void setControlByConf(Configuration dosboxConf, Configuration overrideConf, Configuration combinedConf, boolean multiEdit) {
        if (this.allControlsDisabled()) {
            return;
        }
        String[] values = this.determineValues(dosboxConf, multiEdit ? overrideConf : combinedConf);
        if (values.length == 0 && multiEdit) {
            this.setOriginalValue(null, multiEdit);
        } else {
            if (values.length != this.controls_.length) {
                throw new RuntimeException("invalid DaControl definition");
            }
            for (int i = 0; i < this.controls_.length; ++i) {
                DaControl.setFieldIfEnabled(values[i], this.controls_[i], this.isOnOff_);
            }
            this.setOriginalValue(this.getCurrentValue(), multiEdit);
        }
    }

    private String[] determineValues(Configuration dosboxConf, Configuration combinedConf) {
        if (combinedConf.hasValue(this.section_, this.item_) && combinedConf.hasValue(this.sectionNew_, this.itemNew_)) {
            return this.convertor_.toControlValues(new String[]{combinedConf.getValue(this.section_, this.item_), combinedConf.getValue(this.sectionNew_, this.itemNew_)});
        }
        return this.convertor_.toControlValues(combinedConf.getValue(this.getSectionInConf(dosboxConf), this.getItemInConf(dosboxConf)));
    }

    public void updateConfigurationByControl(TemplateProfileBase configurable) {
        DosboxVersion dosbox = configurable.getDosboxVersion();
        GenerationAwareConfiguration dosboxConf = dosbox.getConfiguration();
        Configuration combinedConf = configurable.getCombinedConfiguration();
        String[] fieldValues = (String[])Stream.of(this.controls_).map(x -> DaControl.getFieldValue(x, this.isOnOff_)).filter(x -> x != null).toArray(String[]::new);
        if (combinedConf.hasValue(this.section_, this.item_) && combinedConf.hasValue(this.sectionNew_, this.itemNew_)) {
            String[] confValues = this.convertor_.toConfValues(fieldValues);
            configurable.setValue(this.section_, this.item_, confValues[0]);
            configurable.setValue(this.sectionNew_, this.itemNew_, confValues[1]);
        } else {
            String value = this.convertor_.toConfValue(fieldValues);
            configurable.setValue(this.getSectionInConf(dosboxConf), this.getItemInConf(dosboxConf), value);
        }
    }
}

