/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.io.IOException;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.abstractdialog.SizeControlledButtonDialog;
import org.dbgl.util.FilesUtils;
import org.dbgl.util.StringRelatedUtils;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class BrowseArchiveDialog
extends SizeControlledButtonDialog<String> {
    private final String fileToBrowse_;
    private String[] executablesInArchive_;

    public BrowseArchiveDialog(Shell parent, String fileToBrowse) {
        super(parent, "archivebrowser");
        this.fileToBrowse_ = fileToBrowse;
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.archivebrowser.title");
    }

    @Override
    protected boolean prepare() {
        try {
            this.executablesInArchive_ = FilesUtils.listExecutablesInZipOrIsoOrFat(this.fileToBrowse_);
            if (this.executablesInArchive_.length <= 0) {
                GeneralPurposeDialogs.warningMessage(this.getParent(), this.text_.get("dialog.archivebrowser.notice.noexe"));
                return false;
            }
        }
        catch (IOException e) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), this.text_.get("dialog.archivebrowser.error.readarchive", new Object[]{this.fileToBrowse_, StringRelatedUtils.toString(e)}), e);
            return false;
        }
        return true;
    }

    @Override
    protected void onShellCreated() {
        this.contents_.setLayout((Layout)new FillLayout());
        final List files = BrowseArchiveDialog.createList(this.contents_, 2560, this.executablesInArchive_, 0);
        files.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                BrowseArchiveDialog.this.doChooseFile(files);
            }
        });
        this.createOkCancelButtons((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowseArchiveDialog.this.doChooseFile(files);
            }
        });
    }

    private void doChooseFile(List files) {
        this.result_ = FilesUtils.determineFullArchiveName(this.fileToBrowse_, files.getItem(files.getSelectionIndex()));
        this.shell_.close();
    }
}

