/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.GenericType;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.abstractdialog.EditConfigurableDialog;
import org.dbgl.gui.abstractdialog.EditProfileDialog;
import org.dbgl.gui.dialog.BrowseSearchEngineDialog;
import org.dbgl.gui.dialog.LoadSharedConfDialog;
import org.dbgl.gui.dialog.SettingsDialog;
import org.dbgl.gui.dialog.ShareConfDialog;
import org.dbgl.model.FileLocation;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.model.WebProfile;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.aggregate.Template;
import org.dbgl.model.entity.SharedConf;
import org.dbgl.model.entity.TemplateProfileBase;
import org.dbgl.model.factory.ProfileFactory;
import org.dbgl.model.repository.DosboxVersionRepository;
import org.dbgl.model.repository.ProfileRepository;
import org.dbgl.model.repository.TemplateRepository;
import org.dbgl.service.FileLocationService;
import org.dbgl.service.ImageService;
import org.dbgl.util.FilesUtils;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class EditSingleProfileDialog
extends EditProfileDialog<Profile> {
    private static final boolean multiEdit = false;
    private Profile profile_;
    private final String sendTo_;
    private final boolean editing_;
    private final boolean focusOnTitle_;

    public EditSingleProfileDialog(Shell parent, Profile prof, String sendTo, boolean focusOnTitle) {
        super(parent);
        this.profile_ = prof;
        this.sendTo_ = sendTo;
        this.focusOnTitle_ = focusOnTitle;
        this.editing_ = this.profile_ != null;
    }

    @Override
    protected String getDialogTitle() {
        if (this.editing_) {
            return this.text_.get("dialog.profile.title.edit", new Object[]{this.profile_.getTitle(), this.profile_.getId()});
        }
        if (this.sendTo_ != null) {
            return this.text_.get("dialog.profile.title.send", new Object[]{this.sendTo_});
        }
        return this.text_.get("dialog.profile.title.add");
    }

    @Override
    protected boolean prepare() {
        if (!super.prepare()) {
            return false;
        }
        try {
            StringBuffer warningsLog = new StringBuffer();
            if (this.editing_) {
                this.dbversionIndex_ = DosboxVersionRepository.indexOf(this.dbversionsList_, this.profile_.getDosboxVersion());
            } else {
                Template template = (Template)TemplateRepository.findDefault(this.templatesList_);
                if (template != null) {
                    warningsLog.append(template.resetAndLoadConfiguration());
                }
                this.profile_ = ProfileFactory.create((DosboxVersion)DosboxVersionRepository.findDefault(this.dbversionsList_), template);
                if (this.sendTo_ != null) {
                    if (FilesUtils.isConfFile(this.sendTo_)) {
                        this.profile_.setConfigurationFileLocation(this.sendTo_);
                    } else if (FilesUtils.isExecutable(this.sendTo_)) {
                        this.profile_.getConfiguration().getAutoexec().setGameMain(new FileLocation(this.sendTo_, FileLocationService.getInstance().dosrootRelative()).getFile().getPath());
                    } else if (FilesUtils.isBooterImage(this.sendTo_)) {
                        this.profile_.getConfiguration().getAutoexec().setImg1(new FileLocation(this.sendTo_, FileLocationService.getInstance().dosrootRelative()).getFile().getPath());
                    }
                }
            }
            warningsLog.append(this.profile_.resetAndLoadConfiguration());
            if (StringUtils.isNotBlank((CharSequence)warningsLog)) {
                GeneralPurposeDialogs.warningMessage(this.getParent(), warningsLog.toString());
            }
            return true;
        }
        catch (Exception e) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), e);
            return false;
        }
    }

    private void updateControlsByProfile() {
        this.metaControls_.forEach(x -> x.setControlByProfile(this.profile_, false));
        this.updateControlsByConfigurable(this.profile_, false);
    }

    @Override
    protected void updateControlsByConfigurable(TemplateProfileBase configurable, boolean multiEdit) {
        super.updateControlsByConfigurable(configurable, multiEdit);
        this.loadfixValue_.setEnabled(this.loadfix_.getSelection());
    }

    protected void updateProfileByControls() {
        this.metaControls_.forEach(x -> x.updateProfileByControl(this.profile_));
        super.updateConfigurableByControls(this.profile_);
    }

    @Override
    protected void doPerformDosboxConfAction(EditConfigurableDialog.DosboxConfAction action, DosboxVersion newDosboxVersion) {
        try {
            StringBuffer warningsLog = new StringBuffer();
            this.updateProfileByControls();
            warningsLog.append(newDosboxVersion.resetAndLoadConfiguration());
            if (action == EditConfigurableDialog.DosboxConfAction.SET) {
                warningsLog.append(this.profile_.setToDosboxVersion(newDosboxVersion));
            } else if (action == EditConfigurableDialog.DosboxConfAction.SWITCH) {
                warningsLog.append(this.profile_.switchToDosboxVersion(newDosboxVersion));
            } else if (action == EditConfigurableDialog.DosboxConfAction.RELOAD) {
                warningsLog.append(this.profile_.reloadDosboxVersion(newDosboxVersion));
            } else if (action == EditConfigurableDialog.DosboxConfAction.RELOAD_TEMPLATE) {
                Template templ = (Template)this.templatesList_.get(this.templateCombo_.getSelectionIndex());
                warningsLog.append(templ.resetAndLoadConfiguration());
                warningsLog.append(this.profile_.reloadTemplate(newDosboxVersion, templ));
            }
            this.updateControlsByConfigurable(this.profile_, false);
            if (StringUtils.isNotEmpty((CharSequence)warningsLog)) {
                GeneralPurposeDialogs.warningMessage(this.getParent(), warningsLog.toString());
            }
        }
        catch (IOException e) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), e);
        }
    }

    @Override
    protected void onShellCreated() {
        this.createInfoTab();
        this.createGeneralTab(this.editing_ ? this.profile_.getCanonicalCaptures().getPath() : this.text_.get("dialog.profile.automatic"), this.editing_ ? this.profile_.getConfigurationCanonicalFile().getPath() : SettingsDialog.confLocations[this.settings_.getIntValue("profiledefaults", "confpath")] + ", " + SettingsDialog.confFilenames[this.settings_.getIntValue("profiledefaults", "conffile")]);
        this.createDisplayTab();
        this.createMachineTab();
        this.createAudioTab();
        this.createIOTab();
        this.createCustomCommandsTab(this.profile_, false);
        this.createMountingTab(this.profile_, false);
        this.createOkCancelButtons();
        this.updateControlsByProfile();
        if (!this.editing_ || this.focusOnTitle_) {
            this.title_.selectAll();
            this.title_.setFocus();
        }
        VerifyListener addMountListener = new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                if (event.text.length() > 1 && EditSingleProfileDialog.this.mountingpointsList_.getItemCount() == 0) {
                    boolean booter = event.widget == EditSingleProfileDialog.this.img1_ || event.widget == EditSingleProfileDialog.this.img2_ || event.widget == EditSingleProfileDialog.this.img3_;
                    EditSingleProfileDialog.this.profile_.addRequiredMount(booter, event.text, false);
                    EditSingleProfileDialog.this.mountingpointsList_.setItems(EditSingleProfileDialog.this.profile_.getMountStringsForUI());
                }
            }
        };
        this.main_.addVerifyListener(addMountListener);
        this.setup_.addVerifyListener(addMountListener);
        this.img1_.addVerifyListener(addMountListener);
        this.img2_.addVerifyListener(addMountListener);
        this.img3_.addVerifyListener(addMountListener);
    }

    @Override
    protected ToolBar createInfoTab() {
        ToolBar toolBar = super.createInfoTab();
        final ToolItem engineToolItem = this.engineSelector_.getToolItem();
        engineToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail != 4) {
                    final int WEB_IMAGE_WIDTH = EditSingleProfileDialog.this.settings_.getIntValue("mobygames", "image_width");
                    int WEB_IMAGE_HEIGHT = EditSingleProfileDialog.this.settings_.getIntValue("mobygames", "image_height");
                    int WEB_IMAGE_COLUMNS = EditSingleProfileDialog.this.settings_.getIntValue("mobygames", "image_columns");
                    int DIALOG_RESIZE_WIDTH = (WEB_IMAGE_WIDTH + 10) * WEB_IMAGE_COLUMNS + 3 * (WEB_IMAGE_COLUMNS - 1) + 19;
                    WebSearchEngine engine = WebSearchEngine.getBySimpleName(EditSingleProfileDialog.this.settings_.getValue("gui", "searchengine"));
                    WebProfile orgProf = (WebProfile)engineToolItem.getData("profile");
                    if (orgProf == null) {
                        String currTitle = EditSingleProfileDialog.this.title_.getText();
                        if (currTitle.length() >= 1) {
                            try {
                                WebProfile thisGame = null;
                                List<WebProfile> webGamesList = engine.getEntries(currTitle, EditSingleProfileDialog.this.settings_.getValues(engine.getSimpleName(), "platform_filter"));
                                if (webGamesList.size() == 0) {
                                    GeneralPurposeDialogs.infoMessage(EditSingleProfileDialog.this.shell_, EditSingleProfileDialog.this.text_.get("general.notice.searchenginenoresults", new String[]{engine.getName(), currTitle}));
                                } else {
                                    thisGame = webGamesList.size() == 1 ? webGamesList.get(0) : (WebProfile)new BrowseSearchEngineDialog(EditSingleProfileDialog.this.shell_, currTitle, webGamesList, engine).open();
                                }
                                if (thisGame != null) {
                                    int ss;
                                    String p;
                                    String n;
                                    final WebProfile profExt = engine.getEntryDetailedInformation(thisGame);
                                    WebProfile currentProf = new WebProfile();
                                    currentProf.setTitle(EditSingleProfileDialog.this.title_.getText());
                                    currentProf.setDeveloperName(EditSingleProfileDialog.this.developer_.getText());
                                    currentProf.setPublisherName(EditSingleProfileDialog.this.publisher_.getText());
                                    currentProf.setYear(EditSingleProfileDialog.this.year_.getText());
                                    currentProf.setGenre(EditSingleProfileDialog.this.genre_.getText());
                                    currentProf.setUrl(EditSingleProfileDialog.this.link_[0].getText());
                                    currentProf.setPlatform(EditSingleProfileDialog.this.linkTitle_[0].getText());
                                    currentProf.setNotes(EditSingleProfileDialog.this.notes_.getText());
                                    currentProf.setRank(EditSingleProfileDialog.this.custom9_.getSelection());
                                    engineToolItem.setData("profile", (Object)currentProf);
                                    engineToolItem.setImage(ImageService.getResourceImage(EditSingleProfileDialog.this.display_, "undo.png"));
                                    engineToolItem.setToolTipText(EditSingleProfileDialog.this.text_.get("dialog.profile.undosearchengine"));
                                    if (EditSingleProfileDialog.this.settings_.getBooleanValue(engine.getSimpleName(), "set_title")) {
                                        EditSingleProfileDialog.this.title_.setText(profExt.getTitle());
                                    }
                                    if (EditSingleProfileDialog.this.settings_.getBooleanValue(engine.getSimpleName(), "set_developer")) {
                                        EditSingleProfileDialog.this.developer_.setText(profExt.getDeveloperName());
                                    }
                                    if (EditSingleProfileDialog.this.settings_.getBooleanValue(engine.getSimpleName(), "set_publisher")) {
                                        EditSingleProfileDialog.this.publisher_.setText(profExt.getPublisherName());
                                    }
                                    if (EditSingleProfileDialog.this.settings_.getBooleanValue(engine.getSimpleName(), "set_year")) {
                                        EditSingleProfileDialog.this.year_.setText(profExt.getYear());
                                    }
                                    if (EditSingleProfileDialog.this.settings_.getBooleanValue(engine.getSimpleName(), "set_genre")) {
                                        EditSingleProfileDialog.this.genre_.setText(profExt.getGenre());
                                    }
                                    if (EditSingleProfileDialog.this.settings_.getBooleanValue(engine.getSimpleName(), "set_link")) {
                                        EditSingleProfileDialog.this.link_[0].setText(profExt.getUrl());
                                        EditSingleProfileDialog.this.linkTitle_[0].setText(EditSingleProfileDialog.this.text_.get("dialog.profile.searchengine.link.maininfo", new String[]{engine.getName()}));
                                    }
                                    if (EditSingleProfileDialog.this.settings_.getBooleanValue(engine.getSimpleName(), "set_description") && !(n = EditSingleProfileDialog.this.notes_.getText()).endsWith(p = profExt.getNotes().replaceAll("\n", EditSingleProfileDialog.this.notes_.getLineDelimiter()))) {
                                        if (n.length() > 0) {
                                            EditSingleProfileDialog.this.notes_.append(EditSingleProfileDialog.this.notes_.getLineDelimiter() + EditSingleProfileDialog.this.notes_.getLineDelimiter());
                                        }
                                        EditSingleProfileDialog.this.notes_.append(p);
                                    }
                                    if (EditSingleProfileDialog.this.settings_.getBooleanValue(engine.getSimpleName(), "set_rank")) {
                                        EditSingleProfileDialog.this.custom9_.setSelection(profExt.getRank());
                                    }
                                    int ca = EditSingleProfileDialog.this.settings_.getBooleanValue(engine.getSimpleName(), "choose_coverart") ? Integer.MAX_VALUE : 0;
                                    int n2 = ss = EditSingleProfileDialog.this.settings_.getBooleanValue(engine.getSimpleName(), "choose_screenshot") ? Integer.MAX_VALUE : 0;
                                    if (ca > 0 || ss > 0) {
                                        boolean forceAllRegionsCoverArt = EditSingleProfileDialog.this.settings_.getBooleanValue(engine.getSimpleName(), "force_all_regions_coverart");
                                        EditSingleProfileDialog.access$5202(EditSingleProfileDialog.this, engine.getEntryImages(profExt, ca, ss, forceAllRegionsCoverArt));
                                        EditSingleProfileDialog.this.webImagesSpaceHolder_ = EditSingleProfileDialog.createInnerComposite(EditSingleProfileDialog.this.contents_, new GridData(4, 4, false, true), 2);
                                        if (EditSingleProfileDialog.this.imageInformation_.length > 0) {
                                            EditSingleProfileDialog.createButton(EditSingleProfileDialog.this.webImagesSpaceHolder_, new GridData(WEB_IMAGE_WIDTH + 10, -1), EditSingleProfileDialog.this.text_.get("button.all"), null, (SelectionListener)new SelectionAdapter(){

                                                public void widgetSelected(SelectionEvent e) {
                                                    for (Button but : EditSingleProfileDialog.this.imgButtons_) {
                                                        but.setSelection(true);
                                                    }
                                                }
                                            });
                                            EditSingleProfileDialog.createButton(EditSingleProfileDialog.this.webImagesSpaceHolder_, new GridData(WEB_IMAGE_WIDTH + 10, -1), EditSingleProfileDialog.this.text_.get("button.none"), null, (SelectionListener)new SelectionAdapter(){

                                                public void widgetSelected(SelectionEvent e) {
                                                    for (Button but : EditSingleProfileDialog.this.imgButtons_) {
                                                        but.setSelection(false);
                                                    }
                                                }
                                            });
                                        }
                                        ScrolledComposite webImagesSpace = new ScrolledComposite(EditSingleProfileDialog.this.webImagesSpaceHolder_, 512);
                                        webImagesSpace.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
                                        webImagesSpace.setLayout((Layout)new GridLayout());
                                        webImagesSpace.getVerticalBar().setIncrement(WEB_IMAGE_HEIGHT / WEB_IMAGE_COLUMNS);
                                        webImagesSpace.getVerticalBar().setPageIncrement(WEB_IMAGE_HEIGHT / WEB_IMAGE_COLUMNS * 8);
                                        GridLayout gridLayoutImagesGroup = new GridLayout(WEB_IMAGE_COLUMNS, true);
                                        gridLayoutImagesGroup.marginHeight = 0;
                                        gridLayoutImagesGroup.marginWidth = 0;
                                        gridLayoutImagesGroup.horizontalSpacing = 1;
                                        gridLayoutImagesGroup.verticalSpacing = 1;
                                        final Composite webImagesComposite = EditSingleProfileDialog.createComposite((Composite)webImagesSpace, null, (Layout)gridLayoutImagesGroup);
                                        webImagesSpace.setContent((Control)webImagesComposite);
                                        if (EditSingleProfileDialog.this.imageInformation_.length > 0) {
                                            EditSingleProfileDialog.access$6802(EditSingleProfileDialog.this, new Button[EditSingleProfileDialog.this.imageInformation_.length]);
                                            int i = 0;
                                            while (i < EditSingleProfileDialog.this.imageInformation_.length) {
                                                ((EditSingleProfileDialog)EditSingleProfileDialog.this).imgButtons_[i] = EditSingleProfileDialog.createImageButton(webImagesComposite, 0x800002, new GridData(16384, 1024, true, true), ImageService.getEmptyImage(EditSingleProfileDialog.this.display_, WEB_IMAGE_WIDTH, WEB_IMAGE_HEIGHT), EditSingleProfileDialog.this.imageInformation_[i].getDescription());
                                                final int j = i++;
                                                Thread thread = new Thread(){

                                                    @Override
                                                    public void run() {
                                                        try {
                                                            ImageData imgData = profExt.getWebImage(j);
                                                            if (!EditSingleProfileDialog.this.shell_.isDisposed() && !EditSingleProfileDialog.this.imgButtons_[j].isDisposed()) {
                                                                final Image img = ImageService.getWidthLimitedImage(EditSingleProfileDialog.this.display_, WEB_IMAGE_WIDTH, imgData);
                                                                if (!EditSingleProfileDialog.this.shell_.isDisposed() && !EditSingleProfileDialog.this.imgButtons_[j].isDisposed()) {
                                                                    EditSingleProfileDialog.this.shell_.getDisplay().syncExec(new Runnable(){

                                                                        @Override
                                                                        public void run() {
                                                                            EditSingleProfileDialog.this.imgButtons_[j].getImage().dispose();
                                                                            EditSingleProfileDialog.this.imgButtons_[j].setImage(img);
                                                                            webImagesComposite.setSize(webImagesComposite.computeSize(-1, -1));
                                                                            webImagesComposite.layout();
                                                                        }
                                                                    });
                                                                }
                                                            }
                                                        }
                                                        catch (IOException iOException) {
                                                            // empty catch block
                                                        }
                                                    }
                                                };
                                                thread.start();
                                            }
                                        } else {
                                            GridData gd = new GridData(0x1000000, 4, true, true, WEB_IMAGE_COLUMNS, 1);
                                            gd.widthHint = (WEB_IMAGE_WIDTH + 10) * WEB_IMAGE_COLUMNS + 3 * (WEB_IMAGE_COLUMNS - 1) + 2;
                                            gd.verticalIndent = WEB_IMAGE_HEIGHT / 2;
                                            EditSingleProfileDialog.createLabel(webImagesComposite, 0x1000040, gd, EditSingleProfileDialog.this.text_.get("dialog.profile.notice.noimagesfound", new String[]{engine.getName()}));
                                        }
                                        EditSingleProfileDialog.this.setListenerEnabled(false);
                                        webImagesComposite.pack();
                                        EditSingleProfileDialog.this.shell_.setSize(((EditSingleProfileDialog)EditSingleProfileDialog.this).shell_.getSize().x + DIALOG_RESIZE_WIDTH, ((EditSingleProfileDialog)EditSingleProfileDialog.this).shell_.getSize().y);
                                        EditSingleProfileDialog.this.shell_.layout();
                                    }
                                }
                            }
                            catch (Exception e) {
                                GeneralPurposeDialogs.warningMessage(EditSingleProfileDialog.this.shell_, EditSingleProfileDialog.this.text_.get("general.error.retrieveinfosearchengine", new String[]{engine.getName(), currTitle, StringRelatedUtils.toString(e)}), e);
                            }
                        }
                    } else {
                        EditSingleProfileDialog.this.title_.setText(orgProf.getTitle());
                        EditSingleProfileDialog.this.developer_.setText(orgProf.getDeveloperName());
                        EditSingleProfileDialog.this.publisher_.setText(orgProf.getPublisherName());
                        EditSingleProfileDialog.this.year_.setText(orgProf.getYear());
                        EditSingleProfileDialog.this.genre_.setText(orgProf.getGenre());
                        EditSingleProfileDialog.this.link_[0].setText(orgProf.getUrl());
                        EditSingleProfileDialog.this.linkTitle_[0].setText(orgProf.getPlatform());
                        EditSingleProfileDialog.this.notes_.setText(orgProf.getNotes());
                        EditSingleProfileDialog.this.custom9_.setSelection(orgProf.getRank());
                        engineToolItem.setData("profile", null);
                        engineToolItem.setImage(ImageService.getResourceImage(EditSingleProfileDialog.this.display_, engine.getIcon()));
                        engineToolItem.setToolTipText(EditSingleProfileDialog.this.text_.get("dialog.profile.consultsearchengine", new String[]{engine.getName()}));
                        if (EditSingleProfileDialog.this.webImagesSpaceHolder_ != null) {
                            EditSingleProfileDialog.this.webImagesSpaceHolder_.dispose();
                            EditSingleProfileDialog.this.webImagesSpaceHolder_ = null;
                            EditSingleProfileDialog.this.shell_.setSize(((EditSingleProfileDialog)EditSingleProfileDialog.this).shell_.getSize().x - DIALOG_RESIZE_WIDTH, ((EditSingleProfileDialog)EditSingleProfileDialog.this).shell_.getSize().y);
                            EditSingleProfileDialog.this.shell_.layout();
                            EditSingleProfileDialog.this.setListenerEnabled(true);
                            EditSingleProfileDialog.access$10902(EditSingleProfileDialog.this, null);
                        }
                    }
                }
            }
        });
        EditSingleProfileDialog.createImageToolItem(toolBar, 8, ImageService.getResourceImage(this.display_, "share.png"), this.text_.get("button.consultconfsearchengine", new String[]{"DBConfWS"}), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String currTitle = EditSingleProfileDialog.this.title_.getText();
                if (currTitle.length() >= 1) {
                    try {
                        Client client = ClientBuilder.newClient();
                        List confs = (List)client.target(EditSingleProfileDialog.this.settings_.getValue("confsharing", "endpoint")).path("/configurations/bytitle/{i}").resolveTemplate("i", (Object)currTitle).request().accept(new String[]{"application/xml"}).get((GenericType)new GenericType<List<SharedConf>>(){});
                        client.close();
                        if (confs.size() == 0) {
                            GeneralPurposeDialogs.infoMessage(EditSingleProfileDialog.this.shell_, EditSingleProfileDialog.this.text_.get("general.notice.searchenginenoresults", new String[]{"DBConfWS", currTitle}));
                            return;
                        }
                        LoadSharedConfDialog.SharedConfLoading result = (LoadSharedConfDialog.SharedConfLoading)new LoadSharedConfDialog(EditSingleProfileDialog.this.shell_, currTitle, confs).open();
                        if (result != null) {
                            EditSingleProfileDialog.this.updateProfileByControls();
                            if (result.reloadDosboxDefaults_) {
                                EditSingleProfileDialog.this.profile_.getConfiguration().clearSections();
                            }
                            EditSingleProfileDialog.this.profile_.loadConfigurationData(EditSingleProfileDialog.this.text_, result.conf_.getIncrConf(), new File(result.conf_.getGameTitle()));
                            EditSingleProfileDialog.this.updateControlsByConfigurable(EditSingleProfileDialog.this.profile_, false);
                        }
                    }
                    catch (Exception e) {
                        GeneralPurposeDialogs.warningMessage(EditSingleProfileDialog.this.shell_, EditSingleProfileDialog.this.text_.get("general.error.retrieveinfosearchengine", new String[]{"DBConfWS", currTitle, StringRelatedUtils.toString(e)}), e);
                    }
                }
            }
        });
        return toolBar;
    }

    protected void createOkCancelButtons() {
        this.createOkCancelButtons((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!EditSingleProfileDialog.this.isValid()) {
                    return;
                }
                try {
                    EditSingleProfileDialog.this.updateProfileByControls();
                    if (EditSingleProfileDialog.this.editing_) {
                        new ProfileRepository().update(EditSingleProfileDialog.this.profile_);
                        EditSingleProfileDialog.this.result_ = EditSingleProfileDialog.this.profile_;
                    } else {
                        EditSingleProfileDialog.this.result_ = new ProfileRepository().add(EditSingleProfileDialog.this.profile_);
                    }
                    if (EditSingleProfileDialog.this.imageInformation_ != null) {
                        File canonicalCapturesDir = EditSingleProfileDialog.this.profile_.getCanonicalCaptures();
                        for (int i = 0; i < EditSingleProfileDialog.this.imageInformation_.length; ++i) {
                            if (!EditSingleProfileDialog.this.imgButtons_[i].getSelection()) continue;
                            String description = FilesUtils.toSafeFilenameForWebImages(EditSingleProfileDialog.this.imageInformation_[i].getDescription());
                            String filename = EditSingleProfileDialog.this.imageInformation_[i].getType() == SearchEngineImageInformation.SearchEngineImageType.CoverArt ? EditSingleProfileDialog.this.text_.get("dialog.profile.mobygames.coverartfilename", new Object[]{i, description}) : EditSingleProfileDialog.this.text_.get("dialog.profile.mobygames.screenshotfilename", new Object[]{i, description});
                            File file = new File(canonicalCapturesDir, filename + ".png");
                            if (!FilesUtils.isExistingFile(file)) {
                                try {
                                    ImageService.save(EditSingleProfileDialog.this.imageInformation_[i].getData(), file.getPath());
                                }
                                catch (SWTException e) {
                                    GeneralPurposeDialogs.warningMessage(EditSingleProfileDialog.this.shell_, EditSingleProfileDialog.this.text_.get("general.error.savefile", new Object[]{file.getPath()}), (Exception)((Object)e));
                                }
                                continue;
                            }
                            GeneralPurposeDialogs.warningMessage(EditSingleProfileDialog.this.shell_, EditSingleProfileDialog.this.text_.get("dialog.profile.error.imagealreadyexists", new Object[]{file.getPath(), WebSearchEngine.getBySimpleName(EditSingleProfileDialog.this.settings_.getValue("gui", "searchengine")).getName()}));
                        }
                    }
                }
                catch (Exception e) {
                    GeneralPurposeDialogs.warningMessage(EditSingleProfileDialog.this.shell_, e);
                }
                EditSingleProfileDialog.this.shell_.close();
            }
        });
        EditSingleProfileDialog.createImageButton(this.otherButtons_, ImageService.getResourceImage(this.display_, "share.png"), this.text_.get("button.shareconf"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditSingleProfileDialog.this.updateProfileByControls();
                new ShareConfDialog(EditSingleProfileDialog.this.shell_, EditSingleProfileDialog.this.title_.getText(), EditSingleProfileDialog.this.year_.getText(), EditSingleProfileDialog.this.profile_).open();
            }
        });
    }

    protected boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        String requiredMount = null;
        if (this.title_.getText().length() == 0) {
            GeneralPurposeDialogs.addError(this.text_.get("dialog.profile.required.title"), (Control)this.title_, this.getTabItemByControl((Control)this.title_));
        }
        if (this.dosExpandItem_.getExpanded()) {
            if (FilesUtils.isExecutable(this.main_.getText())) {
                requiredMount = this.dealWithField(false, this.main_.getText());
            } else {
                GeneralPurposeDialogs.addError(this.text_.get("dialog.profile.required.mainexe"), (Control)this.main_, this.getTabItemByControl((Control)this.main_));
            }
            if (FilesUtils.isExecutable(this.setup_.getText())) {
                requiredMount = this.dealWithField(false, this.setup_.getText());
            }
        } else {
            if (this.img1_.getText().length() == 0) {
                GeneralPurposeDialogs.addError(this.text_.get("dialog.profile.required.booterimage"), (Control)this.img1_, this.getTabItemByControl((Control)this.img1_));
            } else {
                requiredMount = this.dealWithField(true, this.img1_.getText());
            }
            if (this.img2_.getText().length() > 0) {
                requiredMount = this.dealWithField(true, this.img2_.getText());
            }
            if (this.img3_.getText().length() > 0) {
                requiredMount = this.dealWithField(true, this.img3_.getText());
            }
        }
        if (requiredMount != null) {
            GeneralPurposeDialogs.addError(this.text_.get("dialog.profile.required.mountlocation"), (Control)this.mountingpointsList_, this.getTabItemByControl((Control)this.mountingpointsList_));
        }
        if (this.setButton_.isEnabled()) {
            GeneralPurposeDialogs.addError(this.text_.get("dialog.template.required.dosboxassociation"), (Control)this.setButton_, this.getTabItemByControl((Control)this.setButton_));
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell_);
    }

    private String dealWithField(boolean booter, String target) {
        String requiredMount = this.profile_.getRequiredMount(booter, target, true, false);
        if (requiredMount != null && GeneralPurposeDialogs.confirmMessage(this.shell_, this.text_.get("dialog.profile.confirm.addmountlocation", new Object[]{requiredMount}))) {
            this.profile_.addRequiredMount(booter, target, false);
            this.mountingpointsList_.setItems(this.profile_.getMountStringsForUI());
        }
        return this.profile_.getRequiredMount(booter, target, true, false);
    }

    static /* synthetic */ SearchEngineImageInformation[] access$5202(EditSingleProfileDialog x0, SearchEngineImageInformation[] x1) {
        x0.imageInformation_ = x1;
        return x1;
    }

    static /* synthetic */ Button[] access$6802(EditSingleProfileDialog x0, Button[] x1) {
        x0.imgButtons_ = x1;
        return x1;
    }

    static /* synthetic */ SearchEngineImageInformation[] access$10902(EditSingleProfileDialog x0, SearchEngineImageInformation[] x1) {
        x0.imageInformation_ = x1;
        return x1;
    }
}

