/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.abstractdialog.SizeControlledTabbedDialog;
import org.dbgl.gui.controls.BrowseButton;
import org.dbgl.model.FileLocation;
import org.dbgl.model.ICanonicalize;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.service.FileLocationService;
import org.dbgl.service.ImportExportProfilesService;
import org.dbgl.util.FilesUtils;
import org.dbgl.util.SystemUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExportListDialog
extends SizeControlledTabbedDialog<Object> {
    private String[] xslBaseNames_;
    private final List<Profile> profiles_;

    public ExportListDialog(Shell parent, List<Profile> profs) {
        super(parent, "exportlistdialog");
        this.profiles_ = profs;
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.exportlist.title");
    }

    @Override
    protected boolean prepare() {
        this.xslBaseNames_ = FileLocationService.getInstance().listXslBaseNames();
        if (this.xslBaseNames_ == null) {
            GeneralPurposeDialogs.fatalMessage(this.getParent(), this.text_.get("dialog.exportlist.error.noxsldir"));
            return false;
        }
        if (this.xslBaseNames_.length == 0) {
            GeneralPurposeDialogs.fatalMessage(this.getParent(), this.text_.get("dialog.exportlist.error.noxslfiles"));
            return false;
        }
        return true;
    }

    @Override
    protected void onShellCreated() {
        Composite composite = this.createTabWithComposite(this.text_.get("dialog.exportlist.options"), 3);
        final Combo fileTypes = ExportListDialog.createLabelAndCombo(composite, this.text_.get("dialog.exportlist.exportfiletype"), true, 2, this.xslBaseNames_, 10);
        final Text filename = ExportListDialog.createLabelAndText(composite, this.text_.get("dialog.exportlist.filename"), FileLocationService.EXPORT_DIR_STRING + "dbgllist");
        final ICanonicalize canonicalizer = new BrowseButton(composite).connect(this.shell_, filename, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.DOC, true, null);
        final Button saveXml = ExportListDialog.createLabelAndCheckButton(composite, this.text_.get("dialog.exportlist.exportintermediatexml"), false);
        fileTypes.setFocus();
        fileTypes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index;
                String file = filename.getText();
                String type = fileTypes.getItem(fileTypes.getSelectionIndex());
                int usi = type.lastIndexOf(95);
                if (usi != -1) {
                    type = type.substring(usi + 1);
                }
                if ((index = file.lastIndexOf(46)) == -1) {
                    filename.setText(file + '.' + type);
                } else {
                    filename.setText(file.substring(0, index + 1) + type);
                }
            }
        });
        fileTypes.select(0);
        fileTypes.notifyListeners(13, new Event());
        this.createGoCancelButtons(this.text_.get("dialog.exportlist.startexport"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!ExportListDialog.this.isValid(filename, canonicalizer)) {
                    return;
                }
                try {
                    File exportFile = new FileLocation(filename.getText(), canonicalizer).getCanonicalFile();
                    File xmlFile = saveXml.getSelection() ? new File(exportFile + ".xml") : null;
                    File xsltFile = FileLocationService.getInstance().xslBaseNameToFile(fileTypes.getItem(fileTypes.getSelectionIndex()));
                    ImportExportProfilesService.export(ExportListDialog.this.profiles_, xmlFile, xsltFile, exportFile);
                    if (GeneralPurposeDialogs.confirmMessage(ExportListDialog.this.shell_, ExportListDialog.this.text_.get("dialog.exportlist.confirm.viewexport"))) {
                        SystemUtils.openForBrowsing(exportFile.getPath());
                    }
                }
                catch (IOException | ParserConfigurationException | TransformerException e) {
                    GeneralPurposeDialogs.warningMessage(ExportListDialog.this.shell_, e);
                }
            }
        });
    }

    private boolean isValid(Text filename, ICanonicalize canonicalizer) {
        GeneralPurposeDialogs.initErrorDialog();
        String file = filename.getText();
        File target = new FileLocation(file, canonicalizer).getCanonicalFile();
        if (StringUtils.isBlank((CharSequence)file)) {
            GeneralPurposeDialogs.addError(this.text_.get("dialog.exportlist.required.filename"), (Control)filename);
        } else if (FilesUtils.isExistingFile(target)) {
            if (!GeneralPurposeDialogs.confirmMessage(this.shell_, this.text_.get("dialog.exportlist.confirm.overwrite", new Object[]{target}))) {
                GeneralPurposeDialogs.addError(this.text_.get("dialog.exportlist.notice.anotherfilename"), (Control)filename);
            }
        } else {
            File dir = target.getParentFile();
            if (dir == null || !dir.exists()) {
                GeneralPurposeDialogs.addError(this.text_.get("dialog.exportlist.error.dirmissing"), (Control)filename);
            }
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell_);
    }
}

