/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.abstractdialog.SizeControlledButtonDialog;
import org.dbgl.model.entity.LogEntry;
import org.dbgl.model.repository.LoggingRepository;
import org.dbgl.service.ImageService;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class LogDialog
extends SizeControlledButtonDialog<Object> {
    private List<LogEntry> logEntries;
    private String orderByClause_;
    private LogEntry clickedEntry;
    private Integer clickedColumn;

    public LogDialog(Shell parent) {
        super(parent, "log");
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.log.title");
    }

    @Override
    protected void onShellCreated() {
        this.contents_.setLayout((Layout)new FillLayout());
        final Table table = new Table(this.contents_, 67584);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        final LinkedHashMap<String, String> filterClauses = new LinkedHashMap<String, String>();
        this.orderByClause_ = " ORDER BY ID";
        final String[] titles = new String[]{this.text_.get("dialog.log.columns.time"), this.text_.get("dialog.log.columns.event"), this.text_.get("dialog.log.columns.entitytype"), this.text_.get("dialog.log.columns.entitytitle"), this.text_.get("dialog.log.columns.entityid")};
        for (int i = 0; i < titles.length; ++i) {
            final int columnId = i;
            TableColumn column = new TableColumn(table, 0);
            column.setText(titles[i]);
            column.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    switch (columnId) {
                        case 0: {
                            LogDialog.this.orderByClause_ = " ORDER BY ID";
                            break;
                        }
                        case 1: {
                            LogDialog.this.orderByClause_ = " ORDER BY EVENT";
                            break;
                        }
                        case 2: {
                            LogDialog.this.orderByClause_ = " ORDER BY ENTITY_TYPE";
                            break;
                        }
                        case 3: {
                            LogDialog.this.orderByClause_ = " ORDER BY ENTITY_TITLE";
                            break;
                        }
                        case 4: {
                            LogDialog.this.orderByClause_ = " ORDER BY ENTITY_ID";
                            break;
                        }
                    }
                    TableColumn sortColumn = (TableColumn)e.widget;
                    int sortDirection = 128;
                    if (sortColumn == table.getSortColumn() && table.getSortDirection() == 128) {
                        sortDirection = 1024;
                    }
                    if (sortDirection == 1024) {
                        LogDialog.this.orderByClause_ = LogDialog.this.orderByClause_ + " DESC";
                    }
                    LogDialog.this.repopulateEntries(table, sortColumn, sortDirection, filterClauses);
                }
            });
        }
        final Menu menu = new Menu((Decorations)this.shell_, 8);
        menu.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                MenuItem[] menuItems = menu.getItems();
                for (MenuItem menuItem : menuItems) {
                    menuItem.dispose();
                }
                if (LogDialog.this.clickedEntry != null && LogDialog.this.clickedColumn != null) {
                    MenuItem mi = new MenuItem(menu, 8);
                    switch (LogDialog.this.clickedColumn) {
                        case 0: {
                            mi.setText(titles[LogDialog.this.clickedColumn] + ": " + LogDialog.this.text_.toString(LogDialog.this.clickedEntry.getTime()));
                            break;
                        }
                        case 1: {
                            mi.setText(titles[LogDialog.this.clickedColumn] + ": " + LogDialog.this.getEventName(LogDialog.this.clickedEntry.getEvent()));
                            break;
                        }
                        case 2: {
                            mi.setText(titles[LogDialog.this.clickedColumn] + ": " + LogDialog.this.getEntityTypeName(LogDialog.this.clickedEntry.getEntityType()));
                            break;
                        }
                        case 3: {
                            mi.setText(titles[LogDialog.this.clickedColumn] + ": " + LogDialog.this.clickedEntry.getEntityTitle());
                            break;
                        }
                        case 4: {
                            mi.setText(titles[LogDialog.this.clickedColumn] + ": " + LogDialog.this.clickedEntry.getEntityId());
                            break;
                        }
                    }
                    mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            MenuItem mi = (MenuItem)event.widget;
                            switch (LogDialog.this.clickedColumn) {
                                case 0: {
                                    Calendar cal = Calendar.getInstance();
                                    cal.setTime(LogDialog.this.clickedEntry.getTime());
                                    filterClauses.put("YEAR(TIME)=" + cal.get(1) + " AND MONTH(TIME)=" + (cal.get(2) + 1) + " AND DAY(TIME)=" + cal.get(5), mi.getText());
                                    break;
                                }
                                case 1: {
                                    filterClauses.put("EVENT=" + LogDialog.this.clickedEntry.getEvent().ordinal(), mi.getText());
                                    break;
                                }
                                case 2: {
                                    filterClauses.put("ENTITY_TYPE=" + LogDialog.this.clickedEntry.getEntityType().ordinal(), mi.getText());
                                    break;
                                }
                                case 3: {
                                    filterClauses.put("ENTITY_TITLE='" + LogDialog.this.clickedEntry.getEntityTitle() + "'", mi.getText());
                                    break;
                                }
                                case 4: {
                                    filterClauses.put("ENTITY_ID=" + LogDialog.this.clickedEntry.getEntityId(), mi.getText());
                                    break;
                                }
                            }
                            LogDialog.this.repopulateEntries(table, table.getSortColumn(), table.getSortDirection(), filterClauses);
                        }
                    });
                    if (!filterClauses.isEmpty()) {
                        new MenuItem(menu, 2);
                    }
                }
                for (final Map.Entry entry : filterClauses.entrySet()) {
                    MenuItem ci = new MenuItem(menu, 8);
                    ci.setText((String)entry.getValue());
                    ci.setImage(ImageService.getResourceImage(LogDialog.this.display_, "delete.png"));
                    ci.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            filterClauses.remove(entry.getKey());
                            LogDialog.this.repopulateEntries(table, table.getSortColumn(), table.getSortDirection(), filterClauses);
                        }
                    });
                }
            }
        });
        table.setMenu(menu);
        table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                LogDialog.this.clickedEntry = null;
                LogDialog.this.clickedColumn = null;
                Point pt = new Point(event.x, event.y);
                TableItem item = table.getItem(pt);
                if (item == null) {
                    return;
                }
                for (int i = 0; i < titles.length; ++i) {
                    if (!item.getBounds(i).contains(pt)) continue;
                    LogDialog.this.clickedEntry = (LogEntry)LogDialog.this.logEntries.get(table.indexOf(item));
                    LogDialog.this.clickedColumn = i;
                    break;
                }
            }
        });
        this.repopulateEntries(table, table.getColumn(0), 128, filterClauses);
        for (int i = 0; i < titles.length; ++i) {
            table.getColumn(i).pack();
        }
        this.createOkButton((SelectionListener)this.closeShellAdapter);
        Button enableButton = LogDialog.createToggleButton(this.otherButtons_, this.text_.get(this.settings_.getBooleanValue("log", "enabled") ? "dialog.log.enabled" : "dialog.log.disabled"), this.settings_.getBooleanValue("log", "enabled"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.getSource();
                LogDialog.this.settings_.setBooleanValue("log", "enabled", button.getSelection());
                button.setText(LogDialog.this.text_.get(button.getSelection() ? "dialog.log.enabled" : "dialog.log.disabled"));
            }
        });
        Button clearButton = LogDialog.createButton(this.otherButtons_, this.text_.get("button.clear"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (GeneralPurposeDialogs.confirmMessage(LogDialog.this.shell_, LogDialog.this.text_.get("dialog.log.confirm.clear"))) {
                    try {
                        new LoggingRepository().clear();
                        table.removeAll();
                    }
                    catch (SQLException e) {
                        GeneralPurposeDialogs.warningMessage(LogDialog.this.shell_, e);
                    }
                }
            }
        });
        LogDialog.setLayoutDataButtons(this.okButton_);
        LogDialog.setLayoutDataButtons(enableButton, clearButton);
    }

    private void repopulateEntries(Table table, TableColumn sortColumn, int sortDirection, Map<String, String> filterClauses) {
        int selLogEntryId = table.getSelectionIndex() == -1 ? -1 : this.logEntries.get(table.getSelectionIndex()).getId();
        try {
            String whereClause = filterClauses.isEmpty() ? "" : " WHERE " + StringUtils.join(filterClauses.keySet(), (String)" AND ");
            this.logEntries = new LoggingRepository().list(whereClause, this.orderByClause_);
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell_, e);
            this.logEntries = new ArrayList<LogEntry>();
        }
        table.removeAll();
        table.setSortColumn(sortColumn);
        table.setSortDirection(sortDirection);
        table.setItemCount(this.logEntries.size());
        int idx = this.logEntries.size() - 1;
        for (int i = 0; i < this.logEntries.size(); ++i) {
            LogEntry entry = this.logEntries.get(i);
            TableItem item = table.getItem(i);
            item.setText(0, this.text_.toString(entry.getTime(), 2));
            item.setText(1, this.getEventName(entry.getEvent()));
            item.setText(2, this.getEntityTypeName(entry.getEntityType()));
            item.setText(3, entry.getEntityTitle());
            item.setText(4, String.valueOf(entry.getEntityId()));
            if (selLogEntryId != this.logEntries.get(i).getId()) continue;
            idx = i;
        }
        table.setSelection(idx);
        table.showSelection();
    }

    private String getEventName(LogEntry.Event event) {
        switch (event) {
            case ADD: {
                return this.text_.get("dialog.log.columns.event.add");
            }
            case EDIT: {
                return this.text_.get("dialog.log.columns.event.edit");
            }
            case REMOVE: {
                return this.text_.get("dialog.log.columns.event.remove");
            }
            case DUPLICATE: {
                return this.text_.get("dialog.log.columns.event.duplicate");
            }
            case RUN: {
                return this.text_.get("dialog.log.columns.event.run");
            }
            case SETUP: {
                return this.text_.get("dialog.log.columns.event.setup");
            }
        }
        return "";
    }

    private String getEntityTypeName(LogEntry.EntityType type) {
        switch (type) {
            case PROFILE: {
                return this.text_.get("dialog.log.columns.entitytype.profile");
            }
            case DOSBOXVERSION: {
                return this.text_.get("dialog.template.dosboxversion");
            }
            case TEMPLATE: {
                return this.text_.get("dialog.profile.template");
            }
            case FILTER: {
                return this.text_.get("dialog.log.columns.entitytype.filter");
            }
        }
        return "";
    }
}

