/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.connect.Messaging;
import org.dbgl.constants.Constants;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.abstractdialog.SizeControlledDialog;
import org.dbgl.gui.controls.ProfilesList;
import org.dbgl.gui.dialog.AboutDialog;
import org.dbgl.gui.dialog.DeleteProfilesDialog;
import org.dbgl.gui.dialog.EditDosboxVersionDialog;
import org.dbgl.gui.dialog.EditFilterDialog;
import org.dbgl.gui.dialog.EditMultiProfileDialog;
import org.dbgl.gui.dialog.EditSingleProfileDialog;
import org.dbgl.gui.dialog.EditTemplateDialog;
import org.dbgl.gui.dialog.ExportListDialog;
import org.dbgl.gui.dialog.LogDialog;
import org.dbgl.gui.dialog.ProfileLoader;
import org.dbgl.gui.dialog.SettingsDialog;
import org.dbgl.gui.dialog.Thumb;
import org.dbgl.gui.dialog.wizard.AddGameWizardDialog;
import org.dbgl.gui.dialog.wizard.DFendImportDialog;
import org.dbgl.gui.dialog.wizard.ExportDialog;
import org.dbgl.gui.dialog.wizard.ImportDialog;
import org.dbgl.gui.dialog.wizard.MigrateDialog;
import org.dbgl.gui.interfaces.ReOrderable;
import org.dbgl.model.OrderingVector;
import org.dbgl.model.SearchResult;
import org.dbgl.model.ThumbInfo;
import org.dbgl.model.ViewType;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.aggregate.Template;
import org.dbgl.model.entity.Filter;
import org.dbgl.model.repository.DosboxVersionRepository;
import org.dbgl.model.repository.FilterRepository;
import org.dbgl.model.repository.ProfileRepository;
import org.dbgl.model.repository.TemplateRepository;
import org.dbgl.model.repository.TitledEntityRepository;
import org.dbgl.service.DatabaseService;
import org.dbgl.service.FileLocationService;
import org.dbgl.service.ImageService;
import org.dbgl.service.ImportExportTemplatesService;
import org.dbgl.service.TextService;
import org.dbgl.util.ExecuteUtils;
import org.dbgl.util.FilesUtils;
import org.dbgl.util.SystemUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.xml.sax.SAXException;

public class MainWindow
extends SizeControlledDialog<Object>
implements ReOrderable {
    private static final String[] ICOS_DBGL = new String[]{"ico/016.png", "ico/024.png", "ico/032.png", "ico/048.png", "ico/064.png", "ico/128.png", "ico/256.png"};
    private String filterClause_;
    private OrderingVector orderingVector_;
    private List<Profile> profilesList_;
    private List<DosboxVersion> dbversionsList_;
    private List<Template> templatesList_;
    private List<Filter> filtersList_;
    private Messaging mess_;
    public static String[] columnNames_;
    private int[] columnIds_;
    private ToolItem setupToolItem_;
    private ToolItem viewSelector_;
    private CTabFolder filterFolder_;
    private ProfilesList profileTable_;
    private Text notesField_;
    private Link[] link_;
    private SashForm sashInfoForm_;
    private ScrolledComposite scrolledCompositeForThumbs_;
    private Composite thumbsComposite_;
    private int thumbHeight_;
    private File currentThumbFile_ = null;
    private Menu thumbMenu_;
    private Table dbversionTable_;
    private Table templateTable_;
    private final SelectionAdapter addProfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doAddProfile(null);
        }
    };
    private final SelectionAdapter editProfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doEditProfile(false);
        }
    };
    private final SelectionAdapter removeProfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doRemoveProfile();
        }
    };
    private final SelectionAdapter setupProfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doRunProfile(ExecuteUtils.ProfileRunMode.SETUP, false);
        }
    };
    private final SelectionAdapter runProfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doRunProfile(ExecuteUtils.ProfileRunMode.NORMAL, false);
        }
    };

    public MainWindow() {
        super(new Shell(), 32768, "");
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("main.title", new Object[]{Constants.PROGRAM_VERSION});
    }

    @Override
    protected boolean prepare() {
        if (!super.prepare()) {
            return false;
        }
        try {
            this.dbversionsList_ = new DosboxVersionRepository().listAll();
            ProfileRepository profileRepo = new ProfileRepository();
            List<Profile> invalidProfiles = profileRepo.listInvalidProfiles(this.dbversionsList_);
            if (invalidProfiles.size() > 0) {
                String titles = invalidProfiles.stream().map(x -> x.getTitle()).collect(Collectors.joining(", "));
                if (GeneralPurposeDialogs.confirmMessage(new Shell(), this.text_.get("dialog.main.confirm.removeinvalidprofiles", new Object[]{invalidProfiles.size(), titles}))) {
                    for (Profile prof : invalidProfiles) {
                        profileRepo.remove(prof, false, false, false);
                    }
                }
            }
            this.templatesList_ = new TemplateRepository().listAll(this.dbversionsList_);
            this.orderingVector_ = new OrderingVector(this.settings_.getIntValues("gui", "sortcolumn"), this.settings_.getBooleanValues("gui", "sortascending"));
            this.filtersList_ = new FilterRepository().listAll();
            this.filtersList_.add(0, new Filter(this.text_.get("dialog.main.allprofiles"), null));
            this.filterClause_ = this.filtersList_.get(this.settings_.getIntValue("gui", "filtertab")).getFilter();
            this.profilesList_ = profileRepo.list(this.orderingVector_.toClause(), this.filterClause_, this.dbversionsList_);
        }
        catch (Exception e) {
            GeneralPurposeDialogs.warningMessage(new Shell(), e);
            return false;
        }
        if (this.settings_.getBooleanValue("communication", "port_enabled")) {
            this.mess_ = new Messaging(this.settings_.getIntValue("communication", "port"), this, this.text_);
            this.mess_.start();
        }
        return true;
    }

    @Override
    protected void onShellCreated() {
        this.createAppMenuBar();
        this.shell_.setLayout((Layout)new FillLayout());
        this.shell_.setImages(ImageService.getResourceImages(this.display_, ICOS_DBGL));
        final TabFolder tabFolder = new TabFolder((Composite)this.shell_, 0);
        this.createProfilesTab(tabFolder);
        this.createDosboxVersionsTab(tabFolder);
        this.createTemplatesTab(tabFolder);
        this.shell_.addListener(26, new Listener(){

            public void handleEvent(Event arg0) {
                if (tabFolder.getSelectionIndex() == 0) {
                    MainWindow.this.profileTable_.setFocus();
                    MainWindow.this.displayProfileInformation(true);
                }
            }
        });
        this.profilesList_.forEach(x -> this.addProfileToTable((Profile)x));
        this.dbversionsList_.forEach(x -> this.addDosboxVersionToTable((DosboxVersion)x));
        this.templatesList_.forEach(x -> this.addTemplateToTable((Template)x));
        if (DatabaseService.getInstance().isInitializedNewDatabase()) {
            this.doLocateDosbox(false);
            if (this.dbversionsList_.size() > 0) {
                this.doImportDefaultTemplates(false);
            }
        }
    }

    @Override
    protected void onShellOpened() {
        super.onShellOpened();
        this.profileTable_.setFocus();
        this.profileTable_.setSelection(this.settings_.getIntValue("gui", "selectedprofile"));
        this.displayProfileInformation(false);
    }

    @Override
    protected void onClose() {
        super.onClose();
        ImageService.clearCache();
        this.display_.dispose();
        if (this.mess_ != null) {
            this.mess_.close();
        }
        try {
            this.settings_.save();
        }
        catch (IOException e) {
            GeneralPurposeDialogs.warningMessage(this.shell_, e);
        }
        try {
            DatabaseService.getInstance().shutdown();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void initColumnIds() {
        int i;
        columnNames_ = new String[32];
        int c = 0;
        MainWindow.columnNames_[c++] = this.text_.get("dialog.main.profiles.column.title");
        MainWindow.columnNames_[c++] = this.text_.get("dialog.main.profiles.column.setup");
        MainWindow.columnNames_[c++] = this.text_.get("dialog.main.profiles.column.developer");
        MainWindow.columnNames_[c++] = this.text_.get("dialog.main.profiles.column.publisher");
        MainWindow.columnNames_[c++] = this.text_.get("dialog.main.profiles.column.genre");
        MainWindow.columnNames_[c++] = this.text_.get("dialog.main.profiles.column.year");
        MainWindow.columnNames_[c++] = this.text_.get("dialog.main.profiles.column.status");
        MainWindow.columnNames_[c++] = this.text_.get("dialog.main.profiles.column.favorite");
        MainWindow.columnNames_[c++] = this.text_.get("dialog.main.profiles.column.id");
        MainWindow.columnNames_[c++] = this.text_.get("dialog.main.profiles.column.dosboxversionid");
        for (i = 0; i < 10; ++i) {
            MainWindow.columnNames_[c++] = this.settings_.getValue("gui", "custom" + (i + 1));
        }
        MainWindow.columnNames_[c++] = this.text_.get("dialog.main.profiles.column.screenshot");
        MainWindow.columnNames_[c++] = this.text_.get("dialog.main.profiles.column.dosboxversiontitle");
        MainWindow.columnNames_[c++] = this.text_.get("dialog.main.generic.column.created");
        MainWindow.columnNames_[c++] = this.text_.get("dialog.main.generic.column.lastmodify");
        MainWindow.columnNames_[c++] = this.text_.get("dialog.main.generic.column.lastrun");
        MainWindow.columnNames_[c++] = this.text_.get("dialog.main.generic.column.lastsetup");
        MainWindow.columnNames_[c++] = this.text_.get("dialog.main.generic.column.runs");
        MainWindow.columnNames_[c++] = this.text_.get("dialog.main.generic.column.setups");
        for (i = 0; i < 4; ++i) {
            MainWindow.columnNames_[c++] = this.settings_.getValue("gui", "custom" + (i + 1 + 10));
        }
        this.columnIds_ = IntStream.range(0, c).filter(x -> this.settings_.getBooleanValue("gui", "column" + (x + 1) + "visible")).toArray();
    }

    private void createAppMenuBar() {
        Menu appMenuBar = this.display_.getMenuBar();
        if (appMenuBar == null) {
            appMenuBar = new Menu((Decorations)this.shell_, 2);
            this.shell_.setMenuBar(appMenuBar);
        }
        SelectionAdapter settingsAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doOpenSettingsDialog();
            }
        };
        SelectionAdapter logAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                new LogDialog(MainWindow.this.shell_).open();
            }
        };
        SelectionAdapter cleanupAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    if (GeneralPurposeDialogs.confirmMessage(MainWindow.this.shell_, MainWindow.this.text_.get("dialog.main.confirm.databasecleanup"))) {
                        int itemsRemoved = new TitledEntityRepository().cleanup();
                        GeneralPurposeDialogs.infoMessage(MainWindow.this.shell_, MainWindow.this.text_.get("dialog.main.notice.databasecleanupok", new Object[]{itemsRemoved}));
                    }
                }
                catch (SQLException e) {
                    GeneralPurposeDialogs.warningMessage(MainWindow.this.shell_, e);
                }
            }
        };
        SelectionAdapter openAboutAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                new AboutDialog(MainWindow.this.shell_).open();
            }
        };
        SelectionAdapter quitAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.shell_.close();
            }
        };
        Menu systemMenu = this.display_.getSystemMenu();
        if (systemMenu != null) {
            MainWindow.getMenuItemById(systemMenu, -2).addSelectionListener((SelectionListener)settingsAdapter);
            MainWindow.getMenuItemById(systemMenu, -1).addSelectionListener((SelectionListener)openAboutAdapter);
            int prefsIndex = systemMenu.indexOf(MainWindow.getMenuItemById(systemMenu, -2));
            MainWindow.createMenuItem(systemMenu, prefsIndex + 1, this.text_.get("dialog.main.menu.log"), (SelectionListener)logAdapter);
            MainWindow.createMenuItem(systemMenu, prefsIndex + 2, this.text_.get("dialog.main.menu.databasecleanup"), (SelectionListener)cleanupAdapter);
        } else {
            Menu fileMenu = MainWindow.createMenu(appMenuBar, this.text_.get("dialog.main.menu.file"));
            MainWindow.createMenuItem(fileMenu, this.text_.get("dialog.main.menu.adjustsettings"), "settings.png", (SelectionListener)settingsAdapter);
            MainWindow.createMenuItem(fileMenu, this.text_.get("dialog.main.menu.log"), "log.png", (SelectionListener)logAdapter);
            MainWindow.createMenuItem(fileMenu, this.text_.get("dialog.main.menu.databasecleanup"), "clean.png", (SelectionListener)cleanupAdapter);
            MainWindow.createMenuItem(fileMenu, this.text_.get("dialog.main.menu.exit"), "stop.png", (SelectionListener)quitAdapter);
        }
        Menu profilesMenu = MainWindow.createMenu(appMenuBar, this.text_.get("dialog.main.menu.profiles"));
        MainWindow.createMenuItem(profilesMenu, 0, this.text_.get("dialog.main.menu.import"), "import.png", SWT.MOD1 | SWT.MOD3 | 0x49, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doImportProfiles(true);
            }
        });
        MainWindow.createMenuItem(profilesMenu, this.text_.get("dialog.main.menu.importprofile"), "import.png", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doImportProfiles(false);
            }
        });
        MainWindow.createMenuItem(profilesMenu, this.text_.get("dialog.main.menu.importdfendprofiles"), "dfend.png", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DosboxVersion defaultDbversion = MainWindow.this.requireDefaultDBVersion();
                if (defaultDbversion == null) {
                    return;
                }
                if (MainWindow.this.settings_.getIntValue("profiledefaults", "confpath") == 1) {
                    GeneralPurposeDialogs.infoMessage(MainWindow.this.shell_, MainWindow.this.text_.get("dialog.main.notice.dfendimportconflocation", new Object[]{SettingsDialog.confLocations[0]}));
                }
                if (new DFendImportDialog(MainWindow.this.shell_, defaultDbversion).open() != null) {
                    MainWindow.this.updateProfilesList(MainWindow.this.getSelectedProfileIds());
                    MainWindow.this.displayProfileInformation(true);
                }
            }
        });
        MainWindow.createSeparatorMenuItem(profilesMenu);
        MainWindow.createMenuItem(profilesMenu, 0, this.text_.get("dialog.main.menu.export"), "checkout.png", SWT.MOD1 | SWT.MOD3 | 0x45, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                List loadedProfiles;
                if (MainWindow.this.profileTable_.getSelectionIndex() != -1 && (loadedProfiles = (List)new ProfileLoader(MainWindow.this.shell_, MainWindow.this.getSelectedProfiles()).open()) != null) {
                    new ExportDialog(MainWindow.this.shell_, loadedProfiles).open();
                }
            }
        });
        MainWindow.createMenuItem(profilesMenu, this.text_.get("dialog.main.menu.exportprofileslist"), "checkout.png", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                new ExportListDialog(MainWindow.this.shell_, MainWindow.this.profilesList_).open();
            }
        });
        MainWindow.createSeparatorMenuItem(profilesMenu);
        MainWindow.createMenuItem(profilesMenu, this.text_.get("dialog.main.menu.migrateprofiles"), "case.png", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doMigrate();
            }
        });
        Menu dbversionsMenu = MainWindow.createMenu(appMenuBar, this.text_.get("dialog.main.menu.dosboxversions"));
        MainWindow.createMenuItem(dbversionsMenu, this.text_.get("dialog.main.menu.locatedosbox"), "zoom.png", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doLocateDosbox(true);
            }
        });
        Menu templatesMenu = MainWindow.createMenu(appMenuBar, this.text_.get("dialog.main.menu.templates"));
        if (SystemUtils.IS_WINDOWS && SystemUtils.IS_LINUX) {
            MainWindow.createMenuItem(templatesMenu, this.text_.get("dialog.main.menu.exporttemplates"), "checkout.png", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    try {
                        String warnings = ImportExportTemplatesService.export(MainWindow.this.templatesList_);
                        if (StringUtils.isNotEmpty((CharSequence)warnings)) {
                            GeneralPurposeDialogs.warningMessage(MainWindow.this.shell_, warnings);
                        }
                    }
                    catch (Exception e) {
                        GeneralPurposeDialogs.fatalMessage(MainWindow.this.shell_, e.toString(), e);
                    }
                }
            });
        }
        MainWindow.createMenuItem(templatesMenu, this.text_.get("dialog.main.menu.importdefaulttemplates"), "import.png", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doImportDefaultTemplates(true);
            }
        });
        Menu filterMenu = MainWindow.createMenu(appMenuBar, this.text_.get("dialog.main.menu.filter"));
        MainWindow.createMenuItem(filterMenu, this.text_.get("dialog.main.menu.addfilter"), "filter.png", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doAddFilter();
            }
        });
        MainWindow.createMenuItem(filterMenu, this.text_.get("dialog.main.menu.editfilter"), "editfilter.png", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doEditFilter();
            }
        });
        if (systemMenu == null) {
            Menu helpMenu = MainWindow.createMenu(appMenuBar, this.text_.get("dialog.main.menu.help"));
            MainWindow.createMenuItem(helpMenu, this.text_.get("dialog.main.menu.about"), "about.png", (SelectionListener)openAboutAdapter);
        }
    }

    private static MenuItem getMenuItemById(Menu menu, int id) {
        for (MenuItem item : menu.getItems()) {
            if (item.getID() != id) continue;
            return item;
        }
        return null;
    }

    private void createProfilesTab(TabFolder tabFolder) {
        Composite composite = MainWindow.createTabWithInnerComposite(tabFolder, this.text_.get("dialog.main.profiles"), 1);
        RowLayout rowLayout = new RowLayout();
        rowLayout.spacing = 20;
        rowLayout.marginLeft = 0;
        rowLayout.marginBottom = 0;
        rowLayout.marginTop = 0;
        Composite toolbarComposite = MainWindow.createComposite(composite, new GridData(16384, 128, false, false), (Layout)rowLayout);
        ToolBar toolBar = new ToolBar(toolbarComposite, 256);
        MainWindow.createImageToolItem(toolBar, this.text_.get("dialog.main.addprofile"), "tb_new.png", (SelectionListener)this.addProfAdapter);
        MainWindow.createImageToolItem(toolBar, this.text_.get("dialog.main.editprofile"), "tb_edit.png", (SelectionListener)this.editProfAdapter);
        MainWindow.createImageToolItem(toolBar, this.text_.get("dialog.main.removeprofile"), "tb_delete.png", (SelectionListener)this.removeProfAdapter);
        MainWindow.createImageToolItem(toolBar, this.text_.get("dialog.main.runprofile"), "tb_run.png", (SelectionListener)this.runProfAdapter);
        this.setupToolItem_ = MainWindow.createImageToolItem(toolBar, this.text_.get("dialog.main.runprofilesetup"), "tb_setup.png", (SelectionListener)this.setupProfAdapter);
        MainWindow.createSeparatorToolItem(toolBar, 40);
        MainWindow.createImageToolItem(toolBar, this.text_.get("dialog.main.addwizard"), "tb_wizard.png", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.updateWithAddedProfile((Profile)new AddGameWizardDialog(MainWindow.this.shell_).open());
            }
        });
        this.initColumnIds();
        final ViewType[] views = new ViewType[]{new ViewType(ProfilesList.ProfilesListType.TABLE.toString(), "table.png", this.text_.get("dialog.main.profiles.viewtype.table")), new ViewType(ProfilesList.ProfilesListType.SMALL_TILES.toString(), "tiles_small.png", this.text_.get("dialog.main.profiles.viewtype.smalltiles")), new ViewType(ProfilesList.ProfilesListType.MEDIUM_TILES.toString(), "tiles_medium.png", this.text_.get("dialog.main.profiles.viewtype.mediumtiles")), new ViewType(ProfilesList.ProfilesListType.LARGE_TILES.toString(), "tiles_large.png", this.text_.get("dialog.main.profiles.viewtype.largetiles")), new ViewType(ProfilesList.ProfilesListType.SMALL_BOXES.toString(), "boxes_small.png", this.text_.get("dialog.main.profiles.viewtype.smallboxes")), new ViewType(ProfilesList.ProfilesListType.MEDIUM_BOXES.toString(), "boxes_medium.png", this.text_.get("dialog.main.profiles.viewtype.mediumboxes")), new ViewType(ProfilesList.ProfilesListType.LARGE_BOXES.toString(), "boxes_large.png", this.text_.get("dialog.main.profiles.viewtype.largeboxes"))};
        ViewType currentViewType = this.settings_.getValue("gui", "viewstyle").equalsIgnoreCase(views[0].getName()) ? views[0] : views[1];
        final Menu viewMenu = new Menu((Decorations)this.shell_, 8);
        for (ViewType view : views) {
            MainWindow.createMenuItem(viewMenu, 8, view.getDisplayName(), view.getImage(), 1, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    MenuItem menuItem = (MenuItem)event.widget;
                    ViewType newViewType = views[menuItem.getParent().indexOf(menuItem)];
                    if (!MainWindow.this.settings_.getValue("gui", "viewstyle").equalsIgnoreCase(newViewType.getName())) {
                        MainWindow.this.toggleProfileViewType(newViewType);
                    }
                }
            });
        }
        final ToolBar toolBarRight = new ToolBar(toolbarComposite, 256);
        this.viewSelector_ = MainWindow.createImageToolItem(toolBarRight, 4, ImageService.getResourceImage(this.shell_.getDisplay(), currentViewType.getImage()), currentViewType.getDisplayName(), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail == 4) {
                    Rectangle rect = MainWindow.this.viewSelector_.getBounds();
                    Point pt = new Point(rect.x, rect.y + rect.height);
                    pt = toolBarRight.toDisplay(pt);
                    viewMenu.setLocation(pt.x, pt.y);
                    viewMenu.setVisible(true);
                } else {
                    for (int i = 0; i < views.length; ++i) {
                        if (!MainWindow.this.settings_.getValue("gui", "viewstyle").equalsIgnoreCase(views[i].getName())) continue;
                        MainWindow.this.toggleProfileViewType(views[(i + 1) % views.length]);
                        break;
                    }
                }
            }
        });
        MainWindow.createSeparatorToolItem(toolBarRight, 4);
        ToolItem displayScreenshots = MainWindow.createImageToolItem(toolBarRight, 32, ImageService.getResourceImage(this.shell_.getDisplay(), "screenshots.png"), this.text_.get("dialog.main.profiles.togglebutton.screenshots"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ToolItem item = (ToolItem)event.widget;
                ((GridData)((MainWindow)MainWindow.this).scrolledCompositeForThumbs_.getLayoutData()).exclude = !item.getSelection();
                MainWindow.this.scrolledCompositeForThumbs_.getParent().layout();
                MainWindow.this.settings_.setBooleanValue("gui", "screenshotsvisible", item.getSelection());
                MainWindow.this.displayProfileInformation(false);
            }
        });
        displayScreenshots.setSelection(this.settings_.getBooleanValue("gui", "screenshotsvisible"));
        MainWindow.createSeparatorToolItem(toolBarRight, 4);
        ToolItem displayNotes = MainWindow.createImageToolItem(toolBarRight, 32, ImageService.getResourceImage(this.shell_.getDisplay(), "notes.png"), this.text_.get("dialog.main.profiles.togglebutton.notes"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ToolItem item = (ToolItem)event.widget;
                MainWindow.this.sashInfoForm_.setMaximizedControl(item.getSelection() ? null : MainWindow.this.filterFolder_);
                MainWindow.this.settings_.setBooleanValue("gui", "notesvisible", item.getSelection());
                MainWindow.this.displayProfileInformation(false);
            }
        });
        displayNotes.setSelection(this.settings_.getBooleanValue("gui", "notesvisible"));
        this.sashInfoForm_ = new SashForm(composite, 0);
        this.sashInfoForm_.setLayoutData((Object)new GridData(4, 4, true, true));
        this.filterFolder_ = new CTabFolder((Composite)this.sashInfoForm_, 2048);
        this.filterFolder_.setUnselectedCloseVisible(true);
        this.filterFolder_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.updateProfilesAfterTabAction();
            }
        });
        this.filterFolder_.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                if (GeneralPurposeDialogs.confirmMessage(MainWindow.this.shell_, MainWindow.this.text_.get("dialog.main.confirm.removefilter", new Object[]{((CTabItem)event.item).getText().trim()}))) {
                    boolean currentTabToBeClosed = event.item == MainWindow.this.filterFolder_.getSelection();
                    try {
                        FilterRepository filterRepo = new FilterRepository();
                        filterRepo.remove((Filter)FilterRepository.findById(MainWindow.this.filtersList_, (Integer)event.item.getData()));
                        MainWindow.this.filtersList_ = filterRepo.listAll();
                        MainWindow.this.filtersList_.add(0, new Filter(MainWindow.this.text_.get("dialog.main.allprofiles"), null));
                    }
                    catch (SQLException e) {
                        GeneralPurposeDialogs.warningMessage(MainWindow.this.shell_, e);
                    }
                    if (currentTabToBeClosed) {
                        MainWindow.this.filterFolder_.setSelection(0);
                        MainWindow.this.updateProfilesAfterTabAction();
                    }
                } else {
                    event.doit = false;
                }
            }
        });
        this.filterFolder_.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                MainWindow.this.doEditFilter();
            }
        });
        this.filtersList_.forEach(x -> this.addFilterTab((Filter)x));
        this.filterFolder_.setSelection(this.settings_.getIntValue("gui", "filtertab"));
        this.filterFolder_.getSelection().setToolTipText(this.text_.get("dialog.filter.notice.results", new Object[]{this.profilesList_.size()}));
        this.constructProfilesList();
        Composite informationGroup = MainWindow.createInnerComposite((Composite)this.sashInfoForm_, null, 1);
        informationGroup.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                MainWindow.this.settings_.setIntValues("gui", "sashweights", MainWindow.this.sashInfoForm_.getWeights());
            }
        });
        this.notesField_ = MainWindow.createTextarea(informationGroup, true, true, 1, 1, null);
        this.notesField_.setFont(MainWindow.stringToFont((Device)this.display_, this.settings_.getValues("gui", "notesfont"), this.notesField_.getFont()));
        GridLayout linksGridLayout = new GridLayout();
        linksGridLayout.marginWidth = 0;
        linksGridLayout.marginHeight = 1;
        linksGridLayout.verticalSpacing = 2;
        Composite linksComposite = MainWindow.createComposite(informationGroup, new GridData(4, 1, true, false), (Layout)linksGridLayout);
        this.link_ = new Link[8];
        for (int i = 0; i < this.link_.length; ++i) {
            this.link_[i] = MainWindow.createLink(linksComposite, "", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SystemUtils.openForBrowsing(event.text);
                }
            });
        }
        this.thumbHeight_ = this.settings_.getIntValue("gui", "screenshotsheight");
        this.scrolledCompositeForThumbs_ = new ScrolledComposite(composite, 2304);
        this.scrolledCompositeForThumbs_.setMinHeight(this.thumbHeight_ + 20);
        GridData thumbsGridData = new GridData(4, 128, true, false);
        thumbsGridData.exclude = !this.settings_.getBooleanValue("gui", "screenshotsvisible");
        this.scrolledCompositeForThumbs_.setLayoutData((Object)thumbsGridData);
        this.thumbsComposite_ = MainWindow.createComposite((Composite)this.scrolledCompositeForThumbs_, null, (Layout)new RowLayout(256));
        this.scrolledCompositeForThumbs_.setContent((Control)this.thumbsComposite_);
        this.scrolledCompositeForThumbs_.getHorizontalBar().setPageIncrement(300);
        this.scrolledCompositeForThumbs_.getHorizontalBar().setIncrement(50);
        this.sashInfoForm_.setWeights(this.settings_.getIntValues("gui", "sashweights"));
        this.sashInfoForm_.setMaximizedControl((Control)(this.settings_.getBooleanValue("gui", "notesvisible") ? null : this.filterFolder_));
        this.thumbMenu_ = new Menu((Control)this.thumbsComposite_);
        MainWindow.createMenuItem(this.thumbMenu_, this.text_.get("dialog.main.thumb.remove"), "delete.png", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (MainWindow.this.currentThumbFile_ != null) {
                    if (GeneralPurposeDialogs.confirmMessage(MainWindow.this.shell_, MainWindow.this.text_.get("dialog.main.confirm.removethumb", new Object[]{MainWindow.this.currentThumbFile_}))) {
                        FilesUtils.removeFile(MainWindow.this.currentThumbFile_);
                        ImageService.clearCache(MainWindow.this.currentThumbFile_.getPath());
                        MainWindow.this.displayProfileInformation(true);
                    }
                    MainWindow.this.currentThumbFile_ = null;
                }
            }
        });
        MainWindow.createSeparatorMenuItem(this.thumbMenu_);
        MainWindow.createMenuItem(this.thumbMenu_, this.text_.get("dialog.main.thumb.openfolder"), "folder.png", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (MainWindow.this.currentThumbFile_ != null) {
                    SystemUtils.openDirForViewing(MainWindow.this.currentThumbFile_.getParentFile());
                }
            }
        });
        MainWindow.createMenuItem(this.thumbMenu_, this.text_.get("dialog.main.thumb.refresh"), "refresh.png", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                for (ProfilesList.ProfilesListItem item : MainWindow.this.profileTable_.getItems()) {
                    item.resetCachedInfo();
                }
                ImageService.clearCache();
                MainWindow.this.displayProfileInformation(true);
            }
        });
    }

    private void constructProfilesList() {
        this.profileTable_ = this.settings_.getValue("gui", "viewstyle").equalsIgnoreCase(ProfilesList.ProfilesListType.SMALL_TILES.toString()) ? new ProfilesList((Composite)this.filterFolder_, ProfilesList.ProfilesListType.SMALL_TILES) : (this.settings_.getValue("gui", "viewstyle").equalsIgnoreCase(ProfilesList.ProfilesListType.MEDIUM_TILES.toString()) ? new ProfilesList((Composite)this.filterFolder_, ProfilesList.ProfilesListType.MEDIUM_TILES) : (this.settings_.getValue("gui", "viewstyle").equalsIgnoreCase(ProfilesList.ProfilesListType.LARGE_TILES.toString()) ? new ProfilesList((Composite)this.filterFolder_, ProfilesList.ProfilesListType.LARGE_TILES) : (this.settings_.getValue("gui", "viewstyle").equalsIgnoreCase(ProfilesList.ProfilesListType.SMALL_BOXES.toString()) ? new ProfilesList((Composite)this.filterFolder_, ProfilesList.ProfilesListType.SMALL_BOXES) : (this.settings_.getValue("gui", "viewstyle").equalsIgnoreCase(ProfilesList.ProfilesListType.MEDIUM_BOXES.toString()) ? new ProfilesList((Composite)this.filterFolder_, ProfilesList.ProfilesListType.MEDIUM_BOXES) : (this.settings_.getValue("gui", "viewstyle").equalsIgnoreCase(ProfilesList.ProfilesListType.LARGE_BOXES.toString()) ? new ProfilesList((Composite)this.filterFolder_, ProfilesList.ProfilesListType.LARGE_BOXES) : new ProfilesList((Composite)this.filterFolder_, ProfilesList.ProfilesListType.TABLE, this, this.columnIds_, columnNames_))))));
        for (CTabItem tab : this.filterFolder_.getItems()) {
            tab.setControl(this.profileTable_.getControl());
        }
        final Menu menu = new Menu(this.profileTable_.getControl());
        MainWindow.createSeparatorMenuItem(menu);
        MainWindow.createMenuItem(menu, this.text_.get("dialog.main.profile.openfolder"), "folder.png", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = MainWindow.this.profileTable_.getSelectionIndex();
                if (index != -1) {
                    Profile prof = (Profile)MainWindow.this.profilesList_.get(index);
                    try {
                        String warnings = prof.resetAndLoadConfiguration();
                        if (StringUtils.isNotEmpty((CharSequence)warnings)) {
                            GeneralPurposeDialogs.warningMessage(MainWindow.this.shell_, warnings);
                        }
                        SystemUtils.openDirForViewing(prof.getConfiguration().getAutoexec().getCanonicalGameDir());
                    }
                    catch (IOException e) {
                        GeneralPurposeDialogs.warningMessage(MainWindow.this.shell_, e);
                    }
                }
            }
        });
        MainWindow.createMenuItem(menu, this.text_.get("dialog.main.profile.opencapturesfolder"), "folder.png", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = MainWindow.this.profileTable_.getSelectionIndex();
                if (index != -1) {
                    SystemUtils.openDirForViewing(((Profile)MainWindow.this.profilesList_.get(index)).getCanonicalCaptures());
                }
            }
        });
        final Menu profileViewSubMenu = MainWindow.createMenu(menu, this.text_.get("dialog.main.profile.view"), "zoom.png");
        MainWindow.createSeparatorMenuItem(menu);
        MainWindow.createMenuItem(menu, this.text_.get("dialog.main.profile.add"), "new.png", (SelectionListener)this.addProfAdapter);
        MainWindow.createMenuItem(menu, this.text_.get("dialog.main.profile.edit"), "edit.png", (SelectionListener)this.editProfAdapter);
        MainWindow.createMenuItem(menu, this.text_.get("dialog.main.profile.duplicate"), "duplicate.png", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doDuplicateProfile();
            }
        });
        MainWindow.createMenuItem(menu, this.text_.get("dialog.main.profile.remove"), "delete.png", (SelectionListener)this.removeProfAdapter);
        MainWindow.createSeparatorMenuItem(menu);
        MainWindow.createMenuItem(menu, this.text_.get("dialog.main.profile.togglefavorite"), "favorite.png", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doToggleFavoriteProfile();
            }
        });
        if (SystemUtils.IS_WINDOWS || SystemUtils.IS_LINUX) {
            MainWindow.createSeparatorMenuItem(menu);
            MainWindow.createMenuItem(menu, this.text_.get("dialog.main.profile.createshortcut"), "shortcut.png", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IntStream.of(MainWindow.this.profileTable_.getSelectionIndices()).forEach(x -> {
                        try {
                            ExecuteUtils.createShortcut((Profile)MainWindow.this.profilesList_.get(x));
                        }
                        catch (IOException e) {
                            GeneralPurposeDialogs.warningMessage(MainWindow.this.shell_, e);
                        }
                    });
                }
            });
        }
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent event) {
                if (MainWindow.this.profileTable_.getSelectionIndex() != -1) {
                    final Profile prof = (Profile)MainWindow.this.profilesList_.get(MainWindow.this.profileTable_.getSelectionIndex());
                    for (MenuItem menuItem : menu.getItems()) {
                        if (menuItem.getStyle() == 2) break;
                        menuItem.dispose();
                    }
                    if (MainWindow.this.dbversionsList_.size() > 1) {
                        MainWindow.createTopMenuItem(menu, MainWindow.this.text_.get("dialog.main.profile.startmanuallywith"), null, null).setMenu(MainWindow.this.createDosboxVersionsSubmenu(menu, ExecuteUtils.ProfileRunMode.NORMAL, true));
                    }
                    MainWindow.createTopMenuItem(menu, MainWindow.this.text_.get("dialog.main.profile.startmanually"), null, (SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            MainWindow.this.doRunProfile(ExecuteUtils.ProfileRunMode.NORMAL, true);
                        }
                    });
                    if (prof.hasAltExe(1)) {
                        if (MainWindow.this.dbversionsList_.size() > 1) {
                            MainWindow.createTopMenuItem(menu, prof.getAltExeFilenames()[1], null, null).setMenu(MainWindow.this.createDosboxVersionsSubmenu(menu, ExecuteUtils.ProfileRunMode.ALT2, false));
                        }
                        MainWindow.createTopMenuItem(menu, prof.getAltExeFilenames()[1], null, (SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event) {
                                MainWindow.this.doRunProfile(ExecuteUtils.ProfileRunMode.ALT2, false);
                            }
                        });
                    }
                    if (prof.hasAltExe(0)) {
                        if (MainWindow.this.dbversionsList_.size() > 1) {
                            MainWindow.createTopMenuItem(menu, prof.getAltExeFilenames()[0], null, null).setMenu(MainWindow.this.createDosboxVersionsSubmenu(menu, ExecuteUtils.ProfileRunMode.ALT1, false));
                        }
                        MainWindow.createTopMenuItem(menu, prof.getAltExeFilenames()[0], null, (SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event) {
                                MainWindow.this.doRunProfile(ExecuteUtils.ProfileRunMode.ALT1, false);
                            }
                        });
                    }
                    if (prof.hasSetup()) {
                        if (MainWindow.this.dbversionsList_.size() > 1) {
                            MainWindow.createTopMenuItem(menu, MainWindow.this.text_.get("dialog.main.profile.setupwith"), null, null).setMenu(MainWindow.this.createDosboxVersionsSubmenu(menu, ExecuteUtils.ProfileRunMode.SETUP, false));
                        }
                        MainWindow.createTopMenuItem(menu, MainWindow.this.text_.get("dialog.main.profile.setup"), "setup.png", (SelectionListener)MainWindow.this.setupProfAdapter);
                    }
                    if (MainWindow.this.dbversionsList_.size() > 1) {
                        MainWindow.createTopMenuItem(menu, MainWindow.this.text_.get("dialog.main.profile.runwith"), null, null).setMenu(MainWindow.this.createDosboxVersionsSubmenu(menu, ExecuteUtils.ProfileRunMode.NORMAL, false));
                    }
                    MainWindow.createTopMenuItem(menu, MainWindow.this.text_.get("dialog.main.profile.run"), "run.png", (SelectionListener)MainWindow.this.runProfAdapter);
                    for (MenuItem menuItem : profileViewSubMenu.getItems()) {
                        menuItem.dispose();
                    }
                    for (org.dbgl.model.Link link : prof.getLinks()) {
                        final String url = link.getUrl();
                        if (!StringUtils.isNotBlank((CharSequence)url)) continue;
                        MainWindow.createMenuItem(profileViewSubMenu, StringUtils.abbreviateMiddle((String)link.getDisplayTitle(), (String)"....", (int)80), null, (SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event) {
                                SystemUtils.openForBrowsing(url);
                            }
                        });
                    }
                    MainWindow.createMenuItem(profileViewSubMenu, MainWindow.this.text_.get("dialog.main.profile.view.conf"), null, (SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            SystemUtils.openForEditing(prof.getConfigurationCanonicalFile());
                        }
                    });
                }
            }
        });
        this.profileTable_.setMenu(menu);
        this.profileTable_.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                MainWindow.this.doRunProfile(ExecuteUtils.ProfileRunMode.NORMAL, false);
            }
        });
        this.profileTable_.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 127 || event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 114) {
                    MainWindow.this.doRemoveProfile();
                } else if (event.keyCode == 0x1000009 || event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 110) {
                    MainWindow.this.doAddProfile(null);
                } else if (event.keyCode == 0x100000B) {
                    MainWindow.this.doEditProfile(true);
                } else if (event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 109) {
                    MainWindow.this.doToggleFavoriteProfile();
                } else if (event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 100) {
                    MainWindow.this.doDuplicateProfile();
                } else if (event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 97) {
                    MainWindow.this.profileTable_.selectAll();
                } else if (event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 102) {
                    MainWindow.this.doAddFilter();
                } else if (event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 99) {
                    int index = MainWindow.this.profileTable_.getSelectionIndex();
                    if (index != -1) {
                        SystemUtils.openForEditing(((Profile)MainWindow.this.profilesList_.get(index)).getConfigurationCanonicalFile());
                    }
                } else if (event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 119) {
                    MainWindow.this.updateWithAddedProfile((Profile)new AddGameWizardDialog(MainWindow.this.shell_).open());
                }
            }
        });
        this.profileTable_.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.stateMask == SWT.MOD1 && event.detail == 4) {
                    MainWindow.this.doEditProfile(false);
                } else if (event.stateMask == 131072 && event.detail == 4) {
                    MainWindow.this.doRunProfile(ExecuteUtils.ProfileRunMode.SETUP, false);
                } else if (event.detail == 4) {
                    MainWindow.this.doRunProfile(ExecuteUtils.ProfileRunMode.NORMAL, false);
                }
            }
        });
        this.profileTable_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.displayProfileInformation(false);
            }
        });
        DropTarget target = new DropTarget(this.profileTable_.getControl(), 19);
        target.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String[] filenames = (String[])event.data;
                if (filenames != null && filenames.length == 1) {
                    MainWindow.this.doAddProfile(filenames[0]);
                }
            }
        });
    }

    private void rebuildProfilesTable() {
        Set<Integer> selectedProfileIds = this.getSelectedProfileIds();
        this.initColumnIds();
        for (CTabItem tab : this.filterFolder_.getItems()) {
            tab.setControl(null);
        }
        this.profileTable_.dispose();
        this.constructProfilesList();
        this.updateProfilesList(selectedProfileIds);
    }

    private void updateWithAddedProfile(Profile profile) {
        if (profile != null) {
            if (this.settings_.getBooleanValue("gui", "autosortonupdate") || this.filterFolder_.getSelectionIndex() > 0) {
                this.updateProfilesList(new HashSet<Integer>(Arrays.asList(profile.getId())));
            } else {
                this.profilesList_.add(profile);
                this.addProfileToTable(profile);
                this.profileTable_.setSelection(this.profileTable_.getItemCount() - 1);
                this.profileTable_.setFocus();
            }
            this.displayProfileInformation(false);
        }
    }

    private void updateProfileListAfterEdit(int index, Profile profile) {
        boolean quickUpdate = true;
        if (this.settings_.getBooleanValue("gui", "autosortonupdate") || this.filterFolder_.getSelectionIndex() > 0) {
            try {
                this.profilesList_ = new ProfileRepository().list(this.orderingVector_.toClause(), this.filterClause_, this.dbversionsList_);
                if (index != ProfileRepository.indexOf(this.profilesList_, profile)) {
                    quickUpdate = false;
                }
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell_, e);
            }
        }
        if (quickUpdate) {
            this.profilesList_.set(index, profile);
            this.setProfileTableItem(this.profileTable_.getItem(index), profile);
        } else {
            this.updateProfilesList(new HashSet<Integer>(Arrays.asList(profile.getId())));
        }
    }

    private void updateProfilesAfterTabAction() {
        int tabIndex = this.filterFolder_.getSelectionIndex();
        this.settings_.setIntValue("gui", "filtertab", tabIndex);
        this.filterClause_ = this.filtersList_.get(tabIndex).getFilter();
        this.updateProfilesList(this.getSelectedProfileIds());
        for (CTabItem tab : this.filterFolder_.getItems()) {
            tab.setToolTipText(null);
        }
        this.filterFolder_.getSelection().setToolTipText(this.text_.get("dialog.filter.notice.results", new Object[]{this.profilesList_.size()}));
        this.displayProfileInformation(false);
    }

    private void toggleProfileViewType(ViewType newViewType) {
        this.viewSelector_.setImage(ImageService.getResourceImage(this.shell_.getDisplay(), newViewType.getImage()));
        this.viewSelector_.setToolTipText(newViewType.getDisplayName());
        this.settings_.setValue("gui", "viewstyle", newViewType.getName().toLowerCase());
        this.viewSelector_.setEnabled(false);
        Display.getCurrent().timerExec(250, new Runnable(){

            @Override
            public void run() {
                MainWindow.this.viewSelector_.setEnabled(true);
            }
        });
        this.rebuildProfilesTable();
    }

    @Override
    public void doReorder(int columnId, int dir) {
        Set<Integer> selectedProfiles = this.getSelectedProfileIds();
        try {
            this.orderingVector_.addOrdering(this.columnIds_[columnId], dir == 128);
            this.profilesList_ = new ProfileRepository().list(this.orderingVector_.toClause(), this.filterClause_, this.dbversionsList_);
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell_, e);
        }
        for (int i = 0; i < this.profilesList_.size(); ++i) {
            this.setProfileTableItem(this.profileTable_.getItem(i), this.profilesList_.get(i));
        }
        this.profileTable_.setSelection(this.getIndicesByIds(selectedProfiles));
        this.settings_.setIntValues("gui", "sortcolumn", this.orderingVector_.getColumns());
        this.settings_.setBooleanValues("gui", "sortascending", this.orderingVector_.getAscendings());
    }

    private Menu createDosboxVersionsSubmenu(Menu parent, final ExecuteUtils.ProfileRunMode mode, final boolean prepareOnly) {
        Menu dosboxVersionsSubMenu = new Menu(parent);
        for (final DosboxVersion dbVersion : this.dbversionsList_) {
            MainWindow.createMenuItem(dosboxVersionsSubMenu, dbVersion.getTitle(), null, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Profile prof = (Profile)MainWindow.this.profilesList_.get(MainWindow.this.profileTable_.getSelectionIndex());
                    try {
                        ExecuteUtils.doRunProfile(mode, prof, dbVersion, prepareOnly, MainWindow.this.display_);
                    }
                    catch (IOException e) {
                        GeneralPurposeDialogs.warningMessage(MainWindow.this.shell_, e);
                    }
                }
            });
        }
        return dosboxVersionsSubMenu;
    }

    private void displayProfileInformation(boolean forceRefresh) {
        int index = this.profileTable_.getSelectionIndex();
        boolean screenshotsVisible = this.settings_.getBooleanValue("gui", "screenshotsvisible");
        boolean notesVisible = this.settings_.getBooleanValue("gui", "notesvisible");
        if (index == -1) {
            if (screenshotsVisible) {
                this.displayScreenshots(null, null, forceRefresh);
            }
            if (notesVisible) {
                this.notesField_.setText("");
                this.displayLinks(new org.dbgl.model.Link[0]);
            }
            this.setupToolItem_.setEnabled(false);
        } else {
            this.settings_.setIntValue("gui", "selectedprofile", index);
            Profile prof = this.profilesList_.get(index);
            if (screenshotsVisible) {
                this.displayScreenshots(prof, this.profileTable_.getItem(index), forceRefresh);
            } else if (forceRefresh) {
                ((ThumbInfo)this.profileTable_.getItem(index).getData()).resetCachedInfo();
            }
            if (forceRefresh) {
                this.profileTable_.redraw();
            }
            if (notesVisible) {
                if (!StringUtils.equals((CharSequence)prof.getNotes(), (CharSequence)this.notesField_.getText())) {
                    this.notesField_.setText(prof.getNotes());
                }
                this.displayLinks(prof.getLinks());
            }
            this.setupToolItem_.setEnabled(prof.hasSetup());
        }
    }

    private void displayLinks(org.dbgl.model.Link[] profileLinks) {
        boolean showLinks = false;
        for (int i = 0; i < profileLinks.length; ++i) {
            String url = profileLinks[i].getUrl();
            boolean isBlank = StringUtils.isBlank((CharSequence)url);
            if (!isBlank) {
                this.link_[i].setText(profileLinks[i].getAnchor());
                this.link_[i].setToolTipText(url);
            } else {
                this.link_[i].setText("");
                this.link_[i].setToolTipText("");
            }
            this.link_[i].pack();
            ((GridData)this.link_[i].getLayoutData()).exclude = isBlank;
            showLinks |= !isBlank;
        }
        ((GridData)this.link_[0].getParent().getLayoutData()).exclude = !showLinks;
        this.link_[0].getParent().layout();
        this.link_[0].getParent().getParent().layout();
    }

    private void displayScreenshots(Profile prof, ProfilesList.ProfilesListItem profilesListItem, boolean forceRefresh) {
        for (Control c : this.thumbsComposite_.getChildren()) {
            c.setMenu(null);
            c.dispose();
        }
        if (prof != null) {
            File[] files;
            ThumbInfo thumbInfo = (ThumbInfo)profilesListItem.getData();
            if (forceRefresh) {
                thumbInfo.resetCachedInfo();
            }
            if ((files = thumbInfo.getAllThumbs()) != null) {
                for (final File file : files) {
                    String label = null;
                    if (this.settings_.getBooleanValue("gui", "screenshotsfilename")) {
                        label = file.getName().toLowerCase();
                        label = ' ' + label.substring(0, label.lastIndexOf(46)) + ' ';
                    }
                    Button buttonItem = MainWindow.createImageButton(this.thumbsComposite_, 0x800000, null, ImageService.getCachedHeightLimitedImage(this.display_, this.thumbHeight_, file.getPath(), label), null, file.getPath(), (SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            new Thumb(MainWindow.this.shell_, file.getPath()).open();
                        }
                    }, false);
                    buttonItem.addMouseListener((MouseListener)new MouseAdapter(){

                        public void mouseDown(MouseEvent arg0) {
                            MainWindow.this.currentThumbFile_ = new File(file.getPath());
                        }
                    });
                    buttonItem.setMenu(this.thumbMenu_);
                }
                if (!forceRefresh && thumbInfo.isUpdated()) {
                    profilesListItem.setData(thumbInfo);
                }
            }
        }
        this.thumbsComposite_.setVisible(this.thumbsComposite_.getChildren().length != 0);
        this.thumbsComposite_.layout();
        this.thumbsComposite_.pack();
    }

    private void createDosboxVersionsTab(TabFolder tabFolder) {
        SelectionAdapter addDosboxAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doAddDosboxVersion();
            }
        };
        SelectionAdapter editDosboxAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doEditDosboxVersion();
            }
        };
        SelectionAdapter removeDosboxAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRemoveDosboxVersion();
            }
        };
        SelectionAdapter runDosboxAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRunDosbox();
            }
        };
        Composite composite = MainWindow.createTabWithInnerComposite(tabFolder, this.text_.get("dialog.main.dosboxversions"), 1);
        ToolBar toolBar = new ToolBar(composite, 0);
        MainWindow.createImageToolItem(toolBar, this.text_.get("dialog.main.addversion"), "tb_new.png", (SelectionListener)addDosboxAdapter);
        MainWindow.createImageToolItem(toolBar, this.text_.get("dialog.main.editversion"), "tb_edit.png", (SelectionListener)editDosboxAdapter);
        MainWindow.createImageToolItem(toolBar, this.text_.get("dialog.main.removeversion"), "tb_delete.png", (SelectionListener)removeDosboxAdapter);
        MainWindow.createImageToolItem(toolBar, this.text_.get("dialog.main.runversion"), "tb_run.png", (SelectionListener)runDosboxAdapter);
        this.dbversionTable_ = new Table(composite, 67584);
        this.dbversionTable_.setLayoutData((Object)new GridData(4, 4, true, true));
        this.dbversionTable_.setLinesVisible(true);
        this.dbversionTable_.setHeaderVisible(true);
        this.addDBColumn(this.text_.get("dialog.main.dosboxversions.column.title"), 0);
        this.addDBColumn(this.text_.get("dialog.main.dosboxversions.column.version"), 1);
        this.addDBColumn(this.text_.get("dialog.main.dosboxversions.column.path"), 2);
        this.addDBColumn(this.text_.get("dialog.main.dosboxversions.column.default"), 3);
        this.addDBColumn(this.text_.get("dialog.main.dosboxversions.column.id"), 4);
        this.addDBColumn(this.text_.get("dialog.main.generic.column.created"), 5);
        this.addDBColumn(this.text_.get("dialog.main.generic.column.lastmodify"), 6);
        this.addDBColumn(this.text_.get("dialog.main.generic.column.lastrun"), 7);
        this.addDBColumn(this.text_.get("dialog.main.generic.column.runs"), 8);
        Menu menu = new Menu((Control)this.dbversionTable_);
        MainWindow.createMenuItem(menu, this.text_.get("dialog.main.dosboxversion.run"), "run.png", (SelectionListener)runDosboxAdapter);
        MainWindow.createSeparatorMenuItem(menu);
        MainWindow.createMenuItem(menu, this.text_.get("dialog.main.dosboxversion.openfolder"), "folder.png", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = MainWindow.this.dbversionTable_.getSelectionIndex();
                if (index != -1) {
                    SystemUtils.openDirForViewing(((DosboxVersion)MainWindow.this.dbversionsList_.get(index)).getConfigurationCanonicalFile().getParentFile());
                }
            }
        });
        Menu viewDosboxSubMenu = MainWindow.createMenu(menu, this.text_.get("dialog.main.profile.view"), "zoom.png");
        MainWindow.createMenuItem(viewDosboxSubMenu, this.text_.get("dialog.main.profile.view.conf"), null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (MainWindow.this.dbversionTable_.getSelectionIndex() != -1) {
                    DosboxVersion dbversion = (DosboxVersion)MainWindow.this.dbversionsList_.get(MainWindow.this.dbversionTable_.getSelectionIndex());
                    SystemUtils.openForEditing(dbversion.getConfigurationCanonicalFile());
                }
            }
        });
        MainWindow.createSeparatorMenuItem(menu);
        MainWindow.createMenuItem(menu, this.text_.get("dialog.main.dosboxversion.add"), "new.png", (SelectionListener)addDosboxAdapter);
        MainWindow.createMenuItem(menu, this.text_.get("dialog.main.dosboxversion.edit"), "edit.png", (SelectionListener)editDosboxAdapter);
        MainWindow.createMenuItem(menu, this.text_.get("dialog.main.dosboxversion.remove"), "delete.png", (SelectionListener)removeDosboxAdapter);
        MainWindow.createSeparatorMenuItem(menu);
        MainWindow.createMenuItem(menu, this.text_.get("dialog.main.dosboxversion.toggledefault"), "home.png", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doToggleDefaultVersion();
            }
        });
        this.dbversionTable_.setMenu(menu);
        this.dbversionTable_.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 127 || event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 114) {
                    MainWindow.this.doRemoveDosboxVersion();
                } else if (event.keyCode == 0x1000009 || event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 110) {
                    MainWindow.this.doAddDosboxVersion();
                } else if (event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 109) {
                    MainWindow.this.doToggleDefaultVersion();
                }
            }
        });
        this.dbversionTable_.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.stateMask == SWT.MOD1 && event.detail == 4) {
                    MainWindow.this.doEditDosboxVersion();
                } else if (event.detail == 4) {
                    MainWindow.this.doRunDosbox();
                }
            }
        });
        this.dbversionTable_.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                MainWindow.this.doRunDosbox();
            }
        });
    }

    private void addDBColumn(String title, int colIndex) {
        final String width = "column2_" + (colIndex + 1) + "width";
        MainWindow.createTableColumn(this.dbversionTable_, this.settings_.getIntValue("gui", width), title).addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                MainWindow.this.settings_.setIntValue("gui", width, ((TableColumn)event.widget).getWidth());
            }
        });
    }

    private void createTemplatesTab(TabFolder tabFolder) {
        SelectionAdapter addTemplAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doAddTemplate();
            }
        };
        SelectionAdapter editTemplAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doEditTemplate();
            }
        };
        SelectionAdapter removeTemplAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRemoveTemplate();
            }
        };
        SelectionAdapter runTemplAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRunTemplate();
            }
        };
        Composite composite = MainWindow.createTabWithInnerComposite(tabFolder, this.text_.get("dialog.main.templates"), 1);
        ToolBar toolBar = new ToolBar(composite, 0);
        MainWindow.createImageToolItem(toolBar, this.text_.get("dialog.main.addtemplate"), "tb_new.png", (SelectionListener)addTemplAdapter);
        MainWindow.createImageToolItem(toolBar, this.text_.get("dialog.main.edittemplate"), "tb_edit.png", (SelectionListener)editTemplAdapter);
        MainWindow.createImageToolItem(toolBar, this.text_.get("dialog.main.removetemplate"), "tb_delete.png", (SelectionListener)removeTemplAdapter);
        MainWindow.createImageToolItem(toolBar, this.text_.get("dialog.main.runtemplate"), "tb_run.png", (SelectionListener)runTemplAdapter);
        this.templateTable_ = new Table(composite, 67584);
        this.templateTable_.setLayoutData((Object)new GridData(4, 4, true, true));
        this.templateTable_.setLinesVisible(true);
        this.templateTable_.setHeaderVisible(true);
        this.addTemplateColumn(this.text_.get("dialog.main.templates.column.title"), 0);
        this.addTemplateColumn(this.text_.get("dialog.main.templates.column.default"), 1);
        this.addTemplateColumn(this.text_.get("dialog.main.templates.column.id"), 2);
        this.addTemplateColumn(this.text_.get("dialog.main.generic.column.created"), 3);
        this.addTemplateColumn(this.text_.get("dialog.main.generic.column.lastmodify"), 4);
        this.addTemplateColumn(this.text_.get("dialog.main.generic.column.lastrun"), 5);
        this.addTemplateColumn(this.text_.get("dialog.main.generic.column.runs"), 6);
        Menu menu = new Menu((Control)this.templateTable_);
        MainWindow.createMenuItem(menu, this.text_.get("dialog.main.template.run"), "run.png", (SelectionListener)runTemplAdapter);
        MainWindow.createSeparatorMenuItem(menu);
        Menu viewTemplateSubMenu = MainWindow.createMenu(menu, this.text_.get("dialog.main.profile.view"), "zoom.png");
        MainWindow.createMenuItem(viewTemplateSubMenu, this.text_.get("dialog.main.profile.view.conf"), null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (MainWindow.this.templateTable_.getSelectionIndex() != -1) {
                    Template template = (Template)MainWindow.this.templatesList_.get(MainWindow.this.templateTable_.getSelectionIndex());
                    SystemUtils.openForEditing(template.getConfigurationCanonicalFile());
                }
            }
        });
        MainWindow.createSeparatorMenuItem(menu);
        MainWindow.createMenuItem(menu, this.text_.get("dialog.main.template.add"), "new.png", (SelectionListener)addTemplAdapter);
        MainWindow.createMenuItem(menu, this.text_.get("dialog.main.template.edit"), "edit.png", (SelectionListener)editTemplAdapter);
        MainWindow.createMenuItem(menu, this.text_.get("dialog.main.template.duplicate"), "duplicate.png", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doDuplicateTemplate();
            }
        });
        MainWindow.createMenuItem(menu, this.text_.get("dialog.main.template.remove"), "delete.png", (SelectionListener)removeTemplAdapter);
        MainWindow.createSeparatorMenuItem(menu);
        MainWindow.createMenuItem(menu, this.text_.get("dialog.main.template.toggledefault"), "home.png", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doToggleDefaultTemplate();
            }
        });
        this.templateTable_.setMenu(menu);
        this.templateTable_.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 127 || event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 114) {
                    MainWindow.this.doRemoveTemplate();
                } else if (event.keyCode == 0x1000009 || event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 110) {
                    MainWindow.this.doAddTemplate();
                } else if (event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 109) {
                    MainWindow.this.doToggleDefaultTemplate();
                }
            }
        });
        this.templateTable_.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.stateMask == SWT.MOD1 && event.detail == 4) {
                    MainWindow.this.doEditTemplate();
                } else if (event.detail == 4) {
                    MainWindow.this.doRunTemplate();
                }
            }
        });
        this.templateTable_.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                MainWindow.this.doRunTemplate();
            }
        });
    }

    private void addTemplateColumn(String title, int colIndex) {
        final String width = "column3_" + (colIndex + 1) + "width";
        MainWindow.createTableColumn(this.templateTable_, this.settings_.getIntValue("gui", width), title).addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                MainWindow.this.settings_.setIntValue("gui", width, ((TableColumn)event.widget).getWidth());
            }
        });
    }

    private void addProfileToTable(Profile prof) {
        ProfilesList profilesList = this.profileTable_;
        profilesList.getClass();
        this.setProfileTableItem(profilesList.new ProfilesList.ProfilesListItem(this.profileTable_), prof);
    }

    private void addDosboxVersionToTable(DosboxVersion dbversion) {
        this.setDosboxTableItem(new TableItem(this.dbversionTable_, 2048), dbversion);
    }

    private void addTemplateToTable(Template template) {
        this.setTemplateTableItem(new TableItem(this.templateTable_, 2048), template);
    }

    private void setProfileTableItem(ProfilesList.ProfilesListItem newItemTableItem, Profile prof) {
        for (int i = 0; i < this.columnIds_.length; ++i) {
            String value;
            switch (this.columnIds_[i]) {
                case 0: {
                    value = prof.getTitle();
                    break;
                }
                case 1: {
                    value = prof.hasSetup() ? this.text_.get("general.yes") : this.text_.get("general.no");
                    break;
                }
                case 2: {
                    value = prof.getDeveloper();
                    break;
                }
                case 3: {
                    value = prof.getPublisher();
                    break;
                }
                case 4: {
                    value = prof.getGenre();
                    break;
                }
                case 5: {
                    value = prof.getYear();
                    break;
                }
                case 6: {
                    value = prof.getStatus();
                    break;
                }
                case 7: {
                    value = prof.isFavorite() != false ? this.text_.get("general.yes") : this.text_.get("general.no");
                    break;
                }
                case 8: {
                    value = String.valueOf(prof.getId());
                    break;
                }
                case 9: {
                    value = String.valueOf(prof.getDosboxVersion().getId());
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    value = prof.getCustomStrings()[this.columnIds_[i] - 10];
                    break;
                }
                case 18: {
                    value = prof.getCustomInts()[0] + " %";
                    break;
                }
                case 19: {
                    value = String.valueOf(prof.getCustomInts()[1]);
                    break;
                }
                case 21: {
                    value = prof.getDosboxVersion().getTitle();
                    break;
                }
                case 22: {
                    value = this.text_.toString(prof.getStats().getCreated(), 3);
                    break;
                }
                case 23: {
                    value = this.text_.toString(prof.getStats().getModified(), 3);
                    break;
                }
                case 24: {
                    value = this.text_.toString(prof.getStats().getLastRun(), 3);
                    break;
                }
                case 25: {
                    value = this.text_.toString(prof.getProfileStats().getLastSetup(), 3);
                    break;
                }
                case 26: {
                    value = String.valueOf(prof.getStats().getRuns());
                    break;
                }
                case 27: {
                    value = String.valueOf(prof.getProfileStats().getSetups());
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    value = prof.getCustomStrings()[this.columnIds_[i] - 10 - 10];
                    break;
                }
                default: {
                    value = "";
                }
            }
            if (this.columnIds_[i] == 20) continue;
            newItemTableItem.setText(i, this.columnIds_[i], value);
        }
        newItemTableItem.setData(new ThumbInfo(prof.getCapturesString()));
    }

    private void setDosboxTableItem(TableItem newItemTableItem, DosboxVersion dbversion) {
        newItemTableItem.setText(0, dbversion.getTitle());
        newItemTableItem.setText(1, dbversion.getVersion());
        newItemTableItem.setText(2, dbversion.getPath().getPath());
        newItemTableItem.setText(3, dbversion.isDefault() ? this.text_.get("general.yes") : this.text_.get("general.no"));
        newItemTableItem.setText(4, String.valueOf(dbversion.getId()));
        newItemTableItem.setText(5, this.text_.toString(dbversion.getStats().getCreated(), 3));
        newItemTableItem.setText(6, this.text_.toString(dbversion.getStats().getModified(), 3));
        newItemTableItem.setText(7, this.text_.toString(dbversion.getStats().getLastRun(), 3));
        newItemTableItem.setText(8, String.valueOf(dbversion.getStats().getRuns()));
    }

    private void setTemplateTableItem(TableItem newItemTableItem, Template template) {
        newItemTableItem.setText(0, template.getTitle());
        newItemTableItem.setText(1, template.isDefault() ? this.text_.get("general.yes") : this.text_.get("general.no"));
        newItemTableItem.setText(2, String.valueOf(template.getId()));
        newItemTableItem.setText(3, this.text_.toString(template.getStats().getCreated(), 3));
        newItemTableItem.setText(4, this.text_.toString(template.getStats().getModified(), 3));
        newItemTableItem.setText(5, this.text_.toString(template.getStats().getLastRun(), 3));
        newItemTableItem.setText(6, String.valueOf(template.getStats().getRuns()));
    }

    private void updateProfilesList(Set<Integer> profileIds) {
        try {
            this.profilesList_ = new ProfileRepository().list(this.orderingVector_.toClause(), this.filterClause_, this.dbversionsList_);
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell_, e);
        }
        this.profileTable_.setRedraw(false);
        this.profileTable_.removeAll();
        for (Profile prof : this.profilesList_) {
            this.addProfileToTable(prof);
        }
        this.profileTable_.setSelection(this.getIndicesByIds(profileIds));
        this.profileTable_.setRedraw(true);
        this.profileTable_.setFocus();
    }

    private void updateDosboxVersionList(DosboxVersion dbversion) {
        try {
            this.dbversionsList_ = new DosboxVersionRepository().listAll();
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell_, e);
        }
        this.dbversionTable_.removeAll();
        for (DosboxVersion version : this.dbversionsList_) {
            this.addDosboxVersionToTable(version);
        }
        this.dbversionTable_.setSelection(DosboxVersionRepository.indexOf(this.dbversionsList_, dbversion));
        this.dbversionTable_.setFocus();
    }

    private void updateTemplateList(Template template) {
        try {
            this.templatesList_ = new TemplateRepository().listAll(this.dbversionsList_);
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell_, e);
        }
        this.templateTable_.removeAll();
        for (Template temp : this.templatesList_) {
            this.addTemplateToTable(temp);
        }
        this.templateTable_.setSelection(TemplateRepository.indexOf(this.templatesList_, template));
        this.templateTable_.setFocus();
    }

    private void doAddProfile(String filename) {
        if (this.requireDefaultDBVersion() == null) {
            return;
        }
        if (filename == null || FilesUtils.isBooterImage(filename) || FilesUtils.isExecutable(filename) || FilesUtils.isConfFile(filename)) {
            Profile profile = (Profile)new EditSingleProfileDialog(this.shell_, null, filename, false).open();
            if (profile != null) {
                this.updateWithAddedProfile(profile);
            }
        } else if (FilesUtils.isArchive(filename)) {
            Boolean updateCustomFields = (Boolean)new ImportDialog(this.shell_, this.dbversionsList_, new File(filename)).open();
            if (updateCustomFields != null) {
                if (updateCustomFields.booleanValue()) {
                    this.rebuildProfilesTable();
                } else {
                    this.updateProfilesList(this.getSelectedProfileIds());
                }
                this.displayProfileInformation(true);
            }
        } else {
            GeneralPurposeDialogs.warningMessage(this.shell_, this.text_.get("general.error.cannotimportunknownfile"));
        }
    }

    public void addProfile(final String file) {
        this.display_.syncExec(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.doAddProfile(file);
            }
        });
    }

    private void doAddDosboxVersion() {
        DosboxVersion dbversion = (DosboxVersion)new EditDosboxVersionDialog(this.shell_, DosboxVersionRepository.findDefault(this.dbversionsList_) == null, null).open();
        if (dbversion != null) {
            this.updateDosboxVersionList(dbversion);
        }
    }

    private void doAddTemplate() {
        if (this.requireDefaultDBVersion() == null) {
            return;
        }
        Template template = (Template)new EditTemplateDialog(this.shell_, null).open();
        if (template != null) {
            this.updateTemplateList(template);
        }
    }

    private void doAddFilter() {
        Filter filter = (Filter)new EditFilterDialog(this.shell_, null, this.profileTable_.getSelectionCount() > 1 ? this.getSelectedProfileIds() : null).open();
        if (filter != null) {
            this.filtersList_.add(filter);
            this.addFilterTab(filter).setControl(this.profileTable_.getControl());
            this.filterFolder_.setSelection(this.filterFolder_.getItemCount() - 1);
            this.updateProfilesAfterTabAction();
        }
    }

    private CTabItem addFilterTab(Filter filter) {
        CTabItem item = new CTabItem(this.filterFolder_, filter.getFilter() == null ? 0 : 64);
        item.setText("    " + filter.getTitle() + "    ");
        item.setData((Object)filter.getId());
        return item;
    }

    private void doEditProfile(boolean focusTitle) {
        int index = this.profileTable_.getSelectionIndex();
        if (index != -1) {
            if (this.profileTable_.getSelectionCount() > 1) {
                List loadedProfiles = (List)new ProfileLoader(this.shell_, this.getSelectedProfiles()).open();
                if (loadedProfiles != null) {
                    Object results;
                    Object t = results = loadedProfiles.size() > 1 ? new EditMultiProfileDialog(this.shell_, loadedProfiles).open() : new EditSingleProfileDialog(this.shell_, (Profile)loadedProfiles.get(0), null, focusTitle).open();
                    if (results != null) {
                        this.updateProfilesList(this.getSelectedProfileIds());
                        this.displayProfileInformation(false);
                    }
                }
            } else {
                Profile profile = (Profile)new EditSingleProfileDialog(this.shell_, this.profilesList_.get(index), null, focusTitle).open();
                if (profile != null) {
                    this.updateProfileListAfterEdit(index, profile);
                    this.displayProfileInformation(false);
                }
            }
        }
    }

    private void doEditDosboxVersion() {
        DosboxVersion dbversion;
        int index = this.dbversionTable_.getSelectionIndex();
        if (index != -1 && (dbversion = (DosboxVersion)new EditDosboxVersionDialog(this.shell_, false, this.dbversionsList_.get(index)).open()) != null) {
            this.updateDosboxVersionList(dbversion);
        }
    }

    private void doEditTemplate() {
        Template template;
        int index = this.templateTable_.getSelectionIndex();
        if (index != -1 && (template = (Template)new EditTemplateDialog(this.shell_, this.templatesList_.get(index)).open()) != null) {
            this.updateTemplateList(template);
        }
    }

    private void doEditFilter() {
        Filter filter;
        int index = this.filterFolder_.getSelectionIndex();
        if (index > 0 && (filter = (Filter)new EditFilterDialog(this.shell_, this.filtersList_.get(index), null).open()) != null) {
            this.filtersList_.set(index, filter);
            this.filterFolder_.getSelection().setText("    " + filter.getTitle() + "    ");
            this.updateProfilesAfterTabAction();
        }
    }

    private void doToggleFavoriteProfile() {
        int index = this.profileTable_.getSelectionIndex();
        if (index != -1) {
            Profile profile;
            profile.setFavorite((profile = this.profilesList_.get(index)).isFavorite() == false);
            try {
                String warningsLog = profile.resetAndLoadConfiguration();
                if (StringUtils.isNotBlank((CharSequence)warningsLog)) {
                    GeneralPurposeDialogs.warningMessage(this.shell_, warningsLog);
                }
                new ProfileRepository().update(profile);
                this.setProfileTableItem(this.profileTable_.getItem(index), profile);
            }
            catch (IOException | SQLException e) {
                profile.setFavorite(profile.isFavorite() == false);
                GeneralPurposeDialogs.warningMessage(this.shell_, e);
            }
        }
    }

    private void doToggleDefaultVersion() {
        int index = this.dbversionTable_.getSelectionIndex();
        if (index != -1) {
            DosboxVersion dbversion;
            dbversion.setDefault(!(dbversion = this.dbversionsList_.get(index)).isDefault());
            try {
                new DosboxVersionRepository().update(dbversion);
                this.updateDosboxVersionList(dbversion);
            }
            catch (SQLException e) {
                dbversion.setDefault(!dbversion.isDefault());
                GeneralPurposeDialogs.warningMessage(this.shell_, e);
            }
        }
    }

    private void doToggleDefaultTemplate() {
        int index = this.templateTable_.getSelectionIndex();
        if (index != -1) {
            Template template;
            template.setDefault(!(template = this.templatesList_.get(index)).isDefault());
            try {
                String warningsLog = template.resetAndLoadConfiguration();
                if (StringUtils.isNotBlank((CharSequence)warningsLog)) {
                    GeneralPurposeDialogs.warningMessage(this.shell_, warningsLog);
                }
                new TemplateRepository().update(template);
                this.updateTemplateList(template);
            }
            catch (IOException | SQLException e) {
                template.setDefault(!template.isDefault());
                GeneralPurposeDialogs.warningMessage(this.shell_, e);
            }
        }
    }

    private void doRemoveProfile() {
        int index = this.profileTable_.getSelectionIndex();
        if (index != -1 && new DeleteProfilesDialog(this.shell_, this.getSelectedProfiles()).open() != null) {
            int[] idxs = this.profileTable_.getSelectionIndices();
            Arrays.sort(idxs);
            for (int i = idxs.length - 1; i >= 0; --i) {
                this.profileTable_.remove(idxs[i]);
                this.profilesList_.remove(idxs[i]);
            }
            if (idxs[0] > 0) {
                this.profileTable_.setSelection(idxs[0] - 1);
            }
            this.displayProfileInformation(false);
        }
    }

    private void doRemoveDosboxVersion() {
        int index = this.dbversionTable_.getSelectionIndex();
        if (index != -1 && GeneralPurposeDialogs.confirmMessage(this.shell_, this.text_.get("dialog.main.confirm.removedosboxversion"))) {
            try {
                new DosboxVersionRepository().remove(this.dbversionsList_.get(index));
                this.dbversionTable_.remove(index);
                this.dbversionsList_.remove(index);
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell_, e);
            }
        }
    }

    private void doRemoveTemplate() {
        int index = this.templateTable_.getSelectionIndex();
        if (index != -1 && GeneralPurposeDialogs.confirmMessage(this.shell_, this.text_.get("dialog.main.confirm.removetemplate"))) {
            Template template = this.templatesList_.get(index);
            boolean removeConfig = GeneralPurposeDialogs.confirmMessage(this.shell_, this.text_.get("dialog.main.confirm.removetemplateconf", new Object[]{template.getConfigurationFile().getPath()}));
            try {
                new TemplateRepository().remove(template, removeConfig);
                this.templateTable_.remove(index);
                this.templatesList_.remove(index);
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell_, e);
            }
        }
    }

    private void doDuplicateProfile() {
        int index = this.profileTable_.getSelectionIndex();
        if (index != -1) {
            try {
                Profile profile = this.profilesList_.get(index);
                String warnings = profile.resetAndLoadConfiguration();
                if (StringUtils.isNotEmpty((CharSequence)warnings)) {
                    GeneralPurposeDialogs.warningMessage(this.shell_, warnings);
                }
                Profile duplicate = new ProfileRepository().duplicate(profile);
                this.updateWithAddedProfile(duplicate);
            }
            catch (IOException | SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell_, e);
            }
        }
    }

    private void doDuplicateTemplate() {
        int index = this.templateTable_.getSelectionIndex();
        if (index != -1) {
            try {
                Template template = this.templatesList_.get(index);
                String warnings = template.resetAndLoadConfiguration();
                if (StringUtils.isNotEmpty((CharSequence)warnings)) {
                    GeneralPurposeDialogs.warningMessage(this.shell_, warnings);
                }
                Template duplicate = new TemplateRepository().duplicate(template);
                this.updateTemplateList(duplicate);
            }
            catch (IOException | SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell_, e);
            }
        }
    }

    private void doRunProfile(ExecuteUtils.ProfileRunMode mode, boolean prepareOnly) {
        int index = this.profileTable_.getSelectionIndex();
        if (index != -1) {
            Profile prof = this.profilesList_.get(index);
            if (mode != ExecuteUtils.ProfileRunMode.SETUP || prof.hasSetup()) {
                try {
                    String warningsLog = prof.resetAndLoadConfiguration();
                    if (StringUtils.isNotEmpty((CharSequence)warningsLog)) {
                        GeneralPurposeDialogs.warningMessage(this.shell_, warningsLog);
                    }
                    ExecuteUtils.doRunProfile(mode, prof, prepareOnly, this.display_);
                    if (mode == ExecuteUtils.ProfileRunMode.NORMAL) {
                        prof = new ProfileRepository().registerRun(prof);
                    } else if (mode == ExecuteUtils.ProfileRunMode.SETUP) {
                        prof = new ProfileRepository().registerSetup(prof);
                    }
                    this.updateProfileListAfterEdit(index, prof);
                }
                catch (IOException | SQLException e) {
                    GeneralPurposeDialogs.warningMessage(this.shell_, e);
                }
            }
        }
    }

    private void doRunDosbox() {
        int index = this.dbversionTable_.getSelectionIndex();
        if (index != -1) {
            DosboxVersion dbversion = this.dbversionsList_.get(index);
            try {
                ExecuteUtils.doRunDosbox(dbversion);
                new DosboxVersionRepository().registerRun(dbversion);
                this.updateDosboxVersionList(dbversion);
            }
            catch (IOException | SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell_, e);
            }
        }
    }

    private void doRunTemplate() {
        int index = this.templateTable_.getSelectionIndex();
        if (index != -1) {
            Template template = this.templatesList_.get(index);
            try {
                String warningsLog = template.resetAndLoadConfiguration();
                if (StringUtils.isNotEmpty((CharSequence)warningsLog)) {
                    GeneralPurposeDialogs.warningMessage(this.shell_, warningsLog);
                }
                ExecuteUtils.doRunTemplate(template, this.display_);
                new TemplateRepository().registerRun(template);
                this.updateTemplateList(template);
            }
            catch (IOException | SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell_, e);
            }
        }
    }

    private DosboxVersion requireDefaultDBVersion() {
        DosboxVersion dbv = DosboxVersionRepository.findDefault(this.dbversionsList_);
        if (dbv == null) {
            GeneralPurposeDialogs.infoMessage(this.shell_, this.text_.get("dialog.main.required.defaultdosboxversion"));
        }
        return dbv;
    }

    private void doOpenSettingsDialog() {
        if (((Boolean)new SettingsDialog(this.shell_).open()).booleanValue()) {
            this.rebuildProfilesTable();
        }
        this.notesField_.setFont(MainWindow.stringToFont((Device)this.display_, this.settings_.getValues("gui", "notesfont"), this.notesField_.getFont()));
    }

    private void doImportProfiles(boolean defaultToGamepacks) {
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(this.text_.get("filetype.conf"), this.text_.get("filetype.exe") + ", " + this.text_.get("filetype.booterimage"), "*"));
        ArrayList<String> extensions = new ArrayList<String>(Arrays.asList("*.conf;*.CONF", "*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT;*.cp2;*.CP2;*.dcf;*.DCF;*.img;*.IMG;*.jrc;*.JRC;*.td0;*.TD0", "*"));
        if (defaultToGamepacks) {
            names.add(0, this.text_.get("filetype.gamepack"));
            extensions.add(0, "*.zip;*.ZIP;*.7z;*.7Z");
        }
        FileDialog dialog = new FileDialog(this.shell_, 4096);
        dialog.setFilterNames(names.toArray(new String[0]));
        dialog.setFilterExtensions(extensions.toArray(new String[0]));
        String result = dialog.open();
        if (result != null) {
            this.doAddProfile(result);
        }
    }

    private void doMigrate() {
        GeneralPurposeDialogs.infoMessage(this.shell_, this.text_.get("dialog.main.notice.premigration"));
        String from = (String)new MigrateDialog(this.shell_).open();
        if (from != null) {
            this.updateProfilesList(this.getSelectedProfileIds());
            this.displayProfileInformation(true);
            GeneralPurposeDialogs.infoMessage(this.shell_, this.text_.get("dialog.main.notice.postmigration", new Object[]{from, FileLocationService.getInstance().getDosroot()}));
        }
    }

    private void doLocateDosbox(boolean interactive) {
        SearchResult result = FileLocationService.getInstance().findDosbox();
        if (result.result_ == SearchResult.ResultType.NOTFOUND) {
            GeneralPurposeDialogs.warningMessage(this.shell_, this.text_.get("dialog.locatedosbox.notice.notfound"));
            return;
        }
        if (result.result_ == SearchResult.ResultType.COMPLETE && !interactive) {
            try {
                DosboxVersion newDbversion = new DosboxVersionRepository().add(result.dosbox_);
                this.updateDosboxVersionList(newDbversion);
                GeneralPurposeDialogs.infoMessage(null, this.text_.get("dialog.locatedosbox.notice.foundandadded"));
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell_, e);
            }
        } else {
            DosboxVersion dbversion = (DosboxVersion)new EditDosboxVersionDialog(this.shell_, DosboxVersionRepository.findDefault(this.dbversionsList_) == null, result.dosbox_).open();
            if (dbversion != null) {
                this.updateDosboxVersionList(dbversion);
            }
        }
    }

    private void doImportDefaultTemplates(boolean interactive) {
        if (!interactive || GeneralPurposeDialogs.confirmMessage(this.shell_, this.text_.get("dialog.importdefaulttemplates.confirm.start"))) {
            if (this.requireDefaultDBVersion() == null) {
                return;
            }
            try {
                ArrayList<Template> importedTemplates = new ArrayList<Template>();
                String warnings = ImportExportTemplatesService.doImport(importedTemplates);
                if (StringUtils.isNotEmpty((CharSequence)warnings)) {
                    GeneralPurposeDialogs.warningMessage(this.shell_, warnings);
                } else if (interactive) {
                    GeneralPurposeDialogs.infoMessage(this.shell_, this.text_.get("dialog.import.notice.importok"));
                }
                if (!importedTemplates.isEmpty()) {
                    this.updateTemplateList((Template)importedTemplates.get(0));
                }
            }
            catch (XPathExpressionException | SAXException e) {
                GeneralPurposeDialogs.fatalMessage(this.shell_, this.text_.get("dialog.importdefaulttemplates.error.defaultxmlinvalidformat", new Object[]{e.toString()}), e);
            }
            catch (Exception e) {
                GeneralPurposeDialogs.fatalMessage(this.shell_, e.toString(), e);
            }
        }
    }

    public static void openSendToProfileDialog(String file) {
        Shell shell = new Shell();
        shell.setMinimized(true);
        shell.open();
        try {
            List<DosboxVersion> dbversionsList = new DosboxVersionRepository().listAll();
            if (DosboxVersionRepository.findDefault(dbversionsList) == null) {
                GeneralPurposeDialogs.infoMessage(shell, TextService.getInstance().get("dialog.main.required.defaultdosboxversion"));
            } else if (FilesUtils.isGamePackArchiveFile(file)) {
                new ImportDialog(shell, dbversionsList, new File(file)).open();
            } else {
                new EditSingleProfileDialog(shell, null, file, false).open();
            }
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(shell, e);
        }
        finally {
            try {
                DatabaseService.getInstance().shutdown();
            }
            catch (SQLException sQLException) {}
        }
    }

    private List<Profile> getSelectedProfiles() {
        return Arrays.stream(this.profileTable_.getSelectionIndices()).mapToObj(x -> this.profilesList_.get(x)).collect(Collectors.toList());
    }

    private Set<Integer> getSelectedProfileIds() {
        return this.getSelectedProfiles().stream().map(x -> x.getId()).collect(Collectors.toSet());
    }

    private int[] getIndicesByIds(Set<Integer> profileIds) {
        return IntStream.range(0, this.profilesList_.size()).filter(x -> profileIds.contains(this.profilesList_.get(x).getId())).toArray();
    }
}

