/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.util.stream.Stream;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.abstractdialog.SizeControlledTabbedDialog;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.conf.Configuration;
import org.dbgl.model.entity.SharedConf;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.util.SystemUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ShareConfDialog
extends SizeControlledTabbedDialog<Object> {
    private SharedConf sharedConf_;

    public ShareConfDialog(Shell parent, String gameTitle, String gameYear, Profile profile) {
        super(parent, "shareconfdialog");
        this.sharedConf_ = new SharedConf("", "", gameTitle, "", gameYear, profile.getConfigurationForSharing().toString(null), profile.getCombinedConfiguration().toString(null), "", profile.getDosboxVersion().getTitle(), profile.getDosboxVersion().getVersion());
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.confsharing.title");
    }

    @Override
    protected void onShellCreated() {
        Composite composite = this.createTabWithComposite(this.text_.get("dialog.confsharing.tab.info"), 3);
        final Text author = ShareConfDialog.createLabelAndText(composite, this.text_.get("dialog.confsharing.author"), 2);
        final Text gameTitle = ShareConfDialog.createLabelAndText(composite, this.text_.get("dialog.confsharing.gametitle"), 2);
        final Text gameVersion = ShareConfDialog.createLabelAndText(composite, this.text_.get("dialog.confsharing.gameversion"), 2);
        final Text gameYear = ShareConfDialog.createLabelAndText(composite, this.text_.get("dialog.confsharing.gameyear"), 2);
        ShareConfDialog.createLabel(composite, this.text_.get("dialog.confsharing.explanation"));
        final Tree incrConf = new Tree(composite, 2080);
        incrConf.setLayoutData((Object)new GridData(4, 4, false, true));
        final Text explanation = ShareConfDialog.createTextarea(composite, false, true, 1, 1, null);
        final Text notes = ShareConfDialog.createLabelAndTextarea(composite, this.text_.get("dialog.confsharing.notes"), false, true, 2, 1);
        this.createOkCancelButtons((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!ShareConfDialog.this.isValid(author, gameTitle, gameYear, explanation)) {
                    return;
                }
                try {
                    ShareConfDialog.this.sharedConf_.setAuthor(author.getText());
                    ShareConfDialog.this.sharedConf_.setGameTitle(gameTitle.getText());
                    ShareConfDialog.this.sharedConf_.setGameVersion(gameVersion.getText());
                    ShareConfDialog.this.sharedConf_.setGameYear(gameYear.getText());
                    ShareConfDialog.this.sharedConf_.setIncrConf(ShareConfDialog.this.extractConfFromTree(incrConf));
                    ShareConfDialog.this.sharedConf_.setExplanation(explanation.getText());
                    ShareConfDialog.this.sharedConf_.setNotes(notes.getText());
                    Client client = ClientBuilder.newClient();
                    SharedConf result = (SharedConf)client.target(ShareConfDialog.this.settings_.getValue("confsharing", "endpoint")).path("/submissions").request().post(Entity.entity((Object)ShareConfDialog.this.sharedConf_, (String)"application/xml"), SharedConf.class);
                    GeneralPurposeDialogs.infoMessage(ShareConfDialog.this.shell_, ShareConfDialog.this.text_.get("dialog.confsharing.confirmation", new Object[]{result.getGameTitle()}));
                    client.close();
                }
                catch (Exception e) {
                    GeneralPurposeDialogs.fatalMessage(ShareConfDialog.this.shell_, ShareConfDialog.this.text_.get("dialog.confsharing.error.submit", new Object[]{StringRelatedUtils.toString(e)}), e);
                }
                ShareConfDialog.this.settings_.setValue("confsharing", "author", author.getText());
                ShareConfDialog.this.shell_.close();
            }
        });
        author.setText(StringUtils.defaultString((String)this.settings_.getValue("confsharing", "author")));
        gameTitle.setText(this.sharedConf_.getGameTitle());
        gameYear.setText(this.sharedConf_.getGameYear());
        this.fillStringIntoTree(this.sharedConf_.getIncrConf(), incrConf);
        if (StringUtils.isBlank((CharSequence)this.sharedConf_.getIncrConf())) {
            explanation.setText("N/A");
        }
        if (StringUtils.isBlank((CharSequence)gameTitle.getText())) {
            gameTitle.setFocus();
        } else if (StringUtils.isBlank((CharSequence)gameYear.getText())) {
            gameYear.setFocus();
        } else if (StringUtils.isBlank((CharSequence)explanation.getText())) {
            explanation.setFocus();
        } else {
            notes.setFocus();
        }
    }

    private boolean isValid(Text author, Text gameTitle, Text gameYear, Text explanation) {
        GeneralPurposeDialogs.initErrorDialog();
        if (StringUtils.isBlank((CharSequence)author.getText())) {
            GeneralPurposeDialogs.addError(this.text_.get("dialog.confsharing.required.author"), (Control)author);
        }
        if (StringUtils.isBlank((CharSequence)gameTitle.getText())) {
            GeneralPurposeDialogs.addError(this.text_.get("dialog.confsharing.required.gametitle"), (Control)gameTitle);
        }
        if (StringUtils.isBlank((CharSequence)gameYear.getText())) {
            GeneralPurposeDialogs.addError(this.text_.get("dialog.confsharing.required.gameyear"), (Control)gameYear);
        }
        if (StringUtils.isBlank((CharSequence)explanation.getText())) {
            GeneralPurposeDialogs.addError(this.text_.get("dialog.confsharing.required.explanation"), (Control)explanation);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell_);
    }

    private void fillStringIntoTree(String conf, Tree tree) {
        String[] lines = StringUtils.split((String)conf, (String)SystemUtils.EOLN);
        TreeItem sectionItem = null;
        for (String string : lines) {
            if (string.startsWith("[")) {
                sectionItem = new TreeItem(tree, 0);
                sectionItem.setText(string);
                sectionItem.setChecked(true);
                continue;
            }
            TreeItem node = new TreeItem(sectionItem, 0);
            node.setText(string);
            node.setChecked(true);
        }
        for (String string : tree.getItems()) {
            string.setExpanded(true);
        }
        tree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    TreeItem tItem = (TreeItem)event.item;
                    if (tItem.getParentItem() == null) {
                        tItem.setGrayed(false);
                        for (TreeItem item : tItem.getItems()) {
                            item.setChecked(tItem.getChecked());
                        }
                    } else {
                        TreeItem parent;
                        long checkedCount = Stream.of((parent = tItem.getParentItem()).getItems()).filter(x -> x.getChecked()).count();
                        parent.setChecked(checkedCount > 0L);
                        parent.setGrayed(checkedCount > 0L && checkedCount < (long)parent.getItemCount());
                    }
                }
            }
        });
    }

    private String extractConfFromTree(Tree tree) {
        Configuration conf = new Configuration();
        for (TreeItem sectionItem : tree.getItems()) {
            if (!sectionItem.getChecked()) continue;
            for (TreeItem node : sectionItem.getItems()) {
                if (!node.getChecked()) continue;
                String[] v = StringUtils.split((String)node.getText(), (char)'=');
                conf.setValue(StringUtils.substring((String)sectionItem.getText(), (int)1, (int)-1), v[0], v[1]);
            }
        }
        return conf.toString(null);
    }
}

