/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog.wizard;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.abstractdialog.JobWizardDialog;
import org.dbgl.gui.controls.BrowseButton;
import org.dbgl.gui.thread.DFendImportThread;
import org.dbgl.gui.thread.DFendReloadedImportThread;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.service.FileLocationService;
import org.eclipse.swt.events.ExpandAdapter;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DFendImportDialog
extends JobWizardDialog<Object> {
    private DosboxVersion defaultDbversion_;
    private ExpandItem orginalExpandItem_;
    private Text location_;
    private Text dfrLocation_;
    private Text dfrConfsLocation_;
    private Button cleanup_;
    private Button dfrCleanup_;

    public DFendImportDialog(Shell parent, DosboxVersion dbversion) {
        super(parent, "dfendimportdialog");
        this.defaultDbversion_ = dbversion;
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.dfendimport.title");
    }

    @Override
    protected void onShellCreated() {
        Group optionsGroup = DFendImportDialog.createGroup((Composite)this.shell_, this.text_.get("dialog.dfendimport.options"), (Layout)new FillLayout());
        final ExpandBar bar = new ExpandBar((Composite)optionsGroup, 512);
        Composite originalComposite = DFendImportDialog.createComposite((Composite)bar, 3);
        this.location_ = DFendImportDialog.createLabelAndText(originalComposite, this.text_.get("dialog.dfendimport.dfendpath"), FileLocationService.DFEND_STRING);
        new BrowseButton(originalComposite).connect(this.shell_, this.location_, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.DFEND, false, null);
        this.cleanup_ = DFendImportDialog.createLabelAndCheckButton(originalComposite, this.text_.get("dialog.dfendimport.cleanup"), this.text_.get("dialog.dfendimport.removesections"), true);
        DFendImportDialog.createLabel(originalComposite);
        this.orginalExpandItem_ = DFendImportDialog.createExpandItem(bar, this.text_.get("dialog.dfendimport.original.title"), false, originalComposite);
        Composite reloadedComposite = DFendImportDialog.createComposite((Composite)bar, 3);
        this.dfrLocation_ = DFendImportDialog.createLabelAndText(reloadedComposite, this.text_.get("dialog.dfendimport.reloaded.path"), FileLocationService.DFEND_RELOADED_PATH_STRING);
        new BrowseButton(reloadedComposite).connect(this.shell_, this.dfrLocation_, null, BrowseButton.BrowseType.DIR, BrowseButton.CanonicalType.NONE, false, null);
        this.dfrConfsLocation_ = DFendImportDialog.createLabelAndText(reloadedComposite, this.text_.get("dialog.dfendimport.reloaded.exportedconfspath"));
        new BrowseButton(reloadedComposite).connect(this.shell_, this.dfrConfsLocation_, null, BrowseButton.BrowseType.DIR, BrowseButton.CanonicalType.NONE, false, null);
        this.dfrCleanup_ = DFendImportDialog.createLabelAndCheckButton(reloadedComposite, this.text_.get("dialog.dfendimport.cleanup"), this.text_.get("dialog.dfendimport.reloaded.removesections"), false);
        DFendImportDialog.createLabel(reloadedComposite);
        DFendImportDialog.createExpandItem(bar, this.text_.get("dialog.dfendimport.reloaded.title"), true, reloadedComposite);
        bar.addExpandListener((ExpandListener)new ExpandAdapter(){

            public void itemCollapsed(ExpandEvent e) {
                bar.getItem(((ExpandItem)e.item).getText().equals(DFendImportDialog.this.text_.get("dialog.dfendimport.reloaded.title")) ? 0 : 1).setExpanded(true);
                DFendImportDialog.this.display_.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DFendImportDialog.this.shell_.layout();
                    }
                });
            }

            public void itemExpanded(ExpandEvent e) {
                bar.getItem(((ExpandItem)e.item).getText().equals(DFendImportDialog.this.text_.get("dialog.dfendimport.reloaded.title")) ? 0 : 1).setExpanded(false);
                DFendImportDialog.this.display_.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DFendImportDialog.this.shell_.layout();
                    }
                });
            }
        });
        this.addStep(optionsGroup);
        this.addFinalStep(this.text_.get("dialog.dfendimport.progress"), this.text_.get("dialog.dfendimport.startimport"));
    }

    @Override
    protected boolean onNext(int step) {
        if (step == 0) {
            if (!this.isValid()) {
                return false;
            }
        } else if (step == 1) {
            try {
                if (this.orginalExpandItem_.getExpanded()) {
                    this.job_ = new DFendImportThread(this.log_, this.progressBar_, this.status_, new File(this.location_.getText()), this.cleanup_.getSelection(), this.defaultDbversion_);
                }
                this.job_ = new DFendReloadedImportThread(this.log_, this.progressBar_, this.status_, new File(this.dfrLocation_.getText()), new File(this.dfrConfsLocation_.getText()), this.dfrCleanup_.getSelection(), this.defaultDbversion_);
            }
            catch (IOException e) {
                GeneralPurposeDialogs.warningMessage(this.shell_, e);
                return false;
            }
        } else if (step == 2) {
            if (this.job_.isEverythingOk()) {
                GeneralPurposeDialogs.infoMessage(this.shell_, this.text_.get("dialog.dfendimport.notice.importok"));
            } else {
                GeneralPurposeDialogs.warningMessage(this.shell_, this.text_.get("dialog.dfendimport.error.problem"));
            }
            this.status_.setText(this.text_.get("dialog.dfendimport.reviewlog"));
            this.status_.pack();
            this.result_ = this.job_;
        }
        return true;
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.orginalExpandItem_.getExpanded()) {
            if (StringUtils.isBlank((CharSequence)this.location_.getText())) {
                GeneralPurposeDialogs.addError(this.text_.get("dialog.dfendimport.required.location"), (Control)this.location_);
            }
        } else {
            if (StringUtils.isBlank((CharSequence)this.dfrLocation_.getText())) {
                GeneralPurposeDialogs.addError(this.text_.get("dialog.dfendimport.reloaded.required.location"), (Control)this.dfrLocation_);
            }
            if (StringUtils.isBlank((CharSequence)this.dfrConfsLocation_.getText())) {
                GeneralPurposeDialogs.addError(this.text_.get("dialog.dfendimport.reloaded.required.confslocation"), (Control)this.dfrConfsLocation_);
            }
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell_);
    }
}

