/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.thread;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.dbgl.gui.thread.UIThread;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.model.WebProfile;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.repository.ProfileRepository;
import org.dbgl.service.ImageService;
import org.dbgl.service.SettingsService;
import org.dbgl.util.FilesUtils;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public class SearchEngineThread
extends UIThread<Profile> {
    private final String logDelimiter_;
    private final WebSearchEngine engine_;

    public SearchEngineThread(List<Profile> profs, WebSearchEngine engine, Text log, ProgressBar progressBar, Label status) {
        super(log, progressBar, status, false);
        this.setObjects(profs);
        this.logDelimiter_ = log.getLineDelimiter();
        this.engine_ = engine;
    }

    @Override
    public String work(Profile prof) throws SQLException {
        this.displayTitle(text_.get("dialog.multiprofile.updating", new Object[]{this.getTitle(prof)}));
        StringBuffer messageLog = new StringBuffer();
        String title = this.getTitle(prof);
        if (this.engine_ != null) {
            try {
                int firstMatch;
                SettingsService settings = SettingsService.getInstance();
                List<WebProfile> webGamesList = this.engine_.getEntries(title, settings.getValues(this.engine_.getSimpleName(), "platform_filter"));
                if (webGamesList.size() > 1 && (firstMatch = WebSearchEngine.getEntryFirstExactMatchIndex(title, webGamesList)) != -1) {
                    webGamesList = webGamesList.subList(firstMatch, firstMatch + 1);
                }
                if (webGamesList.size() == 1) {
                    WebProfile thisGame = this.engine_.getEntryDetailedInformation(webGamesList.get(0));
                    if (settings.getBooleanValue(this.engine_.getSimpleName(), "set_title")) {
                        prof.setTitle(thisGame.getTitle());
                    }
                    if (settings.getBooleanValue(this.engine_.getSimpleName(), "set_developer")) {
                        prof.setDeveloper(thisGame.getDeveloperName());
                    }
                    if (settings.getBooleanValue(this.engine_.getSimpleName(), "set_publisher")) {
                        prof.setPublisher(thisGame.getPublisherName());
                    }
                    if (settings.getBooleanValue(this.engine_.getSimpleName(), "set_year")) {
                        prof.setYear(thisGame.getYear());
                    }
                    if (settings.getBooleanValue(this.engine_.getSimpleName(), "set_genre")) {
                        prof.setGenre(thisGame.getGenre());
                    }
                    if (settings.getBooleanValue(this.engine_.getSimpleName(), "set_link")) {
                        prof.setLinkDestination(0, thisGame.getUrl());
                        prof.setLinkTitle(0, text_.get("dialog.profile.searchengine.link.maininfo", new String[]{this.engine_.getName()}));
                    }
                    if (settings.getBooleanValue(this.engine_.getSimpleName(), "set_description")) {
                        String engineNotes = thisGame.getNotes().replaceAll("\n", this.logDelimiter_);
                        if (!prof.getNotes().endsWith(engineNotes)) {
                            StringBuffer notes = new StringBuffer(prof.getNotes());
                            if (notes.length() > 0) {
                                notes.append(this.logDelimiter_ + this.logDelimiter_);
                            }
                            notes.append(engineNotes);
                            prof.setNotes(notes.toString());
                        }
                    }
                    if (settings.getBooleanValue(this.engine_.getSimpleName(), "set_rank")) {
                        prof.setCustomInt(0, String.valueOf(thisGame.getRank()));
                    }
                    new ProfileRepository().update(prof);
                    boolean forceAllRegionsCoverArt = settings.getBooleanValue(this.engine_.getSimpleName(), "force_all_regions_coverart");
                    SearchEngineImageInformation[] imageInformation = this.engine_.getEntryImages(thisGame, settings.getIntValue(this.engine_.getSimpleName(), "multi_max_coverart"), settings.getIntValue(this.engine_.getSimpleName(), "multi_max_screenshot"), forceAllRegionsCoverArt);
                    for (int i = 0; i < imageInformation.length; ++i) {
                        File file;
                        String filename;
                        String description = FilesUtils.toSafeFilenameForWebImages(imageInformation[i].getDescription());
                        if (imageInformation[i].getType() == SearchEngineImageInformation.SearchEngineImageType.CoverArt) {
                            filename = text_.get("dialog.profile.mobygames.coverartfilename", new Object[]{i, description});
                            file = new File(prof.getCanonicalCaptures(), filename + ".jpg");
                        } else {
                            filename = text_.get("dialog.profile.mobygames.screenshotfilename", new Object[]{i, description});
                            file = new File(prof.getCanonicalCaptures(), filename + ".png");
                        }
                        if (!FilesUtils.isExistingFile(file)) {
                            ImageService.save(thisGame.getWebImage(i), file.getPath());
                            continue;
                        }
                        messageLog.append(text_.get("dialog.profile.error.imagealreadyexists", new String[]{file.getPath(), this.engine_.getName()})).append('\n');
                    }
                } else if (webGamesList.size() == 0) {
                    messageLog.append(text_.get("general.notice.searchenginenoresults", new String[]{this.engine_.getName(), title})).append('\n');
                } else {
                    messageLog.append(text_.get("dialog.multiprofile.notice.titlenotunique", new String[]{this.engine_.getName(), title})).append('\n');
                }
            }
            catch (IOException e) {
                messageLog.append(text_.get("general.error.retrieveinfosearchengine", new String[]{this.engine_.getName(), title, e.toString()})).append('\n');
            }
        }
        return messageLog.toString();
    }

    @Override
    public String getTitle(Profile profile) {
        return profile.getTitle();
    }

    @Override
    public void preFinish() {
    }
}

