/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.archive;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Enumeration;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.dbgl.gui.interfaces.ProgressNotifyable;
import org.dbgl.service.TextService;
import org.dbgl.util.FilesUtils;
import org.dbgl.util.SystemUtils;

public class ZipUtils {
    public static void zipEntry(ZipOutputStream zos, File srcEntry, File dstEntry) throws IOException {
        if (!srcEntry.isFile() && !srcEntry.isDirectory()) {
            throw new IOException(TextService.getInstance().get("general.error.openfile", new Object[]{srcEntry}));
        }
        ZipEntry zipEntry = new ZipEntry(FilesUtils.toArchivePath(dstEntry, srcEntry.isDirectory()));
        zipEntry.setTime(srcEntry.lastModified());
        if (srcEntry.isFile() && !srcEntry.canWrite()) {
            zipEntry.setExtra(new byte[]{1});
        }
        zos.putNextEntry(zipEntry);
        if (srcEntry.isFile()) {
            Files.copy(srcEntry.toPath(), zos);
        }
        zos.closeEntry();
    }

    public static void zipDir(ZipOutputStream zos, File srcDirToZip, File dstDirInZip) throws IOException {
        ZipUtils.zipDir(zos, srcDirToZip, dstDirInZip, srcDirToZip);
    }

    private static void zipDir(ZipOutputStream zos, File srcDirToZip, File dstDirInZip, File srcRootDir) throws IOException {
        String[] dirList = srcDirToZip.list();
        if (dirList == null) {
            throw new IOException(TextService.getInstance().get("general.error.opendir", new Object[]{srcDirToZip}));
        }
        for (String dirEntry : dirList) {
            File srcEntry = new File(srcDirToZip, dirEntry);
            ZipUtils.zipEntry(zos, srcEntry, new File(dstDirInZip, FilesUtils.relativize(srcRootDir, srcEntry)));
            if (!srcEntry.isDirectory()) continue;
            ZipUtils.zipDir(zos, srcEntry, dstDirInZip, srcRootDir);
        }
    }

    public static long extractedSizeInBytes(File archive, String zipEntryToBeExtracted) throws IOException {
        long bytes = 0L;
        try (ZipFile zf = new ZipFile(archive);){
            ZipEntry entry = zf.getEntry(zipEntryToBeExtracted);
            if (entry != null) {
                bytes = entry.getSize();
            }
        }
        return bytes;
    }

    public static long extractedSizeInBytes(File archive, File dirToBeExtracted) throws IOException {
        long bytes = 0L;
        try (ZipFile zf = new ZipFile(archive);){
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!FilesUtils.areRelated(dirToBeExtracted, new File(entry.getName()))) continue;
                bytes += entry.getSize();
            }
        }
        return bytes;
    }

    public static void extractDirInZip(File archive, File dirToBeExtracted, File dstDir, ProgressNotifyable prog) throws IOException {
        try (ZipFile zf = new ZipFile(archive);){
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File entryFile = new File(entry.getName());
                if (!FilesUtils.areRelated(dirToBeExtracted, entryFile)) continue;
                String relativeFile = FilesUtils.relativize(dirToBeExtracted, entryFile);
                File dstFile = new File(dstDir, relativeFile);
                ZipUtils.extractEntry(zf, entry, dstFile, prog);
            }
        }
    }

    public static void extractFileInZip(File archive, File fileToBeExtracted, File dstFile, ProgressNotifyable prog) throws IOException {
        try (ZipFile zf = new ZipFile(archive);){
            ZipEntry entry = zf.getEntry(FilesUtils.toArchivePath(fileToBeExtracted, false));
            if (entry != null) {
                ZipUtils.extractEntry(zf, entry, dstFile, prog);
            }
        }
    }

    public static void extractEntry(ZipFile zf, ZipEntry srcEntry, File dstFile, ProgressNotifyable prog) throws IOException {
        File foundDstFile = null;
        File temporarilyRenamedFile = null;
        if (SystemUtils.IS_WINDOWS && dstFile.getName().contains("~") && !(foundDstFile = dstFile.getCanonicalFile()).getName().equals(dstFile.getName()) && foundDstFile.exists()) {
            temporarilyRenamedFile = new File(foundDstFile.getParentFile(), UUID.randomUUID() + "__" + foundDstFile.getName());
            foundDstFile.renameTo(temporarilyRenamedFile);
        }
        if (srcEntry.isDirectory()) {
            if (!dstFile.exists()) {
                FilesUtils.createDir(dstFile);
            }
        } else {
            if (dstFile.exists()) {
                throw new IOException(TextService.getInstance().get("general.error.filetobeextractedexists", new Object[]{dstFile}));
            }
            if (dstFile.getParentFile() != null) {
                FilesUtils.createDir(dstFile.getParentFile());
            }
            try (InputStream zis = zf.getInputStream(srcEntry);){
                Files.copy(zis, dstFile.toPath(), new CopyOption[0]);
            }
            byte[] extra = srcEntry.getExtra();
            if (extra != null && extra.length == 1 && extra[0] == 1) {
                FilesUtils.setReadOnly(dstFile);
            }
        }
        FilesUtils.setLastModified(dstFile, srcEntry.getTime());
        if (foundDstFile != null && temporarilyRenamedFile != null) {
            temporarilyRenamedFile.renameTo(foundDstFile);
        }
        prog.incrProgress(srcEntry.getSize());
    }
}

