/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.fat;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.dbgl.util.fat.BlockDevice;
import org.dbgl.util.fat.Fat16BootSector;
import org.dbgl.util.fat.Fat32BootSector;
import org.dbgl.util.fat.FatType;
import org.dbgl.util.fat.Sector;

public abstract class BootSector
extends Sector {
    public static final int FAT_COUNT_OFFSET = 16;
    public static final int RESERVED_SECTORS_OFFSET = 14;
    public static final int TOTAL_SECTORS_16_OFFSET = 19;
    public static final int TOTAL_SECTORS_32_OFFSET = 32;
    public static final int FILE_SYSTEM_TYPE_LENGTH = 8;
    public static final int SECTORS_PER_CLUSTER_OFFSET = 13;
    public static final int SIZE = 512;

    protected BootSector(BlockDevice device, long offset) {
        super(device, offset, 512);
    }

    public static BootSector read(BlockDevice device) throws IOException {
        byte sectorsPerCluster;
        ByteBuffer bb = ByteBuffer.allocate(512);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        long offset = 0L;
        if (device.getSize() > 0x2D0000L) {
            offset = 32256L;
            device.read(0L, bb);
            if ((bb.get(510) & 0xFF) != 85 || (bb.get(511) & 0xFF) != 170) {
                System.err.println("missing boot sector signature");
            }
            for (int i = 0; i < 4; ++i) {
                int partSize = bb.getInt(446 + (i * 16 + 12));
                if (partSize <= 0) continue;
                offset = bb.getInt(446 + (i * 16 + 8)) * 512;
                break;
            }
        }
        bb.clear();
        device.read(offset, bb);
        if ((bb.get(510) & 0xFF) != 85 || (bb.get(511) & 0xFF) != 170) {
            System.err.println("missing boot sector signature");
        }
        if ((sectorsPerCluster = bb.get(13)) <= 0) {
            throw new IOException("suspicious sectors per cluster count " + sectorsPerCluster);
        }
        short rootDirEntries = bb.getShort(17);
        int rootDirSectors = (rootDirEntries * 32 + (device.getSectorSize() - 1)) / device.getSectorSize();
        int total16 = bb.getShort(19) & 0xFFFF;
        long total32 = (long)bb.getInt(32) & 0xFFFFFFFFL;
        long totalSectors = total16 == 0 ? total32 : (long)total16;
        int fatSz16 = bb.getShort(22) & 0xFFFF;
        long fatSz32 = (long)bb.getInt(36) & 0xFFFFFFFFL;
        long fatSz = fatSz16 == 0 ? fatSz32 : (long)fatSz16;
        long dataSectors = totalSectors - ((long)bb.getShort(14) + (long)bb.get(16) * fatSz + (long)rootDirSectors);
        long clusterCount = dataSectors / (long)sectorsPerCluster;
        BootSector result = clusterCount > 65524L ? new Fat32BootSector(device, offset) : new Fat16BootSector(device, offset);
        result.read();
        return result;
    }

    public abstract FatType getFatType();

    public abstract long getSectorsPerFat();

    public abstract int getRootDirEntryCount();

    public abstract long getSectorCount();

    public final long getDataClusterCount() {
        return this.getDataSize() / (long)this.getBytesPerCluster();
    }

    private long getDataSize() {
        return this.getSectorCount() * (long)this.getBytesPerSector() - this.getFilesOffset();
    }

    public String getOemName() {
        int v;
        StringBuilder b = new StringBuilder(8);
        for (int i = 0; i < 8 && (v = this.get8(3 + i)) != 0; ++i) {
            b.append((char)v);
        }
        return b.toString();
    }

    public int getBytesPerSector() {
        return this.get16(11);
    }

    public int getBytesPerCluster() {
        return this.getSectorsPerCluster() * this.getBytesPerSector();
    }

    public int getSectorsPerCluster() {
        return this.get8(13);
    }

    public int getNrReservedSectors() {
        return this.get16(14);
    }

    public final int getNrFats() {
        return this.get8(16);
    }

    protected int getNrLogicalSectors() {
        return this.get16(19);
    }

    protected long getNrTotalSectors() {
        return this.get32(32);
    }

    public int getMediumDescriptor() {
        return this.get8(21);
    }

    public int getSectorsPerTrack() {
        return this.get16(24);
    }

    public int getNrHeads() {
        return this.get16(26);
    }

    public long getNrHiddenSectors() {
        return this.get32(28);
    }

    public long getOffset() {
        return this.offset_;
    }

    public long getFatOffset(int fatNr) {
        return (long)(this.getNrReservedSectors() * this.getBytesPerSector()) + (long)fatNr * this.getSectorsPerFat() * (long)this.getBytesPerSector() + this.getOffset();
    }

    public long getRootDirOffset() {
        return (long)this.getNrFats() * this.getSectorsPerFat() * (long)this.getBytesPerSector() + this.getFatOffset(0);
    }

    public long getFilesOffset() {
        return this.getRootDirOffset() + (long)(this.getRootDirEntryCount() * 32);
    }

    public String toString() {
        StringBuilder res = new StringBuilder(1024);
        res.append("Bootsector :\n");
        res.append("oemName=");
        res.append(this.getOemName());
        res.append('\n');
        res.append("medium descriptor = ");
        res.append(this.getMediumDescriptor());
        res.append('\n');
        res.append("Nr heads = ");
        res.append(this.getNrHeads());
        res.append('\n');
        res.append("Sectors per track = ");
        res.append(this.getSectorsPerTrack());
        res.append('\n');
        res.append("Sector per cluster = ");
        res.append(this.getSectorsPerCluster());
        res.append('\n');
        res.append("byte per sector = ");
        res.append(this.getBytesPerSector());
        res.append('\n');
        res.append("Nr fats = ");
        res.append(this.getNrFats());
        res.append('\n');
        res.append("Nr hidden sectors = ");
        res.append(this.getNrHiddenSectors());
        res.append('\n');
        res.append("Nr logical sectors = ");
        res.append(this.getNrLogicalSectors());
        res.append('\n');
        res.append("Nr reserved sector = ");
        res.append(this.getNrReservedSectors());
        res.append('\n');
        return res.toString();
    }
}

