/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.gif;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.dbgl.util.searchengine.WebSearchEngine;

public class GifDecoder {
    public static final int STATUS_OK = 0;
    public static final int STATUS_FORMAT_ERROR = 1;
    public static final int STATUS_OPEN_ERROR = 2;
    private static final int MaxStackSize = 4096;
    private BufferedInputStream in_;
    private int status_;
    private int width_;
    private int height_;
    private boolean gctFlag_;
    private int gctSize_;
    private int[] gct_;
    private int[] lct_;
    private int[] act_;
    private int bgIndex_;
    private int bgColor_;
    private int lastBgColor_;
    private boolean lctFlag_;
    private boolean interlace_;
    private int lctSize_;
    private int ix_;
    private int iy_;
    private int iw_;
    private int ih_;
    private Rectangle lastRect_;
    private BufferedImage image_;
    private BufferedImage lastImage_;
    private byte[] block_ = new byte[256];
    private int blockSize_ = 0;
    private int dispose_ = 0;
    private int lastDispose_ = 0;
    private boolean transparency_ = false;
    private int delay_ = 0;
    private int transIndex_;
    private short[] prefix_;
    private byte[] suffix_;
    private byte[] pixelStack_;
    private byte[] pixels_;
    private ArrayList<GifFrame> frames_;
    private int frameCount_;

    public int read(BufferedInputStream is) throws IOException {
        this.init();
        if (is != null) {
            this.in_ = is;
            this.readHeader();
            if (!this.err()) {
                this.readContents();
                if (this.frameCount_ < 0) {
                    this.status_ = 1;
                }
            }
        } else {
            this.status_ = 2;
        }
        if (is != null) {
            is.close();
        }
        return this.status_;
    }

    public int read(InputStream is) throws IOException {
        this.init();
        if (is != null) {
            if (!(is instanceof BufferedInputStream)) {
                is = new BufferedInputStream(is);
            }
            this.in_ = (BufferedInputStream)is;
            this.readHeader();
            if (!this.err()) {
                this.readContents();
                if (this.frameCount_ < 0) {
                    this.status_ = 1;
                }
            }
        } else {
            this.status_ = 2;
        }
        if (is != null) {
            is.close();
        }
        return this.status_;
    }

    public int read(String name) {
        this.status_ = 0;
        try {
            name = name.trim().toLowerCase();
            this.in_ = name.indexOf("file:") >= 0 || name.indexOf(":/") > 0 ? new BufferedInputStream(WebSearchEngine.getInputStream(name)) : new BufferedInputStream(new FileInputStream(name));
            this.status_ = this.read(this.in_);
        }
        catch (IOException e) {
            this.status_ = 2;
        }
        return this.status_;
    }

    public int getFrameCount() {
        return this.frameCount_;
    }

    public BufferedImage getFrame(int n) {
        BufferedImage im = null;
        if (n >= 0 && n < this.frameCount_) {
            im = this.frames_.get(n).image_;
        }
        return im;
    }

    public int getDelay(int n) {
        this.delay_ = -1;
        if (n >= 0 && n < this.frameCount_) {
            this.delay_ = this.frames_.get(n).delay_;
        }
        return this.delay_;
    }

    private void setPixels() {
        int[] dest = ((DataBufferInt)this.image_.getRaster().getDataBuffer()).getData();
        if (this.lastDispose_ > 0) {
            if (this.lastDispose_ == 3) {
                int n = this.frameCount_ - 2;
                this.lastImage_ = n > 0 ? this.getFrame(n - 1) : null;
            }
            if (this.lastImage_ != null) {
                int[] prev = ((DataBufferInt)this.lastImage_.getRaster().getDataBuffer()).getData();
                System.arraycopy(prev, 0, dest, 0, this.width_ * this.height_);
                if (this.lastDispose_ == 2) {
                    Graphics2D g = this.image_.createGraphics();
                    Color c = null;
                    c = this.transparency_ ? new Color(0, 0, 0, 0) : new Color(this.lastBgColor_);
                    g.setColor(c);
                    g.setComposite(AlphaComposite.Src);
                    g.fill(this.lastRect_);
                    g.dispose();
                }
            }
        }
        int pass = 1;
        int inc = 8;
        int iline = 0;
        for (int i = 0; i < this.ih_; ++i) {
            int line = i;
            if (this.interlace_) {
                if (iline >= this.ih_) {
                    switch (++pass) {
                        case 2: {
                            iline = 4;
                            break;
                        }
                        case 3: {
                            iline = 2;
                            inc = 4;
                            break;
                        }
                        case 4: {
                            iline = 1;
                            inc = 2;
                        }
                    }
                }
                line = iline;
                iline += inc;
            }
            if ((line += this.iy_) >= this.height_) continue;
            int k = line * this.width_;
            int dx = k + this.ix_;
            int dlim = dx + this.iw_;
            if (k + this.width_ < dlim) {
                dlim = k + this.width_;
            }
            int sx = i * this.iw_;
            while (dx < dlim) {
                int index;
                int c;
                if ((c = this.act_[index = this.pixels_[sx++] & 0xFF]) != 0) {
                    dest[dx] = c;
                }
                ++dx;
            }
        }
    }

    private void decodeImageData() {
        int code;
        int NullCode = -1;
        int npix = this.iw_ * this.ih_;
        if (this.pixels_ == null || this.pixels_.length < npix) {
            this.pixels_ = new byte[npix];
        }
        if (this.prefix_ == null) {
            this.prefix_ = new short[4096];
        }
        if (this.suffix_ == null) {
            this.suffix_ = new byte[4096];
        }
        if (this.pixelStack_ == null) {
            this.pixelStack_ = new byte[4097];
        }
        int data_size = this.read();
        int clear = 1 << data_size;
        int end_of_information = clear + 1;
        int available = clear + 2;
        int old_code = NullCode;
        int code_size = data_size + 1;
        int code_mask = (1 << code_size) - 1;
        for (code = 0; code < clear; ++code) {
            this.prefix_[code] = 0;
            this.suffix_[code] = (byte)code;
        }
        int bi = 0;
        int pi = 0;
        int top = 0;
        int first = 0;
        int count = 0;
        int bits = 0;
        int datum = 0;
        int i = 0;
        while (i < npix) {
            if (top == 0) {
                if (bits < code_size) {
                    if (count == 0) {
                        count = this.readBlock();
                        if (count <= 0) break;
                        bi = 0;
                    }
                    datum += (this.block_[bi] & 0xFF) << bits;
                    bits += 8;
                    ++bi;
                    --count;
                    continue;
                }
                code = datum & code_mask;
                datum >>= code_size;
                bits -= code_size;
                if (code > available || code == end_of_information) break;
                if (code == clear) {
                    code_size = data_size + 1;
                    code_mask = (1 << code_size) - 1;
                    available = clear + 2;
                    old_code = NullCode;
                    continue;
                }
                if (old_code == NullCode) {
                    this.pixelStack_[top++] = this.suffix_[code];
                    old_code = code;
                    first = code;
                    continue;
                }
                int in_code = code;
                if (code == available) {
                    this.pixelStack_[top++] = (byte)first;
                    code = old_code;
                }
                while (code > clear) {
                    this.pixelStack_[top++] = this.suffix_[code];
                    code = this.prefix_[code];
                }
                first = this.suffix_[code] & 0xFF;
                if (available >= 4096) break;
                this.pixelStack_[top++] = (byte)first;
                this.prefix_[available] = (short)old_code;
                this.suffix_[available] = (byte)first;
                if ((++available & code_mask) == 0 && available < 4096) {
                    ++code_size;
                    code_mask += available;
                }
                old_code = in_code;
            }
            this.pixels_[pi++] = this.pixelStack_[--top];
            ++i;
        }
        for (i = pi; i < npix; ++i) {
            this.pixels_[i] = 0;
        }
    }

    private boolean err() {
        return this.status_ != 0;
    }

    private void init() {
        this.status_ = 0;
        this.frameCount_ = 0;
        this.frames_ = new ArrayList();
        this.gct_ = null;
        this.lct_ = null;
    }

    private int read() {
        int curByte = 0;
        try {
            curByte = this.in_.read();
        }
        catch (IOException e) {
            this.status_ = 1;
        }
        return curByte;
    }

    private int readBlock() {
        int n;
        this.blockSize_ = this.read();
        if (this.blockSize_ > 0) {
            try {
                int count = 0;
                for (n = 0; n < this.blockSize_ && (count = this.in_.read(this.block_, n, this.blockSize_ - n)) != -1; n += count) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (n < this.blockSize_) {
                this.status_ = 1;
            }
        }
        return n;
    }

    private int[] readColorTable(int ncolors) {
        int nbytes = 3 * ncolors;
        int[] tab = null;
        byte[] c = new byte[nbytes];
        int n = 0;
        try {
            n = this.in_.read(c);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n < nbytes) {
            this.status_ = 1;
        } else {
            tab = new int[256];
            int i = 0;
            int j = 0;
            while (i < ncolors) {
                int r = c[j++] & 0xFF;
                int g = c[j++] & 0xFF;
                int b = c[j++] & 0xFF;
                tab[i++] = 0xFF000000 | r << 16 | g << 8 | b;
            }
        }
        return tab;
    }

    private void readContents() {
        boolean done = false;
        block10: while (!done && !this.err()) {
            int code = this.read();
            switch (code) {
                case 44: {
                    this.readImage();
                    continue block10;
                }
                case 33: {
                    code = this.read();
                    switch (code) {
                        case 249: {
                            this.readGraphicControlExt();
                            continue block10;
                        }
                        case 255: {
                            this.readBlock();
                            StringBuffer app = new StringBuffer();
                            for (int i = 0; i < 11; ++i) {
                                app.append((char)this.block_[i]);
                            }
                            if (app.toString().equals("NETSCAPE2.0")) {
                                this.readNetscapeExt();
                                continue block10;
                            }
                            this.skip();
                            continue block10;
                        }
                    }
                    this.skip();
                    continue block10;
                }
                case 59: {
                    done = true;
                    continue block10;
                }
                case 0: {
                    continue block10;
                }
            }
            this.status_ = 1;
        }
    }

    private void readGraphicControlExt() {
        this.read();
        int packed = this.read();
        this.dispose_ = (packed & 0x1C) >> 2;
        if (this.dispose_ == 0) {
            this.dispose_ = 1;
        }
        this.transparency_ = (packed & 1) != 0;
        this.delay_ = this.readShort() * 10;
        this.transIndex_ = this.read();
        this.read();
    }

    private void readHeader() {
        StringBuffer id = new StringBuffer();
        for (int i = 0; i < 6; ++i) {
            id.append((char)this.read());
        }
        if (!id.toString().startsWith("GIF")) {
            this.status_ = 1;
            return;
        }
        this.readLSD();
        if (this.gctFlag_ && !this.err()) {
            this.gct_ = this.readColorTable(this.gctSize_);
            this.bgColor_ = this.gct_[this.bgIndex_];
        }
    }

    private void readImage() {
        this.ix_ = this.readShort();
        this.iy_ = this.readShort();
        this.iw_ = this.readShort();
        this.ih_ = this.readShort();
        int packed = this.read();
        this.lctFlag_ = (packed & 0x80) != 0;
        this.interlace_ = (packed & 0x40) != 0;
        this.lctSize_ = 2 << (packed & 7);
        if (this.lctFlag_) {
            this.lct_ = this.readColorTable(this.lctSize_);
            this.act_ = this.lct_;
        } else {
            this.act_ = this.gct_;
            if (this.bgIndex_ == this.transIndex_) {
                this.bgColor_ = 0;
            }
        }
        int save = 0;
        if (this.transparency_) {
            save = this.act_[this.transIndex_];
            this.act_[this.transIndex_] = 0;
        }
        if (this.act_ == null) {
            this.status_ = 1;
        }
        if (this.err()) {
            return;
        }
        this.decodeImageData();
        this.skip();
        if (this.err()) {
            return;
        }
        ++this.frameCount_;
        this.image_ = new BufferedImage(this.width_, this.height_, 3);
        this.setPixels();
        this.frames_.add(new GifFrame(this.image_, this.delay_));
        if (this.transparency_) {
            this.act_[this.transIndex_] = save;
        }
        this.resetFrame();
    }

    private void readLSD() {
        this.width_ = this.readShort();
        this.height_ = this.readShort();
        int packed = this.read();
        this.gctFlag_ = (packed & 0x80) != 0;
        this.gctSize_ = 2 << (packed & 7);
        this.bgIndex_ = this.read();
        this.read();
    }

    private void readNetscapeExt() {
        do {
            this.readBlock();
        } while (this.blockSize_ > 0 && !this.err());
    }

    private int readShort() {
        return this.read() | this.read() << 8;
    }

    private void resetFrame() {
        this.lastDispose_ = this.dispose_;
        this.lastRect_ = new Rectangle(this.ix_, this.iy_, this.iw_, this.ih_);
        this.lastImage_ = this.image_;
        this.lastBgColor_ = this.bgColor_;
        this.dispose_ = 0;
        this.transparency_ = false;
        this.delay_ = 0;
        this.lct_ = null;
    }

    private void skip() {
        do {
            this.readBlock();
        } while (this.blockSize_ > 0 && !this.err());
    }

    private static class GifFrame {
        private final BufferedImage image_;
        private final int delay_;

        public GifFrame(BufferedImage im, int del) {
            this.image_ = im;
            this.delay_ = del;
        }
    }
}

