/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.DRAWITEMSTRUCT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class Label
extends Control {
    String text = "";
    Image image;
    static final int MARGIN = 4;
    static boolean IMAGE_AND_TEXT = false;
    static final long LabelProc;
    static final TCHAR LabelClass;

    public Label(Composite parent, int style) {
        super(parent, Label.checkStyle(style));
    }

    @Override
    long callWindowProc(long hwnd, int msg, long wParam, long lParam) {
        if (this.handle == 0L) {
            return 0L;
        }
        if (OS.WIN32_VERSION >= OS.VERSION(6, 1)) {
            switch (msg) {
                case 515: {
                    return OS.DefWindowProc(hwnd, msg, wParam, lParam);
                }
            }
        }
        return OS.CallWindowProc(LabelProc, hwnd, msg, wParam, lParam);
    }

    static int checkStyle(int style) {
        if (((style |= 0x80000) & 2) != 0) {
            style = Label.checkBits(style, 512, 256, 0, 0, 0, 0);
            return Label.checkBits(style, 8, 4, 32, 0, 0, 0);
        }
        return Label.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        boolean drawImage;
        this.checkWidget();
        int width = 0;
        int height = 0;
        int border = this.getBorderWidthInPixels();
        if ((this.style & 2) != 0) {
            int lineWidth = OS.GetSystemMetrics(5);
            if ((this.style & 0x100) != 0) {
                width = 64;
                height = lineWidth * 2;
            } else {
                width = lineWidth * 2;
                height = 64;
            }
            if (wHint != -1) {
                width = wHint;
            }
            if (hHint != -1) {
                height = hHint;
            }
            return new Point(width += border * 2, height += border * 2);
        }
        int bits = OS.GetWindowLong(this.handle, -16);
        boolean drawText = true;
        boolean bl = drawImage = (bits & 0xD) == 13;
        if (drawImage && this.image != null) {
            Rectangle rect = this.image.getBoundsInPixels();
            width += rect.width;
            height += rect.height;
            if (IMAGE_AND_TEXT) {
                if (this.text.length() != 0) {
                    width += 4;
                }
            } else {
                drawText = false;
            }
        }
        if (drawText) {
            long hDC = OS.GetDC(this.handle);
            long newFont = OS.SendMessage(this.handle, 49, 0L, 0L);
            long oldFont = OS.SelectObject(hDC, newFont);
            int length = OS.GetWindowTextLength(this.handle);
            if (length == 0) {
                TEXTMETRIC tm = new TEXTMETRIC();
                OS.GetTextMetrics(hDC, tm);
                height = Math.max(height, tm.tmHeight);
            } else {
                RECT rect = new RECT();
                int flags = 9280;
                if ((this.style & 0x40) != 0 && wHint != -1) {
                    flags |= 0x10;
                    rect.right = Math.max(0, wHint - width);
                }
                char[] buffer = new char[length + 1];
                OS.GetWindowText(this.handle, buffer, length + 1);
                OS.DrawText(hDC, buffer, length, rect, flags);
                width += rect.right - rect.left;
                height = Math.max(height, rect.bottom - rect.top);
            }
            if (newFont != 0L) {
                OS.SelectObject(hDC, oldFont);
            }
            OS.ReleaseDC(this.handle, hDC);
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width += border * 2, height += border * 2);
    }

    @Override
    void createHandle() {
        super.createHandle();
        this.state |= 0x100;
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return 0;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return "";
        }
        return this.text;
    }

    @Override
    boolean mnemonicHit(char key) {
        Control control = this;
        while (control.parent != null) {
            int index;
            Control[] children = control.parent._getChildren();
            for (index = 0; index < children.length && children[index] != control; ++index) {
            }
            if (++index < children.length && children[index].setFocus()) {
                return true;
            }
            control = control.parent;
        }
        return false;
    }

    @Override
    boolean mnemonicMatch(char key) {
        char mnemonic = this.findMnemonic(this.getText());
        if (mnemonic == '\u0000') {
            return false;
        }
        return Character.toUpperCase(key) == Character.toUpperCase(mnemonic);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.text = null;
        this.image = null;
    }

    @Override
    int resolveTextDirection() {
        return (this.style & 2) != 0 ? 0 : BidiUtil.resolveTextDirection(this.text);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        int bits = OS.GetWindowLong(this.handle, -16);
        if ((bits & 0xD) != 13) {
            bits &= 0xFFFFFFF0;
            if ((this.style & 0x4000) != 0) {
                bits = (this.style & 0x40) != 0 ? (bits |= 0) : (bits |= 0xC);
            }
            if ((this.style & 0x1000000) != 0) {
                bits |= 1;
            }
            if ((this.style & 0x20000) != 0) {
                bits |= 2;
            }
            OS.SetWindowLong(this.handle, -16, bits);
        }
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        int bits = OS.GetWindowLong(this.handle, -16);
        if ((bits & 0xD) != 13) {
            bits &= 0xFFFFFFF0;
            OS.SetWindowLong(this.handle, -16, bits |= 0xD);
        }
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        if (this.image == null || !IMAGE_AND_TEXT) {
            int oldBits;
            int newBits = oldBits = OS.GetWindowLong(this.handle, -16);
            newBits &= 0xFFFFFFF2;
            if ((this.style & 0x4000) != 0) {
                newBits = (this.style & 0x40) != 0 ? (newBits |= 0) : (newBits |= 0xC);
            }
            if ((this.style & 0x1000000) != 0) {
                newBits |= 1;
            }
            if ((this.style & 0x20000) != 0) {
                newBits |= 2;
            }
            if (oldBits != newBits) {
                OS.SetWindowLong(this.handle, -16, newBits);
            }
        }
        string = Display.withCrLf(string);
        TCHAR buffer = new TCHAR(this.getCodePage(), string, true);
        OS.SetWindowText(this.handle, buffer);
        if ((this.state & 0x400000) != 0) {
            this.updateTextDirection(0x6000000);
        }
    }

    @Override
    int widgetExtStyle() {
        int bits = super.widgetExtStyle() & 0xFFFFFDFF;
        if ((this.style & 0x800) != 0) {
            return bits | 0x20000;
        }
        return bits;
    }

    @Override
    int widgetStyle() {
        int bits = super.widgetStyle() | 0x100;
        if ((this.style & 2) != 0) {
            return bits | 0xD;
        }
        if ((this.style & 0x40) != 0) {
            bits |= 0x2000;
        }
        if ((this.style & 0x1000000) != 0) {
            return bits | 1;
        }
        if ((this.style & 0x20000) != 0) {
            return bits | 2;
        }
        if ((this.style & 0x40) != 0) {
            return bits | 0;
        }
        return bits | 0xC;
    }

    @Override
    TCHAR windowClass() {
        return LabelClass;
    }

    @Override
    long windowProc() {
        return LabelProc;
    }

    @Override
    LRESULT WM_ERASEBKGND(long wParam, long lParam) {
        LRESULT result = super.WM_ERASEBKGND(wParam, lParam);
        if (result != null) {
            return result;
        }
        int bits = OS.GetWindowLong(this.handle, -16);
        if ((bits & 0xD) == 13) {
            return LRESULT.ONE;
        }
        return result;
    }

    @Override
    LRESULT WM_SIZE(long wParam, long lParam) {
        LRESULT result = super.WM_SIZE(wParam, lParam);
        if (this.isDisposed()) {
            return result;
        }
        if ((this.style & 2) != 0) {
            OS.InvalidateRect(this.handle, null, true);
            return result;
        }
        int bits = OS.GetWindowLong(this.handle, -16);
        if ((bits & 0xD) == 13) {
            OS.InvalidateRect(this.handle, null, true);
            return result;
        }
        if ((bits & 0xC) != 12) {
            OS.InvalidateRect(this.handle, null, true);
            return result;
        }
        return result;
    }

    @Override
    LRESULT WM_UPDATEUISTATE(long wParam, long lParam) {
        boolean redraw;
        LRESULT result = super.WM_UPDATEUISTATE(wParam, lParam);
        if (result != null) {
            return result;
        }
        boolean bl = redraw = this.findImageControl() != null;
        if (!redraw && (this.state & 0x100) != 0 && OS.IsAppThemed()) {
            boolean bl2 = redraw = this.findThemeControl() != null;
        }
        if (redraw) {
            OS.InvalidateRect(this.handle, null, false);
            long code = OS.DefWindowProc(this.handle, 296, wParam, lParam);
            return new LRESULT(code);
        }
        return result;
    }

    @Override
    LRESULT wmDrawChild(long wParam, long lParam) {
        DRAWITEMSTRUCT struct = new DRAWITEMSTRUCT();
        OS.MoveMemory(struct, lParam, DRAWITEMSTRUCT.sizeof);
        this.drawBackground(struct.hDC);
        if ((this.style & 2) != 0) {
            int flags;
            if ((this.style & 0x20) != 0) {
                return null;
            }
            RECT rect = new RECT();
            int lineWidth = OS.GetSystemMetrics(5);
            int n = flags = (this.style & 4) != 0 ? 10 : 6;
            if ((this.style & 0x100) != 0) {
                int bottom = struct.top + Math.max(lineWidth * 2, (struct.bottom - struct.top) / 2);
                OS.SetRect(rect, struct.left, struct.top, struct.right, bottom);
                OS.DrawEdge(struct.hDC, rect, flags, 8);
            } else {
                int right = struct.left + Math.max(lineWidth * 2, (struct.right - struct.left) / 2);
                OS.SetRect(rect, struct.left, struct.top, right, struct.bottom);
                OS.DrawEdge(struct.hDC, rect, flags, 4);
            }
        } else {
            int width = struct.right - struct.left;
            int height = struct.bottom - struct.top;
            if (width != 0 && height != 0) {
                Object rect;
                boolean drawImage = this.image != null;
                boolean drawText = IMAGE_AND_TEXT && this.text.length() != 0;
                int margin = drawText && drawImage ? 4 : 0;
                int imageWidth = 0;
                int imageHeight = 0;
                if (drawImage) {
                    rect = this.image.getBoundsInPixels();
                    imageWidth = ((Rectangle)rect).width;
                    imageHeight = ((Rectangle)rect).height;
                }
                rect = null;
                char[] buffer = null;
                int textWidth = 0;
                int textHeight = 0;
                int flags = 0;
                if (drawText) {
                    rect = new RECT();
                    flags = 9280;
                    if ((this.style & 0x4000) != 0) {
                        flags |= 0;
                    }
                    if ((this.style & 0x1000000) != 0) {
                        flags |= 1;
                    }
                    if ((this.style & 0x20000) != 0) {
                        flags |= 2;
                    }
                    if ((this.style & 0x40) != 0) {
                        flags |= 0x10;
                        ((RECT)rect).right = Math.max(0, width - imageWidth - margin);
                    }
                    buffer = this.text.toCharArray();
                    OS.DrawText(struct.hDC, buffer, buffer.length, (RECT)rect, flags);
                    textWidth = ((RECT)rect).right - ((RECT)rect).left;
                    textHeight = ((RECT)rect).bottom - ((RECT)rect).top;
                }
                int x = 0;
                if ((this.style & 0x1000000) != 0) {
                    x = Math.max(0, (width - imageWidth - textWidth - margin) / 2);
                } else if ((this.style & 0x20000) != 0) {
                    x = width - imageWidth - textWidth - margin;
                }
                if (drawImage) {
                    GCData data = new GCData();
                    data.device = this.display;
                    GC gc = GC.win32_new(struct.hDC, data);
                    Image image = this.getEnabled() ? this.image : new Image((Device)this.display, this.image, 1);
                    gc.drawImage(image, DPIUtil.autoScaleDown(x), DPIUtil.autoScaleDown(Math.max(0, (height - imageHeight) / 2)));
                    if (image != this.image) {
                        image.dispose();
                    }
                    gc.dispose();
                    x += imageWidth + margin;
                }
                if (drawText) {
                    ((RECT)rect).left = x;
                    ((RECT)rect).right += ((RECT)rect).left;
                    ((RECT)rect).top = Math.max(0, (height - textHeight) / 2);
                    ((RECT)rect).bottom += ((RECT)rect).top;
                    OS.DrawText(struct.hDC, buffer, buffer.length, (RECT)rect, flags &= 0xFFFFFBFF);
                }
            }
        }
        return null;
    }

    static {
        LabelClass = new TCHAR(0, "STATIC", true);
        WNDCLASS lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0L, LabelClass, lpWndClass);
        LabelProc = lpWndClass.lpfnWndProc;
    }
}

