/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.connect;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import org.dbgl.gui.dialog.MainWindow;
import org.dbgl.service.ITextService;

public class Messaging
extends Thread {
    private final int port_;
    private final MainWindow mainWindow_;
    private final ITextService text_;
    private ServerSocket server_;
    private boolean cont_;

    public Messaging(int port, MainWindow mainWindow, ITextService text) {
        this.port_ = port;
        this.mainWindow_ = mainWindow;
        this.text_ = text;
    }

    public void close() {
        this.cont_ = false;
        try {
            if (this.server_ != null) {
                this.server_.close();
            }
        }
        catch (IOException e) {
            System.err.println(this.text_.get("communication.error.closesocket"));
        }
    }

    @Override
    public void run() {
        try {
            this.server_ = new ServerSocket(this.port_);
            this.cont_ = true;
            System.out.println(this.text_.get("communication.notice.listening", new Object[]{this.port_}));
        }
        catch (IOException e) {
            System.err.println(this.text_.get("communication.error.createsocket", new Object[]{this.port_}));
        }
        while (this.cont_) {
            try {
                Socket client = this.server_.accept();
                Throwable throwable = null;
                try {
                    String line = new BufferedReader(new InputStreamReader(client.getInputStream())).readLine();
                    System.out.print(this.text_.get("communication.notice.receivingmessage"));
                    System.out.println(' ' + line);
                    if (line == null || !line.startsWith("sendtoprofile ")) continue;
                    this.mainWindow_.addProfile(line.substring("sendtoprofile ".length()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (client == null) continue;
                    if (throwable != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    client.close();
                }
            }
            catch (IOException e) {
                if (!this.cont_) continue;
                System.err.println(this.text_.get("communication.error.io"));
            }
        }
    }
}

