/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.abstractdialog;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.dbgl.exception.DrivelettersExhaustedException;
import org.dbgl.gui.abstractdialog.SizeControlledTabbedDialog;
import org.dbgl.gui.controls.Button_;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Combo_;
import org.dbgl.gui.controls.Composite_;
import org.dbgl.gui.controls.DaControl;
import org.dbgl.gui.controls.DaControlConvertorAdapter;
import org.dbgl.gui.controls.Group_;
import org.dbgl.gui.controls.Label_;
import org.dbgl.gui.controls.List_;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.gui.controls.MetaControl;
import org.dbgl.gui.controls.Spinner_;
import org.dbgl.gui.controls.Text_;
import org.dbgl.gui.dialog.EditMixerDialog;
import org.dbgl.gui.dialog.EditMountDialog;
import org.dbgl.gui.dialog.EditNativeCommandDialog;
import org.dbgl.gui.interfaces.DaControlConvertor;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.conf.Autoexec;
import org.dbgl.model.conf.Configuration;
import org.dbgl.model.conf.GenerationAwareConfiguration;
import org.dbgl.model.entity.TemplateProfileBase;
import org.dbgl.model.helper.DriveLetterHelper;
import org.dbgl.model.repository.DosboxVersionRepository;
import org.dbgl.service.FileLocationService;
import org.eclipse.swt.events.ExpandAdapter;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;

public abstract class EditConfigurableDialog<T>
extends SizeControlledTabbedDialog<T> {
    protected final List<DaControl> daControls_ = new ArrayList<DaControl>();
    protected final List<MetaControl> metaControls_ = new ArrayList<MetaControl>();
    protected final List<MetaControl> autoexecControls_ = new ArrayList<MetaControl>();
    protected List<DosboxVersion> dbversionsList_;
    protected int dbversionIndex_;
    protected Combo dbversionCombo_;
    protected Button setButton_;
    protected ExpandItem booterExpandItem_;
    protected ExpandItem dosExpandItem_;
    protected org.eclipse.swt.widgets.List mountingpointsList_;
    private Button switchButton_;
    private Button ipx_;
    private Text ipxNet_;
    private Combo output_;
    private Combo scaler_;
    private Combo machine_;
    private Combo cpuType_;
    private Combo midiDevice_;
    private Combo sbType_;
    private Combo oplMode_;
    private org.eclipse.swt.widgets.List nativeCommandsList_;

    public EditConfigurableDialog(Shell parent, String dialogName) {
        super(parent, dialogName);
    }

    protected abstract void doPerformDosboxConfAction(DosboxConfAction var1, DosboxVersion var2);

    @Override
    protected boolean prepare() {
        try {
            this.dbversionsList_ = new DosboxVersionRepository().listAll();
            this.dbversionIndex_ = DosboxVersionRepository.indexOfDefault(this.dbversionsList_);
            return true;
        }
        catch (SQLException e) {
            Mess_.on(this.getParent()).exception(e).warning();
            return false;
        }
    }

    protected void updateControlsByConfigurable(TemplateProfileBase configurable, boolean multiEdit) {
        Object[] machineValues;
        GenerationAwareConfiguration overrideConf = configurable.getConfiguration();
        Autoexec overrideAuto = overrideConf.getAutoexec();
        Configuration combinedConf = configurable.getCombinedConfiguration();
        Autoexec combinedAuto = combinedConf.getAutoexec();
        DosboxVersion dosbox = configurable.getDosboxVersion();
        GenerationAwareConfiguration dosboxConf = dosbox.getConfiguration();
        this.daControls_.forEach(x -> x.enableOrDisable(dosbox));
        Object[] objectArray = machineValues = dosbox.isUsingNewMachineConfig() ? this.settings_.getValues("profile", "machine073") : this.settings_.getValues("profile", "machine");
        if (!Arrays.equals(this.machine_.getItems(), machineValues)) {
            this.machine_.setItems((String[])machineValues);
        }
        this.updateComboItems(this.output_, dosbox.likelyDirect3DSupport(), new String[]{"openglhq", "direct3d"});
        this.updateComboItems(this.scaler_, dosbox.likelyHardwareScalerSupport(), new String[]{"hardware2x", "hardware3x"});
        this.updateComboItems(this.machine_, dosbox.likelyAmstradSupport(), new String[]{"cga_mono", "svga_s3_full", "amstrad"});
        this.updateComboItems(this.cpuType_, dosbox.likelyAdditionalCPUTypesSupport(), new String[]{"486", "pentium", "pentium_mmx"});
        this.updateComboItems(this.midiDevice_, dosbox.hasMT32Support(), new String[]{"mt32", "synth", "timidity"});
        this.updateComboItems(this.sbType_, dosbox.likelySoundBlaster16VibraSupport(), new String[]{"sb16vibra"});
        this.updateComboItems(this.oplMode_, dosbox.hasHardwareOPLSupport(), new String[]{"hardware", "hardwaregb"});
        this.daControls_.forEach(x -> x.setControlByConf(dosboxConf, overrideConf, combinedConf, multiEdit));
        DaControl.setFieldIfEnabled(this.mountingpointsList_, configurable.getMountStringsForUI());
        DaControl.setFieldIfEnabled(this.dosExpandItem_, !combinedAuto.isBooter());
        DaControl.setFieldIfEnabled(this.booterExpandItem_, combinedAuto.isBooter());
        this.autoexecControls_.forEach(x -> x.setControlByAutoexec(overrideAuto, combinedAuto, multiEdit));
        this.setButton_.setEnabled(false);
        this.switchButton_.setEnabled(false);
        this.ipxNet_.setEnabled(this.ipx_.getSelection());
        this.updateNativeCommands(-1, configurable);
    }

    protected void updateConfigurableByControls(TemplateProfileBase configurable) {
        this.daControls_.forEach(x -> x.updateConfigurationByControl(configurable));
        this.autoexecControls_.forEach(x -> x.updateAutoexecByControl(configurable.getConfiguration().getAutoexec()));
        configurable.setBooter(this.booterExpandItem_.getExpanded());
    }

    protected void updateComboItems(Combo combo, boolean available, String[] items) {
        ArrayList<String> comboItems = new ArrayList<String>(Arrays.asList(combo.getItems()));
        boolean changes = false;
        if (available) {
            for (String s : items) {
                if (comboItems.contains(s)) continue;
                comboItems.add(s);
                changes = true;
            }
        } else {
            for (String s : items) {
                if (!comboItems.contains(s)) continue;
                comboItems.remove(s);
                changes = true;
            }
        }
        if (changes) {
            combo.setItems(comboItems.toArray(new String[comboItems.size()]));
        }
    }

    protected Group createGeneralTab(String capturesText, String configFileText) {
        Composite composite = this.createTabWithComposite("dialog.template.tab.general", (Layout)new GridLayout());
        Group associationGroup = Group_.on(composite).layout((Layout)new GridLayout(5, false)).key("dialog.template.association").build();
        associationGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.dbversionCombo_ = Chain.on((Composite)associationGroup).lbl(l -> l.key("dialog.template.dosboxversion")).cmb(c -> c.wide().items((String[])this.dbversionsList_.stream().map(x -> x.getTitle()).toArray(String[]::new)).select(this.dbversionIndex_).visibleItemCount(20)).combo();
        this.setButton_ = Button_.on((Composite)associationGroup).text().key("dialog.template.set").tooltip("dialog.template.set.tooltip").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.this.doPerformDosboxConfAction(DosboxConfAction.SET, EditConfigurableDialog.this.dbversionsList_.get(EditConfigurableDialog.this.dbversionCombo_.getSelectionIndex()));
            }
        }).ctrl();
        this.switchButton_ = Button_.on((Composite)associationGroup).text().key("dialog.template.switch").tooltip("dialog.template.switch.tooltip").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.this.doPerformDosboxConfAction(DosboxConfAction.SWITCH, EditConfigurableDialog.this.dbversionsList_.get(EditConfigurableDialog.this.dbversionCombo_.getSelectionIndex()));
            }
        }).ctrl();
        Button_.on((Composite)associationGroup).text().key("dialog.template.reloadsettings").tooltip("dialog.template.reloadsettings.tooltip").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.this.doPerformDosboxConfAction(DosboxConfAction.RELOAD, EditConfigurableDialog.this.dbversionsList_.get(EditConfigurableDialog.this.dbversionCombo_.getSelectionIndex()));
            }
        }).ctrl();
        this.dbversionCombo_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.this.setButton_.setEnabled(true);
                EditConfigurableDialog.this.switchButton_.setEnabled(true);
            }
        });
        Group miscGroup = Group_.on(composite).layout((Layout)new GridLayout(3, false)).key("dialog.template.miscellaneous").build();
        miscGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Chain.on((Composite)miscGroup).lbl(l -> l).lbl(l -> l.key("dialog.template.active")).lbl(l -> l.key("dialog.template.inactive")).build();
        Chain.on((Composite)miscGroup).lbl(l -> l.key("dialog.template.priority")).cmb(c -> c.tooltip("dialog.template.priority.tooltip").items(this.settings_.getValues("profile", "priority_active"))).cmb(c -> c.tooltip("dialog.template.priority.tooltip").items(this.settings_.getValues("profile", "priority_inactive"))).da(this.daControls_).section("sdl").item("priority").build();
        Chain.on((Composite)miscGroup).lbl(l -> l.key("dialog.template.waitonerror")).but(b -> (Button_.Builder)b.horSpan(2)).da(this.daControls_).section("sdl").item("waitonerror").build();
        Chain.on((Composite)miscGroup).lbl(l -> l.key("dialog.template.exitafterwards")).but(b -> (Button_.Builder)b.horSpan(2)).meta(this.autoexecControls_).autoexec(Autoexec::getExit, Autoexec::setExit).build();
        Chain.on((Composite)miscGroup).lbl(l -> l.key("dialog.template.languagefile")).txt(t -> ((Text_.Builder)t.horSpan(2)).tooltip("dialog.template.languagefile.tooltip")).da(this.daControls_).section("dosbox").item("language").build();
        Chain.on((Composite)miscGroup).lbl(l -> l.key("dialog.template.captures")).txt(t -> ((Text_.Builder)t.horSpan(2)).tooltip("dialog.template.captures.tooltip").val(capturesText).nonEditable()).build();
        Chain.on((Composite)miscGroup).lbl(l -> l.key("dialog.profile.configfile")).txt(t -> ((Text_.Builder)t.horSpan(2)).val(configFileText).nonEditable()).build();
        return associationGroup;
    }

    protected void createDisplayTab() {
        TabFolder subTabFolder = this.createSubTabs("dialog.template.tab.display", 1, 2);
        Composite releaseComposite = (Composite)subTabFolder.getChildren()[0];
        Composite experimentalComposite = (Composite)subTabFolder.getChildren()[1];
        Group groupRelease = Group_.on(releaseComposite).layout((Layout)new GridLayout(4, false)).key("dialog.template.general").build();
        groupRelease.setLayoutData((Object)new GridData(1, 1, false, false));
        this.output_ = Chain.on((Composite)groupRelease).lbl(l -> l.key("dialog.template.output")).cmb(c -> ((Combo_.Builder)c.horSpan(3)).tooltip("dialog.template.output.tooltip").items(this.settings_.getValues("profile", "output"))).da(this.daControls_).section("sdl").item("output").combo();
        Chain.on((Composite)groupRelease).lbl(l -> l.key("dialog.template.frameskip")).cmb(c -> ((Combo_.Builder)c.horSpan(3)).tooltip("dialog.template.frameskip.tooltip").items(this.settings_.getValues("profile", "frameskip")).visibleItemCount(15)).da(this.daControls_).section("render").item("frameskip").build();
        this.scaler_ = Chain.on((Composite)groupRelease).lbl(l -> l.key("dialog.template.scaler")).cmb(c -> c.tooltip("dialog.template.scaler.tooltip").items(this.settings_.getValues("profile", "scaler")).visibleItemCount(15)).lbl(l -> l.key("dialog.template.scalerforced")).but(b -> b.tooltip("dialog.template.scalerforced.tooltip")).da(this.daControls_).section("render").item("scaler").convert(new DaControlConvertorAdapter(){

            @Override
            public String toConfValue(String[] values) {
                String result = values[0];
                if (Boolean.valueOf(values[1]).booleanValue()) {
                    result = result + " forced";
                }
                return result;
            }

            @Override
            public String[] toControlValues(String value) {
                if (value == null) {
                    return new String[0];
                }
                String[] results = new String[2];
                if (value.endsWith("forced")) {
                    results[0] = value.substring(0, value.length() - 7);
                    results[1] = "true";
                } else {
                    results[0] = value;
                    results[1] = "false";
                }
                return results;
            }
        }).combo();
        Chain.on((Composite)groupRelease).lbl(l -> l.key("dialog.template.fullscreenresolution")).cmb(c -> ((Combo_.Builder)c.horSpan(3)).tooltip("dialog.template.fullscreenresolution.tooltip").items(this.settings_.getValues("profile", "fullresolution"))).da(this.daControls_).section("sdl").item("fullresolution").build();
        Chain.on((Composite)groupRelease).lbl(l -> l.key("dialog.template.windowresolution")).cmb(c -> ((Combo_.Builder)c.horSpan(3)).tooltip("dialog.template.windowresolution.tooltip").items(this.settings_.getValues("profile", "windowresolution"))).da(this.daControls_).section("sdl").item("windowresolution").build();
        Chain.on((Composite)groupRelease).lbl(l -> l.key("dialog.template.fullscreen")).but(b -> ((Button_.Builder)b.horSpan(3)).tooltip("dialog.template.fullscreen.tooltip")).da(this.daControls_).section("sdl").item("fullscreen").build();
        Chain.on((Composite)groupRelease).lbl(l -> l.key("dialog.template.doublebuffering")).but(b -> ((Button_.Builder)b.horSpan(3)).tooltip("dialog.template.doublebuffering.tooltip")).da(this.daControls_).section("sdl").item("fulldouble").build();
        Chain.on((Composite)groupRelease).lbl(l -> l.key("dialog.template.aspectcorrection")).but(b -> ((Button_.Builder)b.horSpan(3)).tooltip("dialog.template.aspectcorrection.tooltip")).da(this.daControls_).section("render").item("aspect").build();
        Group groupExpGeneral = Group_.on(experimentalComposite).layout((Layout)new GridLayout(3, false)).key("dialog.template.general").build();
        groupExpGeneral.setLayoutData((Object)new GridData(4, 1, true, false, 1, 3));
        Object[] glShaderFiles = FileLocationService.getInstance().listGlShaderFilenames();
        String[] glShaders = glShaderFiles != null && glShaderFiles.length > 0 ? (String[])ArrayUtils.addAll((Object[])this.settings_.getValues("profile", "glshader"), (Object[])glShaderFiles) : this.settings_.getValues("profile", "glshader");
        Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.glshader")).cmb(c -> c.editable().wide().items(glShaders)).but(b -> b.browse(true, Button_.BrowseType.FILE, Button_.CanonicalType.GLSHADER, false)).da(this.daControls_).section("render").item("glshader").build();
        Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.autofit")).but(b -> (Button_.Builder)b.horSpan(2)).da(this.daControls_).section("render").item("autofit").build();
        Combo pixelshader = Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.pixelshader")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).visibleItemCount(20)).da(this.daControls_).section("sdl").item("pixelshader").combo();
        String[] shaders = FileLocationService.getInstance().listShaderFilenames();
        if (shaders != null && shaders.length > 0) {
            pixelshader.setItems(shaders);
            pixelshader.add("none", 0);
        } else {
            pixelshader.setItems(this.settings_.getValues("profile", "pixelshader"));
        }
        Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.linewise")).but(b -> (Button_.Builder)b.horSpan(2)).da(this.daControls_).section("render").item("linewise").build();
        Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.char9")).but(b -> (Button_.Builder)b.horSpan(2)).da(this.daControls_).section("render").item("char9").build();
        Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.multiscan")).but(b -> (Button_.Builder)b.horSpan(2)).da(this.daControls_).section("render").item("multiscan").build();
        Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.cgasnow")).but(b -> (Button_.Builder)b.horSpan(2)).da(this.daControls_).section("cpu").item("cgasnow").build();
        Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.overscan")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).editable().items(this.settings_.getValues("profile", "overscan"))).da(this.daControls_).section("sdl").item("overscan").build();
        Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.vsyncmode")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).items(this.settings_.getValues("profile", "vsyncmode"))).da(this.daControls_).section("vsync").item("vsyncmode").build();
        Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.vsyncrate")).txt(t -> (Text_.Builder)t.horSpan(2)).da(this.daControls_).section("vsync").item("vsyncrate").build();
        Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.forcerate")).txt(t -> (Text_.Builder)t.horSpan(2)).da(this.daControls_).section("cpu").item("forcerate").build();
        Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.videoram")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).items(this.settings_.getValues("profile", "vmemsize"))).da(this.daControls_).section("dosbox").item("vmemsize").build();
        Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.fullborderless")).but(b -> ((Button_.Builder)b.horSpan(2)).tooltip("dialog.template.fullborderless.tooltip")).da(this.daControls_).section("sdl").item("fullborderless").build();
        Chain.on((Composite)groupExpGeneral).lbl(l -> l.key("dialog.template.glfullvsync")).but(b -> ((Button_.Builder)b.horSpan(2)).tooltip("dialog.template.glfullvsync.tooltip")).da(this.daControls_).section("sdl").item("glfullvsync").build();
        Group groupExpGlide = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.glide").build();
        Chain.on((Composite)groupExpGlide).lbl(l -> l.key("dialog.template.glide")).cmb(c -> c.items(this.settings_.getValues("profile", "glide"))).da(this.daControls_).section("glide").item("glide").build();
        Chain.on((Composite)groupExpGlide).lbl(l -> l.key("dialog.template.glideport")).txt(t -> t).da(this.daControls_).section("glide").item("port", "grport").build();
        Chain.on((Composite)groupExpGlide).lbl(l -> l.key("dialog.template.lfbglide")).cmb(c -> c.items(this.settings_.getValues("profile", "lfbglide"))).da(this.daControls_).section("glide").item("lfb").build();
        Chain.on((Composite)groupExpGlide).lbl(l -> l.key("dialog.template.splash3dfx")).but(b -> b).da(this.daControls_).section("glide").item("splash").build();
        Group groupExpVoodoo = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.voodoo").build();
        Chain.on((Composite)groupExpVoodoo).lbl(l -> l.key("dialog.template.voodoo")).cmb(c -> c.items(this.settings_.getValues("profile", "voodoo"))).da(this.daControls_).section("pci").item("voodoo").build();
        Chain.on((Composite)groupExpVoodoo).lbl(l -> l.key("dialog.template.voodoomem")).cmb(c -> c.items(this.settings_.getValues("profile", "voodoomem"))).da(this.daControls_).section("pci").item("voodoomem").build();
        Group groupExpPPScaling = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.pixelperfectscaling").build();
        Chain.on((Composite)groupExpPPScaling).lbl(l -> l.key("dialog.template.surfacenpsharpness")).spn(s -> s.min(0).max(100)).da(this.daControls_).section("sdl").item("surfacenp-sharpness").build();
    }

    protected Group createMachineTab() {
        TabFolder subTabFolder = this.createSubTabs("dialog.template.tab.machine", 1, 1);
        Composite releaseComposite = (Composite)subTabFolder.getChildren()[0];
        Composite experimentalComposite = (Composite)subTabFolder.getChildren()[1];
        Group cpuGroup = Group_.on(releaseComposite).layout((Layout)new GridLayout(6, false)).key("dialog.template.cpu").build();
        this.machine_ = Chain.on((Composite)cpuGroup).lbl(l -> l.key("dialog.template.machine")).cmb(c -> c.tooltip("dialog.template.machine.tooltip").items(new String[0]).visibleItemCount(20)).da(this.daControls_).section("dosbox").item("machine").combo();
        this.cpuType_ = Chain.on((Composite)cpuGroup).lbl(l -> l.key("dialog.template.cputype")).cmb(c -> ((Combo_.Builder)c.horSpan(3)).tooltip("dialog.template.cputype.tooltip").items(this.settings_.getValues("profile", "cputype"))).da(this.daControls_).section("cpu").item("cputype").combo();
        Chain.on((Composite)cpuGroup).lbl(l -> l.key("dialog.template.core")).cmb(c -> ((Combo_.Builder)c.horSpan(5)).tooltip("dialog.template.core.tooltip").items(this.settings_.getValues("profile", "core"))).da(this.daControls_).section("cpu").item("core").build();
        Chain.on((Composite)cpuGroup).lbl(l -> l.key("dialog.template.cycles")).cmb(c -> c.editable().tooltip("dialog.template.cycles.tooltip").items(this.settings_.getValues("profile", "cycles")).visibleItemCount(15)).da(this.daControls_).section("cpu").item("cycles").build();
        Chain.on((Composite)cpuGroup).lbl(l -> l.key("dialog.template.up")).cmb(c -> c.editable().tooltip("dialog.template.up.tooltip").items(this.settings_.getValues("profile", "cycles_up"))).da(this.daControls_).section("cpu").item("cycleup").build();
        Chain.on((Composite)cpuGroup).lbl(l -> l.key("dialog.template.down")).cmb(c -> c.editable().tooltip("dialog.template.down.tooltip").items(this.settings_.getValues("profile", "cycles_down"))).da(this.daControls_).section("cpu").item("cycledown").build();
        Group memoryGroup = Group_.on(releaseComposite).layout((Layout)new GridLayout(4, false)).key("dialog.template.memory").build();
        Chain.on((Composite)memoryGroup).lbl(l -> l.key("dialog.template.memorysize")).cmb(c -> ((Combo_.Builder)c.horSpan(3)).tooltip("dialog.template.memorysize.tooltip").items(this.settings_.getValues("profile", "memsize"))).da(this.daControls_).section("dosbox").item("memsize").build();
        Chain.on((Composite)memoryGroup).lbl(l -> l.key("dialog.template.xms")).but(b -> ((Button_.Builder)b.horSpan(3)).tooltip("dialog.template.xms.tooltip")).da(this.daControls_).section("dos").item("xms").build();
        Chain.on((Composite)memoryGroup).lbl(l -> l.key("dialog.template.ems")).cmb(c -> ((Combo_.Builder)c.horSpan(3)).tooltip("dialog.template.ems.tooltip").items(this.settings_.getValues("profile", "ems"))).da(this.daControls_).section("dos").item("ems").build();
        Chain.on((Composite)memoryGroup).lbl(l -> l.key("dialog.template.umb")).cmb(c -> ((Combo_.Builder)c.horSpan(3)).tooltip("dialog.template.umb.tooltip").items(this.settings_.getValues("profile", "umb"))).da(this.daControls_).section("dos").item("umb").build();
        Group expMemoryGroup = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.memory").build();
        Chain.on((Composite)expMemoryGroup).lbl(l -> l.key("dialog.template.memorysizekb")).txt(t -> t).da(this.daControls_).section("dosbox").item("memsizekb").build();
        Chain.on((Composite)expMemoryGroup).lbl(l -> l.key("dialog.template.memalias")).cmb(c -> c.editable().items(this.settings_.getValues("profile", "memalias"))).da(this.daControls_).section("dosbox").item("memalias").build();
        return memoryGroup;
    }

    protected void createAudioTab() {
        TabFolder subTabFolder = this.createSubTabs("dialog.template.tab.audio", 3, 3);
        Composite releaseComposite = (Composite)subTabFolder.getChildren()[0];
        Composite experimentalComposite = (Composite)subTabFolder.getChildren()[1];
        Group generalGroup = Group_.on(releaseComposite).layout((Layout)new GridLayout(3, false)).key("dialog.template.general").build();
        generalGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Chain.on((Composite)generalGroup).lbl(l -> l.key("dialog.template.silentmode")).but(b -> ((Button_.Builder)b.horSpan(2)).tooltip("dialog.template.silentmode.tooltip")).da(this.daControls_).section("mixer").item("nosound").build();
        Chain.on((Composite)generalGroup).lbl(l -> l.key("dialog.template.samplerate")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).tooltip("dialog.template.samplerate.tooltip").items(this.settings_.getValues("profile", "rate"))).da(this.daControls_).section("mixer").item("rate").build();
        Chain.on((Composite)generalGroup).lbl(l -> l.key("dialog.template.blocksize")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).tooltip("dialog.template.blocksize.tooltip").items(this.settings_.getValues("profile", "blocksize"))).da(this.daControls_).section("mixer").item("blocksize").build();
        Chain.on((Composite)generalGroup).lbl(l -> l.key("dialog.template.prebuffer")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).editable().tooltip("dialog.template.prebuffer.tooltip").items(this.settings_.getValues("profile", "prebuffer"))).da(this.daControls_).section("mixer").item("prebuffer").build();
        Chain.on((Composite)generalGroup).lbl(l -> l.key("dialog.template.mpu401")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).tooltip("dialog.template.mpu401.tooltip").items(this.settings_.getValues("profile", "mpu401"))).da(this.daControls_).section("midi", "midi").item("intelligent", "mpu401").convert(new DaControlConvertorAdapter(){

            @Override
            public String toConfValue(String[] values) {
                return values[0];
            }

            @Override
            public String[] toControlValues(String value) {
                if (value == null) {
                    return new String[0];
                }
                return new String[]{value};
            }

            @Override
            public String[] toConfValues(String[] values) {
                String[] result = new String[]{String.valueOf(!values[0].equalsIgnoreCase("none")), String.valueOf(!values[0].equalsIgnoreCase("uart"))};
                return result;
            }

            @Override
            public String[] toControlValues(String[] values) {
                boolean intelligent = Boolean.valueOf(values[0]);
                boolean mpu = Boolean.valueOf(values[1]);
                String[] stringArray = new String[1];
                stringArray[0] = mpu ? (intelligent ? "intelligent" : "uart") : "none";
                return stringArray;
            }
        }).build();
        this.midiDevice_ = Chain.on((Composite)generalGroup).lbl(l -> l.key("dialog.template.mididevice")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).tooltip("dialog.template.mididevice.tooltip").items(this.settings_.getValues("profile", "device"))).da(this.daControls_).section("midi").item("device", "mididevice").combo();
        Chain.on((Composite)generalGroup).lbl(l -> l.key("dialog.template.midiconfig")).txt(t -> ((Text_.Builder)t.horSpan(2)).tooltip("dialog.template.midiconfig.tooltip")).da(this.daControls_).section("midi").item("config", "midiconfig").build();
        final Chain chnMixer = Chain.on((Composite)generalGroup).lbl(l -> l.key("dialog.template.mixercommand")).txt(t -> t).meta(this.autoexecControls_).autoexec(Autoexec::getMixer, Autoexec::setMixer).but(b -> b.threedots()).build();
        chnMixer.getButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String command = (String)new EditMixerDialog(EditConfigurableDialog.this.shell_, chnMixer.getText().getText()).open();
                if (command != null) {
                    chnMixer.getText().setText(command);
                }
            }
        });
        Group soundblasterGroup = Group_.on(releaseComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.soundblaster").build();
        this.sbType_ = Chain.on((Composite)soundblasterGroup).lbl(l -> l.key("dialog.template.sbtype")).cmb(c -> c.tooltip("dialog.template.sbtype.tooltip").items(this.settings_.getValues("profile", "sbtype"))).da(this.daControls_).section("sblaster").item("type", "sbtype").combo();
        Chain.on((Composite)soundblasterGroup).lbl(l -> l.key("dialog.template.sboplrate")).cmb(c -> c.tooltip("dialog.template.sboplrate.tooltip").items(this.settings_.getValues("profile", "oplrate"))).da(this.daControls_).section("sblaster").item("oplrate").build();
        this.oplMode_ = Chain.on((Composite)soundblasterGroup).lbl(l -> l.key("dialog.template.sboplmode")).cmb(c -> c.tooltip("dialog.template.sboplmode.tooltip").items(this.settings_.getValues("profile", "oplmode"))).da(this.daControls_).section("sblaster").item("oplmode").combo();
        Chain.on((Composite)soundblasterGroup).lbl(l -> l.key("dialog.template.sboplemu")).cmb(c -> c.tooltip("dialog.template.sboplemu.tooltip").items(this.settings_.getValues("profile", "oplemu"))).da(this.daControls_).section("sblaster").item("oplemu").build();
        Chain.on((Composite)soundblasterGroup).lbl(l -> l.key("dialog.template.sbaddress")).cmb(c -> c.tooltip("dialog.template.sbaddress.tooltip").items(this.settings_.getValues("profile", "sbbase"))).da(this.daControls_).section("sblaster").item("base", "sbbase").combo();
        Chain.on((Composite)soundblasterGroup).lbl(l -> l.key("dialog.template.sbirq")).cmb(c -> c.tooltip("dialog.template.sbirq.tooltip").items(this.settings_.getValues("profile", "irq"))).da(this.daControls_).section("sblaster").item("irq").build();
        Chain.on((Composite)soundblasterGroup).lbl(l -> l.key("dialog.template.sbdma")).cmb(c -> c.tooltip("dialog.template.sbdma.tooltip").items(this.settings_.getValues("profile", "dma"))).da(this.daControls_).section("sblaster").item("dma").build();
        Chain.on((Composite)soundblasterGroup).lbl(l -> l.key("dialog.template.sbhdma")).cmb(c -> c.tooltip("dialog.template.sbhdma.tooltip").items(this.settings_.getValues("profile", "hdma"))).da(this.daControls_).section("sblaster").item("hdma").build();
        Chain.on((Composite)soundblasterGroup).lbl(l -> l.key("dialog.template.mixer")).but(b -> b.tooltip("dialog.template.mixer.tooltip")).da(this.daControls_).section("sblaster").item("mixer", "sbmixer").build();
        Group gusGroup = Group_.on(releaseComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.gravisultrasound").build();
        gusGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Chain.on((Composite)gusGroup).lbl(l -> l.key("dialog.template.enablegus")).but(b -> b.tooltip("dialog.template.enablegus.tooltip")).da(this.daControls_).section("gus").item("gus").build();
        Chain.on((Composite)gusGroup).lbl(l -> l.key("dialog.template.gusrate")).cmb(c -> c.tooltip("dialog.template.gusrate.tooltip").items(this.settings_.getValues("profile", "gusrate"))).da(this.daControls_).section("gus").item("rate", "gusrate").combo();
        Chain.on((Composite)gusGroup).lbl(l -> l.key("dialog.template.gusaddress")).cmb(c -> c.tooltip("dialog.template.gusaddress.tooltip").items(this.settings_.getValues("profile", "gusbase"))).da(this.daControls_).section("gus").item("base", "gusbase").combo();
        Chain.on((Composite)gusGroup).lbl(l -> l.key("dialog.template.gusirq1")).cmb(c -> c.tooltip("dialog.template.gusirq1.tooltip").items(this.settings_.getValues("profile", "irq1"))).da(this.daControls_).section("gus").item("irq1", "gusirq").combo();
        Chain.on((Composite)gusGroup).lbl(l -> l.key("dialog.template.gusirq2")).cmb(c -> c.tooltip("dialog.template.gusirq1.tooltip").items(this.settings_.getValues("profile", "irq2"))).da(this.daControls_).section("gus").item("irq2").build();
        Chain.on((Composite)gusGroup).lbl(l -> l.key("dialog.template.gusdma1")).cmb(c -> c.tooltip("dialog.template.gusdma1.tooltip").items(this.settings_.getValues("profile", "dma1"))).da(this.daControls_).section("gus").item("dma1", "gusdma").combo();
        Chain.on((Composite)gusGroup).lbl(l -> l.key("dialog.template.gusdma2")).cmb(c -> c.tooltip("dialog.template.gusdma1.tooltip").items(this.settings_.getValues("profile", "dma2"))).da(this.daControls_).section("gus").item("dma2").build();
        Chain.on((Composite)gusGroup).lbl(l -> l.key("dialog.template.ultradir")).txt(t -> t.tooltip("dialog.template.ultradir.tooltip")).da(this.daControls_).section("gus").item("ultradir").text();
        Group speakerGroup = Group_.on(releaseComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.pcspeaker").build();
        speakerGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Chain.on((Composite)speakerGroup).lbl(l -> l.key("dialog.template.enablepcspeaker")).but(b -> b.tooltip("dialog.template.enablepcspeaker.tooltip")).da(this.daControls_).section("speaker").item("pcspeaker").build();
        Chain.on((Composite)speakerGroup).lbl(l -> l.key("dialog.template.pcrate")).cmb(c -> c.tooltip("dialog.template.pcrate.tooltip").items(this.settings_.getValues("profile", "pcrate"))).da(this.daControls_).section("speaker").item("pcrate").build();
        Group tandyGroup = Group_.on(releaseComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.tandy").build();
        tandyGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        Chain.on((Composite)tandyGroup).lbl(l -> l.key("dialog.template.enabletandy")).cmb(c -> c.tooltip("dialog.template.enabletandy.tooltip").items(this.settings_.getValues("profile", "tandy"))).da(this.daControls_).section("speaker").item("tandy").build();
        Chain.on((Composite)tandyGroup).lbl(l -> l.key("dialog.template.tandyrate")).cmb(c -> c.tooltip("dialog.template.tandyrate.tooltip").items(this.settings_.getValues("profile", "tandyrate"))).da(this.daControls_).section("speaker").item("tandyrate").build();
        Group disneyGroup = Group_.on(releaseComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.miscellaneous").build();
        disneyGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Chain.on((Composite)disneyGroup).lbl(l -> l.key("dialog.template.enablesoundsource")).but(b -> b.tooltip("dialog.template.enablesoundsource.tooltip")).da(this.daControls_).section("speaker").item("disney").build();
        Group generalExpGroup = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.general").build();
        generalExpGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Chain.on((Composite)generalExpGroup).lbl(l -> l.key("dialog.template.swapstereo")).but(b -> b).da(this.daControls_).section("mixer").item("swapstereo").build();
        Group soundblasterExpGroup = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.soundblaster").build();
        soundblasterExpGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        Chain.on((Composite)soundblasterExpGroup).lbl(l -> l.key("dialog.template.hardwaresbaddress")).cmb(c -> c.items(this.settings_.getValues("profile", "hardwaresbbase"))).da(this.daControls_).section("sblaster").item("hardwarebase").build();
        Chain.on((Composite)soundblasterExpGroup).lbl(l -> l.key("dialog.template.goldplay")).but(b -> b).da(this.daControls_).section("sblaster").item("goldplay").build();
        Chain.on((Composite)soundblasterExpGroup).lbl(l -> l.key("dialog.template.fmstrength")).spn(s -> s.min(1).max(1000)).da(this.daControls_).section("sblaster").item("fmstrength").build();
        Group mt32ExpGroup = Group_.on(experimentalComposite).layout((Layout)new GridLayout(3, false)).key("dialog.template.mt32").build();
        mt32ExpGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 3));
        Chain.on((Composite)mt32ExpGroup).lbl(l -> l.key("dialog.template.mt32.romdir")).txt(t -> t).but(b -> b.browse(true, Button_.BrowseType.DIR, Button_.CanonicalType.NONE, false)).da(this.daControls_).section("midi").item("mt32.romdir").build();
        Chain.on((Composite)mt32ExpGroup).lbl(l -> l.key("dialog.template.swapstereo")).but(b -> (Button_.Builder)b.horSpan(2)).da(this.daControls_).section("midi").item("mt32.reverse.stereo").build();
        Chain.on((Composite)mt32ExpGroup).lbl(l -> l.key("dialog.template.mt32.verboselogging")).but(b -> (Button_.Builder)b.horSpan(2)).da(this.daControls_).section("midi").item("mt32.verbose").build();
        Chain.on((Composite)mt32ExpGroup).lbl(l -> l.key("dialog.template.mt32.multithread")).but(b -> (Button_.Builder)b.horSpan(2)).da(this.daControls_).section("midi").item("mt32.thread").build();
        Chain.on((Composite)mt32ExpGroup).lbl(l -> l.key("dialog.template.mt32.chunk")).spn(s -> ((Spinner_.Builder)s.horSpan(2)).min(2).max(100)).da(this.daControls_).section("midi").item("mt32.chunk").build();
        Chain.on((Composite)mt32ExpGroup).lbl(l -> l.key("dialog.template.mt32.prebuffer")).spn(s -> ((Spinner_.Builder)s.horSpan(2)).min(3).max(200)).da(this.daControls_).section("midi").item("mt32.prebuffer").build();
        Chain.on((Composite)mt32ExpGroup).lbl(l -> l.key("dialog.template.mt32.partials")).spn(s -> ((Spinner_.Builder)s.horSpan(2)).min(0).max(256)).da(this.daControls_).section("midi").item("mt32.partials").build();
        Chain.on((Composite)mt32ExpGroup).lbl(l -> l.key("dialog.template.mt32.dac")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).items(this.settings_.getValues("profile", "mt32dac"))).da(this.daControls_).section("midi").item("mt32.dac").build();
        Chain.on((Composite)mt32ExpGroup).lbl(l -> l.key("dialog.template.mt32.analog")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).items(this.settings_.getValues("profile", "mt32analog"))).da(this.daControls_).section("midi").item("mt32.analog").build();
        Chain.on((Composite)mt32ExpGroup).lbl(l -> l.key("dialog.template.mt32.reverbmode")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).items(this.settings_.getValues("profile", "mt32reverbmode"))).da(this.daControls_).section("midi").item("mt32.reverb.mode").build();
        Chain.on((Composite)mt32ExpGroup).lbl(l -> l.key("dialog.template.mt32.reverbtime")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).items(this.settings_.getValues("profile", "mt32reverbtime"))).da(this.daControls_).section("midi").item("mt32.reverb.time").build();
        Chain.on((Composite)mt32ExpGroup).lbl(l -> l.key("dialog.template.mt32.reverblevel")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).items(this.settings_.getValues("profile", "mt32reverblevel"))).da(this.daControls_).section("midi").item("mt32.reverb.level").build();
        Group fluidExpGroup = Group_.on(experimentalComposite).layout((Layout)new GridLayout(3, false)).key("dialog.template.fluidsynth").build();
        fluidExpGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 3));
        Chain.on((Composite)fluidExpGroup).lbl(l -> l.key("dialog.template.fluidsynth.driver")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).editable().items(this.settings_.getValues("profile", "fluidsynthdriver"))).da(this.daControls_).section("midi").item("fluid.driver").build();
        Chain.on((Composite)fluidExpGroup).lbl(l -> l.key("dialog.template.fluidsynth.soundfont")).txt(t -> t).but(b -> b.browse(true, Button_.BrowseType.FILE, Button_.CanonicalType.NONE, false)).da(this.daControls_).da(this.daControls_).section("midi").item("fluid.soundfont").build();
        Chain.on((Composite)fluidExpGroup).lbl(l -> l.key("dialog.template.fluidsynth.samplerate")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).items(this.settings_.getValues("profile", "fluidsynthsamplerate"))).da(this.daControls_).section("midi").item("fluid.samplerate").build();
        Chain.on((Composite)fluidExpGroup).lbl(l -> l.key("dialog.template.fluidsynth.gain")).txt(t -> (Text_.Builder)t.horSpan(2)).da(this.daControls_).section("midi").item("fluid.gain").build();
        Group innovaExpGroup = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.innova").build();
        innovaExpGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        Chain.on((Composite)innovaExpGroup).lbl(l -> l.key("dialog.template.innovaenable")).but(b -> b).da(this.daControls_).section("innova").item("innova").build();
        Chain.on((Composite)innovaExpGroup).lbl(l -> l.key("dialog.template.innovarate")).cmb(c -> c.items(this.settings_.getValues("profile", "innovarate"))).da(this.daControls_).section("innova").item("samplerate").build();
        Chain.on((Composite)innovaExpGroup).lbl(l -> l.key("dialog.template.innovaaddress")).cmb(c -> c.items(this.settings_.getValues("profile", "innovabase"))).da(this.daControls_).section("innova").item("sidbase").build();
        Chain.on((Composite)innovaExpGroup).lbl(l -> l.key("dialog.template.innovaquality")).cmb(c -> c.items(this.settings_.getValues("profile", "innovaquality"))).da(this.daControls_).section("innova").item("quality").build();
        Group ps1ExpGroup = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.ps1").build();
        ps1ExpGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        Chain.on((Composite)ps1ExpGroup).lbl(l -> l.key("dialog.template.ps1enable")).but(b -> b).da(this.daControls_).section("speaker").item("ps1audio").onOff().build();
        Chain.on((Composite)ps1ExpGroup).lbl(l -> l.key("dialog.template.ps1rate")).cmb(c -> c.items(this.settings_.getValues("profile", "ps1rate"))).da(this.daControls_).section("speaker").item("ps1audiorate").build();
    }

    protected void createIOTab() {
        TabFolder subTabFolder = this.createSubTabs("dialog.template.tab.io", 3, 4);
        Composite releaseComposite = (Composite)subTabFolder.getChildren()[0];
        Composite experimentalComposite = (Composite)subTabFolder.getChildren()[1];
        Group mouseGroup = Group_.on(releaseComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.mouse").build();
        mouseGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        Chain.on((Composite)mouseGroup).lbl(l -> l.key("dialog.template.autolock")).but(b -> b.tooltip("dialog.template.autolock.tooltip")).da(this.daControls_).section("sdl").item("autolock").build();
        Chain.on((Composite)mouseGroup).lbl(l -> l.key("dialog.template.sensitivity")).cmb(c -> c.editable().items(this.settings_.getValues("profile", "sensitivity")).visibleItemCount(20).tooltip("dialog.template.sensitivity.tooltip")).da(this.daControls_).section("sdl").item("sensitivity").convert(new DaControlConvertor(){

            @Override
            public String toConfValue(String[] values) {
                return String.join((CharSequence)",", values);
            }

            @Override
            public String[] toControlValues(String value) {
                String[] stringArray;
                if (value == null) {
                    stringArray = new String[]{};
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = value;
                }
                return stringArray;
            }

            @Override
            public String[] toConfValues(String[] values) {
                return null;
            }

            @Override
            public String[] toControlValues(String[] values) {
                return null;
            }
        }).build();
        Group keyboardGroup = Group_.on(releaseComposite).layout((Layout)new GridLayout(3, false)).key("dialog.template.keyboard").build();
        keyboardGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Chain.on((Composite)keyboardGroup).lbl(l -> l.key("dialog.template.usescancodes")).but(b -> ((Button_.Builder)b.horSpan(2)).tooltip("dialog.template.usescancodes.tooltip")).da(this.daControls_).section("sdl").item("usescancodes").build();
        final Text mapperfile = Chain.on((Composite)keyboardGroup).lbl(l -> l.key("dialog.template.mapperfile")).txt(t -> t.tooltip("dialog.template.mapperfile.tooltip")).da(this.daControls_).section("sdl").item("mapperfile").text();
        Button_.on((Composite)keyboardGroup).star().listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                mapperfile.setText(EditConfigurableDialog.this.settings_.getValue("profile", "uniquemapperfile"));
            }
        }).ctrl();
        Chain.on((Composite)keyboardGroup).lbl(l -> l.key("dialog.template.keyboardlayout")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).wide().editable().tooltip("dialog.template.keyboardlayout.tooltip").items(this.settings_.getValues("profile", "keyboardlayout")).visibleItemCount(15)).da(this.daControls_).section("dos").item("keyboardlayout").build();
        Chain.on((Composite)keyboardGroup).lbl(l -> l.key("dialog.template.keybcommand")).txt(t -> (Text_.Builder)t.horSpan(2)).meta(this.autoexecControls_).autoexec(Autoexec::getKeyb, Autoexec::setKeyb).build();
        Group joystickGroup = Group_.on(releaseComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.joystick").build();
        joystickGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Chain.on((Composite)joystickGroup).lbl(l -> l.key("dialog.template.joysticktype")).cmb(c -> c.tooltip("dialog.template.joysticktype.tooltip").items(this.settings_.getValues("profile", "joysticktype"))).da(this.daControls_).section("bios", "joystick").item("joysticktype", "joysticktype").build();
        Chain.on((Composite)joystickGroup).lbl(l -> l.key("dialog.template.timedemulation")).but(b -> b.tooltip("dialog.template.timedemulation.tooltip")).da(this.daControls_).section("joystick").item("timed").build();
        Chain.on((Composite)joystickGroup).lbl(l -> l.key("dialog.template.autofire")).but(b -> b.tooltip("dialog.template.autofire.tooltip")).da(this.daControls_).section("joystick").item("autofire").build();
        Chain.on((Composite)joystickGroup).lbl(l -> l.key("dialog.template.swap34")).but(b -> b.tooltip("dialog.template.swap34.tooltip")).da(this.daControls_).section("joystick").item("swap34").build();
        Chain.on((Composite)joystickGroup).lbl(l -> l.key("dialog.template.buttonwrapping")).but(b -> b.tooltip("dialog.template.buttonwrapping.tooltip")).da(this.daControls_).section("joystick").item("buttonwrap").build();
        Group modemGroup = Group_.on(releaseComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.modem").build();
        modemGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Chain.on((Composite)modemGroup).lbl(l -> l.key("dialog.template.serial1")).txt(t -> t.tooltip("dialog.template.serial.tooltip")).da(this.daControls_).section("serial").item("serial1").build();
        Chain.on((Composite)modemGroup).lbl(l -> l.key("dialog.template.serial2")).txt(t -> t.tooltip("dialog.template.serial.tooltip")).da(this.daControls_).section("serial").item("serial2").build();
        Chain.on((Composite)modemGroup).lbl(l -> l.key("dialog.template.serial3")).txt(t -> t.tooltip("dialog.template.serial.tooltip")).da(this.daControls_).section("serial").item("serial3").build();
        Chain.on((Composite)modemGroup).lbl(l -> l.key("dialog.template.serial4")).txt(t -> t.tooltip("dialog.template.serial.tooltip")).da(this.daControls_).section("serial").item("serial4").build();
        Group networkGroup = Group_.on(releaseComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.network").build();
        networkGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.ipx_ = Chain.on((Composite)networkGroup).lbl(l -> l.key("dialog.template.enableipx")).but(b -> b.tooltip("dialog.template.enableipx.tooltip")).da(this.daControls_).section("ipx").item("ipx").button();
        this.ipxNet_ = Chain.on((Composite)networkGroup).lbl(l -> ((Label_.Builder)l.horSpan(2)).key("dialog.template.ipxnetcommand")).txt(t -> (Text_.Builder)t.horSpan(2)).meta(this.autoexecControls_).autoexec(Autoexec::getIpxnet, Autoexec::setIpxnet).text();
        this.ipx_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.this.ipxNet_.setEnabled(EditConfigurableDialog.this.ipx_.getSelection());
            }
        });
        Group mouseExpGroup = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.mouse").build();
        mouseExpGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Chain.on((Composite)mouseExpGroup).lbl(l -> l.key("dialog.template.int33")).but(b -> b).da(this.daControls_).section("dos").item("int33").build();
        Chain.on((Composite)mouseExpGroup).lbl(l -> l.key("dialog.template.biosps2")).but(b -> b).da(this.daControls_).section("dos").item("biosps2").build();
        Chain.on((Composite)mouseExpGroup).lbl(l -> l.key("dialog.template.aux")).but(b -> b).da(this.daControls_).section("keyboard").item("aux").build();
        Chain.on((Composite)mouseExpGroup).lbl(l -> l.key("dialog.template.auxdevice")).cmb(c -> c.items(this.settings_.getValues("profile", "auxdevice"))).da(this.daControls_).section("keyboard").item("auxdevice").build();
        Group miscExpGroup = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.miscellaneous").build();
        miscExpGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Chain.on((Composite)miscExpGroup).lbl(l -> l.key("dialog.template.files")).spn(s -> s.min(8).max(255)).da(this.daControls_).section("dos").item("files").build();
        Chain.on((Composite)miscExpGroup).lbl(l -> l.key("dialog.template.isapnpbios")).but(b -> b).da(this.daControls_).section("cpu").item("isapnpbios").build();
        Chain.on((Composite)miscExpGroup).lbl(l -> l.key("dialog.template.ide1")).but(b -> b).da(this.daControls_).section("ide, primary").item("enable").build();
        Chain.on((Composite)miscExpGroup).lbl(l -> l.key("dialog.template.ide2")).but(b -> b).da(this.daControls_).section("ide, secondary").item("enable").build();
        Chain.on((Composite)miscExpGroup).lbl(l -> l.key("dialog.template.ide3")).but(b -> b).da(this.daControls_).section("ide, tertiary").item("enable").build();
        Chain.on((Composite)miscExpGroup).lbl(l -> l.key("dialog.template.ide4")).but(b -> b).da(this.daControls_).section("ide, quaternary").item("enable").build();
        Chain.on((Composite)miscExpGroup).lbl(l -> l.key("dialog.template.automount")).but(b -> b).da(this.daControls_).section("dos").item("automount").build();
        Group printerExpGroup = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.printer").build();
        printerExpGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Chain.on((Composite)printerExpGroup).lbl(l -> l.key("dialog.template.printerenable")).but(b -> b).da(this.daControls_).section("printer").item("printer").build();
        Chain.on((Composite)printerExpGroup).lbl(l -> l.key("dialog.template.printerdpi")).spn(s -> s.min(0).max(Short.MAX_VALUE)).da(this.daControls_).section("printer").item("dpi").build();
        Chain.on((Composite)printerExpGroup).lbl(l -> l.key("dialog.template.printerwidth")).spn(s -> s.min(0).max(Short.MAX_VALUE)).da(this.daControls_).section("printer").item("width").build();
        Chain.on((Composite)printerExpGroup).lbl(l -> l.key("dialog.template.printerheight")).spn(s -> s.min(0).max(Short.MAX_VALUE)).da(this.daControls_).section("printer").item("height").build();
        Chain.on((Composite)printerExpGroup).lbl(l -> l.key("dialog.template.printeroutput")).cmb(c -> c.items(this.settings_.getValues("profile", "printeroutput"))).da(this.daControls_).section("printer").item("printoutput").build();
        Chain.on((Composite)printerExpGroup).lbl(l -> l.key("dialog.template.printermultipage")).but(b -> b).da(this.daControls_).section("printer").item("multipage").build();
        Chain.on((Composite)printerExpGroup).lbl(l -> l.key("dialog.template.printerdocpath")).txt(t -> t).da(this.daControls_).section("printer").item("docpath").build();
        Chain.on((Composite)printerExpGroup).lbl(l -> l.key("dialog.template.printertimeout")).spn(s -> s.min(0).max(Short.MAX_VALUE)).da(this.daControls_).section("printer").item("timeout").build();
        Group joystickExpGroup = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.joystick").build();
        joystickExpGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Chain.on((Composite)joystickExpGroup).lbl(l -> l.key("dialog.template.circularinput")).but(b -> b.tooltip("dialog.template.circularinput.tooltip")).da(this.daControls_).section("joystick").item("circularinput").build();
        Chain.on((Composite)joystickExpGroup).lbl(l -> l.key("dialog.template.deadzone")).spn(s -> s.tooltip("dialog.template.deadzone.tooltip").min(0).max(100)).da(this.daControls_).section("joystick").item("deadzone").build();
        Group parallelExpGroup = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.parallel").build();
        parallelExpGroup.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Chain.on((Composite)parallelExpGroup).lbl(l -> l.key("dialog.template.parallel1")).txt(t -> t).da(this.daControls_).section("parallel").item("parallel1").build();
        Chain.on((Composite)parallelExpGroup).lbl(l -> l.key("dialog.template.parallel2")).txt(t -> t).da(this.daControls_).section("parallel").item("parallel2").build();
        Chain.on((Composite)parallelExpGroup).lbl(l -> l.key("dialog.template.parallel3")).txt(t -> t).da(this.daControls_).section("parallel").item("parallel3").build();
        Chain.on((Composite)parallelExpGroup).lbl(l -> l.key("dialog.template.dongle")).but(b -> b).da(this.daControls_).section("parallel").item("dongle").build();
        Group ne2000ExpGroup = Group_.on(experimentalComposite).layout((Layout)new GridLayout(2, false)).key("dialog.template.ne2000").build();
        ne2000ExpGroup.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Chain.on((Composite)ne2000ExpGroup).lbl(l -> l.key("dialog.template.ne2000enable")).but(b -> b).da(this.daControls_).section("ne2000").item("ne2000").build();
        Chain.on((Composite)ne2000ExpGroup).lbl(l -> l.key("dialog.template.ne2000base")).txt(t -> t).da(this.daControls_).section("ne2000").item("nicbase").build();
        Chain.on((Composite)ne2000ExpGroup).lbl(l -> l.key("dialog.template.ne2000irq")).txt(t -> t).da(this.daControls_).section("ne2000").item("nicirq").build();
        Chain.on((Composite)ne2000ExpGroup).lbl(l -> l.key("dialog.template.ne2000macaddress")).txt(t -> t).da(this.daControls_).section("ne2000").item("macaddr").build();
        Chain.on((Composite)ne2000ExpGroup).lbl(l -> l.key("dialog.template.ne2000realnic")).txt(t -> t).da(this.daControls_).section("ne2000").item("realnic").build();
    }

    protected void createCustomCommandsTab(final TemplateProfileBase configurable, boolean multiEdit) {
        TabFolder subTabFolder = this.createSubTabs("dialog.template.tab.customcommands", "dialog.template.tab.dosboxautoexec", 2, "dialog.template.tab.native", 2);
        Composite dosboxComposite = (Composite)subTabFolder.getChildren()[0];
        Composite nativeComposite = (Composite)subTabFolder.getChildren()[1];
        for (int i = 0; i < Autoexec.SECTIONS; ++i) {
            int j = i + 1;
            Chain.on(dosboxComposite).lbl(l -> l.key("dialog.template.customcommand" + j)).txt(t -> t.multi()).meta(this.autoexecControls_).autoexec(i, Autoexec::getCustomSection, Autoexec::setCustomSection).build();
        }
        this.nativeCommandsList_ = List_.on(nativeComposite).ctrl();
        this.nativeCommandsList_.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (EditConfigurableDialog.this.nativeCommandsList_.getSelectionIndex() == -1) {
                    EditConfigurableDialog.this.doAddNativeCommand(configurable);
                } else {
                    EditConfigurableDialog.this.doEditNativeCommand(configurable);
                }
            }
        });
        Composite nativeButComp = ((Composite_.Builder)Composite_.on(nativeComposite).layoutData(new GridData(1, 1, false, false))).innerLayout(1).build();
        Chain.on(nativeButComp).but(b -> b.text().key("dialog.template.mount.add").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.this.doAddNativeCommand(configurable);
            }
        })).but(b -> b.text().key("dialog.template.mount.edit").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.this.doEditNativeCommand(configurable);
            }
        })).but(b -> b.text().key("dialog.template.mount.remove").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.this.doRemoveNativeCommand(configurable);
            }
        })).but(b -> b.arrow(true).listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int sel = EditConfigurableDialog.this.nativeCommandsList_.getSelectionIndex();
                if (sel > 0) {
                    Collections.swap(configurable.getNativeCommands(), sel, sel - 1);
                    EditConfigurableDialog.this.updateNativeCommands(sel - 1, configurable);
                }
            }
        })).but(b -> b.arrow(false).listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int sel = EditConfigurableDialog.this.nativeCommandsList_.getSelectionIndex();
                if (sel >= 0 && sel < EditConfigurableDialog.this.nativeCommandsList_.getItemCount() - 1) {
                    Collections.swap(configurable.getNativeCommands(), sel, sel + 1);
                    EditConfigurableDialog.this.updateNativeCommands(sel + 1, configurable);
                }
            }
        })).build();
        if (multiEdit) {
            Arrays.asList(nativeComposite.getChildren()).forEach(x -> x.setEnabled(false));
        }
    }

    protected void updateNativeCommands(int sel, TemplateProfileBase configurable) {
        this.nativeCommandsList_.removeAll();
        for (NativeCommand cmd : configurable.getNativeCommands()) {
            this.nativeCommandsList_.add(cmd.toString());
        }
        this.nativeCommandsList_.select(sel);
    }

    protected void doAddNativeCommand(TemplateProfileBase configurable) {
        EditNativeCommandDialog cmdDialog = new EditNativeCommandDialog(this.shell_, null);
        NativeCommand cmd = (NativeCommand)cmdDialog.open();
        if (cmd != null) {
            int nr = this.nativeCommandsList_.getSelectionIndex() + 1;
            configurable.getNativeCommands().add(nr, cmd);
            this.updateNativeCommands(nr, configurable);
        }
    }

    protected void doEditNativeCommand(TemplateProfileBase configurable) {
        EditNativeCommandDialog cmdDialog;
        NativeCommand cmd;
        int sel = this.nativeCommandsList_.getSelectionIndex();
        if (sel != -1 && !(cmd = configurable.getNativeCommands().get(sel)).isDosboxCommand() && (cmd = (NativeCommand)(cmdDialog = new EditNativeCommandDialog(this.shell_, cmd)).open()) != null) {
            configurable.getNativeCommands().set(sel, cmd);
            this.updateNativeCommands(sel, configurable);
        }
    }

    protected void doRemoveNativeCommand(TemplateProfileBase configurable) {
        NativeCommand cmd;
        int sel = this.nativeCommandsList_.getSelectionIndex();
        if (sel != -1 && !(cmd = configurable.getNativeCommands().get(sel)).isDosboxCommand()) {
            configurable.getNativeCommands().remove(sel);
            this.updateNativeCommands(Math.min(sel, this.nativeCommandsList_.getItemCount() - 1), configurable);
        }
    }

    protected void createMountingTab(final TemplateProfileBase configurable, boolean multiEdit) {
        final Composite composite = this.createTabWithComposite("dialog.template.tab.mounting", (Layout)new GridLayout());
        Group mountGroup = Group_.on(composite).layout((Layout)new GridLayout(2, false)).key("dialog.template.mountingoverview").build();
        mountGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.mountingpointsList_ = List_.on((Composite)mountGroup).ctrl();
        Group executeGroup = Group_.on(composite).layout((Layout)new FillLayout()).key("dialog.template.execute").build();
        executeGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        final ExpandBar dosBooterExpandBar = new ExpandBar((Composite)executeGroup, 512);
        Composite booterComposite = Composite_.on((Composite)dosBooterExpandBar).build();
        Composite dosComposite = Composite_.on((Composite)dosBooterExpandBar).build();
        this.booterExpandItem_ = EditConfigurableDialog.createExpandItem(dosBooterExpandBar, "dialog.template.booter", false, booterComposite);
        this.dosExpandItem_ = EditConfigurableDialog.createExpandItem(dosBooterExpandBar, "dialog.template.dos", false, dosComposite);
        dosBooterExpandBar.addExpandListener((ExpandListener)new ExpandAdapter(){

            public void itemCollapsed(ExpandEvent e) {
                dosBooterExpandBar.getItem(((ExpandItem)e.item).getText().equals(EditConfigurableDialog.this.text_.get("dialog.template.dos")) ? 0 : 1).setExpanded(true);
                EditConfigurableDialog.this.display_.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        composite.layout();
                    }
                });
            }

            public void itemExpanded(ExpandEvent e) {
                dosBooterExpandBar.getItem(((ExpandItem)e.item).getText().equals(EditConfigurableDialog.this.text_.get("dialog.template.dos")) ? 0 : 1).setExpanded(false);
                EditConfigurableDialog.this.display_.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        composite.layout();
                    }
                });
            }
        });
        this.mountingpointsList_.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (EditConfigurableDialog.this.mountingpointsList_.getSelectionIndex() == -1) {
                    EditConfigurableDialog.doAddMount(EditConfigurableDialog.this.shell_, EditConfigurableDialog.this.booterExpandItem_.getExpanded(), EditConfigurableDialog.this.mountingpointsList_, configurable);
                } else {
                    EditConfigurableDialog.doEditMount(EditConfigurableDialog.this.shell_, EditConfigurableDialog.this.mountingpointsList_, configurable);
                }
            }
        });
        Composite mntButComp = Composite_.on((Composite)mountGroup).innerLayout(1).build();
        Chain.on(mntButComp).but(b -> b.text().key("dialog.template.mount.add").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.doAddMount(EditConfigurableDialog.this.shell_, EditConfigurableDialog.this.booterExpandItem_.getExpanded(), EditConfigurableDialog.this.mountingpointsList_, configurable);
            }
        })).but(b -> b.text().key("dialog.template.mount.edit").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.doEditMount(EditConfigurableDialog.this.shell_, EditConfigurableDialog.this.mountingpointsList_, configurable);
            }
        })).but(b -> b.text().key("dialog.template.mount.remove").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.this.doRemoveMount(configurable);
            }
        })).build();
        if (multiEdit) {
            Arrays.asList(mntButComp.getChildren()).forEach(x -> x.setEnabled(false));
        }
    }

    public static void doAddMount(Shell shell, boolean floppy, org.eclipse.swt.widgets.List mountingpoints, TemplateProfileBase configurable) {
        char drive;
        try {
            drive = DriveLetterHelper.getFirstAvailable(floppy, configurable.getNettoMountedDrives());
        }
        catch (DrivelettersExhaustedException e) {
            drive = 'C';
        }
        EditMountDialog addMountDialog = new EditMountDialog(shell, null, drive);
        String mount = (String)addMountDialog.open();
        if (mount != null) {
            configurable.addMount(mount);
            mountingpoints.setItems(configurable.getMountStringsForUI());
            mountingpoints.select(mountingpoints.getItemCount() - 1);
        }
    }

    public static void doEditMount(Shell shell, org.eclipse.swt.widgets.List mountingpoints, TemplateProfileBase configurable) {
        EditMountDialog editMountDialog;
        String mount;
        int mounts = mountingpoints.getItemCount();
        int sel = mountingpoints.getSelectionIndex();
        if (sel == -1 && mounts == 1) {
            sel = 0;
            mountingpoints.select(sel);
        }
        if (sel != -1 && !configurable.getMountingPointsForUI().get(sel).isUnmounted() && (mount = (String)(editMountDialog = new EditMountDialog(shell, mountingpoints.getItem(sel), 'C')).open()) != null) {
            configurable.editMountBasedOnIndexUI(sel, mount);
            mountingpoints.setItems(configurable.getMountStringsForUI());
            if (mountingpoints.getItemCount() == mounts) {
                mountingpoints.select(sel);
            } else {
                mountingpoints.select(mountingpoints.getItemCount() - 1);
            }
        }
    }

    protected void doRemoveMount(TemplateProfileBase configurable) {
        EditConfigurableDialog.doRemoveMount(this.mountingpointsList_, configurable);
    }

    public static void doRemoveMount(org.eclipse.swt.widgets.List mountingpoints, TemplateProfileBase configurable) {
        int mounts = mountingpoints.getItemCount();
        int sel = mountingpoints.getSelectionIndex();
        if (sel == -1 && mounts == 1) {
            sel = 0;
            mountingpoints.select(sel);
        }
        if (sel != -1) {
            configurable.removeMountBasedOnIndexUI(sel);
            mountingpoints.setItems(configurable.getMountStringsForUI());
            if (mountingpoints.getItemCount() == mounts) {
                mountingpoints.select(sel);
            } else if (mountingpoints.getItemCount() > 0) {
                mountingpoints.select(mountingpoints.getItemCount() - 1);
            }
        }
    }

    private TabFolder createSubTabs(String titleKey, int numColumns1, int numColumns2) {
        return this.createSubTabs(titleKey, "dialog.template.tab.releaseoptions", numColumns1, "dialog.template.tab.experimentaloptions", numColumns2);
    }

    private TabFolder createSubTabs(String titleKey, String key1, int numColumns1, String key2, int numColumns2) {
        TabFolder subTabFolder = new TabFolder(this.createTabWithComposite(titleKey, (Layout)new FillLayout()), 0);
        Composite_.on((Composite)subTabFolder).layout((Layout)new GridLayout(numColumns1, false)).tab(key1).build();
        Composite_.on((Composite)subTabFolder).layout((Layout)new GridLayout(numColumns2, false)).tab(key2).build();
        return subTabFolder;
    }

    protected static enum DosboxConfAction {
        SET,
        SWITCH,
        RELOAD,
        RELOAD_TEMPLATE;

    }
}

