/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.abstractdialog;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.dbgl.gui.abstractdialog.EditConfigurableDialog;
import org.dbgl.gui.controls.Button_;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Combo_;
import org.dbgl.gui.controls.Label_;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.gui.controls.Scale_;
import org.dbgl.gui.controls.SearchEngineSelector;
import org.dbgl.gui.controls.TextControl_;
import org.dbgl.gui.controls.Text_;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.aggregate.Template;
import org.dbgl.model.conf.Autoexec;
import org.dbgl.model.entity.ITitledEntity;
import org.dbgl.model.entity.TemplateProfileBase;
import org.dbgl.model.entity.TitledEntity;
import org.dbgl.model.repository.TemplateRepository;
import org.dbgl.model.repository.TitledEntityRepository;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;

public abstract class EditProfileDialog<T>
extends EditConfigurableDialog<T> {
    protected List<ITitledEntity> developersList_;
    protected List<ITitledEntity> publishersList_;
    protected List<ITitledEntity> genresList_;
    protected List<ITitledEntity> yearsList_;
    protected List<ITitledEntity> statusList_;
    protected List<List<ITitledEntity>> customList_;
    protected List<Template> templatesList_;
    protected Text title_;
    protected Text notes_;
    protected SearchEngineSelector engineSelector_;
    protected Text[] link_;
    protected Text[] linkTitle_;
    protected Button[] linkBrowseButton_;
    protected Combo developer_;
    protected Combo publisher_;
    protected Combo genre_;
    protected Combo year_;
    protected Scale custom9_;
    protected Combo templateCombo_;
    protected Button loadfix_;
    protected Combo loadfixValue_;
    protected Text img1_;
    protected Text img2_;
    protected Text img3_;
    protected Text main_;
    protected Text setup_;
    protected Composite webImagesSpaceHolder_;
    protected SearchEngineImageInformation[] imageInformation_;
    protected Button[] imgButtons_;
    protected int templateIndex_;

    public EditProfileDialog(Shell parent) {
        super(parent, "profiledialog");
    }

    @Override
    protected boolean prepare() {
        if (!super.prepare()) {
            return false;
        }
        try {
            TemplateRepository templRepo = new TemplateRepository();
            TitledEntityRepository titledRepo = new TitledEntityRepository();
            this.templatesList_ = templRepo.listAll(this.dbversionsList_);
            this.developersList_ = titledRepo.listDevelopers(null);
            this.publishersList_ = titledRepo.listPublishers(null);
            this.genresList_ = titledRepo.listGenres(null);
            this.yearsList_ = titledRepo.listYears(null);
            this.statusList_ = titledRepo.listStatus(null);
            this.customList_ = new ArrayList<List<ITitledEntity>>();
            for (int i = 0; i < 4; ++i) {
                this.customList_.add(titledRepo.listCustomValues(i, null));
            }
            this.templateIndex_ = TemplateRepository.indexOfDefault(this.templatesList_);
            return true;
        }
        catch (Exception e) {
            Mess_.on(this.getParent()).exception(e).warning();
            return false;
        }
    }

    protected ToolBar createInfoTab() {
        int i;
        Composite composite = this.createTabWithComposite("dialog.profile.tab.info", 6);
        this.title_ = Chain.on(composite).lbl(l -> l.key("dialog.profile.title")).txt(t -> (Text_.Builder)t.horSpan(4)).meta(this.metaControls_).profile(TitledEntity::getTitle, TitledEntity::setTitle).text();
        ToolBar toolBar = new ToolBar(composite, 0x800000);
        this.engineSelector_ = new SearchEngineSelector(toolBar, false);
        this.developer_ = Chain.on(composite).lbl(l -> l.key("dialog.profile.developer")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).autoSelect(this.developersList_)).meta(this.metaControls_).profile(Profile::getDeveloper, Profile::setDeveloper).combo();
        this.publisher_ = Chain.on(composite).lbl(l -> l.key("dialog.profile.publisher")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).autoSelect(this.publishersList_)).meta(this.metaControls_).profile(Profile::getPublisher, Profile::setPublisher).combo();
        this.genre_ = Chain.on(composite).lbl(l -> l.key("dialog.profile.genre")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).autoSelect(this.genresList_)).meta(this.metaControls_).profile(Profile::getGenre, Profile::setGenre).combo();
        this.year_ = Chain.on(composite).lbl(l -> l.key("dialog.profile.year")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).autoSelect(this.yearsList_)).meta(this.metaControls_).profile(Profile::getYear, Profile::setYear).combo();
        this.link_ = new Text[8];
        this.linkBrowseButton_ = new Button[8];
        this.linkTitle_ = new Text[8];
        for (int i2 = 0; i2 < 4; ++i2) {
            int j = i2 + 1;
            Chain chnLink = Chain.on(composite).lbl(l -> l.key("dialog.profile.link", new Object[]{j})).txt(t -> t).meta(this.metaControls_).profile(i2, Profile::getLinkDestination, Profile::setLinkDestination).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.DOC, false)).build();
            this.link_[i2] = chnLink.getText();
            this.linkBrowseButton_[i2] = chnLink.getButton();
            this.linkTitle_[i2] = Chain.on(composite).lbl(l -> l.key("dialog.profile.linktitle")).txt(t -> (Text_.Builder)t.horSpan(2)).meta(this.metaControls_).profile(i2, Profile::getLinkTitle, Profile::setLinkTitle).text();
        }
        Chain.on(composite).lbl(l -> l.key("dialog.profile.status")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).autoSelect(this.statusList_)).meta(this.metaControls_).profile(Profile::getStatus, Profile::setStatus).build();
        Chain.on(composite).lbl(l -> l.key("dialog.profile.favorite")).but(b -> (Button_.Builder)b.layoutData(new GridData(4, 0x1000000, true, false))).lbl(l -> l).meta(this.metaControls_).profile(Profile::getFavorite, Profile::setFavorite).build();
        this.notes_ = Chain.on(composite).lbl(l -> l.key("dialog.profile.notes")).txt(t -> ((Text_.Builder)t.horSpan(5)).multi().wrap()).meta(this.metaControls_).profile(Profile::getNotes, Profile::setNotes).text();
        this.notes_.setFont(EditProfileDialog.stringToFont((Device)this.display_, this.settings_.getValues("gui", "notesfont"), this.notes_.getFont()));
        this.notes_.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                EditProfileDialog.this.notes_.getFont().dispose();
            }
        });
        Composite customComposite = this.createTabWithComposite("dialog.profile.tab.custominfo", 5);
        for (i = 0; i < 4; ++i) {
            int j = i + 1;
            int k = i;
            Chain.on(customComposite).lbl(l -> l.txt(this.settings_.getValue("gui", "custom" + j))).cmb(c -> ((Combo_.Builder)c.horSpan(4)).autoSelect(this.customList_.get(k))).meta(this.metaControls_).profile(i, Profile::getCustomString, Profile::setCustomString).build();
        }
        for (i = 0; i < 4; ++i) {
            int j = i + 1;
            Chain.on(customComposite).lbl(l -> l.txt(this.settings_.getValue("gui", "custom" + (j + 4)))).txt(t -> (Text_.Builder)t.horSpan(4)).meta(this.metaControls_).profile(i + 4, Profile::getCustomString, Profile::setCustomString).build();
        }
        this.custom9_ = Chain.on(customComposite).lbl(l -> l.txt(this.settings_.getValue("gui", "custom9"))).scl(s -> (Scale_.Builder)s.horSpan(2)).meta(this.metaControls_).profile(0, Profile::getCustomInt, Profile::setCustomInt).scale();
        Chain.on(customComposite).lbl(l -> l.txt(this.settings_.getValue("gui", "custom10"))).spn(s -> s.min(Integer.MIN_VALUE).max(Integer.MAX_VALUE)).meta(this.metaControls_).profile(1, Profile::getCustomInt, Profile::setCustomInt).build();
        for (i = 4; i < 8; ++i) {
            int j = i + 1;
            Chain chnLink = Chain.on(customComposite).lbl(l -> l.key("dialog.profile.link", new Object[]{j})).txt(t -> t).meta(this.metaControls_).profile(i, Profile::getLinkDestination, Profile::setLinkDestination).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.DOC, false)).build();
            this.link_[i] = chnLink.getText();
            this.linkBrowseButton_[i] = chnLink.getButton();
            this.linkTitle_[i] = Chain.on(customComposite).lbl(l -> l.key("dialog.profile.linktitle")).txt(t -> t).meta(this.metaControls_).profile(i, Profile::getLinkTitle, Profile::setLinkTitle).text();
        }
        for (i = 0; i < 4; ++i) {
            int columns = i % 2 == 0 ? 2 : 1;
            int j = i + 1;
            Chain.on(customComposite).lbl(l -> l.txt(this.settings_.getValue("gui", "custom" + (j + 4 + 2 + 4)))).txt(t -> (Text_.Builder)t.horSpan(columns)).meta(this.metaControls_).profile(i + 4 + 4, Profile::getCustomString, Profile::setCustomString).build();
        }
        return toolBar;
    }

    @Override
    protected Group createGeneralTab(String capturesText, String configFileText) {
        Group associationGroup = super.createGeneralTab(capturesText, configFileText);
        this.templateCombo_ = Chain.on((Composite)associationGroup).lbl(l -> l.key("dialog.profile.template")).cmb(c -> ((Combo_.Builder)c.horSpan(3)).wide().items((String[])this.templatesList_.stream().map(z -> z.getTitle()).toArray(String[]::new)).select(this.templateIndex_).visibleItemCount(20)).combo();
        Button_.on((Composite)associationGroup).text().key("dialog.profile.reloadsettings").tooltip("dialog.profile.reloadsettings.tooltip").listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (EditProfileDialog.this.templateCombo_.getSelectionIndex() != -1) {
                    if (EditProfileDialog.this.setButton_.isEnabled()) {
                        Mess_.on(EditProfileDialog.this.shell_).key("dialog.template.required.dosboxassociation").bind((Control)EditProfileDialog.this.setButton_, EditProfileDialog.this.getTabItemByControl((Control)EditProfileDialog.this.setButton_)).valid();
                        return;
                    }
                    EditProfileDialog.this.doPerformDosboxConfAction(EditConfigurableDialog.DosboxConfAction.RELOAD_TEMPLATE, (DosboxVersion)EditProfileDialog.this.dbversionsList_.get(EditProfileDialog.this.dbversionCombo_.getSelectionIndex()));
                }
            }
        }).ctrl().setEnabled(this.dbversionIndex_ != -1);
        return associationGroup;
    }

    @Override
    protected Group createMachineTab() {
        Group memoryGroup = super.createMachineTab();
        this.loadfix_ = Chain.on((Composite)memoryGroup).lbl(l -> l.key("dialog.profile.loadfix")).but(b -> b.listen((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditProfileDialog.this.loadfixValue_.setEnabled(EditProfileDialog.this.loadfix_.getSelection());
            }
        })).meta(this.autoexecControls_).autoexec(Autoexec::getLoadfix, Autoexec::setLoadfix).button();
        this.loadfixValue_ = Chain.on((Composite)memoryGroup).cmb(c -> c.editable().items(this.settings_.getValues("profile", "loadfix_value"))).lbl(l -> l.key("dialog.profile.kb")).meta(this.autoexecControls_).autoexec(Autoexec::getLoadfixValueAsString, Autoexec::setLoadfixValue).combo();
        Chain.on((Composite)memoryGroup).lbl(l -> l.key("dialog.profile.loadhigh")).but(b -> (Button_.Builder)b.horSpan(3)).meta(this.autoexecControls_).autoexec(Autoexec::getLoadhigh, Autoexec::setLoadhigh).build();
        return memoryGroup;
    }

    @Override
    protected void createMountingTab(TemplateProfileBase configurable, boolean multiEdit) {
        super.createMountingTab(configurable, multiEdit);
        Composite booterComposite = (Composite)this.booterExpandItem_.getControl();
        booterComposite.setLayout((Layout)new GridLayout(4, false));
        Chain img1Chain = Chain.on(booterComposite).lbl(l -> l.key("dialog.profile.booterimage1")).txt(t -> t).meta(this.autoexecControls_).autoexec(Autoexec::getImg1, Autoexec::setImg1).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.BOOTER, false)).but(b -> b.grab(this.mountingpointsList_, true)).build();
        this.img1_ = img1Chain.getText();
        Chain img2Chain = Chain.on(booterComposite).lbl(l -> l.key("dialog.profile.booterimage2")).txt(t -> t).meta(this.autoexecControls_).autoexec(Autoexec::getImg2, Autoexec::setImg2).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.BOOTER, false)).but(b -> b.grab(this.mountingpointsList_, true)).build();
        this.img2_ = img2Chain.getText();
        Chain img3Chain = Chain.on(booterComposite).lbl(l -> l.key("dialog.profile.booterimage3")).txt(t -> t).meta(this.autoexecControls_).autoexec(Autoexec::getImg3, Autoexec::setImg3).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.BOOTER, false)).but(b -> b.grab(this.mountingpointsList_, true)).build();
        this.img3_ = img3Chain.getText();
        Chain.on(booterComposite).lbl(l -> l.key("dialog.profile.booterdriveletter")).cmb(c -> ((Combo_.Builder)c.horSpan(3)).items(new String[]{"", "A", "C", "D"}).visibleItemCount(4)).meta(this.autoexecControls_).autoexec(Autoexec::getImgDriveletter, Autoexec::setImgDriveletter).build();
        this.booterExpandItem_.setHeight(booterComposite.computeSize((int)-1, (int)-1).y);
        Composite dosComposite = (Composite)this.dosExpandItem_.getControl();
        dosComposite.setLayout((Layout)new GridLayout(7, false));
        this.main_ = Chain.on(dosComposite).lbl(l -> l.key("dialog.profile.mainexe")).txt(t -> (Text_.Builder)t.horSpan(4)).meta(this.autoexecControls_).autoexec(Autoexec::getMain, Autoexec::setMain).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.EXE, false)).but(b -> b.grab(this.mountingpointsList_, false)).text();
        Chain.on(dosComposite).lbl(l -> l).lbl(l -> l.key("dialog.profile.mainparameters")).txt(t -> (Text_.Builder)t.horSpan(3)).lbl(l -> (Label_.Builder)l.horSpan(2)).meta(this.autoexecControls_).autoexec(Autoexec::getParameters, Autoexec::setParameters).build();
        Chain setupChain = Chain.on(dosComposite).lbl(l -> l.key("dialog.profile.setupexe")).txt(t -> (Text_.Builder)t.horSpan(4)).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.EXE, false)).meta(this.metaControls_).profile(Profile::getSetupString, Profile::setSetupFileLocation).but(b -> b.grab(this.mountingpointsList_, false)).build();
        this.setup_ = setupChain.getText();
        Chain.on(dosComposite).lbl(l -> l).lbl(l -> l.key("dialog.profile.setupparameters")).txt(t -> (Text_.Builder)t.horSpan(3)).lbl(l -> (Label_.Builder)l.horSpan(2)).meta(this.metaControls_).profile(Profile::getSetupParams, Profile::setSetupParams).build();
        Text alt1 = Chain.on(dosComposite).lbl(l -> l.key("dialog.profile.altexe", new Object[]{1})).txt(t -> (Text_.Builder)t.horSpan(2)).meta(this.metaControls_).profile(0, Profile::getAltExeString, Profile::setAltExeFileLocation).text();
        Chain alt1Chain = Chain.on(dosComposite).lbl(l -> l).txt(t -> t).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.EXE, false)).meta(this.metaControls_).profile(0, Profile::getAltExeParam, Profile::setAltExeParam).but(b -> b.grab(this.mountingpointsList_, false)).build();
        Text alt2 = Chain.on(dosComposite).lbl(l -> l.key("dialog.profile.altexe", new Object[]{2})).txt(t -> (Text_.Builder)t.horSpan(2)).meta(this.metaControls_).profile(1, Profile::getAltExeString, Profile::setAltExeFileLocation).text();
        Chain alt2Chain = Chain.on(dosComposite).lbl(l -> l).txt(t -> t).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.EXE, false)).meta(this.metaControls_).profile(1, Profile::getAltExeParam, Profile::setAltExeParam).but(b -> b.grab(this.mountingpointsList_, false)).build();
        this.dosExpandItem_.setHeight(dosComposite.computeSize((int)-1, (int)-1).y);
        for (int i = 0; i < 8; ++i) {
            this.linkBrowseButton_[i].setData("altControl", (Object)this.main_);
        }
        img1Chain.getButton().setData("altControl", (Object)this.main_);
        img2Chain.getButton().setData("altControl", (Object)this.img1_);
        img3Chain.getButton().setData("altControl", (Object)this.img1_);
        setupChain.getButton().setData("altControl", (Object)this.main_);
        alt1Chain.getButtons()[0].setData("control", (Object)new TextControl_(alt1));
        alt1Chain.getButtons()[1].setData("control", (Object)new TextControl_(alt1));
        alt1Chain.getButton().setData("altControl", (Object)this.main_);
        alt2Chain.getButtons()[0].setData("control", (Object)new TextControl_(alt2));
        alt2Chain.getButtons()[1].setData("control", (Object)new TextControl_(alt2));
        alt2Chain.getButton().setData("altControl", (Object)this.main_);
        if (multiEdit) {
            Stream.of(booterComposite.getChildren()).forEach(x -> x.setEnabled(false));
            Stream.of(dosComposite.getChildren()).forEach(x -> x.setEnabled(false));
        }
    }
}

