/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.abstractdialog;

import org.dbgl.gui.abstractdialog.BaseDialog;
import org.dbgl.service.SettingsService;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;

public abstract class SizeControlledDialog<T>
extends BaseDialog<T> {
    private final String dialogName_;
    private boolean listenerEnabled_;
    protected final SettingsService settings_;

    public SizeControlledDialog(Shell parent, int shellStyle, String dialogName) {
        super(parent, shellStyle);
        this.dialogName_ = dialogName;
        this.listenerEnabled_ = true;
        this.settings_ = SettingsService.getInstance();
    }

    public SizeControlledDialog(Shell parent, String dialogName) {
        this(parent, 67696, dialogName);
    }

    @Override
    protected void onShellInit() {
        if (this.shellStyle_ == 32768) {
            if (this.settings_.getBooleanValue("gui", "maximized")) {
                this.shell_.setMaximized(true);
            } else {
                this.shell_.setLocation(this.settings_.getIntValue("gui", "x"), this.settings_.getIntValue("gui", "y"));
                this.shell_.setSize(this.settings_.getIntValue("gui", "width"), this.settings_.getIntValue("gui", "height"));
            }
            this.shell_.addControlListener((ControlListener)new ControlAdapter(){

                public void controlMoved(ControlEvent event) {
                    if (!SizeControlledDialog.this.shell_.getMaximized()) {
                        Rectangle rec = SizeControlledDialog.this.shell_.getBounds();
                        SizeControlledDialog.this.settings_.setIntValue("gui", "x", rec.x);
                        SizeControlledDialog.this.settings_.setIntValue("gui", "y", rec.y);
                    }
                }
            });
        } else {
            this.shell_.setSize(this.settings_.getIntValue("gui", this.dialogName_ + "_width"), this.settings_.getIntValue("gui", this.dialogName_ + "_height"));
        }
        this.shell_.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                if (SizeControlledDialog.this.listenerEnabled_) {
                    boolean isMaximized = SizeControlledDialog.this.shell_.getMaximized();
                    if (!isMaximized) {
                        Rectangle rec = SizeControlledDialog.this.shell_.getBounds();
                        if (SizeControlledDialog.this.shellStyle_ == 32768) {
                            SizeControlledDialog.this.settings_.setIntValue("gui", "width", rec.width);
                            SizeControlledDialog.this.settings_.setIntValue("gui", "height", rec.height);
                            SizeControlledDialog.this.settings_.setIntValue("gui", "x", rec.x);
                            SizeControlledDialog.this.settings_.setIntValue("gui", "y", rec.y);
                        } else {
                            SizeControlledDialog.this.settings_.setIntValue("gui", SizeControlledDialog.this.dialogName_ + "_width", rec.width);
                            SizeControlledDialog.this.settings_.setIntValue("gui", SizeControlledDialog.this.dialogName_ + "_height", rec.height);
                        }
                    }
                    if (SizeControlledDialog.this.shellStyle_ == 32768) {
                        SizeControlledDialog.this.settings_.setBooleanValue("gui", "maximized", isMaximized);
                    }
                }
            }
        });
    }

    public void setListenerEnabled(boolean listenerEnabled) {
        this.listenerEnabled_ = listenerEnabled;
    }
}

