/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.controls;

import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.controls.DaControlConvertorAdapter;
import org.dbgl.gui.interfaces.DaControlConvertor;
import org.dbgl.service.TextService;
import org.dbgl.util.SystemUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public abstract class ChangeTrackingControl {
    private static final Color normalFieldColor = Display.getDefault().getSystemColor(2);
    private static final Color conflictingValuesFieldColor = Display.getDefault().getSystemColor(4);
    private static final Color changedFieldValueColor = Display.getDefault().getSystemColor(3);
    protected static final DaControlConvertor defaultConvertor = new DaControlConvertorAdapter(){};
    protected final Label label_;
    protected final Control[] controls_;
    protected boolean originalValueSet_;

    public ChangeTrackingControl(Label label, Control[] controls) {
        this.label_ = label;
        this.controls_ = controls;
    }

    public String getLabelText() {
        return this.label_.getText();
    }

    protected boolean allControlsDisabled() {
        return Stream.of(this.controls_).noneMatch(x -> x.isEnabled());
    }

    public String getOriginalValue() {
        return (String)this.label_.getData();
    }

    protected boolean setOriginalValue(String value, boolean multiEdit) {
        if (!this.originalValueSet_) {
            this.label_.setData((Object)value);
            if (multiEdit) {
                this.updateLabelColorAndTooltip(value == null ? ChangeState.CONFLICTING : ChangeState.NORMAL);
                if (value == null) {
                    Stream.of(this.controls_).filter(x -> x instanceof Button).forEach(x -> {
                        ((Button)x).setSelection(true);
                        ((Button)x).setGrayed(true);
                    });
                }
            }
            this.originalValueSet_ = true;
            return true;
        }
        return false;
    }

    protected boolean hasConflictingValues() {
        return this.originalValueSet_ ? this.label_.getData() == null : false;
    }

    public boolean hasChangedValue() {
        return this.label_.getForeground().toString().equals(changedFieldValueColor.toString());
    }

    public abstract String getCurrentValue();

    protected boolean hasOriginalValue() {
        return StringUtils.equals((CharSequence)this.getOriginalValue(), (CharSequence)this.getCurrentValue());
    }

    protected void updateLabelColorAndTooltipByValue() {
        this.updateLabelColorAndTooltip(this.hasOriginalValue() ? (this.hasConflictingValues() ? ChangeState.CONFLICTING : ChangeState.NORMAL) : ChangeState.CHANGED);
    }

    protected void updateLabelColorAndTooltip(ChangeState state) {
        switch (state) {
            case NORMAL: {
                this.label_.setForeground(normalFieldColor);
                this.label_.setToolTipText(TextService.getInstance().get("dialog.multiprofile.title.unalteredvalue"));
                break;
            }
            case CONFLICTING: {
                this.label_.setForeground(conflictingValuesFieldColor);
                this.label_.setToolTipText(TextService.getInstance().get("dialog.multiprofile.title.conflictingvalues"));
                break;
            }
            case CHANGED: {
                this.label_.setForeground(changedFieldValueColor);
                this.label_.setToolTipText(TextService.getInstance().get("dialog.multiprofile.title.alteredvalue"));
            }
        }
    }

    public void addListeners() {
        ModifyListener changeMarker = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ChangeTrackingControl.this.updateLabelColorAndTooltipByValue();
            }
        };
        SelectionAdapter selectionMarker = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button;
                if (event.widget instanceof Button && ChangeTrackingControl.this.hasConflictingValues() && ((button = (Button)event.widget).getStyle() & 0x20) == 32) {
                    if (button.getSelection()) {
                        if (button.getGrayed()) {
                            button.setSelection(false);
                        }
                    } else if (button.getGrayed()) {
                        button.setGrayed(false);
                    } else {
                        button.setGrayed(true);
                        button.setSelection(true);
                    }
                }
                ChangeTrackingControl.this.updateLabelColorAndTooltipByValue();
            }
        };
        for (Control cntrl : this.controls_) {
            if (cntrl instanceof Combo) {
                ((Combo)cntrl).addModifyListener(changeMarker);
                continue;
            }
            if (cntrl instanceof Text) {
                ((Text)cntrl).addModifyListener(changeMarker);
                continue;
            }
            if (cntrl instanceof Button) {
                ((Button)cntrl).addSelectionListener((SelectionListener)selectionMarker);
                continue;
            }
            if (cntrl instanceof Spinner) {
                ((Spinner)cntrl).addModifyListener(changeMarker);
                continue;
            }
            if (cntrl instanceof Scale) {
                ((Scale)cntrl).addSelectionListener((SelectionListener)selectionMarker);
                continue;
            }
            if (!(cntrl instanceof List)) continue;
            ((List)cntrl).addSelectionListener((SelectionListener)selectionMarker);
        }
    }

    protected static String getFieldValue(Control control, boolean isOnOff) {
        if (control.isEnabled()) {
            if (control instanceof Text) {
                String contents = ((Text)control).getText();
                String del = ((Text)control).getLineDelimiter();
                return StringUtils.replace((String)StringUtils.strip((String)contents, (String)del), (String)del, (String)SystemUtils.EOLN);
            }
            if (control instanceof Combo) {
                return ((Combo)control).getText();
            }
            if (control instanceof Button && !((Button)control).getGrayed()) {
                boolean v = ((Button)control).getSelection();
                return isOnOff ? (v ? "on" : "off") : String.valueOf(v);
            }
            if (control instanceof Scale) {
                return String.valueOf(((Scale)control).getSelection());
            }
            if (control instanceof Spinner) {
                return String.valueOf(((Spinner)control).getSelection());
            }
        }
        return null;
    }

    protected static void setFieldIfEnabled(String value, Control control, boolean isOnOff) {
        if (control.isEnabled()) {
            if (control instanceof Text) {
                String newValue = StringUtils.replace((String)value, (String)SystemUtils.EOLN, (String)((Text)control).getLineDelimiter());
                if (!((Text)control).getText().equals(newValue)) {
                    ((Text)control).setText(newValue);
                }
            } else if (control instanceof Combo) {
                if (!((Combo)control).getText().equals(value)) {
                    ((Combo)control).setText(value);
                }
            } else if (control instanceof Button) {
                boolean newValue;
                boolean bl = newValue = isOnOff ? "on".equalsIgnoreCase(value) : Boolean.valueOf(value).booleanValue();
                if (((Button)control).getSelection() != newValue || ((Button)control).getGrayed()) {
                    ((Button)control).setSelection(newValue);
                    ((Button)control).notifyListeners(13, new Event());
                }
            } else if (control instanceof Scale) {
                Integer newValue = Integer.valueOf(value);
                if (((Scale)control).getSelection() != newValue.intValue()) {
                    ((Scale)control).setSelection(newValue.intValue());
                }
            } else if (control instanceof Spinner) {
                Integer newValue = Integer.valueOf(value);
                if (((Spinner)control).getSelection() != newValue.intValue()) {
                    ((Spinner)control).setSelection(newValue.intValue());
                }
            }
        }
    }

    public static void setFieldIfEnabled(List listControl, String[] values) {
        if (listControl.isEnabled() && !Arrays.equals(listControl.getItems(), values)) {
            listControl.setItems(values);
        }
    }

    public static void setFieldIfEnabled(ExpandItem control, boolean value) {
        control.setExpanded(value);
    }

    private static enum ChangeState {
        NORMAL,
        CONFLICTING,
        CHANGED;

    }
}

