/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.util.Collections;
import java.util.List;
import org.dbgl.gui.abstractdialog.SizeControlledButtonDialog;
import org.dbgl.model.WebProfile;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class BrowseSearchEngineDialog
extends SizeControlledButtonDialog<WebProfile> {
    private final String title_;
    private final List<WebProfile> webProfiles_;
    private final WebSearchEngine engine_;

    public BrowseSearchEngineDialog(Shell parent, String title, List<WebProfile> profs, WebSearchEngine engine) {
        super(parent, "mobygamesbrowser");
        this.title_ = title;
        this.webProfiles_ = profs;
        this.engine_ = engine;
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.searchenginebrowser.title", new String[]{this.engine_.getName()});
    }

    @Override
    protected void onShellCreated() {
        int i;
        this.contents_.setLayout((Layout)new FillLayout());
        final Table table = new Table(this.contents_, 67584);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        Listener sortListener = new Listener(){

            public void handleEvent(Event e) {
                int selIndex = table.getSelectionIndex();
                WebProfile selWebProfile = (WebProfile)BrowseSearchEngineDialog.this.webProfiles_.get(selIndex);
                TableColumn column = (TableColumn)e.widget;
                int index = (Integer)column.getData();
                switch (index) {
                    case 0: {
                        Collections.sort(BrowseSearchEngineDialog.this.webProfiles_, new WebProfile.byTitle());
                        break;
                    }
                    case 1: {
                        Collections.sort(BrowseSearchEngineDialog.this.webProfiles_, new WebProfile.byYear());
                        break;
                    }
                    case 2: {
                        Collections.sort(BrowseSearchEngineDialog.this.webProfiles_, new WebProfile.byPlatform());
                        break;
                    }
                }
                table.removeAll();
                BrowseSearchEngineDialog.this.populate(table);
                table.setSortColumn(column);
                table.setSortDirection(128);
                for (int i = 0; i < BrowseSearchEngineDialog.this.webProfiles_.size(); ++i) {
                    if (selWebProfile != BrowseSearchEngineDialog.this.webProfiles_.get(i)) continue;
                    table.setSelection(i);
                    break;
                }
            }
        };
        String[] titles = new String[]{this.text_.get("dialog.profile.title"), this.text_.get("dialog.profile.year"), this.text_.get("dialog.searchenginebrowser.column.platform")};
        for (i = 0; i < titles.length; ++i) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(titles[i]);
            column.setData((Object)i);
            column.addListener(13, sortListener);
            if (i != titles.length - 1) continue;
            table.setSortColumn(column);
            table.setSortDirection(128);
        }
        this.populate(table);
        for (i = 0; i < titles.length; ++i) {
            table.getColumn(i).pack();
        }
        table.setSelection(WebSearchEngine.getEntryBestMatchIndex(this.title_, this.webProfiles_));
        table.showSelection();
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                BrowseSearchEngineDialog.this.doChooseGame(table);
            }
        });
        this.createOkCancelButtons((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowseSearchEngineDialog.this.doChooseGame(table);
            }
        });
    }

    private void populate(Table table) {
        for (WebProfile p : this.webProfiles_) {
            TableItem item = new TableItem(table, 0);
            item.setText(0, p.getTitle());
            item.setText(1, p.getYear());
            item.setText(2, p.getPlatform());
        }
    }

    private void doChooseGame(Table table) {
        this.result_ = this.webProfiles_.get(table.getSelectionIndex());
        this.shell_.close();
    }
}

