/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.abstractdialog.SizeControlledTabbedDialog;
import org.dbgl.gui.controls.Button_;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Combo_;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.gui.controls.Text_;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.factory.DosboxVersionFactory;
import org.dbgl.model.repository.DosboxVersionRepository;
import org.dbgl.service.FileLocationService;
import org.dbgl.util.ExecuteUtils;
import org.dbgl.util.FilesUtils;
import org.dbgl.util.SystemUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditDosboxVersionDialog
extends SizeControlledTabbedDialog<DosboxVersion> {
    private final boolean isDefault_;
    private final DosboxVersion dbversion_;

    public EditDosboxVersionDialog(Shell parent, boolean isDefault, DosboxVersion dbversion) {
        super(parent, "dosboxdialog");
        this.isDefault_ = isDefault;
        this.dbversion_ = dbversion;
    }

    @Override
    protected String getDialogTitle() {
        return this.dbversion_ == null || this.dbversion_.getId() == -1 ? this.text_.get("dialog.dosboxversion.title.add") : this.text_.get("dialog.dosboxversion.title.edit", new Object[]{this.dbversion_.getTitle(), this.dbversion_.getId()});
    }

    @Override
    protected void onShellCreated() {
        Composite composite = this.createTabWithComposite("dialog.dosboxversion.tab.info", 3);
        final Text title = Chain.on(composite).lbl(l -> l.key("dialog.dosboxversion.title")).txt(t -> ((Text_.Builder)t.horSpan(2)).focus()).text();
        Chain chainPath = Chain.on(composite).lbl(l -> l.key("dialog.dosboxversion.path")).txt(t -> t).but(b -> b.browse(false, SystemUtils.IS_OSX ? Button_.BrowseType.FILE : Button_.BrowseType.DIR, Button_.CanonicalType.DOSBOX, false)).build();
        final Text path = chainPath.getText();
        final Text exe = Chain.on(composite).lbl(l -> l.key("dialog.dosboxversion.executable")).txt(t -> t.tooltip("dialog.dosboxversion.executable.tooltip", FileLocationService.DOSBOX_EXE_STRING)).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.DOSBOXEXE, false)).text();
        final Text conf = Chain.on(composite).lbl(l -> l.key("dialog.profile.configfile")).txt(t -> t).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.DOSBOXCONF, false)).text();
        final Text parameters = Chain.on(composite).lbl(l -> l.key("dialog.dosboxversion.parameters")).txt(t -> (Text_.Builder)t.horSpan(2)).text();
        final Combo version = Chain.on(composite).lbl(l -> l.key("dialog.dosboxversion.version")).cmb(c -> ((Combo_.Builder)c.horSpan(2)).visibleItemCount(15).items(DosboxVersion.SUPP_RELEASES)).combo();
        final Button multiconf = Chain.on(composite).lbl(l -> l.key("dialog.dosboxversion.multiconfsupport")).but(b -> (Button_.Builder)b.horSpan(2)).button();
        final Button usingCurses = Chain.on(composite).lbl(l -> l.key("dialog.dosboxversion.altstartup")).but(b -> ((Button_.Builder)b.horSpan(2)).key("dialog.dosboxversion.altstartupexplanation")).button();
        final Button defaultButton = Chain.on(composite).lbl(l -> l.key("dialog.dosboxversion.default")).but(b -> (Button_.Builder)b.horSpan(2)).button();
        chainPath.getButton().setData("altControl", (Object)conf);
        this.createOkCancelButtons((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!EditDosboxVersionDialog.this.isValid(title, path, exe, conf, usingCurses)) {
                    return;
                }
                try {
                    if (EditDosboxVersionDialog.this.dbversion_ == null || EditDosboxVersionDialog.this.dbversion_.getId() == -1) {
                        DosboxVersion dbv = DosboxVersionFactory.create(title.getText(), version.getText(), defaultButton.getSelection(), multiconf.getSelection(), usingCurses.getSelection(), path.getText(), exe.getText(), parameters.getText(), conf.getText());
                        EditDosboxVersionDialog.this.result_ = new DosboxVersionRepository().add(dbv);
                    } else {
                        EditDosboxVersionDialog.this.dbversion_.setTitle(title.getText());
                        EditDosboxVersionDialog.this.dbversion_.setVersion(version.getText());
                        EditDosboxVersionDialog.this.dbversion_.setDefault(defaultButton.getSelection());
                        EditDosboxVersionDialog.this.dbversion_.setMultiConfig(multiconf.getSelection());
                        EditDosboxVersionDialog.this.dbversion_.setUsingCurses(usingCurses.getSelection());
                        EditDosboxVersionDialog.this.dbversion_.setPath(path.getText());
                        EditDosboxVersionDialog.this.dbversion_.setExe(exe.getText());
                        EditDosboxVersionDialog.this.dbversion_.setExecutableParameters(parameters.getText());
                        EditDosboxVersionDialog.this.dbversion_.setConfigurationFileLocation(conf.getText());
                        new DosboxVersionRepository().update(EditDosboxVersionDialog.this.dbversion_);
                        EditDosboxVersionDialog.this.result_ = EditDosboxVersionDialog.this.dbversion_;
                    }
                }
                catch (SQLException e) {
                    Mess_.on(EditDosboxVersionDialog.this.shell_).exception(e).warning();
                }
                EditDosboxVersionDialog.this.shell_.close();
            }
        });
        if (this.dbversion_ != null) {
            title.setText(this.dbversion_.getTitle());
            path.setText(this.dbversion_.getPath().getPath());
            exe.setText(this.dbversion_.getExe().getPath());
            conf.setText(this.dbversion_.getConfigurationFile().getPath());
            parameters.setText(this.dbversion_.getExecutableParameters());
            version.setText(this.dbversion_.getVersion());
            defaultButton.setSelection(this.dbversion_.isDefault());
            multiconf.setSelection(this.dbversion_.isMultiConfig());
            usingCurses.setSelection(this.dbversion_.isUsingCurses());
        } else {
            version.select(version.getItemCount() - 1);
            defaultButton.setSelection(this.isDefault_);
            multiconf.setSelection(true);
        }
    }

    private boolean isValid(Text title, Text path, Text exe, Text conf, Button usingCurses) {
        Mess_.Builder mess = Mess_.on(this.shell_);
        if (StringUtils.isBlank((CharSequence)title.getText())) {
            mess.key("dialog.dosboxversion.required.title").bind((Control)title);
        }
        if (StringUtils.isBlank((CharSequence)path.getText())) {
            mess.key("dialog.dosboxversion.required.path").bind((Control)path);
        }
        if (StringUtils.isBlank((CharSequence)conf.getText())) {
            mess.key("dialog.dosboxversion.required.conf").bind((Control)conf);
        }
        if (mess.noErrors()) {
            DosboxVersion dbversion = DosboxVersionFactory.create("", "", false, false, false, path.getText(), exe.getText(), "", conf.getText());
            File executable = dbversion.getCanonicalExecutable();
            File configFile = dbversion.getConfigurationCanonicalFile();
            boolean exeAvailable = FilesUtils.isReadableFile(executable);
            if (!exeAvailable) {
                mess.key("dialog.dosboxversion.error.dosboxexemissing", new Object[]{executable}).bind((Control)path);
            }
            if (!FilesUtils.isReadableFile(configFile) && exeAvailable && Mess_.on(this.shell_).key("dialog.dosboxversion.confirm.createmissingdosboxconf", new Object[]{configFile}).confirm()) {
                try {
                    ExecuteUtils.doCreateDosboxConf(dbversion);
                }
                catch (IOException e) {
                    Mess_.on(this.shell_).exception(e).warning();
                }
            }
            if (!usingCurses.getSelection() && !FilesUtils.isReadableFile(configFile)) {
                mess.key("dialog.dosboxversion.error.dosboxconfmissing", new Object[]{configFile}).bind((Control)path);
            }
        }
        return mess.valid();
    }
}

