/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.abstractdialog.SizeControlledTabbedDialog;
import org.dbgl.gui.controls.Button_;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.gui.controls.Text_;
import org.dbgl.model.NativeCommand;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditNativeCommandDialog
extends SizeControlledTabbedDialog<NativeCommand> {
    private final NativeCommand nativeCommand_;

    public EditNativeCommandDialog(Shell parent, NativeCommand cmd) {
        super(parent, "nativecommanddialog");
        this.nativeCommand_ = cmd;
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get(this.nativeCommand_ == null ? "dialog.nativecommand.title.add" : "dialog.nativecommand.title.edit");
    }

    @Override
    protected void onShellCreated() {
        Composite composite = this.createTabWithComposite("dialog.nativecommand.tab.info", 3);
        final Chain chnCommand = Chain.on(composite).lbl(l -> l.key("dialog.nativecommand.command")).txt(t -> t.focus()).but(b -> b.browse(false, Button_.BrowseType.FILE, Button_.CanonicalType.NATIVE_EXE, false)).build();
        final Text parameters = Chain.on(composite).lbl(l -> l.key("dialog.nativecommand.parameters")).txt(t -> (Text_.Builder)t.horSpan(2)).text();
        final Text cwd = Chain.on(composite).lbl(l -> l.key("dialog.nativecommand.cwd")).txt(t -> t).but(b -> b.browse(false, Button_.BrowseType.DIR, Button_.CanonicalType.NATIVE_EXE, false)).text();
        final Button waitFor = Chain.on(composite).lbl(l -> l.key("dialog.nativecommand.waitfor")).but(b -> (Button_.Builder)b.horSpan(2)).button();
        chnCommand.getButton().setData("altControl", (Object)cwd);
        this.createOkCancelButtons((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!EditNativeCommandDialog.this.isValid(chnCommand.getText(), cwd)) {
                    return;
                }
                int orderNr = EditNativeCommandDialog.this.nativeCommand_ == null ? -1 : EditNativeCommandDialog.this.nativeCommand_.getOrderNr();
                EditNativeCommandDialog.this.result_ = new NativeCommand(chnCommand.getText().getText(), parameters.getText(), cwd.getText(), waitFor.getSelection(), orderNr);
                EditNativeCommandDialog.this.shell_.close();
            }
        });
        if (this.nativeCommand_ != null) {
            chnCommand.getText().setText(this.nativeCommand_.getCommand().getPath());
            parameters.setText(this.nativeCommand_.getParameters());
            cwd.setText(this.nativeCommand_.getCwd().getPath());
            waitFor.setSelection(this.nativeCommand_.isWaitFor());
        }
    }

    private boolean isValid(Text command, Text cwd) {
        Mess_.Builder mess = Mess_.on(this.shell_);
        if (StringUtils.isBlank((CharSequence)command.getText())) {
            mess.key("dialog.nativecommand.required.command").bind((Control)command);
        } else if (StringUtils.isBlank((CharSequence)cwd.getText())) {
            mess.key("dialog.nativecommand.required.cwd").bind((Control)cwd);
        }
        return mess.valid();
    }
}

