/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.listeners;

import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ToolTipListener
implements Listener {
    private static final Color infoForegroundColor_ = Display.getDefault().getSystemColor(28);
    private static final Color infoBackgroundColor_ = Display.getDefault().getSystemColor(29);
    private Shell tip_ = null;

    public void handleEvent(Event event) {
        switch (event.type) {
            case 32: {
                Gallery gallery = (Gallery)event.widget;
                GalleryItem galleryItem = gallery.getItem(new Point(event.x, event.y));
                if (galleryItem == null) break;
                if (this.tip_ != null && !this.tip_.isDisposed()) {
                    this.tip_.dispose();
                }
                this.tip_ = new Shell(gallery.getShell(), 540676);
                this.tip_.setBackground(infoBackgroundColor_);
                FillLayout layout = new FillLayout();
                layout.marginWidth = 2;
                this.tip_.setLayout((Layout)layout);
                Label label = new Label((Composite)this.tip_, 0);
                label.setForeground(infoForegroundColor_);
                label.setBackground(infoBackgroundColor_);
                label.setText(galleryItem.getText(1));
                label.addListener(7, (Listener)this);
                Point size = this.tip_.computeSize(-1, -1);
                Point pt = gallery.toDisplay(event.x, event.y + 16);
                this.tip_.setBounds(pt.x, pt.y, size.x, size.y);
                this.tip_.setVisible(true);
                break;
            }
            default: {
                if (this.tip_ != null && !this.tip_.isDisposed()) {
                    this.tip_.dispose();
                }
                this.tip_ = null;
            }
        }
    }
}

