/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.thread;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.GenericType;
import org.dbgl.gui.thread.UIThread;
import org.dbgl.model.Link;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.entity.SharedConf;
import org.dbgl.model.factory.ProfileFactory;
import org.dbgl.model.repository.GameFilesRepository;
import org.dbgl.model.repository.ProfileRepository;
import org.dbgl.service.SettingsService;
import org.dbgl.util.searchengine.MetropolisSearchEngine;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public class ImportDirThread
extends UIThread<GameFilesRepository.GameDirEntry> {
    private static final SettingsService settings_ = SettingsService.getInstance();
    private static final WebSearchEngine engine_ = MetropolisSearchEngine.getInstance();
    private final List<GameFilesRepository.GameDirEntry> games_;
    private final Profile profile_;
    private final boolean consultConf_;

    public ImportDirThread(Text log, ProgressBar progressBar, Label status, List<GameFilesRepository.GameDirEntry> games, Profile profile, boolean consultConf) throws IOException, SQLException {
        super(log, progressBar, status, true);
        this.games_ = games;
        this.profile_ = profile;
        this.consultConf_ = consultConf;
        this.setObjects(this.games_);
        this.setTotal(this.games_.size());
    }

    @Override
    public String work(GameFilesRepository.GameDirEntry entry) throws IOException, SQLException {
        this.displayTitle(text_.get("dialog.import.importing", new Object[]{this.getTitle(entry)}));
        Profile prof = ProfileFactory.createCopy(this.profile_);
        prof.loadConfigurationData(text_, this.profile_.getConfigurationString(), new File(""));
        prof.setTitle(entry.webProfile_.getTitle());
        if (settings_.getBooleanValue(engine_.getSimpleName(), "set_developer")) {
            prof.setDeveloper(entry.webProfile_.getDeveloperName());
        }
        if (settings_.getBooleanValue(engine_.getSimpleName(), "set_publisher")) {
            prof.setPublisher(entry.webProfile_.getPublisherName());
        }
        if (settings_.getBooleanValue(engine_.getSimpleName(), "set_year")) {
            prof.setYear(entry.webProfile_.getYear());
        }
        if (settings_.getBooleanValue(engine_.getSimpleName(), "set_genre")) {
            prof.setGenre(entry.webProfile_.getGenre());
        }
        if (settings_.getBooleanValue(engine_.getSimpleName(), "set_link")) {
            Link[] links = new Link[8];
            for (int i = 0; i < 8; ++i) {
                links[i] = new Link("", "");
            }
            links[0] = new Link(text_.get("dialog.profile.searchengine.link.maininfo", new String[]{engine_.getName()}), entry.webProfile_.getUrl());
            prof.setLinks(links);
        }
        if (settings_.getBooleanValue(engine_.getSimpleName(), "set_description")) {
            prof.setNotes(entry.webProfile_.getNotes());
        }
        if (settings_.getBooleanValue(engine_.getSimpleName(), "set_rank")) {
            prof.setCustomInts(new int[]{entry.webProfile_.getRank(), 0});
        }
        prof.setSetupFileLocation(entry.setup_.isPresent() ? entry.setup_.get().getPath() : "");
        prof.addRequiredMount(false, entry.main_.get().getPath(), false);
        prof.setAutoexecSettings(entry.main_.get().getPath(), "");
        if (this.consultConf_) {
            Client client = ClientBuilder.newClient();
            GenericType<List<SharedConf>> confType = new GenericType<List<SharedConf>>(){};
            List confs = (List)client.target(SettingsService.getInstance().getValue("confsharing", "endpoint")).path("/configurations/bytitle/{i}").resolveTemplate("i", (Object)prof.getTitle()).request().accept(new String[]{"application/xml"}).get((GenericType)confType);
            client.close();
            if (confs.size() == 0) {
                this.messageLog_.append("  - ").append(text_.get("general.notice.searchenginenoresults", new String[]{"DBConfWS", prof.getTitle()})).append('\n');
            } else if (confs.size() == 1) {
                prof.getConfiguration().clearSections();
                prof.loadConfigurationData(text_, ((SharedConf)confs.get(0)).getIncrConf(), new File(((SharedConf)confs.get(0)).getGameTitle()));
                this.messageLog_.append("  + ").append(text_.get("dialog.importdir.notice.conffound", prof.getTitle())).append('\n');
            } else {
                this.messageLog_.append("  - ").append(text_.get("dialog.multiprofile.notice.titlenotunique", new String[]{"DBConfWS", prof.getTitle()})).append('\n');
            }
        }
        ProfileRepository pRepo = new ProfileRepository();
        prof = pRepo.add(prof);
        this.messageLog_.append("  + ").append(text_.get("dialog.import.notice.createddbentry", new Object[]{prof.getId(), prof.getConfigurationFile(), prof.getCapturesString(), prof.getDosboxVersion().getTitle()})).append('\n');
        return null;
    }

    @Override
    public String getTitle(GameFilesRepository.GameDirEntry obj) {
        return obj.webProfile_.getTitle() + " (" + obj.dir_.getPath() + ")";
    }

    @Override
    public void preFinish() throws IOException {
    }
}

