/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.aggregate;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.FileLocation;
import org.dbgl.model.GenericStats;
import org.dbgl.model.ICanBeDefault;
import org.dbgl.model.conf.GenerationAwareConfiguration;
import org.dbgl.model.entity.Configurable;
import org.dbgl.service.FileLocationService;
import org.dbgl.service.ITextService;
import org.dbgl.service.TextService;

public class DosboxVersion
extends Configurable
implements ICanBeDefault,
Comparable<DosboxVersion> {
    public static final String[] SUPP_RELEASES = new String[]{"0.63", "0.65", "0.70", "0.71", "0.72", "0.73", "0.74", "0.74-2", "0.74-3"};
    public static final String LATEST = SUPP_RELEASES[SUPP_RELEASES.length - 1];
    private String version_;
    private String executableParameters_;
    private boolean default_;
    private boolean multiConfig_;
    private boolean usingCurses_;
    private FileLocation path_;
    private FileLocation exe_;
    private GenericStats stats_;

    public String getVersion() {
        return this.version_;
    }

    public void setVersion(String version) {
        this.version_ = version;
    }

    private int getVersionAsInt() {
        if (StringUtils.isBlank((CharSequence)this.version_)) {
            return 0;
        }
        int revisionMarker = this.version_.indexOf(45);
        if (revisionMarker != -1) {
            return Integer.valueOf(this.version_.substring(2, revisionMarker)) * 10 + Integer.valueOf(this.version_.substring(revisionMarker + 1));
        }
        return Integer.valueOf(this.version_.substring(2)) * 10;
    }

    public int distance(DosboxVersion other) {
        return Math.abs(other.getVersionAsInt() - this.getVersionAsInt());
    }

    @Override
    public boolean isDefault() {
        return this.default_;
    }

    public void setDefault(boolean isDefault) {
        this.default_ = isDefault;
    }

    public boolean isMultiConfig() {
        return this.multiConfig_;
    }

    public void setMultiConfig(boolean multiConfig) {
        this.multiConfig_ = multiConfig;
    }

    public boolean isUsingCurses() {
        return this.usingCurses_;
    }

    public void setUsingCurses(boolean usingCurses) {
        this.usingCurses_ = usingCurses;
    }

    public File getPath() {
        return this.path_.getFile();
    }

    public File getCanonicalPath() {
        return this.path_.getCanonicalFile();
    }

    public void setPath(String path) {
        this.path_ = new FileLocation(path, FileLocationService.getInstance().dosboxRelative());
    }

    public File getExe() {
        return this.exe_.getFile();
    }

    public File getCanonicalExe() {
        return this.exe_.getCanonicalFile();
    }

    public void setExe(String exe) {
        this.exe_ = new FileLocation(exe, FileLocationService.getInstance().dosboxRelative());
    }

    public File getExecutable() {
        return StringUtils.isBlank((CharSequence)this.getExe().getPath()) ? new File(this.getPath(), FileLocationService.DOSBOX_EXE_STRING) : this.getExe();
    }

    public File getCanonicalExecutable() {
        return StringUtils.isBlank((CharSequence)this.getExe().getPath()) ? new File(this.getCanonicalPath(), FileLocationService.DOSBOX_EXE_STRING) : this.getCanonicalExe();
    }

    public String getExecutableParameters() {
        return this.executableParameters_;
    }

    public void setExecutableParameters(String executableParameters) {
        this.executableParameters_ = executableParameters;
    }

    public void setConfigurationFileLocation(String file) {
        this.configuration_.setFileLocation(new FileLocation(file, FileLocationService.getInstance().dosboxRelative()));
    }

    public String getConfigurationString() {
        return this.configuration_.toString(null);
    }

    public String resetAndLoadConfiguration() throws IOException {
        return this.configuration_.reloadWithAutoexec(TextService.getInstance(), null);
    }

    public String loadConfigurationData(ITextService text, String data, File file) throws IOException {
        return this.configuration_.loadDataWithAutoexec(text, data, file, null);
    }

    public File getCwd() {
        return FileLocationService.getInstance().getDosroot();
    }

    public GenericStats getStats() {
        return this.stats_;
    }

    public void setStats(GenericStats stats) {
        this.stats_ = stats;
    }

    public boolean hasMT32Support() {
        return this.configuration_.hasMT32Support();
    }

    public boolean hasHardwareOPLSupport() {
        return this.configuration_.hasHardwareOPLSupport();
    }

    public boolean likelyDirect3DSupport() {
        return this.configuration_.hasPixelshaderSupport();
    }

    public boolean likelyAmstradSupport() {
        return this.configuration_.hasPS1AudioSupport();
    }

    public boolean likelyHardwareScalerSupport() {
        return this.configuration_.hasPixelshaderSupport();
    }

    public boolean likelySoundBlaster16VibraSupport() {
        return this.configuration_.hasSoundBlasterGoldplaySupport();
    }

    public boolean likelyAdditionalCPUTypesSupport() {
        return this.configuration_.hasParallelDongleSupport();
    }

    public boolean isUsingNewMachineConfig() {
        return this.getGeneration().ordinal() >= GenerationAwareConfiguration.Generation.Gen_073.ordinal();
    }

    public GenerationAwareConfiguration.Generation getGeneration() {
        GenerationAwareConfiguration.Generation result = this.configuration_.getGeneration();
        if (result != null) {
            return result;
        }
        int ver = this.getVersionAsInt();
        if (ver >= 730) {
            return GenerationAwareConfiguration.Generation.Gen_073;
        }
        if (ver >= 700) {
            return GenerationAwareConfiguration.Generation.Gen_070;
        }
        if (ver >= 650) {
            return GenerationAwareConfiguration.Generation.Gen_065;
        }
        return GenerationAwareConfiguration.Generation.Gen_063;
    }

    @Override
    public int compareTo(DosboxVersion comp) {
        int ver2;
        int ver1 = this.getVersionAsInt();
        if (ver1 != (ver2 = comp.getVersionAsInt())) {
            return ver1 - ver2;
        }
        return this.getTitle().compareTo(comp.getTitle());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DosboxVersion)) {
            return false;
        }
        DosboxVersion other = (DosboxVersion)obj;
        return this.getVersion().equals(other.getVersion()) && this.getTitle().equals(other.getTitle());
    }

    public int hashCode() {
        return this.getVersion().hashCode() ^ this.getTitle().hashCode();
    }
}

